/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.campaignclassic.internal;

import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.MobilePrivacyStatus;
import com.adobe.marketing.mobile.SharedStateResolution;
import com.adobe.marketing.mobile.SharedStateResult;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.DataReaderException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\u0018H\u00d6\u0001J\t\u0010$\u001a\u00020\tH\u00d6\u0001R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0001\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u001b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010\u00a8\u0006%"}, d2={"Lcom/adobe/marketing/mobile/campaignclassic/internal/CampaignClassicConfiguration;", "", "event", "Lcom/adobe/marketing/mobile/Event;", "extensionApi", "Lcom/adobe/marketing/mobile/ExtensionApi;", "(Lcom/adobe/marketing/mobile/Event;Lcom/adobe/marketing/mobile/ExtensionApi;)V", "configSharedState", "", "", "getEvent", "()Lcom/adobe/marketing/mobile/Event;", "getExtensionApi", "()Lcom/adobe/marketing/mobile/ExtensionApi;", "integrationKey", "getIntegrationKey", "()Ljava/lang/String;", "marketingServer", "getMarketingServer", "privacyStatus", "Lcom/adobe/marketing/mobile/MobilePrivacyStatus;", "getPrivacyStatus", "()Lcom/adobe/marketing/mobile/MobilePrivacyStatus;", "timeout", "", "getTimeout", "()I", "trackingServer", "getTrackingServer", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "campaignclassic_phoneRelease"})
public final class CampaignClassicConfiguration {
    @NotNull
    private final Event event;
    @NotNull
    private final ExtensionApi extensionApi;
    @Nullable
    private final Map<String, Object> configSharedState;

    public CampaignClassicConfiguration(@NotNull Event event, @NotNull ExtensionApi extensionApi) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)extensionApi, (String)"extensionApi");
        this.event = event;
        this.extensionApi = extensionApi;
        SharedStateResult sharedStateResult = this.extensionApi.getSharedState("com.adobe.module.configuration", this.event, false, SharedStateResolution.ANY);
        this.configSharedState = sharedStateResult != null ? sharedStateResult.getValue() : null;
    }

    @NotNull
    public final Event getEvent() {
        return this.event;
    }

    @NotNull
    public final ExtensionApi getExtensionApi() {
        return this.extensionApi;
    }

    @Nullable
    public final String getMarketingServer() {
        String marketingServer = DataReader.optString(this.configSharedState, (String)"campaignclassic.marketingServer", null);
        CharSequence charSequence = marketingServer;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : marketingServer;
    }

    @Nullable
    public final String getIntegrationKey() {
        String integrationKey = DataReader.optString(this.configSharedState, (String)"campaignclassic.android.integrationKey", null);
        CharSequence charSequence = integrationKey;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : integrationKey;
    }

    @Nullable
    public final String getTrackingServer() {
        String trackingServer = DataReader.optString(this.configSharedState, (String)"campaignclassic.trackingServer", null);
        CharSequence charSequence = trackingServer;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : trackingServer;
    }

    public final int getTimeout() {
        return DataReader.optInt(this.configSharedState, (String)"campaignclassic.timeout", (int)30);
    }

    @NotNull
    public final MobilePrivacyStatus getPrivacyStatus() {
        MobilePrivacyStatus mobilePrivacyStatus;
        try {
            MobilePrivacyStatus mobilePrivacyStatus2 = MobilePrivacyStatus.fromString((String)DataReader.getString(this.configSharedState, (String)"global.privacy"));
            Intrinsics.checkNotNullExpressionValue((Object)mobilePrivacyStatus2, (String)"{\n                Mobile\u2026          )\n            }");
            mobilePrivacyStatus = mobilePrivacyStatus2;
        }
        catch (DataReaderException e) {
            mobilePrivacyStatus = MobilePrivacyStatus.UNKNOWN;
        }
        return mobilePrivacyStatus;
    }

    @NotNull
    public final Event component1() {
        return this.event;
    }

    @NotNull
    public final ExtensionApi component2() {
        return this.extensionApi;
    }

    @NotNull
    public final CampaignClassicConfiguration copy(@NotNull Event event, @NotNull ExtensionApi extensionApi) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)extensionApi, (String)"extensionApi");
        return new CampaignClassicConfiguration(event, extensionApi);
    }

    public static /* synthetic */ CampaignClassicConfiguration copy$default(CampaignClassicConfiguration campaignClassicConfiguration, Event event, ExtensionApi extensionApi, int n, Object object) {
        if ((n & 1) != 0) {
            event = campaignClassicConfiguration.event;
        }
        if ((n & 2) != 0) {
            extensionApi = campaignClassicConfiguration.extensionApi;
        }
        return campaignClassicConfiguration.copy(event, extensionApi);
    }

    @NotNull
    public String toString() {
        return "CampaignClassicConfiguration(event=" + this.event + ", extensionApi=" + this.extensionApi + ')';
    }

    public int hashCode() {
        int result = this.event.hashCode();
        result = result * 31 + this.extensionApi.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CampaignClassicConfiguration)) {
            return false;
        }
        CampaignClassicConfiguration campaignClassicConfiguration = (CampaignClassicConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.event, (Object)campaignClassicConfiguration.event)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.extensionApi, (Object)campaignClassicConfiguration.extensionApi);
    }
}

