/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.campaignclassic.internal.CampaignClassicExtension;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class CampaignClassic {
    public static final Class<? extends Extension> EXTENSION = CampaignClassicExtension.class;
    public static final String EXTENSION_VERSION = "3.1.4";
    private static final String LOG_TAG = "CampaignClassicExtension";
    private static final String SELF_TAG = "CampaignClassic";
    static final String REGISTER_DEVICE = "registerdevice";
    static final String TRACK_RECEIVE = "trackreceive";
    static final String TRACK_CLICK = "trackclick";
    static final String TRACK_INFO = "trackinfo";
    static final String DEVICE_TOKEN = "devicetoken";
    static final String USER_KEY = "userkey";
    static final String ADDITIONAL_PARAMETERS = "additionalparameters";
    private static final String NULL_TOKEN_MESSAGE = "The provided token is null or empty";
    private static final String NULL_TRACK_INFO_MESSAGE = "The provided trackInfo map is null or empty";

    private CampaignClassic() {
    }

    @NonNull
    public static String extensionVersion() {
        return EXTENSION_VERSION;
    }

    public static void registerDevice(@NonNull String token, String userKey, Map<String, Object> additionalParams) {
        if (StringUtils.isNullOrEmpty((String)token)) {
            Log.error((String)LOG_TAG, (String)SELF_TAG, (String)"Failed to register device for CampaignClassic (%s)", (Object[])new Object[]{NULL_TOKEN_MESSAGE});
            return;
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put(REGISTER_DEVICE, true);
        eventData.put(DEVICE_TOKEN, token);
        eventData.put(USER_KEY, userKey);
        eventData.put(ADDITIONAL_PARAMETERS, additionalParams);
        Event event = new Event.Builder("CampaignClassic Register Device", "com.adobe.eventType.campaign", "com.adobe.eventSource.requestContent").setEventData(eventData).build();
        MobileCore.dispatchEvent((Event)event);
    }

    public static void trackNotificationReceive(@NonNull Map<String, String> trackInfo) {
        if (trackInfo == null || trackInfo.isEmpty()) {
            Log.error((String)LOG_TAG, (String)SELF_TAG, (String)"Failed to track notification receive for CampaignClassic (%s)", (Object[])new Object[]{NULL_TRACK_INFO_MESSAGE});
            return;
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put(TRACK_RECEIVE, true);
        eventData.put(TRACK_INFO, trackInfo);
        Event event = new Event.Builder("CampaignClassic Track Notification Receive", "com.adobe.eventType.campaign", "com.adobe.eventSource.requestContent").setEventData(eventData).build();
        MobileCore.dispatchEvent((Event)event);
    }

    public static void trackNotificationClick(@NonNull Map<String, String> trackInfo) {
        if (trackInfo == null || trackInfo.isEmpty()) {
            Log.error((String)LOG_TAG, (String)SELF_TAG, (String)"Failed to track notification click for CampaignClassic (%s)", (Object[])new Object[]{NULL_TRACK_INFO_MESSAGE});
            return;
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put(TRACK_CLICK, true);
        eventData.put(TRACK_INFO, trackInfo);
        Event event = new Event.Builder("CampaignClassic Track Notification Click", "com.adobe.eventType.campaign", "com.adobe.eventSource.requestContent").setEventData(eventData).build();
        MobileCore.dispatchEvent((Event)event);
    }
}

