/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.audience;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.EventCoder;
import com.adobe.marketing.mobile.services.DataEntity;
import com.adobe.marketing.mobile.services.Log;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

class AudienceDataEntity {
    private static final String LOG_SOURCE = "AudienceDataEntity";
    private static final String EVENT_KEY = "event";
    private static final String URL_KEY = "url";
    private static final String TIMEOUT_KEY = "timeoutSec";
    private final Event event;
    private final String url;
    private final int timeoutSec;

    AudienceDataEntity(@NonNull Event event, String url, int timeoutSec) throws IllegalArgumentException {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        this.event = event;
        this.url = url;
        this.timeoutSec = timeoutSec;
    }

    Event getEvent() {
        return this.event;
    }

    String getUrl() {
        return this.url;
    }

    int getTimeoutSec() {
        return this.timeoutSec;
    }

    @Nullable
    DataEntity toDataEntity() {
        try {
            JSONObject serializedEntity = new JSONObject();
            serializedEntity.put(EVENT_KEY, (Object)new JSONObject(EventCoder.encode((Event)this.event)));
            serializedEntity.put(URL_KEY, (Object)this.url);
            serializedEntity.put(TIMEOUT_KEY, this.timeoutSec);
            return new DataEntity(this.event.getUniqueIdentifier(), new Date(this.event.getTimestamp()), serializedEntity.toString());
        }
        catch (JSONException e) {
            Log.debug((String)"Audience", (String)LOG_SOURCE, (String)("Failed to serialize AudienceDataEntity to DataEntity: " + e.getLocalizedMessage()), (Object[])new Object[0]);
            return null;
        }
    }

    @Nullable
    static AudienceDataEntity fromDataEntity(@NotNull DataEntity dataEntity) {
        String entity = dataEntity.getData();
        if (entity == null || entity.isEmpty()) {
            return null;
        }
        try {
            JSONObject serializedEntity = new JSONObject(entity);
            String url = null;
            if (serializedEntity.has(URL_KEY)) {
                url = serializedEntity.getString(URL_KEY);
            }
            int timeout = 2;
            if (serializedEntity.has(TIMEOUT_KEY)) {
                timeout = serializedEntity.getInt(TIMEOUT_KEY);
            }
            String eventString = serializedEntity.getJSONObject(EVENT_KEY).toString();
            Event event = EventCoder.decode((String)eventString);
            return new AudienceDataEntity(event, url, timeout);
        }
        catch (IllegalArgumentException | JSONException e) {
            Log.debug((String)"Audience", (String)LOG_SOURCE, (String)("Failed to deserialize DataEntity to AudienceDataEntity: " + e.getLocalizedMessage()), (Object[])new Object[0]);
            return null;
        }
    }
}

