/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.analytics.internal;

import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.analytics.internal.AnalyticsHit;
import com.adobe.marketing.mobile.analytics.internal.AnalyticsState;
import com.adobe.marketing.mobile.analytics.internal.AnalyticsVersionProvider;
import com.adobe.marketing.mobile.services.DataEntity;
import com.adobe.marketing.mobile.services.HitProcessing;
import com.adobe.marketing.mobile.services.HitProcessingResult;
import com.adobe.marketing.mobile.services.HttpConnecting;
import com.adobe.marketing.mobile.services.HttpMethod;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NetworkRequest;
import com.adobe.marketing.mobile.services.Networking;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.StreamUtils;
import com.adobe.marketing.mobile.util.TimeUtils;
import com.adobe.marketing.mobile.util.UrlUtils;
import java.io.InputStream;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\r\u0010\u0010\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0015H\u0016J\u0015\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\bH\u0001\u00a2\u0006\u0002\b!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsHitProcessor;", "Lcom/adobe/marketing/mobile/services/HitProcessing;", "analyticsState", "Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsState;", "extensionApi", "Lcom/adobe/marketing/mobile/ExtensionApi;", "(Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsState;Lcom/adobe/marketing/mobile/ExtensionApi;)V", "lastHitTimestamp", "", "networkService", "Lcom/adobe/marketing/mobile/services/Networking;", "version", "", "getAnalyticsBaseUrl", "state", "getAnalyticsResponseType", "getLastHitTimestamp", "getLastHitTimestamp$analytics_phoneRelease", "processHit", "", "entity", "Lcom/adobe/marketing/mobile/services/DataEntity;", "processingResult", "Lcom/adobe/marketing/mobile/services/HitProcessingResult;", "replaceTimestampInPayload", "payload", "oldTs", "newTs", "retryInterval", "", "dataEntity", "setLastHitTimestamp", "timestamp", "setLastHitTimestamp$analytics_phoneRelease", "Companion", "analytics_phoneRelease"})
public final class AnalyticsHitProcessor
implements HitProcessing {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalyticsState analyticsState;
    @NotNull
    private final ExtensionApi extensionApi;
    @NotNull
    private final Networking networkService;
    private long lastHitTimestamp;
    @NotNull
    private final String version;
    @NotNull
    private static final String CLASS_NAME = "AnalyticsHitProcessor";
    private static final int HIT_QUEUE_RETRY_TIME_SECONDS = 30;
    private static final int TIMESTAMP_DISABLED_WAIT_THRESHOLD_SECONDS = 60;
    @NotNull
    private static final String CONTENT_TYPE_URL_ENCODED = "application/x-www-form-urlencoded";

    public AnalyticsHitProcessor(@NotNull AnalyticsState analyticsState, @NotNull ExtensionApi extensionApi) {
        Intrinsics.checkNotNullParameter((Object)analyticsState, (String)"analyticsState");
        Intrinsics.checkNotNullParameter((Object)extensionApi, (String)"extensionApi");
        this.analyticsState = analyticsState;
        this.extensionApi = extensionApi;
        Networking networking = ServiceProvider.getInstance().getNetworkService();
        Intrinsics.checkNotNullExpressionValue((Object)networking, (String)"getInstance().networkService");
        this.networkService = networking;
        this.version = AnalyticsVersionProvider.buildVersionString$analytics_phoneRelease$default(AnalyticsVersionProvider.INSTANCE, null, null, 3, null);
    }

    public int retryInterval(@NotNull DataEntity dataEntity) {
        Intrinsics.checkNotNullParameter((Object)dataEntity, (String)"dataEntity");
        return 30;
    }

    public void processHit(@NotNull DataEntity entity, @NotNull HitProcessingResult processingResult) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)processingResult, (String)"processingResult");
        AnalyticsHit analyticsHit = AnalyticsHit.Companion.from$analytics_phoneRelease(entity);
        String eventIdentifier = analyticsHit.getEventIdentifier();
        Ref.ObjectRef payload = new Ref.ObjectRef();
        payload.element = analyticsHit.getPayload();
        Ref.LongRef timestamp = new Ref.LongRef();
        timestamp.element = analyticsHit.getTimestampSec();
        if (((CharSequence)payload.element).length() == 0) {
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"processHit - Dropping Analytics hit, payload is empty.", (Object[])new Object[0]);
            processingResult.complete(true);
            return;
        }
        if (timestamp.element < this.analyticsState.getLastResetIdentitiesTimestampSec$analytics_phoneRelease()) {
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"processHit - Dropping Analytics hit, resetIdentities API was called after this request.", (Object[])new Object[0]);
            processingResult.complete(true);
            return;
        }
        if (!this.analyticsState.isOfflineTrackingEnabled$analytics_phoneRelease() && timestamp.element < TimeUtils.getUnixTimeInSeconds() - (long)60) {
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"processHit - Dropping Analytics hit, timestamp exceeds offline disabled wait threshold", (Object[])new Object[0]);
            processingResult.complete(true);
            return;
        }
        if (this.analyticsState.isOfflineTrackingEnabled$analytics_phoneRelease() && timestamp.element - this.lastHitTimestamp < 0L) {
            long newTimestamp = this.lastHitTimestamp + 1L;
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)("processHit - Adjusting out of order hit timestamp " + analyticsHit + ".timestamp -> " + newTimestamp), (Object[])new Object[0]);
            payload.element = this.replaceTimestampInPayload((String)payload.element, timestamp.element, newTimestamp);
            timestamp.element = newTimestamp;
        }
        String string = this.getAnalyticsBaseUrl(this.analyticsState);
        if (string == null) {
            AnalyticsHitProcessor $this$processHit_u24lambda_u240 = this;
            boolean bl = false;
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"processHit - Retrying Analytics hit, error generating base url.", (Object[])new Object[0]);
            processingResult.complete(false);
            return;
        }
        String url = string;
        if (this.analyticsState.isAssuranceSessionActive$analytics_phoneRelease()) {
            payload.element = (String)payload.element + "&p.&debug=true&.p";
        }
        Map header = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)CONTENT_TYPE_URL_ENCODED));
        byte[] byArray = ((String)payload.element).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        NetworkRequest networkRequest = new NetworkRequest(url, HttpMethod.POST, byArray, header, 5, 5);
        this.networkService.connectAsync(networkRequest, arg_0 -> AnalyticsHitProcessor.processHit$lambda$1(processingResult, url, payload, eventIdentifier, timestamp, this, arg_0));
    }

    private final String replaceTimestampInPayload(String payload, long oldTs, long newTs) {
        String oldTSString = "&ts=" + oldTs;
        String newTSString = "&ts=" + newTs;
        return StringsKt.replaceFirst$default((String)payload, (String)oldTSString, (String)newTSString, (boolean)false, (int)4, null);
    }

    private final String getAnalyticsBaseUrl(AnalyticsState state) {
        String baseUrl;
        if (!state.isAnalyticsConfigured()) {
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"getAnalyticsBaseUrl - The Analytics configuration for RSID or host is not found. RSID and host must not be null or empty.", (Object[])new Object[0]);
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder().append("https://").append(state.getHost$analytics_phoneRelease()).append("/b/ss/");
        String string = state.getRsids$analytics_phoneRelease();
        if (string == null) {
            string = "";
        }
        if (!UrlUtils.isValidUrl((String)(baseUrl = stringBuilder.append(string).append('/').append(this.getAnalyticsResponseType(state)).append('/').append(this.version).append("/s").append(RangesKt.random((IntRange)new IntRange(0, 100000000), (Random)((Random)Random.Default))).toString()))) {
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"getAnalyticsBaseUrl - Error building Analytics base URL, returning null", (Object[])new Object[0]);
            return null;
        }
        return baseUrl;
    }

    private final String getAnalyticsResponseType(AnalyticsState state) {
        return state.isAnalyticsForwardingEnabled$analytics_phoneRelease() ? "10" : "0";
    }

    @VisibleForTesting
    public final long getLastHitTimestamp$analytics_phoneRelease() {
        return this.lastHitTimestamp;
    }

    @VisibleForTesting
    public final void setLastHitTimestamp$analytics_phoneRelease(long timestamp) {
        this.lastHitTimestamp = timestamp;
    }

    private static final void processHit$lambda$1(HitProcessingResult $processingResult, String $url, Ref.ObjectRef $payload, String $eventIdentifier, Ref.LongRef $timestamp, AnalyticsHitProcessor this$0, HttpConnecting connection) {
        Intrinsics.checkNotNullParameter((Object)$processingResult, (String)"$processingResult");
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        Intrinsics.checkNotNullParameter((Object)$payload, (String)"$payload");
        Intrinsics.checkNotNullParameter((Object)$eventIdentifier, (String)"$eventIdentifier");
        Intrinsics.checkNotNullParameter((Object)$timestamp, (String)"$timestamp");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (connection == null) {
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"processHit - Retrying Analytics hit, there is currently no network connectivity", (Object[])new Object[0]);
            $processingResult.complete(false);
            return;
        }
        boolean doneProcessingResult = false;
        int n = connection.getResponseCode();
        if (n == 200) {
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)("processHit - Analytics hit request with url (" + $url + ") and payload (" + (String)$payload.element + ") sent successfully"), (Object[])new Object[0]);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ETag", (Object)connection.getResponsePropertyValue("ETag")), TuplesKt.to((Object)"Server", (Object)connection.getResponsePropertyValue("Server")), TuplesKt.to((Object)"Content-Type", (Object)connection.getResponsePropertyValue("Content-Type"))};
            Map httpHeaders = MapsKt.mapOf((Pair[])pairArray);
            String responseString = StreamUtils.readAsString((InputStream)connection.getInputStream());
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)"analyticsserverresponse", (Object)responseString), TuplesKt.to((Object)"headers", (Object)httpHeaders), TuplesKt.to((Object)"hitHost", (Object)$url), TuplesKt.to((Object)"hitUrl", (Object)$payload.element), TuplesKt.to((Object)"requestEventIdentifier", (Object)$eventIdentifier)};
            Map eventData = MapsKt.mapOf((Pair[])objectArray);
            if ($timestamp.element > this$0.analyticsState.getLastResetIdentitiesTimestampSec$analytics_phoneRelease()) {
                objectArray = new Object[]{$eventIdentifier};
                Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"processHit - Dispatching Analytics hit response for request event id %s.", (Object[])objectArray);
                this$0.extensionApi.dispatch(new Event.Builder("AnalyticsResponse", "com.adobe.eventType.analytics", "com.adobe.eventSource.responseContent").setEventData(eventData).build());
            } else {
                objectArray = new Object[]{$eventIdentifier};
                Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"processHit - Ignoring response for request event id %s as it was received while processing a resetIdentities event.", (Object[])objectArray);
            }
            this$0.lastHitTimestamp = $timestamp.element;
            doneProcessingResult = true;
        } else {
            Object[] httpHeaders = new Integer[]{408, 504, 503, -1};
            if (ArraysKt.contains((Object[])httpHeaders, (Object)n)) {
                Log.debug((String)"Analytics", (String)CLASS_NAME, (String)("processHit - Retrying Analytics hit, request with url " + $url + " failed with recoverable status code " + connection.getResponseCode()), (Object[])new Object[0]);
                doneProcessingResult = false;
            } else {
                String errorResponse = StreamUtils.readAsString((InputStream)connection.getErrorStream());
                Log.warning((String)"Analytics", (String)CLASS_NAME, (String)("processHit - Dropping Analytics hit, request with url " + $url + " failed with error and unrecoverable status code " + connection.getResponseCode() + ": " + errorResponse), (Object[])new Object[0]);
                doneProcessingResult = true;
            }
        }
        connection.close();
        $processingResult.complete(doneProcessingResult);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsHitProcessor$Companion;", "", "()V", "CLASS_NAME", "", "CONTENT_TYPE_URL_ENCODED", "HIT_QUEUE_RETRY_TIME_SECONDS", "", "TIMESTAMP_DISABLED_WAIT_THRESHOLD_SECONDS", "analytics_phoneRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

