/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.analytics.internal;

import com.adobe.marketing.mobile.analytics.internal.AnalyticsHit;
import com.adobe.marketing.mobile.analytics.internal.AnalyticsState;
import com.adobe.marketing.mobile.analytics.internal.ContextDataUtil;
import com.adobe.marketing.mobile.services.DataEntity;
import com.adobe.marketing.mobile.services.DataQueue;
import com.adobe.marketing.mobile.services.HitProcessing;
import com.adobe.marketing.mobile.services.HitQueuing;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.PersistentHitQueue;
import com.adobe.marketing.mobile.services.ServiceProvider;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0002,-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\r\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u0006\u0010\u001c\u001a\u00020\u0010J\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0010J$\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0001\u0018\u00010\bJ\b\u0010!\u001a\u00020\u0016H\u0002J-\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b(J\u0006\u0010)\u001a\u00020\u0016J\u000e\u0010*\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010+\u001a\u00020\u0010H\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsDatabase;", "", "processor", "Lcom/adobe/marketing/mobile/services/HitProcessing;", "analyticsState", "Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsState;", "(Lcom/adobe/marketing/mobile/services/HitProcessing;Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsState;)V", "additionalData", "", "", "hitQueue", "Lcom/adobe/marketing/mobile/services/HitQueuing;", "mainQueue", "Lcom/adobe/marketing/mobile/services/DataQueue;", "reorderQueue", "waitingForLifecycle", "", "waitingForReferrer", "appendAdditionalData", "Lcom/adobe/marketing/mobile/services/DataEntity;", "dataEntity", "cancelWaitForAdditionalData", "", "dataType", "Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsDatabase$DataType;", "getQueueSize", "", "getQueueSize$analytics_phoneRelease", "isHitWaiting", "kick", "ignoreBatchLimit", "kickWithAdditionalData", "data", "moveHitsFromReorderQueue", "queue", "payload", "timestampSec", "", "eventIdentifier", "isBackdateHit", "queue$analytics_phoneRelease", "reset", "waitForAdditionalData", "waitingForAdditionalData", "Companion", "DataType", "analytics_phoneRelease"})
@SourceDebugExtension(value={"SMAP\nAnalyticsDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsDatabase.kt\ncom/adobe/marketing/mobile/analytics/internal/AnalyticsDatabase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,353:1\n1855#2,2:354\n1#3:356\n*S KotlinDebug\n*F\n+ 1 AnalyticsDatabase.kt\ncom/adobe/marketing/mobile/analytics/internal/AnalyticsDatabase\n*L\n105#1:354,2\n*E\n"})
public final class AnalyticsDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HitProcessing processor;
    @NotNull
    private final AnalyticsState analyticsState;
    @NotNull
    private final HitQueuing hitQueue;
    @NotNull
    private final DataQueue mainQueue;
    @NotNull
    private final DataQueue reorderQueue;
    private boolean waitingForLifecycle;
    private boolean waitingForReferrer;
    @NotNull
    private Map<String, ? extends Object> additionalData;
    @NotNull
    private static final String CLASS_NAME = "AnalyticsDatabase";

    public AnalyticsDatabase(@NotNull HitProcessing processor, @NotNull AnalyticsState analyticsState) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)analyticsState, (String)"analyticsState");
        this.processor = processor;
        this.analyticsState = analyticsState;
        this.additionalData = MapsKt.emptyMap();
        DataQueue mainDataQueue = ServiceProvider.getInstance().getDataQueueService().getDataQueue("com.adobe.module.analytics");
        DataQueue reorderDataQueue = ServiceProvider.getInstance().getDataQueueService().getDataQueue("com.adobe.module.analyticsreorderqueue");
        Intrinsics.checkNotNullExpressionValue((Object)mainDataQueue, (String)"mainDataQueue");
        this.mainQueue = mainDataQueue;
        Intrinsics.checkNotNullExpressionValue((Object)reorderDataQueue, (String)"reorderDataQueue");
        this.reorderQueue = reorderDataQueue;
        this.hitQueue = (HitQueuing)new PersistentHitQueue(mainDataQueue, this.processor);
        this.moveHitsFromReorderQueue();
    }

    private final void moveHitsFromReorderQueue() {
        int count = this.reorderQueue.count();
        if (count <= 0) {
            Log.trace((String)"Analytics", (String)CLASS_NAME, (String)"moveHitsFromReorderQueue - No hits in reorder queue", (Object[])new Object[0]);
            return;
        }
        Log.trace((String)"Analytics", (String)CLASS_NAME, (String)("moveHitsFromReorderQueue - Moving queued hits " + count + " from reorder queue -> main queue"), (Object[])new Object[0]);
        List list = this.reorderQueue.peek(count);
        if (list != null) {
            List list2 = list;
            boolean bl = false;
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DataEntity it = (DataEntity)element$iv;
                boolean bl2 = false;
                this.mainQueue.add(it);
            }
        }
        this.reorderQueue.clear();
    }

    public final void queue$analytics_phoneRelease(@NotNull String payload, long timestampSec, @NotNull String eventIdentifier, boolean isBackdateHit) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)eventIdentifier, (String)"eventIdentifier");
        Log.debug((String)"Analytics", (String)CLASS_NAME, (String)("queueHit - " + payload + " isBackdateHit:" + isBackdateHit), (Object[])new Object[0]);
        String string = new AnalyticsHit(payload, timestampSec, eventIdentifier).toDataEntity$analytics_phoneRelease().getData();
        if (string == null) {
            AnalyticsDatabase $this$queue_u24lambda_u242 = this;
            boolean bl = false;
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"queueHit - Dropping Analytics hit, failed to encode AnalyticsHit", (Object[])new Object[0]);
            return;
        }
        String hitData = string;
        DataEntity hit = new DataEntity(hitData);
        if (isBackdateHit) {
            if (this.waitingForAdditionalData()) {
                Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"queueHit - Queueing backdated hit", (Object[])new Object[0]);
                this.mainQueue.add(hit);
            } else {
                Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"queueHit - Dropping backdate hit, as processing has begun for this current session", (Object[])new Object[0]);
            }
        } else if (this.waitingForAdditionalData()) {
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"queueHit - Queueing hit in reorder queue as a previous hit is waiting for additional data", (Object[])new Object[0]);
            this.reorderQueue.add(hit);
        } else {
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"queueHit - Queueing hit in main queue", (Object[])new Object[0]);
            this.mainQueue.add(hit);
        }
        this.kick(false);
    }

    public final void kick(boolean ignoreBatchLimit) {
        boolean overBatchLimit;
        Log.trace((String)"Analytics", (String)CLASS_NAME, (String)("Kick - ignoreBatchLimit " + ignoreBatchLimit + '.'), (Object[])new Object[0]);
        if (!this.analyticsState.isAnalyticsConfigured()) {
            Log.trace((String)"Analytics", (String)CLASS_NAME, (String)"Kick - Failed to kick database hits (Analytics is not configured).", (Object[])new Object[0]);
            return;
        }
        if (!this.analyticsState.isOptIn()) {
            Log.trace((String)"Analytics", (String)CLASS_NAME, (String)"Kick - Failed to kick database hits (Privacy status is not opted-in).", (Object[])new Object[0]);
            return;
        }
        int count = this.mainQueue.count();
        boolean bl = overBatchLimit = !this.analyticsState.isOfflineTrackingEnabled$analytics_phoneRelease() || count > this.analyticsState.getBatchLimit$analytics_phoneRelease();
        if (overBatchLimit || ignoreBatchLimit) {
            Log.trace((String)"Analytics", (String)CLASS_NAME, (String)"Kick - Begin processing database hits", (Object[])new Object[0]);
            this.hitQueue.beginProcessing();
        }
    }

    public final void reset() {
        this.hitQueue.suspend();
        this.mainQueue.clear();
        this.reorderQueue.clear();
        this.additionalData = MapsKt.emptyMap();
        this.waitingForLifecycle = false;
        this.waitingForReferrer = false;
    }

    public final void cancelWaitForAdditionalData(@NotNull DataType dataType) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        Log.debug((String)"Analytics", (String)CLASS_NAME, (String)("cancelWaitForAdditionalData - " + (Object)((Object)dataType)), (Object[])new Object[0]);
        this.kickWithAdditionalData(dataType, null);
    }

    public final void waitForAdditionalData(@NotNull DataType dataType) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        Log.debug((String)"Analytics", (String)CLASS_NAME, (String)("waitForAdditionalData - " + (Object)((Object)dataType)), (Object[])new Object[0]);
        switch (WhenMappings.$EnumSwitchMapping$0[dataType.ordinal()]) {
            case 1: {
                this.waitingForReferrer = true;
                break;
            }
            case 2: {
                this.waitingForLifecycle = true;
            }
        }
    }

    public final boolean isHitWaiting() {
        return this.reorderQueue.count() > 0;
    }

    public final void kickWithAdditionalData(@NotNull DataType dataType, @Nullable Map<String, ? extends Object> data) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        if (!this.waitingForAdditionalData()) {
            return;
        }
        Log.debug((String)"Analytics", (String)CLASS_NAME, (String)("KickWithAdditionalData - " + (Object)((Object)dataType) + " - " + data), (Object[])new Object[0]);
        switch (WhenMappings.$EnumSwitchMapping$0[dataType.ordinal()]) {
            case 1: {
                this.waitingForReferrer = false;
                break;
            }
            case 2: {
                this.waitingForLifecycle = false;
            }
        }
        Map<String, ? extends Object> map = data;
        if (map != null) {
            Map<String, ? extends Object> it = map;
            boolean bl = false;
            this.additionalData = MapsKt.plus(this.additionalData, it);
        }
        if (!this.waitingForAdditionalData()) {
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"KickWithAdditionalData - done waiting for additional data", (Object[])new Object[0]);
            if (this.isHitWaiting()) {
                DataEntity dataEntity = this.reorderQueue.peek();
                if (dataEntity != null) {
                    DataEntity firstHit = dataEntity;
                    boolean bl = false;
                    DataEntity appendedHit = this.appendAdditionalData(this.additionalData, firstHit);
                    this.mainQueue.add(appendedHit);
                    this.reorderQueue.remove();
                }
            }
            this.moveHitsFromReorderQueue();
            this.additionalData = MapsKt.emptyMap();
        }
        this.kick(false);
    }

    private final DataEntity appendAdditionalData(Map<String, ? extends Object> additionalData, DataEntity dataEntity) {
        AnalyticsHit analyticsHit = AnalyticsHit.Companion.from$analytics_phoneRelease(dataEntity);
        Intrinsics.checkNotNull(additionalData, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
        String payload = ContextDataUtil.appendContextData(additionalData, analyticsHit.getPayload());
        Intrinsics.checkNotNullExpressionValue((Object)payload, (String)"payload");
        String hitData = new AnalyticsHit(payload, analyticsHit.getTimestampSec(), analyticsHit.getEventIdentifier()).toDataEntity$analytics_phoneRelease().getData();
        return new DataEntity(hitData);
    }

    private final boolean waitingForAdditionalData() {
        return this.waitingForReferrer || this.waitingForLifecycle;
    }

    public final int getQueueSize$analytics_phoneRelease() {
        return this.mainQueue.count() + this.reorderQueue.count();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsDatabase$Companion;", "", "()V", "CLASS_NAME", "", "analytics_phoneRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsDatabase$DataType;", "", "(Ljava/lang/String;I)V", "REFERRER", "LIFECYCLE", "analytics_phoneRelease"})
    public static final class DataType
    extends Enum<DataType> {
        public static final /* enum */ DataType REFERRER = new DataType();
        public static final /* enum */ DataType LIFECYCLE = new DataType();
        private static final /* synthetic */ DataType[] $VALUES;

        public static DataType[] values() {
            return (DataType[])$VALUES.clone();
        }

        public static DataType valueOf(String value) {
            return Enum.valueOf(DataType.class, value);
        }

        static {
            $VALUES = dataTypeArray = new DataType[]{DataType.REFERRER, DataType.LIFECYCLE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataType.values().length];
            try {
                nArray[DataType.REFERRER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.LIFECYCLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

