/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.auth.impl.cug;

import com.day.cq.auth.impl.cug.CugRoot;
import com.day.cq.auth.impl.cug.CugSupportImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

class CugSupportWebConsolePlugin
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String LABEL = "cug";
    private static final String TITLE = "Closed User Groups (CUG)";
    private final CugSupportImpl cugSupport;
    private final ServiceRegistration registration;

    CugSupportWebConsolePlugin(BundleContext bundleContext, CugSupportImpl cugSupport) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("service.description", "Day CQ Closed User Group (CUG) Support WebConsole Plugin");
        props.put("service.vendor", "Day Management AG");
        props.put("felix.webconsole.label", LABEL);
        props.put("felix.webconsole.title", TITLE);
        props.put("felix.webconsole.configprinter.modes", new String[]{"txt", "zip"});
        this.registration = bundleContext.registerService(new String[]{"javax.servlet.Servlet"}, (Object)this, props);
        this.cugSupport = cugSupport;
    }

    void dispose() {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter pw = res.getWriter();
        String[] exemptedPrincipals = this.cugSupport.getExemptedPrincipals();
        CugRoot[] cugRoots = this.cugSupport.getCugRoots();
        pw.printf("<p class='statline ui-state-highlight'>Closed User Groups support is %sabled (%d configured CUG Root(s), %d exempted Principal(s))</p>%n", this.cugSupport.isEnabled() ? "en" : "dis", cugRoots.length, exemptedPrincipals.length);
        pw.println("<div class='ui-widget-header ui-corner-top buttonGroup' style='text-align: left; padding-left: 1em'>");
        pw.println("CUG Roots");
        pw.println("</div>");
        pw.println("<table class='nicetable ui-widget'>");
        pw.println("<tbody>");
        pw.println("<tr><th>Root</th><th>Login Form</th><th>Principals</th><th>Realm</th></tr>");
        for (CugRoot cugRoot : cugRoots) {
            pw.printf("<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>%n", cugRoot.getRoot(), cugRoot.getLoginPath() == null ? "[Default]" : cugRoot.getLoginPath(), cugRoot.getPrincipals() == null ? "-" : Arrays.asList(cugRoot.getPrincipals()), cugRoot.getRealm() == null ? "-" : cugRoot.getRealm());
        }
        pw.println("</tbody>");
        pw.println("</table>");
        pw.println("<p>&nbsp;</p>");
        pw.println("<div class='ui-widget-header ui-corner-top buttonGroup' style='text-align: left; padding-left: 1em'>");
        pw.println("Exempted Principals");
        pw.println("</div>");
        pw.println("<table class='nicetable ui-widget'>");
        pw.println("<tbody>");
        for (String ep : exemptedPrincipals) {
            pw.printf("<tr><td>%s</td></tr>%n", ep);
        }
        pw.println("</tbody>");
        pw.println("</table>");
    }

    public void printConfiguration(PrintWriter pw, String mode) {
        pw.println("Configuration");
        pw.printf("  Enabled: %s%n", this.cugSupport.isEnabled());
        pw.printf("  Exempted Principals: %s%n", Arrays.asList(this.cugSupport.getExemptedPrincipals()));
        pw.println();
        pw.println("Closed User Group Roots");
        for (CugRoot cugRoot : this.cugSupport.getCugRoots()) {
            pw.printf("  %s%n", cugRoot.getRoot());
            pw.printf("    Login Form: %s%n", cugRoot.getLoginPath() == null ? "[Default]" : cugRoot.getLoginPath());
            pw.printf("    Principals: %s%n", cugRoot.getPrincipals() == null ? "-" : Arrays.asList(cugRoot.getPrincipals()));
            pw.printf("    Realm: %s%n", cugRoot.getRealm() == null ? "-" : cugRoot.getRealm());
        }
    }
}

