/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.IOException;
import org.apache.xerces.impl.XMLDocumentFragmentScannerImpl;
import org.apache.xerces.impl.XMLDocumentScannerMMImpl;
import org.apache.xerces.impl.XMLScanner;
import org.apache.xerces.impl.dtd.XMLDTDValidatorFilter;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.util.XMLAttributesMMImpl;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentSource;

public class XMLNSDocumentScannerMMImpl
extends XMLDocumentScannerMMImpl {
    protected boolean fBindNamespaces;
    protected boolean fPerformValidation;
    protected String[] fUri = new String[4];
    protected String[] fLocalpart = new String[4];
    protected int fLength = 0;
    private XMLDTDValidatorFilter fDTDValidator;

    public void setDTDValidator(XMLDTDValidatorFilter dtd) {
        this.fDTDValidator = dtd;
    }

    protected boolean scanStartElement() throws IOException, XNIException {
        String rawname = null;
        ((XMLScanner)this).fEntityScanner.scanQName(this.fElementQName);
        if (this.fBindNamespaces) {
            this.fNamespaceContext.pushContext();
            rawname = this.fElementQName.rawname;
            if (this.fScannerState == 6 && this.fPerformValidation) {
                ((XMLScanner)this).fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_GRAMMAR_NOT_FOUND", new Object[]{rawname}, (short)1);
                if (this.fDoctypeName == null || !this.fDoctypeName.equals(rawname)) {
                    ((XMLScanner)this).fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "RootElementTypeMustMatchDoctypedecl", new Object[]{this.fDoctypeName, rawname}, (short)1);
                }
            }
        }
        this.fCurrentElement = this.fElementStack.pushElement(this.fElementQName);
        boolean empty = false;
        this.fAttributes.removeAllAttributes();
        while (true) {
            boolean sawSpace = ((XMLScanner)this).fEntityScanner.skipSpaces();
            int c = ((XMLScanner)this).fEntityScanner.peekChar();
            if (c == 62) {
                ((XMLScanner)this).fEntityScanner.scanChar();
                break;
            }
            if (c == 47) {
                ((XMLScanner)this).fEntityScanner.scanChar();
                if (!((XMLScanner)this).fEntityScanner.skipChar(62)) {
                    this.reportFatalError("ElementUnterminated", new Object[]{rawname});
                }
                empty = true;
                break;
            }
            if (!this.isValidNameStartChar(c) || !sawSpace) {
                this.reportFatalError("ElementUnterminated", new Object[]{rawname});
            }
            this.scanAttribute(this.fAttributes);
        }
        if (this.fBindNamespaces) {
            if (this.fElementQName.prefix == XMLSymbols.PREFIX_XMLNS) {
                ((XMLScanner)this).fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "ElementXMLNSPrefix", new Object[]{this.fElementQName.rawname}, (short)2);
            }
            String prefix = this.fElementQName.prefix != null ? this.fElementQName.prefix : XMLSymbols.EMPTY_STRING;
            this.fCurrentElement.uri = this.fElementQName.uri = this.fNamespaceContext.getURI(prefix);
            if (this.fElementQName.prefix == null && this.fElementQName.uri != null) {
                this.fElementQName.prefix = XMLSymbols.EMPTY_STRING;
            }
            if (this.fElementQName.prefix != null && this.fElementQName.uri == null) {
                ((XMLScanner)this).fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "ElementPrefixUnbound", new Object[]{this.fElementQName.prefix, this.fElementQName.rawname}, (short)2);
            }
            int length = this.fAttributes.getLength();
            this.fLength = 0;
            int i = 0;
            while (i < length) {
                this.fAttributes.getName(i, this.fAttributeQName);
                String aprefix = this.fAttributeQName.prefix != null ? this.fAttributeQName.prefix : XMLSymbols.EMPTY_STRING;
                String uri = this.fNamespaceContext.getURI(aprefix);
                if (this.fAttributeQName.uri != null && this.fAttributeQName.uri == uri) {
                    this.checkDuplicates(this.fAttributeQName, this.fAttributes);
                } else if (aprefix != XMLSymbols.EMPTY_STRING) {
                    this.fAttributeQName.uri = uri;
                    if (uri == null) {
                        ((XMLScanner)this).fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "AttributePrefixUnbound", new Object[]{aprefix, this.fAttributeQName.rawname}, (short)2);
                    }
                    this.fAttributes.setURI(i, uri);
                    this.checkDuplicates(this.fAttributeQName, this.fAttributes);
                }
                ++i;
            }
        }
        if (this.fDocumentHandler != null) {
            if (empty) {
                --this.fMarkupDepth;
                if (this.fMarkupDepth < this.fEntityStack[((XMLScanner)this).fEntityDepth - 1]) {
                    this.reportFatalError("ElementEntityMismatch", new Object[]{this.fCurrentElement.rawname});
                }
                this.fDocumentHandler.emptyElement(this.fElementQName, (XMLAttributes)this.fAttributes, null);
                if (this.fBindNamespaces) {
                    this.fNamespaceContext.popContext();
                }
                this.fElementStack.popElement(this.fElementQName);
            } else {
                this.fDocumentHandler.startElement(this.fElementQName, (XMLAttributes)this.fAttributes, null);
            }
        }
        return empty;
    }

    private final void checkDuplicates(QName qname, XMLAttributesImpl attributes) {
        int i = 0;
        while (i < this.fLength) {
            if (qname.uri == this.fUri[i] && this.fLocalpart[i].equals(qname.localpart)) {
                ((XMLScanner)this).fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "AttributeNSNotUnique", new Object[]{this.fElementQName.rawname, qname.rawname, qname.uri}, (short)2);
            }
            ++i;
        }
        int index = this.fLength;
        if (this.fLength++ == this.fUri.length) {
            String[] uris = new String[this.fUri.length + 4];
            String[] lps = new String[this.fUri.length + 4];
            System.arraycopy(this.fUri, 0, uris, 0, this.fUri.length);
            System.arraycopy(this.fLocalpart, 0, lps, 0, this.fLocalpart.length);
            this.fUri = uris;
            this.fLocalpart = lps;
        }
        this.fUri[index] = qname.uri;
        this.fLocalpart[index] = qname.localpart;
    }

    protected void scanAttribute(XMLAttributesImpl attributes) throws IOException, XNIException {
        ((XMLScanner)this).fEntityScanner.scanQName(this.fAttributeQName);
        ((XMLScanner)this).fEntityScanner.skipSpaces();
        if (!((XMLScanner)this).fEntityScanner.skipChar(61)) {
            this.reportFatalError("EqRequiredInAttribute", new Object[]{this.fAttributeQName.rawname});
        }
        ((XMLScanner)this).fEntityScanner.skipSpaces();
        int oldLen = attributes.getLength();
        int index = attributes.addAttribute(this.fAttributeQName, XMLSymbols.fCDATASymbol, null);
        if (attributes instanceof XMLAttributesMMImpl) {
            ((XMLAttributesMMImpl)attributes).setLineNumber(index, ((XMLScanner)this).fEntityScanner.getLineNumber());
        }
        if (oldLen == attributes.getLength()) {
            this.reportFatalError("AttributeNotUnique", new Object[]{this.fCurrentElement.rawname, this.fAttributeQName.rawname});
        }
        boolean isVC = this.fHasExternalDTD && !this.fStandalone;
        this.scanAttributeValue(this.fTempString, this.fTempString2, this.fAttributeQName.rawname, (XMLAttributes)attributes, oldLen, isVC);
        String value = this.fTempString.toString();
        attributes.setValue(oldLen, value);
        attributes.setNonNormalizedValue(oldLen, this.fTempString2.toString());
        attributes.setSpecified(oldLen, true);
        if (this.fBindNamespaces) {
            String prefix;
            String localpart = this.fAttributeQName.localpart;
            String string = prefix = this.fAttributeQName.prefix != null ? this.fAttributeQName.prefix : XMLSymbols.EMPTY_STRING;
            if (prefix == XMLSymbols.PREFIX_XMLNS || prefix == XMLSymbols.EMPTY_STRING && localpart == XMLSymbols.PREFIX_XMLNS) {
                String uri = ((XMLScanner)this).fSymbolTable.addSymbol(value);
                if (prefix == XMLSymbols.PREFIX_XMLNS && localpart == XMLSymbols.PREFIX_XMLNS) {
                    ((XMLScanner)this).fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXMLNS", new Object[]{this.fAttributeQName}, (short)2);
                }
                if (uri == NamespaceContext.XMLNS_URI) {
                    ((XMLScanner)this).fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXMLNS", new Object[]{this.fAttributeQName}, (short)2);
                }
                if (localpart == XMLSymbols.PREFIX_XML) {
                    if (uri != NamespaceContext.XML_URI) {
                        ((XMLScanner)this).fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXML", new Object[]{this.fAttributeQName}, (short)2);
                    }
                } else if (uri == NamespaceContext.XML_URI) {
                    ((XMLScanner)this).fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXML", new Object[]{this.fAttributeQName}, (short)2);
                }
                String string2 = prefix = localpart != XMLSymbols.PREFIX_XMLNS ? localpart : XMLSymbols.EMPTY_STRING;
                if (uri == XMLSymbols.EMPTY_STRING && localpart != XMLSymbols.PREFIX_XMLNS) {
                    ((XMLScanner)this).fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "EmptyPrefixedAttName", new Object[]{this.fAttributeQName}, (short)2);
                }
                this.fNamespaceContext.declarePrefix(prefix, uri.length() != 0 ? uri : null);
                attributes.setURI(oldLen, this.fNamespaceContext.getURI(XMLSymbols.PREFIX_XMLNS));
            } else if (this.fAttributeQName.prefix != null) {
                attributes.setURI(oldLen, this.fNamespaceContext.getURI(this.fAttributeQName.prefix));
            }
        }
    }

    protected int scanEndElement() throws IOException, XNIException {
        this.fElementStack.popElement(this.fElementQName);
        if (!((XMLScanner)this).fEntityScanner.skipString(this.fElementQName.rawname)) {
            this.reportFatalError("ETagRequired", new Object[]{this.fElementQName.rawname});
        }
        ((XMLScanner)this).fEntityScanner.skipSpaces();
        if (!((XMLScanner)this).fEntityScanner.skipChar(62)) {
            this.reportFatalError("ETagUnterminated", new Object[]{this.fElementQName.rawname});
        }
        --this.fMarkupDepth;
        --this.fMarkupDepth;
        if (this.fMarkupDepth < this.fEntityStack[((XMLScanner)this).fEntityDepth - 1]) {
            this.reportFatalError("ElementEntityMismatch", new Object[]{this.fCurrentElement.rawname});
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endElement(this.fElementQName, null);
            if (this.fBindNamespaces) {
                this.fNamespaceContext.popContext();
            }
        }
        return this.fMarkupDepth;
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        super.reset(componentManager);
        this.fPerformValidation = false;
        this.fBindNamespaces = false;
    }

    protected XMLDocumentFragmentScannerImpl.Dispatcher createContentDispatcher() {
        return new NSContentDispatcher();
    }

    protected final class NSContentDispatcher
    extends XMLDocumentScannerMMImpl.ContentDispatcher {
        protected NSContentDispatcher() {
        }

        protected boolean scanRootElementHook() throws IOException, XNIException {
            if (XMLNSDocumentScannerMMImpl.this.fDTDValidator == null) {
                XMLNSDocumentScannerMMImpl.this.fBindNamespaces = true;
            } else if (!XMLNSDocumentScannerMMImpl.this.fDTDValidator.hasGrammar()) {
                XMLNSDocumentScannerMMImpl.this.fBindNamespaces = true;
                XMLNSDocumentScannerMMImpl.this.fPerformValidation = XMLNSDocumentScannerMMImpl.this.fDTDValidator.validate();
                XMLDocumentSource source = XMLNSDocumentScannerMMImpl.this.fDTDValidator.getDocumentSource();
                XMLDocumentHandler handler = XMLNSDocumentScannerMMImpl.this.fDTDValidator.getDocumentHandler();
                source.setDocumentHandler(handler);
                if (handler != null) {
                    handler.setDocumentSource(source);
                }
                XMLNSDocumentScannerMMImpl.this.fDTDValidator.setDocumentSource(null);
                XMLNSDocumentScannerMMImpl.this.fDTDValidator.setDocumentHandler(null);
            }
            if (XMLNSDocumentScannerMMImpl.this.scanStartElement()) {
                XMLNSDocumentScannerMMImpl.this.setScannerState(12);
                XMLNSDocumentScannerMMImpl.this.setDispatcher(XMLNSDocumentScannerMMImpl.this.fTrailingMiscDispatcher);
                return true;
            }
            return false;
        }
    }
}

