/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts;

import flash.fonts.FontDescription;
import flash.fonts.FontFace;
import flash.swf.tags.DefineFont;
import flash.util.Trace;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class FontManager {
    public static final String LOCAL_FONT_PATHS = "local-font-paths";
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    protected Properties languageRanges;
    protected FontManager parent;

    protected FontManager() {
    }

    public abstract void initialize(Map var1);

    public void setParent(FontManager parent) {
        this.parent = parent;
    }

    public void setLanguageRange(Properties languageRanges) {
        this.languageRanges = languageRanges;
    }

    public String getLanguageRange(String lang) {
        String range = null;
        if (this.languageRanges != null) {
            range = this.languageRanges.getProperty(lang);
        }
        return range;
    }

    public DefineFont createDefineFont(int tagCode, FontDescription desc) {
        return null;
    }

    public abstract FontFace getEntryFromLocation(URL var1, int var2, boolean var3);

    public abstract FontFace getEntryFromSystem(String var1, int var2, boolean var3);

    public void loadDefineFont(DefineFont tag, Object location) {
    }

    public void loadDefineFont(DefineFont tag) {
        this.loadDefineFont(tag, null);
    }

    protected int[][] getUnicodeRanges(String r) {
        int[][] ranges = null;
        if (r != null) {
            String value = new String(r);
            String langRange = this.getLanguageRange(value);
            if (langRange != null) {
                value = langRange;
            }
            value = value.replace(';', ' ').replace('\n', ' ').replace('\r', ' ').replace('\f', ' ');
            StringTokenizer st = new StringTokenizer(value, ",");
            int count = st.countTokens();
            ranges = new int[count][2];
            FontManager.parseRanges(st, ranges);
        }
        return ranges;
    }

    public static boolean isItalic(int style) {
        return style == 2 || style == 3;
    }

    public static boolean isBold(int style) {
        return style == 1 || style == 3;
    }

    public static FontManager create(List managerClasses, Map map) {
        return FontManager.create(managerClasses, map, null);
    }

    public static FontManager create(List managerClasses, Map map, Properties languageRanges) {
        FontManager manager = null;
        if (managerClasses != null) {
            for (int i = 0; i < managerClasses.size(); ++i) {
                try {
                    Class<?> clazz;
                    Object obj;
                    Object className = managerClasses.get(i);
                    if (className == null || !((obj = (clazz = Class.forName(className.toString())).newInstance()) instanceof FontManager)) continue;
                    FontManager fm = (FontManager)obj;
                    fm.initialize(map);
                    if (manager != null) {
                        fm.setParent(manager);
                    }
                    if (languageRanges != null) {
                        fm.setLanguageRange(languageRanges);
                    }
                    manager = fm;
                    continue;
                }
                catch (Throwable t) {
                    if (!Trace.font) continue;
                    Trace.trace(t.getMessage());
                }
            }
        }
        return manager;
    }

    public static void throwFontNotFound(String alias, String fontFamily, int style, String location) {
        StringBuilder message = new StringBuilder("Font for alias '");
        message.append(alias).append("' ");
        if (style == 1) {
            message.append("with bold weight ");
        } else if (style == 2) {
            message.append("with italic style ");
        } else if (style == 3) {
            message.append("with bold weight and italic style ");
        } else {
            message.append("with plain weight and style ");
        }
        if (location != null) {
            message.append("was not found at: ").append(location.toString());
        } else {
            message.append("was not found by family name '").append(fontFamily).append("'");
        }
        throw new FontNotFoundException(message.toString());
    }

    private static void parseRanges(StringTokenizer st, int[][] ranges) {
        int i = 0;
        while (st.hasMoreElements()) {
            String element = ((String)st.nextElement()).trim().toUpperCase();
            if (element.startsWith("U+")) {
                String high;
                String low;
                String range = element.substring(2).trim();
                if (range.indexOf(63) > 0) {
                    low = range.replace('?', '0');
                    high = range.replace('?', 'F');
                } else if (range.indexOf(45) > 0) {
                    low = range.substring(0, range.indexOf(45));
                    String temp = range.substring(range.indexOf(45) + 1).trim();
                    high = temp.startsWith("U+") ? temp.substring(2).trim() : temp;
                } else if (range.length() <= 4) {
                    low = range;
                    high = range;
                } else {
                    throw new InvalidUnicodeRangeException(range);
                }
                ranges[i][0] = Integer.parseInt(low, 16);
                ranges[i][1] = Integer.parseInt(high, 16);
                ++i;
                continue;
            }
            if (element.length() == 0) continue;
            throw new InvalidUnicodeRangeException(element);
        }
    }

    public static final class InvalidUnicodeRangeException
    extends RuntimeException {
        private static final long serialVersionUID = 3173208110428813980L;
        public String range;

        public InvalidUnicodeRangeException(String range) {
            this.range = range;
        }
    }

    public static final class FontNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = -2385779348825570473L;

        public FontNotFoundException(String message) {
            super(message);
        }
    }
}

