/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.DOMParserHelper;
import com.adobe.internal.fxg.dom.GraphicContentNode;
import com.adobe.internal.fxg.dom.GraphicContext;
import com.adobe.internal.fxg.dom.MaskingNode;
import com.adobe.internal.fxg.dom.types.ScalingGrid;
import java.util.ArrayList;
import java.util.List;

public class GroupNode
extends GraphicContentNode
implements MaskingNode {
    public double scaleGridLeft = 0.0;
    public double scaleGridTop = 0.0;
    public double scaleGridRight = 0.0;
    public double scaleGridBottom = 0.0;
    public List<GraphicContentNode> children;
    private boolean definesScaleGrid;
    private boolean insideScaleGrid;
    private int maskIndex;

    public void addChild(FXGNode child) {
        if (child instanceof GraphicContentNode) {
            if (this.children == null) {
                this.children = new ArrayList<GraphicContentNode>();
            }
            GraphicContentNode graphicContent = (GraphicContentNode)child;
            graphicContent.setParentGraphicContext(this.createGraphicContext());
            if (child instanceof GroupNode && this.isInsideScaleGrid()) {
                throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidScaleGridGroupChild", new Object[0]);
            }
            this.children.add(graphicContent);
        } else {
            super.addChild(child);
        }
    }

    public String getNodeName() {
        return "Group";
    }

    public void setAttribute(String name, String value) {
        if ("scaleGridLeft".equals(name)) {
            this.scaleGridLeft = DOMParserHelper.parseDouble(this, value, name);
            this.definesScaleGrid = true;
        } else if ("scaleGridTop".equals(name)) {
            this.scaleGridTop = DOMParserHelper.parseDouble(this, value, name);
            this.definesScaleGrid = true;
        } else if ("scaleGridRight".equals(name)) {
            this.scaleGridRight = DOMParserHelper.parseDouble(this, value, name);
            this.definesScaleGrid = true;
        } else if ("scaleGridBottom".equals(name)) {
            this.scaleGridBottom = DOMParserHelper.parseDouble(this, value, name);
            this.definesScaleGrid = true;
        } else {
            super.setAttribute(name, value);
        }
        if (this.definesScaleGrid && this.rotationSet) {
            throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidScaleGridRotationAttribute", new Object[0]);
        }
    }

    public GraphicContext createGraphicContext() {
        GraphicContext context = super.createGraphicContext();
        if (this.definesScaleGrid()) {
            ScalingGrid scalingGrid = new ScalingGrid();
            scalingGrid.scaleGridLeft = this.scaleGridLeft;
            scalingGrid.scaleGridTop = this.scaleGridTop;
            scalingGrid.scaleGridRight = this.scaleGridRight;
            scalingGrid.scaleGridBottom = this.scaleGridBottom;
            context.scalingGrid = scalingGrid;
        }
        return context;
    }

    public boolean definesScaleGrid() {
        return this.definesScaleGrid;
    }

    public boolean isInsideScaleGrid() {
        return this.insideScaleGrid || this.definesScaleGrid;
    }

    public void setInsideScaleGrid(boolean value) {
        this.insideScaleGrid = value;
    }

    public int getMaskIndex() {
        return this.maskIndex;
    }

    public void setMaskIndex(int index) {
        this.maskIndex = index;
    }
}

