/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.sax;

import com.adobe.fxg.FXGVersion;
import com.adobe.internal.fxg.sax.FXGVersionHandler;
import com.adobe.internal.fxg.sax.FXG_v1_0_Handler;
import com.adobe.internal.fxg.sax.FXG_v2_0_Handler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FXGVersionHandlerRegistry {
    private static HashMap<FXGVersion, FXGVersionHandler> versionHandlers = new HashMap(4);
    public static FXGVersion defaultVersion = FXGVersion.v2_0;
    private static boolean registered = false;

    private static void registerKnownHandlers() {
        if (registered) {
            return;
        }
        FXGVersionHandlerRegistry.registerHandler(FXGVersion.v1_0, new FXG_v1_0_Handler());
        FXGVersionHandlerRegistry.registerHandler(FXGVersion.v2_0, new FXG_v2_0_Handler());
        registered = true;
    }

    protected static FXGVersionHandler getDefaultHandler() {
        FXGVersionHandlerRegistry.registerKnownHandlers();
        return versionHandlers.get(defaultVersion);
    }

    protected static void registerHandler(FXGVersion version, FXGVersionHandler obj) {
        if (versionHandlers != null) {
            FXGVersionHandler vHandler = versionHandlers.get(version);
            FXGVersion fxgVersion = vHandler != null ? vHandler.getVersion() : version;
            versionHandlers.put(fxgVersion, obj);
        }
    }

    protected static void unregisterHandler(FXGVersion version) {
        FXGVersionHandler vHandler;
        if (versionHandlers != null && (vHandler = versionHandlers.get(version)) != null) {
            FXGVersion fxgVersion = vHandler.getVersion();
            versionHandlers.remove(fxgVersion);
        }
    }

    protected static Set<FXGVersion> getVersionsForRegisteredHandlers() {
        if (versionHandlers == null) {
            return null;
        }
        FXGVersionHandlerRegistry.registerKnownHandlers();
        return versionHandlers.keySet();
    }

    protected static FXGVersionHandler getVersionHandler(FXGVersion fxgVersion) {
        if (versionHandlers == null) {
            return null;
        }
        Set<FXGVersion> versions = FXGVersionHandlerRegistry.getVersionsForRegisteredHandlers();
        for (FXGVersion version : versions) {
            if (!version.equalTo(fxgVersion)) continue;
            return versionHandlers.get(version);
        }
        for (FXGVersion version : versions) {
            if (version.getMajorVersion() != fxgVersion.getMajorVersion()) continue;
            return versionHandlers.get(version);
        }
        return null;
    }

    protected static FXGVersionHandler getVersionHandler(double version) {
        FXGVersion fxgVersion = FXGVersion.newInstance(version);
        return FXGVersionHandlerRegistry.getVersionHandler(fxgVersion);
    }

    protected static FXGVersionHandler getLatestVersionHandler() {
        if (versionHandlers == null) {
            return null;
        }
        Set<FXGVersion> versions = FXGVersionHandlerRegistry.getVersionsForRegisteredHandlers();
        Iterator<FXGVersion> iter = versions.iterator();
        FXGVersion latest = null;
        while (iter.hasNext()) {
            FXGVersion version = iter.next();
            if (latest == null) {
                latest = version;
                continue;
            }
            if (!version.greaterThan(latest)) continue;
            latest = version;
        }
        return versionHandlers.get(latest);
    }
}

