/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom.richtext;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.types.AlignmentBaseline;
import com.adobe.internal.fxg.dom.types.BlockProgression;
import com.adobe.internal.fxg.dom.types.BreakOpportunity;
import com.adobe.internal.fxg.dom.types.DigitCase;
import com.adobe.internal.fxg.dom.types.DigitWidth;
import com.adobe.internal.fxg.dom.types.Direction;
import com.adobe.internal.fxg.dom.types.DominantBaseline;
import com.adobe.internal.fxg.dom.types.FontStyle;
import com.adobe.internal.fxg.dom.types.FontWeight;
import com.adobe.internal.fxg.dom.types.JustificationRule;
import com.adobe.internal.fxg.dom.types.JustificationStyle;
import com.adobe.internal.fxg.dom.types.Kerning;
import com.adobe.internal.fxg.dom.types.LeadingModel;
import com.adobe.internal.fxg.dom.types.LigatureLevel;
import com.adobe.internal.fxg.dom.types.LineBreak;
import com.adobe.internal.fxg.dom.types.TextAlign;
import com.adobe.internal.fxg.dom.types.TextDecoration;
import com.adobe.internal.fxg.dom.types.TextJustify;
import com.adobe.internal.fxg.dom.types.TextRotation;
import com.adobe.internal.fxg.dom.types.TypographicCase;
import com.adobe.internal.fxg.dom.types.VerticalAlign;
import com.adobe.internal.fxg.dom.types.WhiteSpaceCollapse;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextHelper {
    protected static final double ALPHA_MIN_INCLUSIVE = 0.0;
    protected static final double ALPHA_MAX_INCLUSIVE = 1.0;
    protected static Pattern whitespacePattern = Pattern.compile("(\\s+)");

    public static boolean ignorableWhitespace(String value) {
        Matcher m = whitespacePattern.matcher(value);
        return m.matches();
    }

    public static FontStyle getFontStyle(FXGNode node, String value) {
        if ("normal".equals(value)) {
            return FontStyle.NORMAL;
        }
        if ("italic".equals(value)) {
            return FontStyle.ITALIC;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownFontStyle", value);
    }

    public static FontWeight getFontWeight(FXGNode node, String value) {
        if ("normal".equals(value)) {
            return FontWeight.NORMAL;
        }
        if ("bold".equals(value)) {
            return FontWeight.BOLD;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownFontWeight", value);
    }

    public static TextDecoration getTextDecoration(FXGNode node, String value) {
        if ("none".equals(value)) {
            return TextDecoration.NONE;
        }
        if ("underline".equals(value)) {
            return TextDecoration.UNDERLINE;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownTextDecoration", value);
    }

    public static Kerning getKerning(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return Kerning.AUTO;
        }
        if ("on".equals(value)) {
            return Kerning.ON;
        }
        if ("off".equals(value)) {
            return Kerning.OFF;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownKerning", value);
    }

    public static WhiteSpaceCollapse getWhiteSpaceCollapse(FXGNode node, String value) {
        if ("preserve".equals(value)) {
            return WhiteSpaceCollapse.PRESERVE;
        }
        if ("collapse".equals(value)) {
            return WhiteSpaceCollapse.COLLAPSE;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownWhiteSpaceCollapse", value);
    }

    public static BreakOpportunity getBreakOpportunity(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return BreakOpportunity.AUTO;
        }
        if ("any".equals(value)) {
            return BreakOpportunity.ANY;
        }
        if ("none".equals(value)) {
            return BreakOpportunity.NONE;
        }
        if ("all".equals(value)) {
            return BreakOpportunity.ALL;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownBreakOpportunity", value);
    }

    public static DigitCase getDigitCase(FXGNode node, String value) {
        if ("default".equals(value)) {
            return DigitCase.DEFAULT;
        }
        if ("lining".equals(value)) {
            return DigitCase.LINING;
        }
        if ("oldStyle".equals(value)) {
            return DigitCase.OLDSTYLE;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownDigitCase", value);
    }

    public static DigitWidth getDigitWidth(FXGNode node, String value) {
        if ("default".equals(value)) {
            return DigitWidth.DEFAULT;
        }
        if ("proportional".equals(value)) {
            return DigitWidth.PROPORTIONAL;
        }
        if ("tabular".equals(value)) {
            return DigitWidth.TABULAR;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownDigitWidth", value);
    }

    public static DominantBaseline getDominantBaseline(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return DominantBaseline.AUTO;
        }
        if ("roman".equals(value)) {
            return DominantBaseline.ROMAN;
        }
        if ("ascent".equals(value)) {
            return DominantBaseline.ASCENT;
        }
        if ("descent".equals(value)) {
            return DominantBaseline.DESCENT;
        }
        if ("ideographicTop".equals(value)) {
            return DominantBaseline.IDEOGRAPHICTOP;
        }
        if ("ideographicCenter".equals(value)) {
            return DominantBaseline.IDEOGRAPHICCENTER;
        }
        if ("ideographicBottom".equals(value)) {
            return DominantBaseline.IDEOGRAPHICBOTTOM;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownDominantBaseline", value);
    }

    public static AlignmentBaseline getAlignmentBaseline(FXGNode node, String value) {
        if ("useDominantBaseline".equals(value)) {
            return AlignmentBaseline.USEDOMINANTBASELINE;
        }
        if ("roman".equals(value)) {
            return AlignmentBaseline.ROMAN;
        }
        if ("ascent".equals(value)) {
            return AlignmentBaseline.ASCENT;
        }
        if ("descent".equals(value)) {
            return AlignmentBaseline.DESCENT;
        }
        if ("ideographicTop".equals(value)) {
            return AlignmentBaseline.IDEOGRAPHICTOP;
        }
        if ("ideographicCenter".equals(value)) {
            return AlignmentBaseline.IDEOGRAPHICCENTER;
        }
        if ("ideographicBottom".equals(value)) {
            return AlignmentBaseline.IDEOGRAPHICBOTTOM;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownAlignmentBaseline", value);
    }

    public static LigatureLevel getLigatureLevel(FXGNode node, String value) {
        if ("minimum".equals(value)) {
            return LigatureLevel.MINIMUM;
        }
        if ("common".equals(value)) {
            return LigatureLevel.COMMON;
        }
        if ("uncommon".equals(value)) {
            return LigatureLevel.UNCOMMON;
        }
        if ("exotic".equals(value)) {
            return LigatureLevel.EXOTIC;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownLigatureLevel", value);
    }

    public static TypographicCase getTypographicCase(FXGNode node, String value) {
        if ("default".equals(value)) {
            return TypographicCase.DEFAULT;
        }
        if ("capsToSmallCaps".equals(value)) {
            return TypographicCase.CAPSTOSMALLCAPS;
        }
        if ("uppercase".equals(value)) {
            return TypographicCase.UPPERCASE;
        }
        if ("lowercase".equals(value)) {
            return TypographicCase.LOWERCASE;
        }
        if ("lowercaseToSmallCaps".equals(value)) {
            return TypographicCase.LOWERCASETOSMALLCAPS;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownTypographicCase", value);
    }

    public static TextRotation getTextRotation(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return TextRotation.AUTO;
        }
        if ("rotate0".equals(value)) {
            return TextRotation.ROTATE_0;
        }
        if ("rotate90".equals(value)) {
            return TextRotation.ROTATE_90;
        }
        if ("rotate180".equals(value)) {
            return TextRotation.ROTATE_180;
        }
        if ("rotate270".equals(value)) {
            return TextRotation.ROTATE_270;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownTextRotation", value);
    }

    public static TextAlign getTextAlign(FXGNode node, String value) {
        if ("start".equals(value)) {
            return TextAlign.START;
        }
        if ("end".equals(value)) {
            return TextAlign.END;
        }
        if ("left".equals(value)) {
            return TextAlign.LEFT;
        }
        if ("center".equals(value)) {
            return TextAlign.CENTER;
        }
        if ("right".equals(value)) {
            return TextAlign.RIGHT;
        }
        if ("justify".equals(value)) {
            return TextAlign.JUSTIFY;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownTextAlign", value);
    }

    public static Direction getDirection(FXGNode node, String value) {
        if ("ltr".equals(value)) {
            return Direction.LTR;
        }
        if ("rtl".equals(value)) {
            return Direction.RTL;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownDirection", value);
    }

    public static JustificationRule getJustificationRule(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return JustificationRule.AUTO;
        }
        if ("space".equals(value)) {
            return JustificationRule.SPACE;
        }
        if ("eastAsian".equals(value)) {
            return JustificationRule.EASTASIAN;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownJustificationRule", value);
    }

    public static JustificationStyle getJustificationStyle(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return JustificationStyle.AUTO;
        }
        if ("prioritizeLeastAdjustment".equals(value)) {
            return JustificationStyle.PRIORITIZELEASTADJUSTMENT;
        }
        if ("pushInKinsoku".equals(value)) {
            return JustificationStyle.PUSHINKINSOKU;
        }
        if ("pushOutOnly".equals(value)) {
            return JustificationStyle.PUSHOUTONLY;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownJustificationStyle", value);
    }

    public static TextJustify getTextJustify(FXGNode node, String value) {
        if ("interWord".equals(value)) {
            return TextJustify.INTERWORD;
        }
        if ("distribute".equals(value)) {
            return TextJustify.DISTRIBUTE;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownTextJustify", value);
    }

    public static LeadingModel getLeadingModel(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return LeadingModel.AUTO;
        }
        if ("romanUp".equals(value)) {
            return LeadingModel.ROMANUP;
        }
        if ("ideographicTopUp".equals(value)) {
            return LeadingModel.IDEOGRAPHICTOPUP;
        }
        if ("ideographicCenterUp".equals(value)) {
            return LeadingModel.IDEOGRAPHICCENTERUP;
        }
        if ("ascentDescentUp".equals(value)) {
            return LeadingModel.ASCENTDESCENTUP;
        }
        if ("ideographicTopDown".equals(value)) {
            return LeadingModel.IDEOGRAPHICTOPDOWN;
        }
        if ("ideographicCenterDown".equals(value)) {
            return LeadingModel.IDEOGRAPHICCENTERDOWN;
        }
        if ("approximateTextField".equals(value)) {
            return LeadingModel.APPROXIMATETEXTFIELD;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownLeadingModel", value);
    }

    public static BlockProgression getBlockProgression(FXGNode node, String value) {
        if ("tb".equals(value)) {
            return BlockProgression.TB;
        }
        if ("rl".equals(value)) {
            return BlockProgression.RL;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownBlockProgression", value);
    }

    public static LineBreak getLineBreak(FXGNode node, String value) {
        if ("toFit".equals(value)) {
            return LineBreak.TOFIT;
        }
        if ("explicit".equals(value)) {
            return LineBreak.EXPLICIT;
        }
        if ("inherit".equals(value)) {
            return LineBreak.INHERIT;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownLineBreak", value);
    }

    public static VerticalAlign getVerticalAlign(FXGNode node, String value) {
        if ("top".equals(value)) {
            return VerticalAlign.TOP;
        }
        if ("bottom".equals(value)) {
            return VerticalAlign.BOTTOM;
        }
        if ("middle".equals(value)) {
            return VerticalAlign.MIDDLE;
        }
        if ("justify".equals(value)) {
            return VerticalAlign.JUSTIFY;
        }
        if ("inherit".equals(value)) {
            return VerticalAlign.INHERIT;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownVerticalAlign", value);
    }
}

