/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.FXGVersion;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.fxg.util.FXGLog;
import com.adobe.internal.fxg.dom.GraphicNode;

public abstract class AbstractFXGNode
implements FXGNode {
    protected FXGNode documentNode;
    protected String uri;
    protected int startLine;
    protected int startColumn;
    protected int endLine;
    protected int endColumn;
    public static final double ALPHA_MIN_INCLUSIVE = 0.0;
    public static final double ALPHA_MAX_INCLUSIVE = 1.0;
    public static final int COLOR_BLACK = -16777216;
    public static final int COLOR_WHITE = -1;
    public static final int COLOR_RED = -65536;
    public static final int GRADIENT_ENTRIES_MAX_INCLUSIVE = 16;
    public static final double EPSILON = 1.0E-5;

    public void addChild(FXGNode child) {
        if (child == null) {
            throw new FXGException("InvalidChildNode", null, this.getNodeName());
        }
        throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidChildNode", child.getNodeName(), this.getNodeName());
    }

    public void setAttribute(String name, String value) {
        if (!this.isVersionGreaterThanCompiler()) {
            throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidNodeAttribute", name, this.getNodeName());
        }
        FXGLog.getLogger().log(30000, "UnknownNodeAttribute", null, this.getDocumentName(), this.startLine, this.startColumn);
    }

    public FXGNode getDocumentNode() {
        return this.documentNode;
    }

    public void setDocumentNode(FXGNode root) {
        this.documentNode = root;
    }

    public String getNodeURI() {
        return this.uri;
    }

    public void setNodeURI(String uri) {
        this.uri = uri;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int line) {
        this.startLine = line;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public void setStartColumn(int column) {
        this.startColumn = column;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int line) {
        this.endLine = line;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(int column) {
        this.endColumn = column;
    }

    public boolean isVersionGreaterThanCompiler() {
        return ((GraphicNode)this.documentNode).isVersionGreaterThanCompiler();
    }

    public FXGVersion getFileVersion() {
        return ((GraphicNode)this.documentNode).getVersion();
    }

    public String getDocumentName() {
        return ((GraphicNode)this.getDocumentNode()).getDocumentName();
    }
}

