/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.swf;

import com.adobe.internal.fxg.dom.ScalableGradientNode;
import com.adobe.internal.fxg.dom.fills.BitmapFillNode;
import com.adobe.internal.fxg.dom.transforms.MatrixNode;
import com.adobe.internal.fxg.types.FXGMatrix;
import flash.swf.types.CXFormWithAlpha;
import flash.swf.types.Matrix;
import flash.swf.types.Rect;

public class TypeHelper {
    public static Rect rect(double minX, double minY, double maxX, double maxY) {
        Rect rect = new Rect();
        rect.xMin = (int)(minX * 20.0);
        rect.yMin = (int)(minY * 20.0);
        rect.xMax = (int)(maxX * 20.0);
        rect.yMax = (int)(maxY * 20.0);
        return rect;
    }

    public static Rect rect(double width, double height) {
        Rect rect = new Rect();
        rect.xMax = (int)(width * 20.0);
        rect.yMax = (int)(height * 20.0);
        return rect;
    }

    public static Matrix radialGradientMatrix(ScalableGradientNode gradient, Rect pathBounds, FXGMatrix pathMatrix) {
        MatrixNode mtxNode = gradient.getMatrixNode();
        FXGMatrix matrix = new FXGMatrix();
        if (mtxNode != null) {
            Rect transformedBounds = pathMatrix.apply(pathBounds);
            double width = transformedBounds.xMax - transformedBounds.xMin;
            double height = transformedBounds.yMax - transformedBounds.yMin;
            matrix.scale(width / 32768.0, height / 32768.0);
            matrix.translate((double)transformedBounds.xMin / 20.0, (double)transformedBounds.yMin / 20.0);
            FXGMatrix nodeMatrix = new FXGMatrix(mtxNode);
            matrix.concat(nodeMatrix);
            return matrix.toSWFMatrix();
        }
        double w = !Double.isNaN(gradient.getScaleX()) ? gradient.getScaleX() : (double)pathBounds.getWidth() / 20.0;
        double h = !Double.isNaN(gradient.getScaleY()) ? gradient.getScaleY() : (double)pathBounds.getHeight() / 20.0;
        double tx = (double)pathBounds.xMin / 20.0 + (!Double.isNaN(gradient.getX()) ? gradient.getX() : (double)pathBounds.getWidth() / 40.0);
        double ty = (double)pathBounds.yMin / 20.0 + (!Double.isNaN(gradient.getY()) ? gradient.getY() : (double)pathBounds.getHeight() / 40.0);
        matrix.scale(w * 20.0 / 32768.0, h * 20.0 / 32768.0);
        if (!Double.isNaN(gradient.getRotation()) && gradient.getRotation() != 0.0) {
            matrix.rotate(gradient.getRotation());
        }
        matrix.translate(tx, ty);
        return matrix.toSWFMatrix();
    }

    public static Matrix linearGradientMatrix(ScalableGradientNode gradient, Rect pathBounds, FXGMatrix pathMatrix) {
        MatrixNode mtxNode = gradient.getMatrixNode();
        FXGMatrix matrix = new FXGMatrix();
        if (mtxNode != null) {
            Rect transformedBounds = pathMatrix.apply(pathBounds);
            double width = (double)(transformedBounds.xMax - transformedBounds.xMin) / 20.0;
            double height = (double)(transformedBounds.yMax - transformedBounds.yMin) / 20.0;
            matrix.scale(width * 20.0 / 32768.0, 1.0);
            matrix.translate(width / 2.0 + (double)transformedBounds.xMin / 20.0, height / 2.0 + (double)transformedBounds.yMin / 20.0);
            FXGMatrix nodeMatrix = new FXGMatrix(mtxNode);
            matrix.concat(nodeMatrix);
            return matrix.toSWFMatrix();
        }
        double width = (double)(pathBounds.xMax - pathBounds.xMin) / 20.0;
        double height = (double)(pathBounds.yMax - pathBounds.yMin) / 20.0;
        double scaleX = gradient.getScaleX();
        double rotation = gradient.getRotation();
        double tx = gradient.getX();
        double ty = gradient.getY();
        if (Double.isNaN(scaleX)) {
            if (rotation % 90.0 != 0.0) {
                double normalizedAngle = rotation % 360.0;
                if (normalizedAngle < 0.0) {
                    normalizedAngle += 360.0;
                }
                if ((normalizedAngle %= 180.0) > 90.0) {
                    normalizedAngle = 180.0 - normalizedAngle;
                }
                double side = width;
                double hypotenuse = Math.sqrt(width * width + height * height);
                double hypotenuseAngle = Math.acos(width / hypotenuse) * 180.0 / Math.PI;
                if (normalizedAngle > hypotenuseAngle) {
                    normalizedAngle = 90.0 - normalizedAngle;
                    side = height;
                }
                scaleX = side / Math.cos(normalizedAngle / 180.0 * Math.PI);
            } else {
                double d = scaleX = rotation % 180.0 == 0.0 ? width : height;
            }
        }
        if (!Double.isNaN(tx) && Double.isNaN(ty)) {
            ty = 0.0;
        }
        if (Double.isNaN(tx) && !Double.isNaN(ty)) {
            tx = 0.0;
        }
        if (!Double.isNaN(tx) && !Double.isNaN(ty)) {
            matrix.translate(819.2, 819.2);
        }
        scaleX = Math.max(scaleX, 2.0);
        scaleX = scaleX * 20.0 / 32768.0;
        matrix.scale(scaleX, 1.0);
        if (!Double.isNaN(rotation)) {
            matrix.rotate(rotation);
        }
        if (Double.isNaN(tx)) {
            tx = width / 2.0;
        }
        if (Double.isNaN(ty)) {
            ty = height / 2.0;
        }
        matrix.translate(tx + (double)pathBounds.xMin / 20.0, ty + (double)pathBounds.yMin / 20.0);
        return matrix.toSWFMatrix();
    }

    public static Matrix bitmapFillMatrix(BitmapFillNode fill, Rect pathBounds) {
        MatrixNode mtxNode = fill.getMatrix();
        if (mtxNode != null) {
            double tx = mtxNode.tx;
            double ty = mtxNode.ty;
            FXGMatrix fxgMtx = new FXGMatrix(mtxNode.a, mtxNode.b, mtxNode.c, mtxNode.d, 0.0, 0.0);
            fxgMtx.scale(20.0, 20.0);
            fxgMtx.translate(tx, ty);
            return fxgMtx.toSWFMatrix();
        }
        FXGMatrix matrix = new FXGMatrix();
        double tx = fill.x + (double)pathBounds.xMin / 20.0;
        double ty = fill.y + (double)pathBounds.yMin / 20.0;
        double scaleX = 20.0 * fill.scaleX;
        double scaleY = 20.0 * fill.scaleY;
        for (double angle = fill.rotation; angle < 0.0; angle += 360.0) {
        }
        matrix.scale(scaleX, scaleY);
        matrix.rotate(angle %= 360.0);
        matrix.translate(tx, ty);
        return matrix.toSWFMatrix();
    }

    public static CXFormWithAlpha cxFormWithAlpha(double alphaMultiplier) {
        CXFormWithAlpha c = new CXFormWithAlpha();
        c.hasMult = true;
        c.alphaMultTerm = TypeHelper.fixed8(alphaMultiplier);
        return c;
    }

    public static CXFormWithAlpha cxFormWithAlpha(double alphaMultiplier, double redMultiplier, double greenMultiplier, double blueMultiplier, double alphaOffset, double redOffset, double greenOffset, double blueOffset) {
        CXFormWithAlpha c = new CXFormWithAlpha();
        c.alphaMultTerm = TypeHelper.fixed8(alphaMultiplier);
        c.redMultTerm = TypeHelper.fixed8(redMultiplier);
        c.greenMultTerm = TypeHelper.fixed8(greenMultiplier);
        c.blueMultTerm = TypeHelper.fixed8(blueMultiplier);
        c.alphaAddTerm = (int)alphaOffset;
        c.redAddTerm = (int)redOffset;
        c.greenAddTerm = (int)greenOffset;
        c.blueAddTerm = (int)blueOffset;
        if (c.alphaAddTerm > 0 || c.redAddTerm > 0 || c.greenAddTerm > 0 || c.blueAddTerm > 0) {
            c.hasAdd = true;
        }
        if (c.alphaMultTerm > 0 || c.redMultTerm > 0 || c.greenMultTerm > 0 || c.blueMultTerm > 0) {
            c.hasMult = true;
        }
        return c;
    }

    public static int gradientRatio(double ratio) {
        return (int)StrictMath.rint(ratio * 255.0);
    }

    public static int colorARGB(int color, double alpha) {
        int rgb = color & 0xFFFFFF;
        int a = (int)StrictMath.rint(alpha * 255.0);
        int argb = rgb | a << 24;
        return argb;
    }

    public static int fixed(double value) {
        return (int)(value * 65536.0);
    }

    public static int fixed8(double value) {
        return (int)(value * 256.0) & 0xFFFF;
    }
}

