/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.swf;

import flash.swf.SwfConstants;
import flash.swf.types.CurvedEdgeRecord;
import flash.swf.types.LineStyle;
import flash.swf.types.Rect;
import flash.swf.types.ShapeRecord;
import flash.swf.types.StraightEdgeRecord;
import flash.swf.types.StyleChangeRecord;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeHelper
implements SwfConstants {
    public static List<ShapeRecord> line(double startX, double startY, double endX, double endY) {
        ArrayList<ShapeRecord> shapeRecords = new ArrayList<ShapeRecord>();
        shapeRecords.add((ShapeRecord)ShapeHelper.move(startX, startY));
        shapeRecords.add((ShapeRecord)ShapeHelper.straightEdge(startX, startY, endX, endY));
        return shapeRecords;
    }

    public static List<ShapeRecord> implicitClosepath(double startX, double startY, double endX, double endY) {
        ArrayList<ShapeRecord> shapeRecords = new ArrayList<ShapeRecord>();
        StyleChangeRecord scr = new StyleChangeRecord();
        scr.setMove((int)startX * 20, (int)startY * 20);
        scr.setLinestyle(0);
        shapeRecords.add((ShapeRecord)scr);
        shapeRecords.add((ShapeRecord)ShapeHelper.straightEdge(startX, startY, endX, endY));
        return shapeRecords;
    }

    public static List<ShapeRecord> rectangle(double startX, double startY, double width, double height) {
        ArrayList<ShapeRecord> shapeRecords = new ArrayList<ShapeRecord>();
        shapeRecords.add((ShapeRecord)ShapeHelper.move(startX, startY));
        shapeRecords.add((ShapeRecord)ShapeHelper.straightEdge(startX, startY, width, startY));
        shapeRecords.add((ShapeRecord)ShapeHelper.straightEdge(width, startY, width, height));
        shapeRecords.add((ShapeRecord)ShapeHelper.straightEdge(width, height, startX, height));
        shapeRecords.add((ShapeRecord)ShapeHelper.straightEdge(startX, height, startX, startY));
        return shapeRecords;
    }

    public static List<ShapeRecord> rectangle(double startx, double starty, double width, double height, double radiusX, double radiusY) {
        ArrayList<ShapeRecord> shapeRecords = new ArrayList<ShapeRecord>();
        if (radiusX == 0.0) {
            radiusX = 0.0;
            radiusY = 0.0;
        } else if (radiusY == 0.0) {
            radiusY = radiusX;
        }
        if (radiusX > width / 2.0) {
            radiusX = width / 2.0;
        }
        if (radiusY > height / 2.0) {
            radiusY = height / 2.0;
        }
        double c0 = 0.923879532511;
        double c1 = 0.382683432365;
        double c3 = 0.707106781187;
        double rx = radiusX;
        double ry = radiusY;
        double tx = rx / 0.923879532511;
        double ty = ry / 0.923879532511;
        double dx = startx + width - rx;
        double dy = starty + height - ry;
        shapeRecords.add((ShapeRecord)ShapeHelper.move(dx + rx, dy));
        double currentx = dx + rx;
        double currenty = dy;
        if (radiusX != 0.0) {
            shapeRecords.add((ShapeRecord)ShapeHelper.curvedEdge(currentx, currenty, dx + c0 * tx, dy + c1 * ty, dx + c3 * rx, dy + c3 * ry));
            shapeRecords.add((ShapeRecord)ShapeHelper.curvedEdge(dx + c3 * rx, dy + c3 * ry, dx + c1 * tx, dy + c0 * ty, dx, dy + ry));
            currentx = dx;
            currenty = dy + ry;
        }
        dx = startx + rx;
        dy = starty + height - ry;
        shapeRecords.add((ShapeRecord)ShapeHelper.straightEdge(currentx, currenty, dx, dy + ry));
        currentx = dx;
        currenty = dy + ry;
        if (radiusX != 0.0) {
            shapeRecords.add((ShapeRecord)ShapeHelper.curvedEdge(currentx, currenty, dx - c1 * tx, dy + c0 * ty, dx - c3 * rx, dy + c3 * ry));
            shapeRecords.add((ShapeRecord)ShapeHelper.curvedEdge(dx - c3 * rx, dy + c3 * ry, dx - c0 * tx, dy + c1 * ty, dx - rx, dy));
            currentx = dx - rx;
            currenty = dy;
        }
        dx = startx + rx;
        dy = starty + ry;
        shapeRecords.add((ShapeRecord)ShapeHelper.straightEdge(currentx, currenty, dx - rx, dy));
        currentx = dx - rx;
        currenty = dy;
        if (radiusX != 0.0) {
            shapeRecords.add((ShapeRecord)ShapeHelper.curvedEdge(currentx, currenty, dx - c0 * tx, dy - c1 * ty, dx - c3 * rx, dy - c3 * ry));
            shapeRecords.add((ShapeRecord)ShapeHelper.curvedEdge(dx - c3 * rx, dy - c3 * ry, dx - c1 * tx, dy - c0 * ty, dx, dy - ry));
            currentx = dx;
            currenty = dy - ry;
        }
        dx = startx + width - rx;
        dy = starty + ry;
        shapeRecords.add((ShapeRecord)ShapeHelper.straightEdge(currentx, currenty, dx, dy - ry));
        currentx = dx;
        currenty = dy - ry;
        if (radiusX != 0.0) {
            shapeRecords.add((ShapeRecord)ShapeHelper.curvedEdge(currentx, currenty, dx + c1 * tx, dy - c0 * ty, dx + c3 * rx, dy - c3 * ry));
            shapeRecords.add((ShapeRecord)ShapeHelper.curvedEdge(dx + c3 * rx, dy - c3 * ry, dx + c0 * tx, dy - c1 * ty, dx + rx, dy));
            currentx = dx + rx;
            currenty = dy;
        }
        dx = startx + width - rx;
        dy = starty + height - ry;
        shapeRecords.add((ShapeRecord)ShapeHelper.straightEdge(currentx, currenty, dx + rx, dy));
        return shapeRecords;
    }

    public static List<ShapeRecord> rectangle(double width, double height) {
        return ShapeHelper.rectangle(0.0, 0.0, width, height);
    }

    public static void setStyles(List<ShapeRecord> shapeRecords, int lineStyleIndex, int fillStyle0Index, int fillStyle1Index) {
        ShapeRecord firstRecord;
        if (shapeRecords != null && shapeRecords.size() > 0 && (firstRecord = shapeRecords.get(0)) instanceof StyleChangeRecord) {
            StyleChangeRecord scr = (StyleChangeRecord)firstRecord;
            if (fillStyle0Index > 0) {
                scr.setFillStyle0(fillStyle0Index);
            }
            if (fillStyle1Index > 0) {
                scr.setFillStyle1(fillStyle1Index);
            }
            if (lineStyleIndex > 0) {
                scr.setLinestyle(lineStyleIndex);
            }
        }
    }

    public static void setPathStyles(List<ShapeRecord> shapeRecords, int lineStyleIndex, int fillStyle0Index, int fillStyle1Index) {
        if (shapeRecords != null && shapeRecords.size() > 0) {
            for (int i = 0; i < shapeRecords.size(); ++i) {
                ShapeRecord record = shapeRecords.get(i);
                if (!(record instanceof StyleChangeRecord)) continue;
                StyleChangeRecord scr = (StyleChangeRecord)record;
                if (fillStyle0Index > 0) {
                    scr.setFillStyle0(fillStyle0Index);
                }
                if (fillStyle1Index > 0) {
                    scr.setFillStyle1(fillStyle1Index);
                }
                if (scr.stateLineStyle || lineStyleIndex <= 0) continue;
                scr.setLinestyle(lineStyleIndex);
            }
        }
    }

    public static StyleChangeRecord move(double x, double y) {
        int moveX = (int)(x *= 20.0);
        int moveY = (int)(y *= 20.0);
        StyleChangeRecord scr = new StyleChangeRecord();
        scr.setMove(moveX, moveY);
        return scr;
    }

    public static StraightEdgeRecord straightEdge(double xFrom, double yFrom, double xTo, double yTo) {
        int dx = (int)(xTo *= 20.0) - (int)(xFrom *= 20.0);
        int dy = (int)(yTo *= 20.0) - (int)(yFrom *= 20.0);
        StraightEdgeRecord ser = new StraightEdgeRecord(dx, dy);
        return ser;
    }

    public static CurvedEdgeRecord curvedEdge(double startX, double startY, double controlX, double controlY, double anchorX, double anchorY) {
        int dcx = (int)(controlX *= 20.0) - (int)(startX *= 20.0);
        int dcy = (int)(controlY *= 20.0) - (int)(startY *= 20.0);
        int dax = (int)(anchorX *= 20.0) - (int)controlX;
        int day = (int)(anchorY *= 20.0) - (int)controlY;
        CurvedEdgeRecord cer = new CurvedEdgeRecord();
        cer.controlDeltaX = dcx;
        cer.controlDeltaY = dcy;
        cer.anchorDeltaX = dax;
        cer.anchorDeltaY = day;
        return cer;
    }

    public static List<ShapeRecord> cubicToQuadratic(double startX, double startY, double control1X, double control1Y, double control2X, double control2Y, double anchorX, double anchorY) {
        double ratio = 0.75;
        double pax = startX + (control1X - startX) * ratio;
        double pay = startY + (control1Y - startY) * ratio;
        double pbx = anchorX + (control2X - anchorX) * ratio;
        double pby = anchorY + (control2Y - anchorY) * ratio;
        double dx = (anchorX - startX) / 16.0;
        double dy = (anchorY - startY) / 16.0;
        ratio = 0.375;
        double c1x = startX + (control1X - startX) * ratio;
        double c1y = startY + (control1Y - startY) * ratio;
        double c2x = pax + (pbx - pax) * ratio;
        double c2y = pay + (pby - pay) * ratio;
        c2x -= dx;
        c2y -= dy;
        double c3x = pbx + (pax - pbx) * ratio;
        double c3y = pby + (pay - pby) * ratio;
        c3x += dx;
        c3y += dy;
        double c4x = anchorX + (control2X - anchorX) * ratio;
        double c4y = anchorY + (control2Y - anchorY) * ratio;
        double a1x = (c1x + c2x) / 2.0;
        double a1y = (c1y + c2y) / 2.0;
        double a2x = (pax + pbx) / 2.0;
        double a2y = (pay + pby) / 2.0;
        double a3x = (c3x + c4x) / 2.0;
        double a3y = (c3y + c4y) / 2.0;
        ArrayList<ShapeRecord> shapeRecords = new ArrayList<ShapeRecord>(4);
        shapeRecords.add((ShapeRecord)ShapeHelper.curvedEdge(startX, startY, c1x, c1y, a1x, a1y));
        shapeRecords.add((ShapeRecord)ShapeHelper.curvedEdge(a1x, a1y, c2x, c2y, a2x, a2y));
        shapeRecords.add((ShapeRecord)ShapeHelper.curvedEdge(a2x, a2y, c3x, c3y, a3x, a3y));
        shapeRecords.add((ShapeRecord)ShapeHelper.curvedEdge(a3x, a3y, c4x, c4y, anchorX, anchorY));
        return shapeRecords;
    }

    public static List<ShapeRecord> path(String data, boolean fill) {
        ArrayList<ShapeRecord> shapeRecords = new ArrayList<ShapeRecord>();
        if (data.length() == 0) {
            return shapeRecords;
        }
        String temp = data.replaceAll("([A-Za-z])([0-9\\-\\.])", "$1 $2");
        temp = temp.replaceAll("([0-9\\.])([A-Za-z\\-])", "$1 $2");
        temp = temp.replaceAll("([A-Za-z\\-])([A-Za-z\\-])", "$1 $2");
        temp = temp.replaceAll("([0-9])( )([eE])( )([0-9\\-])", "$1$3$5");
        temp = temp.replace(',', ' ');
        temp = temp.trim();
        String[] args = temp.split("\\s+");
        int ic = 0;
        int prevIc = 0;
        double lastMoveX = 0.0;
        double lastMoveY = 0.0;
        double prevX = 0.0;
        double prevY = 0.0;
        double x = 0.0;
        double y = 0.0;
        double controlX = 0.0;
        double controlY = 0.0;
        double control2X = 0.0;
        double control2Y = 0.0;
        boolean firstMove = true;
        int i = 0;
        while (i < args.length) {
            boolean relative = false;
            int c = args[i].toCharArray()[0];
            if (c >= 65 && c <= 90 || c >= 97 && c <= 122) {
                ic = c;
                ++i;
            }
            switch (ic) {
                case 109: {
                    relative = true;
                }
                case 77: {
                    if (firstMove) {
                        x = Double.parseDouble(args[i++]);
                        y = Double.parseDouble(args[i++]);
                        shapeRecords.add((ShapeRecord)ShapeHelper.move(x, y));
                        firstMove = false;
                    } else {
                        if (fill && (Math.abs(prevX - lastMoveX) > 1.0E-5 || Math.abs(prevY - lastMoveY) > 1.0E-5)) {
                            shapeRecords.addAll(ShapeHelper.implicitClosepath(prevX, prevY, lastMoveX, lastMoveY));
                        }
                        x = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                        y = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                        shapeRecords.add((ShapeRecord)ShapeHelper.move(x, y));
                    }
                    lastMoveX = x;
                    lastMoveY = y;
                    ic = relative ? 108 : 76;
                    break;
                }
                case 108: {
                    relative = true;
                }
                case 76: {
                    x = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    y = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    shapeRecords.add((ShapeRecord)ShapeHelper.straightEdge(prevX, prevY, x, y));
                    break;
                }
                case 104: {
                    relative = true;
                }
                case 72: {
                    x = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    y = prevY;
                    shapeRecords.add((ShapeRecord)ShapeHelper.straightEdge(prevX, prevY, x, y));
                    break;
                }
                case 118: {
                    relative = true;
                }
                case 86: {
                    x = prevX;
                    y = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    shapeRecords.add((ShapeRecord)ShapeHelper.straightEdge(prevX, prevY, x, y));
                    break;
                }
                case 113: {
                    relative = true;
                }
                case 81: {
                    controlX = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    controlY = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    x = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    y = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    shapeRecords.add((ShapeRecord)ShapeHelper.curvedEdge(prevX, prevY, controlX, controlY, x, y));
                    break;
                }
                case 116: {
                    relative = true;
                }
                case 84: {
                    if (prevIc == 84 || prevIc == 116 || prevIc == 113 || prevIc == 81) {
                        controlX = prevX + (prevX - controlX);
                        controlY = prevY + (prevY - controlY);
                    } else {
                        controlX = prevX;
                        controlY = prevY;
                    }
                    x = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    y = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    shapeRecords.add((ShapeRecord)ShapeHelper.curvedEdge(prevX, prevY, controlX, controlY, x, y));
                    break;
                }
                case 99: {
                    relative = true;
                }
                case 67: {
                    controlX = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    controlY = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    control2X = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    control2Y = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    x = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    y = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    shapeRecords.addAll(ShapeHelper.cubicToQuadratic(prevX, prevY, controlX, controlY, control2X, control2Y, x, y));
                    break;
                }
                case 115: {
                    relative = true;
                }
                case 83: {
                    if (prevIc == 83 || prevIc == 115 || prevIc == 99 || prevIc == 67) {
                        controlX = prevX + (prevX - control2X);
                        controlY = prevY + (prevY - control2Y);
                    } else {
                        controlX = prevX;
                        controlY = prevY;
                    }
                    control2X = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    control2Y = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    x = Double.parseDouble(args[i++]) + (relative ? prevX : 0.0);
                    y = Double.parseDouble(args[i++]) + (relative ? prevY : 0.0);
                    shapeRecords.addAll(ShapeHelper.cubicToQuadratic(prevX, prevY, controlX, controlY, control2X, control2Y, x, y));
                    break;
                }
                case 90: 
                case 122: {
                    shapeRecords.add((ShapeRecord)ShapeHelper.straightEdge(prevX, prevY, lastMoveX, lastMoveY));
                    x = lastMoveX;
                    y = lastMoveY;
                    break;
                }
                default: {
                    return null;
                }
            }
            prevX = x;
            prevY = y;
            prevIc = ic;
        }
        if (fill && Math.abs(prevX - lastMoveX) > 1.0E-5 || Math.abs(prevY - lastMoveY) > 1.0E-5) {
            shapeRecords.addAll(ShapeHelper.implicitClosepath(prevX, prevY, lastMoveX, lastMoveY));
        }
        return shapeRecords;
    }

    public static Rect getBounds(List<ShapeRecord> records, List<LineStyle> lineStyles) {
        if (records == null || records.size() == 0) {
            return new Rect();
        }
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        int x = 0;
        int y = 0;
        boolean firstMove = true;
        for (ShapeRecord r : records) {
            if (r == null) continue;
            if (r instanceof StyleChangeRecord) {
                StyleChangeRecord scr = (StyleChangeRecord)r;
                x = scr.moveDeltaX;
                y = scr.moveDeltaY;
                if (firstMove) {
                    x1 = x;
                    y1 = y;
                    x2 = x;
                    y2 = y;
                    firstMove = false;
                }
            } else if (r instanceof StraightEdgeRecord) {
                StraightEdgeRecord ser = (StraightEdgeRecord)r;
                x += ser.deltaX;
                y += ser.deltaY;
            } else if (r instanceof CurvedEdgeRecord) {
                CurvedEdgeRecord cer = (CurvedEdgeRecord)r;
                Rect curvBounds = ShapeHelper.computeCurveBounds(x, y, cer);
                if (curvBounds.xMin < x1) {
                    x1 = curvBounds.xMin;
                }
                if (curvBounds.yMin < y1) {
                    y1 = curvBounds.yMin;
                }
                if (curvBounds.xMax > x2) {
                    x2 = curvBounds.xMax;
                }
                if (curvBounds.yMax > y2) {
                    y2 = curvBounds.yMax;
                }
                x = x + cer.controlDeltaX + cer.anchorDeltaX;
                y = y + cer.controlDeltaY + cer.anchorDeltaY;
            }
            if (x < x1) {
                x1 = x;
            }
            if (y < y1) {
                y1 = y;
            }
            if (x > x2) {
                x2 = x;
            }
            if (y <= y2) continue;
            y2 = y;
        }
        if (lineStyles != null && lineStyles.size() > 0) {
            Iterator<LineStyle> lineIterator = lineStyles.iterator();
            int width = 20;
            while (lineIterator.hasNext()) {
                LineStyle ls = lineIterator.next();
                if (ls == null) continue;
                if (ls.hasMiterJoint()) {
                    int jointwidth;
                    double miterLimit = (double)ls.miterLimit / 256.0;
                    if (miterLimit < 1.0) {
                        miterLimit = 1.0;
                    }
                    if (width >= (jointwidth = (int)((double)ls.width * miterLimit))) continue;
                    width = jointwidth;
                    continue;
                }
                if (width >= ls.width) continue;
                width = ls.width;
            }
            int stroke = (int)Math.rint((double)width / 2.0);
            x1 -= stroke;
            y1 -= stroke;
            x2 += stroke;
            y2 += stroke;
        }
        return new Rect(x1, x2, y1, y2);
    }

    private static Rect computeCurveBounds(int x0, int y0, CurvedEdgeRecord curve) {
        int y;
        int x;
        double t;
        int x1 = x0 + curve.controlDeltaX;
        int y1 = y0 + curve.controlDeltaY;
        int x2 = x1 + curve.anchorDeltaX;
        int y2 = y1 + curve.anchorDeltaY;
        int xmin = x0;
        int xmax = x0;
        int ymin = y0;
        int ymax = y0;
        if (x2 < xmin) {
            xmin = x2;
        }
        if (y2 < ymin) {
            ymin = y2;
        }
        if (x2 > xmax) {
            xmax = x2;
        }
        if (y2 > ymax) {
            ymax = y2;
        }
        if ((t = ShapeHelper.computeTExtrema(x0, x1, x2)) == Double.NaN) {
            if (x1 < xmin) {
                xmin = x1;
            }
            if (y1 < ymin) {
                ymin = y1;
            }
            if (x1 > xmax) {
                xmax = x1;
            }
            if (y1 > ymax) {
                ymax = y1;
            }
        } else if (t > 0.0 && t < 1.0) {
            x = ShapeHelper.computeValueForCurve(x0, x1, x2, t);
            y = ShapeHelper.computeValueForCurve(y0, y1, y2, t);
            if (x < xmin) {
                xmin = x;
            }
            if (y < ymin) {
                ymin = y;
            }
            if (x > xmax) {
                xmax = x;
            }
            if (y > ymax) {
                ymax = y;
            }
        }
        if ((t = ShapeHelper.computeTExtrema(y0, y1, y2)) == Double.NaN) {
            if (x1 < xmin) {
                xmin = x1;
            }
            if (y1 < ymin) {
                ymin = y1;
            }
            if (x1 > xmax) {
                xmax = x1;
            }
            if (y1 > ymax) {
                ymax = y1;
            }
        } else if (t > 0.0 && t < 1.0) {
            x = ShapeHelper.computeValueForCurve(x0, x1, x2, t);
            y = ShapeHelper.computeValueForCurve(y0, y1, y2, t);
            if (x < xmin) {
                xmin = x;
            }
            if (y < ymin) {
                ymin = y;
            }
            if (x > xmax) {
                xmax = x;
            }
            if (y > ymax) {
                ymax = y;
            }
        }
        Rect r = new Rect(xmin, xmax, ymin, ymax);
        return r;
    }

    private static int computeValueForCurve(int p0, int p1, int p2, double t) {
        return (int)((double)p0 * (1.0 - t) * (1.0 - t) + (double)(2 * p1) * (1.0 - t) * t + (double)p2 * t * t);
    }

    private static double computeTExtrema(int p0, int p1, int p2) {
        int denom = p0 - 2 * p1 + p2;
        if (denom == 0) {
            return Double.NaN;
        }
        double t = (double)(p0 - p1) / (double)denom;
        return t;
    }
}

