/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom.strokes;

import com.adobe.fxg.FXGException;
import com.adobe.internal.fxg.dom.AbstractFXGNode;
import com.adobe.internal.fxg.dom.StrokeNode;
import com.adobe.internal.fxg.dom.types.Caps;
import com.adobe.internal.fxg.dom.types.Joints;
import com.adobe.internal.fxg.dom.types.ScaleMode;

public abstract class AbstractStrokeNode
extends AbstractFXGNode
implements StrokeNode {
    protected static final double MITERLIMIT_MIN_INCLUSIVE = 1.0;
    protected static final double MITERLIMIT_MAX_INCLUSIVE = 255.0;
    protected static final double WEIGHT_MIN_INCLUSIVE = 0.0;
    protected static final double WEIGHT_MAX_INCLUSIVE = 255.0;
    protected String id;
    public ScaleMode scaleMode = ScaleMode.NORMAL;
    public Caps caps = Caps.ROUND;
    public double weight = 1.0;
    public boolean pixelHinting = false;
    public Joints joints = Joints.ROUND;
    public double miterLimit = 3.0;

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public void setAttribute(String name, String value) {
        if ("scaleMode".equals(name)) {
            this.scaleMode = this.getScaleMode(value);
        } else if ("caps".equals(name)) {
            this.caps = this.getCaps(value);
        } else if ("weight".equals(name)) {
            this.weight = this.parseDouble(value, 0.0, 255.0, this.weight);
        } else if ("pixelHinting".equals(name)) {
            this.pixelHinting = this.parseBoolean(value);
        } else if ("joints".equals(name)) {
            this.joints = this.getJoints(value);
        } else if ("miterLimit".equals(name)) {
            this.miterLimit = this.parseDouble(value, 1.0, 255.0, this.miterLimit);
        } else if ("id".equals(name)) {
            this.id = value;
        } else {
            super.setAttribute(name, value);
        }
    }

    protected Caps getCaps(String value) {
        if ("round".equals(value)) {
            return Caps.ROUND;
        }
        if ("square".equals(value)) {
            return Caps.SQUARE;
        }
        if ("none".equals(value)) {
            return Caps.NONE;
        }
        throw new FXGException(this.getStartLine(), this.getStartColumn(), "UnsupportedCapsSetting", value);
    }

    protected Joints getJoints(String value) {
        if ("round".equals(value)) {
            return Joints.ROUND;
        }
        if ("miter".equals(value)) {
            return Joints.MITER;
        }
        if ("bevel".equals(value)) {
            return Joints.BEVEL;
        }
        throw new FXGException(this.getStartLine(), this.getStartColumn(), "UnsupportedJointsSetting", value);
    }

    protected ScaleMode getScaleMode(String value) {
        if ("none".equals(value)) {
            return ScaleMode.NONE;
        }
        if ("vertical".equals(value)) {
            return ScaleMode.VERTICAL;
        }
        if ("normal".equals(value)) {
            return ScaleMode.NORMAL;
        }
        if ("horizontal".equals(value)) {
            return ScaleMode.HORIZONTAL;
        }
        throw new FXGException(this.getStartLine(), this.getStartColumn(), "UnsupportedScaleMode", value);
    }
}

