/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom.richtext;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.richtext.AbstractRichTextNode;
import com.adobe.internal.fxg.dom.types.NumberPercentAuto;

public class ImgNode
extends AbstractRichTextNode {
    public NumberPercentAuto width = NumberPercentAuto.newInstance(NumberPercentAuto.NumberPercentAutoAsEnum.AUTO);
    public NumberPercentAuto height = NumberPercentAuto.newInstance(NumberPercentAuto.NumberPercentAutoAsEnum.AUTO);
    public String source = "";

    public String getNodeName() {
        return "img";
    }

    public void setAttribute(String name, String value) {
        if ("width".equals(name)) {
            this.width = this.getNumberPercentAuto(this, value);
        } else if ("height".equals(name)) {
            this.height = this.getNumberPercentAuto(this, value);
        } else if ("source".equals(name)) {
            this.source = value;
        } else {
            super.setAttribute(name, value);
            return;
        }
        this.rememberAttribute(name, value);
    }

    private NumberPercentAuto getNumberPercentAuto(FXGNode node, String value) {
        try {
            double valueDbl = this.parsePercent(value);
            return NumberPercentAuto.newInstance(valueDbl);
        }
        catch (NumberFormatException e) {
            if ("auto".equals(value)) {
                return NumberPercentAuto.newInstance(NumberPercentAuto.NumberPercentAutoAsEnum.AUTO);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownNumberPercentAuto", value);
        }
    }
}

