/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom.richtext;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.richtext.AbstractRichTextNode;
import com.adobe.internal.fxg.dom.types.AlignmentBaseline;
import com.adobe.internal.fxg.dom.types.BaselineShift;
import com.adobe.internal.fxg.dom.types.BreakOpportunity;
import com.adobe.internal.fxg.dom.types.ColorWithEnum;
import com.adobe.internal.fxg.dom.types.DigitCase;
import com.adobe.internal.fxg.dom.types.DigitWidth;
import com.adobe.internal.fxg.dom.types.DominantBaseline;
import com.adobe.internal.fxg.dom.types.FontStyle;
import com.adobe.internal.fxg.dom.types.FontWeight;
import com.adobe.internal.fxg.dom.types.Kerning;
import com.adobe.internal.fxg.dom.types.LigatureLevel;
import com.adobe.internal.fxg.dom.types.NumberInherit;
import com.adobe.internal.fxg.dom.types.TextDecoration;
import com.adobe.internal.fxg.dom.types.TextRotation;
import com.adobe.internal.fxg.dom.types.TypographicCase;
import com.adobe.internal.fxg.dom.types.WhiteSpaceCollapse;

public abstract class AbstractRichTextLeafNode
extends AbstractRichTextNode {
    public String format = "";
    public String fontFamily = "Arial";
    public double fontSize = 12.0;
    public FontStyle fontStyle = FontStyle.NORMAL;
    public FontWeight fontWeight = FontWeight.NORMAL;
    public Kerning kerning = Kerning.AUTO;
    public double lineHeight = 120.0;
    public TextDecoration textDecoration = TextDecoration.NONE;
    public boolean lineThrough = false;
    public int color = -16777216;
    public double textAlpha = 1.0;
    public WhiteSpaceCollapse whiteSpaceCollapse = WhiteSpaceCollapse.COLLAPSE;
    public NumberInherit backgroundAlpha = NumberInherit.newInstance(1.0);
    public ColorWithEnum backgroundColor = ColorWithEnum.newInstance(ColorWithEnum.ColorEnum.TRANSPARENT);
    public BaselineShift baselineShift = BaselineShift.newInstance(0.0);
    public BreakOpportunity breakOpportunity = BreakOpportunity.AUTO;
    public DigitCase digitCase = DigitCase.DEFAULT;
    public DigitWidth digitWidth = DigitWidth.DEFAULT;
    public DominantBaseline dominantBaseline = DominantBaseline.AUTO;
    public AlignmentBaseline alignmentBaseline = AlignmentBaseline.USEDOMINANTBASELINE;
    public LigatureLevel ligatureLevel = LigatureLevel.COMMON;
    public String locale = "en";
    public TypographicCase typographicCase = TypographicCase.DEFAULT;
    public double trackingLeft = 0.0;
    public double trackingRight = 0.0;
    public TextRotation textRotation = TextRotation.AUTO;

    public void setAttribute(String name, String value) {
        if ("format".equals(name)) {
            this.format = value;
        } else if ("fontFamily".equals(name)) {
            this.fontFamily = value;
        } else if ("fontSize".equals(name)) {
            this.fontSize = this.parseDouble(value);
        } else if ("fontStyle".equals(name)) {
            this.fontStyle = AbstractRichTextLeafNode.getFontStyle(this, value);
        } else if ("fontWeight".equals(name)) {
            this.fontWeight = AbstractRichTextLeafNode.getFontWeight(this, value);
        } else if ("kerning".equals(name)) {
            this.kerning = AbstractRichTextLeafNode.getKerning(this, value);
        } else if ("lineHeight".equals(name)) {
            this.lineHeight = this.parsePercent(value);
        } else if ("textDecoration".equals(name)) {
            this.textDecoration = AbstractRichTextLeafNode.getTextDecoration(this, value);
        } else if ("lineThrough".equals(name)) {
            this.lineThrough = this.parseBoolean(value);
        } else if ("color".equals(name)) {
            this.color = this.parseRGB(value, this.color);
        } else if ("textAlpha".equals(name)) {
            this.textAlpha = this.parseDouble(value, 0.0, 1.0, this.textAlpha);
        } else if ("whiteSpaceCollapse".equals(name)) {
            this.whiteSpaceCollapse = AbstractRichTextLeafNode.getWhiteSpaceCollapse(this, value);
        } else if ("backgroundAlpha".equals(name)) {
            this.backgroundAlpha = this.getAlphaInherit(this, value, 0.0, 1.0, this.backgroundAlpha.getNumberInheritAsDbl());
        } else if ("backgroundColor".equals(name)) {
            this.backgroundColor = this.getColorWithEnum(this, value);
        } else if ("baselineShift".equals(name)) {
            this.baselineShift = this.getBaselineShift(this, value);
        } else if ("breakOpportunity".equals(name)) {
            this.breakOpportunity = AbstractRichTextLeafNode.getBreakOpportunity(this, value);
        } else if ("digitCase".equals(name)) {
            this.digitCase = AbstractRichTextLeafNode.getDigitCase(this, value);
        } else if ("digitWidth".equals(name)) {
            this.digitWidth = AbstractRichTextLeafNode.getDigitWidth(this, value);
        } else if ("dominantBaseline".equals(name)) {
            this.dominantBaseline = AbstractRichTextLeafNode.getDominantBaseline(this, value);
        } else if ("alignmentBaseline".equals(name)) {
            this.alignmentBaseline = AbstractRichTextLeafNode.getAlignmentBaseline(this, value);
        } else if ("ligatureLevel".equals(name)) {
            this.ligatureLevel = AbstractRichTextLeafNode.getLigatureLevel(this, value);
        } else if ("locale".equals(name)) {
            this.locale = value;
        } else if ("typographicCase".equals(name)) {
            this.typographicCase = AbstractRichTextLeafNode.getTypographicCase(this, value);
        } else if ("trackingLeft".equals(name)) {
            this.trackingLeft = this.parsePercent(value);
        } else if ("trackingRight".equals(name)) {
            this.trackingRight = this.parsePercent(value);
        } else if ("textRotation".equals(name)) {
            this.textRotation = this.getTextRotation(this, value);
        } else {
            super.setAttribute(name, value);
            return;
        }
        this.rememberAttribute(name, value);
    }

    public static FontStyle getFontStyle(FXGNode node, String value) {
        if ("normal".equals(value)) {
            return FontStyle.NORMAL;
        }
        if ("italic".equals(value)) {
            return FontStyle.ITALIC;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownFontStyle", value);
    }

    public static FontWeight getFontWeight(FXGNode node, String value) {
        if ("normal".equals(value)) {
            return FontWeight.NORMAL;
        }
        if ("bold".equals(value)) {
            return FontWeight.BOLD;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownFontWeight", value);
    }

    public static TextDecoration getTextDecoration(FXGNode node, String value) {
        if ("none".equals(value)) {
            return TextDecoration.NONE;
        }
        if ("underline".equals(value)) {
            return TextDecoration.UNDERLINE;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownTextDecoration", value);
    }

    public static Kerning getKerning(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return Kerning.AUTO;
        }
        if ("on".equals(value)) {
            return Kerning.ON;
        }
        if ("off".equals(value)) {
            return Kerning.OFF;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownKerning", value);
    }

    public static WhiteSpaceCollapse getWhiteSpaceCollapse(FXGNode node, String value) {
        if ("preserve".equals(value)) {
            return WhiteSpaceCollapse.PRESERVE;
        }
        if ("collapse".equals(value)) {
            return WhiteSpaceCollapse.COLLAPSE;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownWhiteSpaceCollapse", value);
    }

    public static BreakOpportunity getBreakOpportunity(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return BreakOpportunity.AUTO;
        }
        if ("any".equals(value)) {
            return BreakOpportunity.ANY;
        }
        if ("none".equals(value)) {
            return BreakOpportunity.NONE;
        }
        if ("all".equals(value)) {
            return BreakOpportunity.ALL;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownBreakOpportunity", value);
    }

    public static DigitCase getDigitCase(FXGNode node, String value) {
        if ("default".equals(value)) {
            return DigitCase.DEFAULT;
        }
        if ("lining".equals(value)) {
            return DigitCase.LINING;
        }
        if ("oldStyle".equals(value)) {
            return DigitCase.OLDSTYLE;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownDigitCase", value);
    }

    public static DigitWidth getDigitWidth(FXGNode node, String value) {
        if ("default".equals(value)) {
            return DigitWidth.DEFAULT;
        }
        if ("proportional".equals(value)) {
            return DigitWidth.PROPORTIONAL;
        }
        if ("tabular".equals(value)) {
            return DigitWidth.TABULAR;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownDigitWidth", value);
    }

    public static DominantBaseline getDominantBaseline(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return DominantBaseline.AUTO;
        }
        if ("roman".equals(value)) {
            return DominantBaseline.ROMAN;
        }
        if ("ascent".equals(value)) {
            return DominantBaseline.ASCENT;
        }
        if ("descent".equals(value)) {
            return DominantBaseline.DESCENT;
        }
        if ("ideographicTop".equals(value)) {
            return DominantBaseline.IDEOGRAPHICTOP;
        }
        if ("ideographicCenter".equals(value)) {
            return DominantBaseline.IDEOGRAPHICCENTER;
        }
        if ("ideographicBottom".equals(value)) {
            return DominantBaseline.IDEOGRAPHICBOTTOM;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownDominantBaseline", value);
    }

    public static AlignmentBaseline getAlignmentBaseline(FXGNode node, String value) {
        if ("useDominantBaseline".equals(value)) {
            return AlignmentBaseline.USEDOMINANTBASELINE;
        }
        if ("roman".equals(value)) {
            return AlignmentBaseline.ROMAN;
        }
        if ("ascent".equals(value)) {
            return AlignmentBaseline.ASCENT;
        }
        if ("descent".equals(value)) {
            return AlignmentBaseline.DESCENT;
        }
        if ("ideographicTop".equals(value)) {
            return AlignmentBaseline.IDEOGRAPHICTOP;
        }
        if ("ideographicCenter".equals(value)) {
            return AlignmentBaseline.IDEOGRAPHICCENTER;
        }
        if ("ideographicBottom".equals(value)) {
            return AlignmentBaseline.IDEOGRAPHICBOTTOM;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownAlignmentBaseline", value);
    }

    public static LigatureLevel getLigatureLevel(FXGNode node, String value) {
        if ("minimum".equals(value)) {
            return LigatureLevel.MINIMUM;
        }
        if ("common".equals(value)) {
            return LigatureLevel.COMMON;
        }
        if ("uncommon".equals(value)) {
            return LigatureLevel.UNCOMMON;
        }
        if ("exotic".equals(value)) {
            return LigatureLevel.EXOTIC;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownLigatureLevel", value);
    }

    public static TypographicCase getTypographicCase(FXGNode node, String value) {
        if ("default".equals(value)) {
            return TypographicCase.DEFAULT;
        }
        if ("capsToSmallCaps".equals(value)) {
            return TypographicCase.CAPSTOSMALLCAPS;
        }
        if ("uppercase".equals(value)) {
            return TypographicCase.UPPERCASE;
        }
        if ("lowercase".equals(value)) {
            return TypographicCase.LOWERCASE;
        }
        if ("lowercaseToSmallCaps".equals(value)) {
            return TypographicCase.LOWERCASETOSMALLCAPS;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownTypographicCase", value);
    }

    private BaselineShift getBaselineShift(FXGNode node, String value) {
        try {
            return BaselineShift.newInstance(this.parsePercent(value));
        }
        catch (NumberFormatException e) {
            if ("superscript".equals(value)) {
                return BaselineShift.newInstance(BaselineShift.BaselineShiftAsEnum.SUPERSCRIPT);
            }
            if ("superscript".equals(value)) {
                return BaselineShift.newInstance(BaselineShift.BaselineShiftAsEnum.SUBSCRIPT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownBaselineShift", value);
        }
    }

    private TextRotation getTextRotation(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return TextRotation.AUTO;
        }
        if ("rotate0".equals(value)) {
            return TextRotation.ROTATE_0;
        }
        if ("rotate90".equals(value)) {
            return TextRotation.ROTATE_90;
        }
        if ("rotate180".equals(value)) {
            return TextRotation.ROTATE_180;
        }
        if ("rotate270".equals(value)) {
            return TextRotation.ROTATE_270;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownTextRotation", value);
    }

    private NumberInherit getAlphaInherit(FXGNode node, String value, double min, double max, double defaultValue) {
        try {
            return NumberInherit.newInstance(this.parseDouble(value, 0.0, 1.0, defaultValue));
        }
        catch (NumberFormatException e) {
            if ("inherit".equals(value)) {
                return NumberInherit.newInstance(NumberInherit.NumberInheritAsEnum.INHERIT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownNumberInherit", value);
        }
    }

    private ColorWithEnum getColorWithEnum(FXGNode node, String value) {
        if ("transparent".equals(value)) {
            return ColorWithEnum.newInstance(ColorWithEnum.ColorEnum.TRANSPARENT);
        }
        if ("inherit".equals(value)) {
            return ColorWithEnum.newInstance(ColorWithEnum.ColorEnum.INHERIT);
        }
        return ColorWithEnum.newInstance(this.parseRGB(value));
    }
}

