/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom.richtext;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.richtext.AbstractRichParagraphNode;
import com.adobe.internal.fxg.dom.types.BaselineOffset;
import com.adobe.internal.fxg.dom.types.BlockProgression;
import com.adobe.internal.fxg.dom.types.LineBreak;
import com.adobe.internal.fxg.dom.types.NumberAuto;
import com.adobe.internal.fxg.dom.types.NumberInherit;
import com.adobe.internal.fxg.dom.types.VerticalAlign;

public abstract class AbstractRichBlockTextNode
extends AbstractRichParagraphNode {
    public BlockProgression blockProgression = BlockProgression.TB;
    public NumberInherit paddingLeft = NumberInherit.newInstance(0.0);
    public NumberInherit paddingRight = NumberInherit.newInstance(0.0);
    public NumberInherit paddingTop = NumberInherit.newInstance(0.0);
    public NumberInherit paddingBottom = NumberInherit.newInstance(0.0);
    public LineBreak lineBreak = LineBreak.TOFIT;
    public NumberInherit columnGap = NumberInherit.newInstance(20.0);
    public NumberAuto columnCount = NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
    public NumberAuto columnWidth = NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
    public BaselineOffset firstBaselineOffset = BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.AUTO);
    public VerticalAlign verticalAlign = VerticalAlign.TOP;

    public void setAttribute(String name, String value) {
        if ("blockProgression".equals(name)) {
            this.blockProgression = AbstractRichBlockTextNode.getBlockProgression(this, value);
        } else if ("paddingLeft".equals(name)) {
            this.paddingLeft = this.getNumberInherit(this, value);
        } else if ("paddingRight".equals(name)) {
            this.paddingRight = this.getNumberInherit(this, value);
        } else if ("paddingTop".equals(name)) {
            this.paddingTop = this.getNumberInherit(this, value);
        } else if ("paddingBottom".equals(name)) {
            this.paddingBottom = this.getNumberInherit(this, value);
        } else if ("lineBreak".equals(name)) {
            this.lineBreak = AbstractRichBlockTextNode.getLineBreak(this, value);
        } else if ("columnGap".equals(name)) {
            this.columnGap = this.getNumberInherit(this, value);
        } else if ("columnCount".equals(name)) {
            this.columnCount = this.getNumberAutoInt(this, value);
        } else if ("columnWidth".equals(name)) {
            this.columnWidth = this.getNumberAutoDbl(this, value);
        } else if ("firstBaselineOffset".equals(name)) {
            this.firstBaselineOffset = this.getFirstBaselineOffset(this, value);
        } else if ("verticalAlign".equals(name)) {
            this.verticalAlign = AbstractRichBlockTextNode.getVerticalAlign(this, value);
        } else {
            super.setAttribute(name, value);
            return;
        }
        this.rememberAttribute(name, value);
    }

    public static BlockProgression getBlockProgression(FXGNode node, String value) {
        if ("tb".equals(value)) {
            return BlockProgression.TB;
        }
        if ("rl".equals(value)) {
            return BlockProgression.RL;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownBlockProgression", value);
    }

    public static LineBreak getLineBreak(FXGNode node, String value) {
        if ("toFit".equals(value)) {
            return LineBreak.TOFIT;
        }
        if ("explicit".equals(value)) {
            return LineBreak.EXPLICIT;
        }
        if ("inherit".equals(value)) {
            return LineBreak.INHERIT;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownLineBreak", value);
    }

    private BaselineOffset getFirstBaselineOffset(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.AUTO);
        }
        if ("ascent".equals(value)) {
            return BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.ASCENT);
        }
        if ("lineHeight".equals(value)) {
            return BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.LINEHEIGHT);
        }
        try {
            return BaselineOffset.newInstance(this.parseDouble(value));
        }
        catch (NumberFormatException e) {
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownBaselineOffset", value);
        }
    }

    public static VerticalAlign getVerticalAlign(FXGNode node, String value) {
        if ("top".equals(value)) {
            return VerticalAlign.TOP;
        }
        if ("bottom".equals(value)) {
            return VerticalAlign.BOTTOM;
        }
        if ("middle".equals(value)) {
            return VerticalAlign.MIDDLE;
        }
        if ("justify".equals(value)) {
            return VerticalAlign.JUSTIFY;
        }
        if ("inherit".equals(value)) {
            return VerticalAlign.INHERIT;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownVerticalAlign", value);
    }

    private NumberAuto getNumberAutoDbl(FXGNode node, String value) {
        try {
            return NumberAuto.newInstance(this.parseDouble(value));
        }
        catch (NumberFormatException e) {
            if ("auto".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
            }
            if ("inherit".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.INHERIT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownNumberAuto", value);
        }
    }

    private NumberAuto getNumberAutoInt(FXGNode node, String value) {
        try {
            return NumberAuto.newInstance(this.parseInt(value));
        }
        catch (NumberFormatException e) {
            if ("auto".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
            }
            if ("inherit".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.INHERIT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownNumberAuto", value);
        }
    }

    private NumberInherit getNumberInherit(FXGNode node, String value) {
        try {
            return NumberInherit.newInstance(this.parseDouble(value));
        }
        catch (NumberFormatException e) {
            if ("inherit".equals(value)) {
                return NumberInherit.newInstance(NumberInherit.NumberInheritAsEnum.INHERIT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownNumberInherit", value);
        }
    }
}

