/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom.filters;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.GradientEntryNode;
import com.adobe.internal.fxg.dom.filters.AbstractFilterNode;
import com.adobe.internal.fxg.dom.types.BevelType;
import java.util.ArrayList;
import java.util.List;

public class GradientBevelFilterNode
extends AbstractFilterNode {
    public double angle = 45.0;
    public double blurX = 4.0;
    public double blurY = 4.0;
    public int quality = 1;
    public double distance = 4.0;
    public boolean knockout = false;
    public double strength = 1.0;
    public BevelType type = BevelType.INNER;
    public List<GradientEntryNode> entries;

    public void addChild(FXGNode child) {
        if (child instanceof GradientEntryNode) {
            if (this.entries == null) {
                this.entries = new ArrayList<GradientEntryNode>(4);
            } else if (this.entries.size() >= 16) {
                throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidGradientBevelFilterNumElements", new Object[0]);
            }
            this.entries.add((GradientEntryNode)child);
        } else {
            super.addChild(child);
        }
    }

    public String getNodeName() {
        return "GradientBevelFilter";
    }

    public void setAttribute(String name, String value) {
        if ("angle".equals(name)) {
            this.angle = this.parseDouble(value);
        } else if ("blurX".equals(name)) {
            this.blurX = this.parseDouble(value);
        } else if ("blurY".equals(name)) {
            this.blurY = this.parseDouble(value);
        } else if ("quality".equals(name)) {
            this.quality = this.parseInt(value, 1, 3, this.quality);
        } else if ("distance".equals(name)) {
            this.distance = this.parseDouble(value);
        } else if ("knockout".equals(name)) {
            this.knockout = this.parseBoolean(value);
        } else if ("strength".equals(name)) {
            this.strength = this.parseDouble(value);
        } else if ("type".equals(name)) {
            this.type = this.getBevelType(value);
        } else {
            super.setAttribute(name, value);
        }
    }
}

