/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.CDATANode;
import com.adobe.internal.fxg.dom.GraphicContentNode;
import com.adobe.internal.fxg.dom.TextNode;
import com.adobe.internal.fxg.dom.text.AbstractCharacterTextNode;
import com.adobe.internal.fxg.dom.text.BRNode;
import com.adobe.internal.fxg.dom.text.ParagraphNode;
import com.adobe.internal.fxg.dom.text.SpanNode;
import com.adobe.internal.fxg.dom.types.Kerning;
import com.adobe.internal.fxg.dom.types.LineBreak;
import com.adobe.internal.fxg.dom.types.WhiteSpaceCollapse;
import com.adobe.internal.fxg.swf.TextHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextGraphicNode
extends GraphicContentNode
implements TextNode {
    public double width = 0.0;
    public double height = 0.0;
    public double paddingLeft = 0.0;
    public double paddingRight = 0.0;
    public double paddingBottom = 0.0;
    public double paddingTop = 0.0;
    public String fontFamily = "Times New Roman";
    public double fontSize = 12.0;
    public String fontStyle = "normal";
    public String fontWeight = "normal";
    public double lineHeight = 120.0;
    public String textDecoration = "none";
    public WhiteSpaceCollapse whiteSpaceCollapse = WhiteSpaceCollapse.PRESERVE;
    public LineBreak lineBreak = LineBreak.TOFIT;
    public boolean lineThrough = false;
    public double tracking = 0.0;
    public Kerning kerning = Kerning.AUTO;
    public double textAlpha = 1.0;
    public int color = -16777216;
    public String textAlign = "left";
    public String textAlignLast = "left";
    public double textIndent = 0.0;
    public double marginLeft = 0.0;
    public double marginRight = 0.0;
    public double marginTop = 0.0;
    public double marginBottom = 0.0;
    public String direction = "ltr";
    public String blockProgression = "tb";
    private boolean contiguous = false;
    protected Map<String, String> textAttributes;
    protected List<TextNode> content;

    @Override
    public Map<String, String> getTextAttributes() {
        return this.textAttributes;
    }

    @Override
    public List<TextNode> getTextChildren() {
        return this.content;
    }

    @Override
    public List<TextNode> getTextProperties() {
        return null;
    }

    protected void rememberAttribute(String name, String value) {
        if (this.textAttributes == null) {
            this.textAttributes = new HashMap<String, String>(4);
        }
        this.textAttributes.put(name, value);
    }

    public void addContentChild(FXGNode child) {
        if (child instanceof ParagraphNode || child instanceof BRNode || child instanceof SpanNode || child instanceof CDATANode) {
            if (this.content == null) {
                this.content = new ArrayList<TextNode>();
                this.contiguous = true;
            }
            if (!this.contiguous) {
                throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidRichTextContent", new Object[0]);
            }
            this.content.add((TextNode)child);
        }
    }

    @Override
    public void addChild(FXGNode child) {
        if (child instanceof CDATANode) {
            if (TextHelper.ignorableWhitespace(((CDATANode)child).content)) {
                return;
            }
            throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidTextGraphicContent", new Object[0]);
        }
        super.addChild(child);
        this.contiguous = false;
    }

    @Override
    public String getNodeName() {
        return "TextGraphic";
    }

    @Override
    public void setAttribute(String name, String value) {
        if ("width".equals(name)) {
            this.width = this.parseDouble(value);
        } else if ("height".equals(name)) {
            this.height = this.parseDouble(value);
        } else if ("paddingLeft".equals(name)) {
            this.paddingLeft = this.parseDouble(value);
        } else if ("paddingRight".equals(name)) {
            this.paddingRight = this.parseDouble(value);
        } else if ("paddingBottom".equals(name)) {
            this.paddingBottom = this.parseDouble(value);
        } else if ("paddingTop".equals(name)) {
            this.paddingTop = this.parseDouble(value);
        } else if ("fontFamily".equals(name)) {
            this.fontFamily = value;
        } else if ("fontSize".equals(name)) {
            this.fontSize = this.parseDouble(value);
        } else if ("fontStyle".equals(name)) {
            this.fontStyle = value;
        } else if ("fontWeight".equals(name)) {
            this.fontWeight = value;
        } else if ("lineHeight".equals(name)) {
            this.lineHeight = this.parsePercent(value);
        } else if ("textDecoration".equals(name)) {
            this.textDecoration = value;
        } else if ("whiteSpaceCollapse".equals(name)) {
            this.whiteSpaceCollapse = AbstractCharacterTextNode.getWhiteSpaceCollapse(this, value);
        } else if ("lineBreak".equals(name)) {
            this.lineBreak = AbstractCharacterTextNode.getLineBreak(this, value);
        } else if ("tracking".equals(name)) {
            this.tracking = this.parsePercent(value);
        } else if ("kerning".equals(name)) {
            this.kerning = AbstractCharacterTextNode.getKerning(this, value);
        } else if ("textAlpha".equals(name)) {
            this.textAlpha = this.parseDouble(value, 0.0, 1.0, this.textAlpha);
        } else if ("color".equals(name)) {
            this.color = this.parseRGB(value, this.color);
        } else if ("textAlign".equals(name)) {
            this.textAlign = value;
        } else if ("textAlignLast".equals(name)) {
            this.textAlignLast = value;
        } else if ("textIndent".equals(name)) {
            this.textIndent = this.parseDouble(value);
        } else if ("marginLeft".equals(name)) {
            this.marginLeft = this.parseDouble(value);
        } else if ("marginRight".equals(name)) {
            this.marginRight = this.parseDouble(value);
        } else if ("marginTop".equals(name)) {
            this.marginTop = this.parseDouble(value);
        } else if ("marginBottom".equals(name)) {
            this.marginBottom = this.parseDouble(value);
        } else if ("direction".equals(name)) {
            this.direction = value;
        } else if ("blockProgression".equals(name)) {
            this.blockProgression = value;
        } else if ("x".equals(name)) {
            this.x = this.parseDouble(value);
            this.translateSet = true;
        } else if ("y".equals(name)) {
            this.y = this.parseDouble(value);
            this.translateSet = true;
        } else if ("rotation".equals(name)) {
            this.rotation = this.parseDouble(value);
            this.rotationSet = true;
        } else if ("scaleX".equals(name)) {
            this.scaleX = this.parseDouble(value);
            this.scaleSet = true;
        } else if ("scaleY".equals(name)) {
            this.scaleY = this.parseDouble(value);
            this.scaleSet = true;
        } else if ("alpha".equals(name)) {
            this.alpha = this.parseDouble(value, 0.0, 1.0, this.alpha);
            this.alphaSet = true;
        } else if ("blendMode".equals(name)) {
            this.blendMode = this.parseBlendMode(value, this.blendMode);
            this.blendModeSet = true;
        } else if ("maskType".equals(name)) {
            this.maskType = this.parseMaskType(value, this.maskType);
            this.maskTypeSet = true;
        } else if ("visible".equals(name)) {
            this.visible = this.parseBoolean(value);
        } else if ("lineThrough".equals(name)) {
            this.lineThrough = this.parseBoolean(value);
        } else if (!"id".equals(name)) {
            throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidNodeAttribute", name, this.getNodeName());
        }
        this.rememberAttribute(name, value);
    }
}

