/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.FXGVersion;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.fxg.util.FXGLog;
import com.adobe.internal.fxg.dom.AbstractFXGNode;
import com.adobe.internal.fxg.dom.FilterNode;
import com.adobe.internal.fxg.dom.GraphicContext;
import com.adobe.internal.fxg.dom.GraphicNode;
import com.adobe.internal.fxg.dom.MaskPropertyNode;
import com.adobe.internal.fxg.dom.MaskableNode;
import com.adobe.internal.fxg.dom.MaskingNode;
import com.adobe.internal.fxg.dom.transforms.ColorTransformNode;
import com.adobe.internal.fxg.dom.transforms.MatrixNode;
import com.adobe.internal.fxg.dom.types.BlendMode;
import com.adobe.internal.fxg.dom.types.MaskType;
import com.adobe.internal.fxg.types.FXGMatrix;
import java.util.ArrayList;
import java.util.List;

public abstract class GraphicContentNode
extends AbstractFXGNode
implements MaskableNode {
    protected String id;
    public boolean visible = true;
    public double x = 0.0;
    public double y = 0.0;
    public double scaleX = 1.0;
    public double scaleY = 1.0;
    public double rotation = 0.0;
    public double alpha = 1.0;
    public BlendMode blendMode = BlendMode.AUTO;
    public MaskType maskType = MaskType.CLIP;
    protected boolean translateSet;
    protected boolean scaleSet;
    protected boolean rotationSet;
    protected boolean alphaSet;
    protected boolean blendModeSet;
    protected boolean maskTypeSet;
    protected boolean luminosityClip = false;
    protected boolean luminosityInvert = false;
    public List<FilterNode> filters;
    public MaskingNode mask;
    public MatrixNode matrix;
    public ColorTransformNode colorTransform;
    private GraphicContext parentGraphicContext;

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public void addChild(FXGNode child) {
        if (child instanceof FilterNode) {
            if (this.filters == null) {
                this.filters = new ArrayList<FilterNode>();
            }
            this.filters.add((FilterNode)child);
        } else if (child instanceof MaskPropertyNode) {
            this.mask = ((MaskPropertyNode)child).mask;
            if (this.mask instanceof GraphicContentNode) {
                ((GraphicContentNode)((Object)this.mask)).setParentGraphicContext(this.createGraphicContext());
            }
        } else if (child instanceof MatrixNode) {
            if (this.translateSet || this.scaleSet || this.rotationSet) {
                throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidChildMatrixNode", new Object[0]);
            }
            this.matrix = (MatrixNode)child;
        } else if (child instanceof ColorTransformNode) {
            if (this.alphaSet) {
                throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidChildColorTransformNode", new Object[0]);
            }
            this.colorTransform = (ColorTransformNode)child;
        } else {
            super.addChild(child);
        }
    }

    public void setAttribute(String name, String value) {
        if ("x".equals(name)) {
            this.x = this.parseDouble(value);
            this.translateSet = true;
        } else if ("y".equals(name)) {
            this.y = this.parseDouble(value);
            this.translateSet = true;
        } else if ("rotation".equals(name)) {
            this.rotation = this.parseDouble(value);
            this.rotationSet = true;
        } else if ("scaleX".equals(name)) {
            this.scaleX = this.parseDouble(value);
            this.scaleSet = true;
        } else if ("scaleY".equals(name)) {
            this.scaleY = this.parseDouble(value);
            this.scaleSet = true;
        } else if ("alpha".equals(name)) {
            this.alpha = this.parseDouble(value, 0.0, 1.0, this.alpha);
            this.alphaSet = true;
        } else if ("blendMode".equals(name)) {
            this.blendMode = this.parseBlendMode(value, this.blendMode);
            this.blendModeSet = true;
        } else if ("visible".equals(name)) {
            this.visible = this.parseBoolean(value);
        } else if ("id".equals(name)) {
            this.id = value;
        } else if ("maskType".equals(name)) {
            this.maskType = this.parseMaskType(value, this.maskType);
            this.maskTypeSet = true;
        } else {
            if (this.getFileVersion().equalTo(FXGVersion.v1_0)) {
                throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidNodeAttribute", name, this.getNodeName());
            }
            if ("luminosityClip".equals(name)) {
                this.luminosityClip = this.parseBoolean(value);
            } else if ("luminosityInvert".equals(name)) {
                this.luminosityInvert = this.parseBoolean(value);
            } else {
                super.setAttribute(name, value);
            }
        }
    }

    public MaskingNode getMask() {
        return this.mask;
    }

    public MaskType getMaskType() {
        return this.maskType;
    }

    public GraphicContext createGraphicContext() {
        GraphicContext graphicContext = new GraphicContext();
        if (this.parentGraphicContext != null) {
            graphicContext.scalingGrid = this.parentGraphicContext.scalingGrid;
        }
        FXGMatrix transform = graphicContext.getTransform();
        if (this.matrix != null) {
            FXGMatrix t = new FXGMatrix(this.matrix);
            transform.concat(t);
        } else {
            if (this.scaleSet) {
                transform.scale(this.scaleX, this.scaleY);
            }
            if (this.rotationSet) {
                transform.rotate(this.rotation);
            }
            if (this.translateSet) {
                transform.translate(this.x, this.y);
            }
        }
        if (this.colorTransform != null) {
            graphicContext.colorTransform = this.colorTransform;
        } else if (this.alphaSet) {
            if (graphicContext.colorTransform == null) {
                graphicContext.colorTransform = new ColorTransformNode();
            }
            graphicContext.colorTransform.alphaMultiplier = this.alpha;
        }
        if (this.blendModeSet) {
            graphicContext.blendMode = this.blendMode;
        }
        if (this.filters != null) {
            graphicContext.addFilters(this.filters);
        }
        if (this.maskTypeSet) {
            graphicContext.maskType = this.maskType;
        } else if (this.parentGraphicContext != null) {
            graphicContext.maskType = this.parentGraphicContext.maskType;
        }
        return graphicContext;
    }

    public void setParentGraphicContext(GraphicContext context) {
        this.parentGraphicContext = context;
    }

    protected BlendMode parseBlendMode(String value, BlendMode defMode) {
        FXGVersion fileVersion = ((GraphicNode)this.getDocumentNode()).getVersion();
        if ("add".equals(value)) {
            return BlendMode.ADD;
        }
        if ("alpha".equals(value)) {
            return BlendMode.ALPHA;
        }
        if ("darken".equals(value)) {
            return BlendMode.DARKEN;
        }
        if ("difference".equals(value)) {
            return BlendMode.DIFFERENCE;
        }
        if ("erase".equals(value)) {
            return BlendMode.ERASE;
        }
        if ("hardlight".equals(value)) {
            return BlendMode.HARDLIGHT;
        }
        if ("invert".equals(value)) {
            return BlendMode.INVERT;
        }
        if ("layer".equals(value)) {
            return BlendMode.LAYER;
        }
        if ("lighten".equals(value)) {
            return BlendMode.LIGHTEN;
        }
        if ("multiply".equals(value)) {
            return BlendMode.MULTIPLY;
        }
        if ("normal".equals(value)) {
            return BlendMode.NORMAL;
        }
        if ("overlay".equals(value)) {
            return BlendMode.OVERLAY;
        }
        if ("screen".equals(value)) {
            return BlendMode.SCREEN;
        }
        if ("subtract".equals(value)) {
            return BlendMode.SUBTRACT;
        }
        if (fileVersion.equalTo(FXGVersion.v1_0)) {
            throw new FXGException(this.getStartLine(), this.getStartColumn(), "UnknownBlendMode", value);
        }
        if ("colordodge".equals(value)) {
            return BlendMode.COLORDODGE;
        }
        if ("colorburn".equals(value)) {
            return BlendMode.COLORBURN;
        }
        if ("exclusion".equals(value)) {
            return BlendMode.EXCLUSION;
        }
        if ("softlight".equals(value)) {
            return BlendMode.SOFTLIGHT;
        }
        if ("hue".equals(value)) {
            return BlendMode.HUE;
        }
        if ("saturation".equals(value)) {
            return BlendMode.SATURATION;
        }
        if ("color".equals(value)) {
            return BlendMode.COLOR;
        }
        if ("luminosity".equals(value)) {
            return BlendMode.LUMINOSITY;
        }
        if ("auto".equals(value)) {
            return BlendMode.AUTO;
        }
        if (!this.isVersionGreaterThanCompiler()) {
            throw new FXGException(this.getStartLine(), this.getStartColumn(), "UnknownBlendMode", value);
        }
        FXGLog.getLogger().log(30000, "UnknownBlendMode", null, this.getDocumentName(), this.startLine, this.startColumn);
        return defMode;
    }

    public void convertTransformAttrToMatrix() {
        try {
            MatrixNode matrixNode = (MatrixNode)MatrixNode.class.newInstance();
            FXGMatrix matrix = FXGMatrix.convertToMatrix(this.scaleX, this.scaleY, this.rotation, this.x, this.y);
            matrix.setMatrixNodeValue(matrixNode);
            this.resetTransformAttr();
            this.addChild(matrixNode);
        }
        catch (Throwable t) {
            throw new FXGException(this.mask.getStartLine(), this.mask.getStartColumn(), "InvalidChildMatrixNode", t, new Object[0]);
        }
    }

    private void resetTransformAttr() {
        this.x = 0.0;
        this.y = 0.0;
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        this.rotation = 0.0;
        this.translateSet = false;
        this.scaleSet = false;
        this.rotationSet = false;
    }
}

