/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.FXGVersion;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.fxg.util.FXGLog;
import com.adobe.internal.fxg.dom.GraphicNode;
import com.adobe.internal.fxg.dom.types.InterpolationMethod;
import com.adobe.internal.fxg.dom.types.MaskType;
import com.adobe.internal.fxg.dom.types.ResizeMode;
import com.adobe.internal.fxg.dom.types.SpreadMethod;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractFXGNode
implements FXGNode {
    protected static final double ALPHA_MIN_INCLUSIVE = 0.0;
    protected static final double ALPHA_MAX_INCLUSIVE = 1.0;
    protected static final int COLOR_BLACK = -16777216;
    protected static final int COLOR_WHITE = -1;
    protected static final int COLOR_RED = -65536;
    protected static final int GRADIENT_ENTRIES_MAX_INCLUSIVE = 16;
    protected static Pattern idPattern = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*");
    protected FXGNode documentNode;
    protected String uri;
    protected int startLine;
    protected int startColumn;
    protected int endLine;
    protected int endColumn;
    public static final double EPSILON = 1.0E-5;

    public void addChild(FXGNode child) {
        if (child == null) {
            throw new FXGException("InvalidChildNode", null, this.getNodeName());
        }
        throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidChildNode", child.getNodeName(), this.getNodeName());
    }

    public void setAttribute(String name, String value) {
        if (!this.isVersionGreaterThanCompiler()) {
            throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidNodeAttribute", name, this.getNodeName());
        }
        FXGLog.getLogger().log(30000, "UnknownNodeAttribute", null, this.getDocumentName(), this.startLine, this.startColumn);
    }

    public FXGNode getDocumentNode() {
        return this.documentNode;
    }

    public void setDocumentNode(FXGNode root) {
        this.documentNode = root;
    }

    public String getNodeURI() {
        return this.uri;
    }

    public void setNodeURI(String uri) {
        this.uri = uri;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int line) {
        this.startLine = line;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public void setStartColumn(int column) {
        this.startColumn = column;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int line) {
        this.endLine = line;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(int column) {
        this.endColumn = column;
    }

    public boolean isVersionGreaterThanCompiler() {
        return ((GraphicNode)this.documentNode).isVersionGreaterThanCompiler();
    }

    public FXGVersion getFileVersion() {
        return ((GraphicNode)this.documentNode).getVersion();
    }

    protected String getDocumentName() {
        return ((GraphicNode)this.getDocumentNode()).getDocumentName();
    }

    protected boolean parseBoolean(String value) {
        return Boolean.parseBoolean(value);
    }

    protected int parseRGB(String value, int defaultValue) {
        if ((value = value.trim()).charAt(0) == '#') {
            value = value.substring(1);
        } else if (value.startsWith("0x")) {
            value = value.substring(2);
        }
        int a = 255;
        int r = 0;
        int g = 0;
        int b = 0;
        if (value.length() != 6) {
            if (this.isVersionGreaterThanCompiler()) {
                FXGLog.getLogger().log(30000, "DefaultColorValue", null, this.getDocumentName(), this.startLine, this.startColumn);
                return defaultValue;
            }
            throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidColorValue", new Object[0]);
        }
        r = Integer.parseInt(value.substring(0, 2), 16) & 0xFF;
        g = Integer.parseInt(value.substring(2, 4), 16) & 0xFF;
        b = Integer.parseInt(value.substring(4, 6), 16) & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    protected int parseRGB(String value) {
        if ((value = value.trim()).charAt(0) == '#') {
            value = value.substring(1);
        } else if (value.startsWith("0x")) {
            value = value.substring(2);
        }
        int a = 255;
        int r = 0;
        int g = 0;
        int b = 0;
        if (value.length() != 6) {
            throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidColorValue", new Object[0]);
        }
        r = Integer.parseInt(value.substring(0, 2), 16) & 0xFF;
        g = Integer.parseInt(value.substring(2, 4), 16) & 0xFF;
        b = Integer.parseInt(value.substring(4, 6), 16) & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    protected double parseDouble(String value) {
        return Double.parseDouble(value);
    }

    protected double parsePercent(String value) {
        if ((value = value.trim()).charAt(value.length() - 1) == '%') {
            value = value.substring(0, value.length() - 1);
            value = value.trim();
        }
        return Double.parseDouble(value);
    }

    protected float parseFloat(String value) {
        return Float.parseFloat(value);
    }

    protected double parseDouble(String value, double min, double max, double defaultValue) {
        double d = Double.parseDouble(value);
        if (d >= min && d <= max) {
            return d;
        }
        if (this.isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, this.getDocumentName(), this.startLine, this.startColumn);
            return defaultValue;
        }
        throw new FXGException(this.getStartLine(), this.getStartColumn(), "OutOfRangeValue", value, min, max);
    }

    protected int parseInt(String value, int min, int max, int defaultValue) {
        int i = Integer.parseInt(value);
        if (i >= min && i <= max) {
            return i;
        }
        if (this.isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, this.getDocumentName(), this.startLine, this.startColumn);
            return defaultValue;
        }
        throw new FXGException(this.getStartLine(), this.getStartColumn(), "OutOfRangeValue", value, min, max);
    }

    protected double parseInt(String value) {
        return Integer.parseInt(value);
    }

    protected InterpolationMethod parseInterpolationMethod(String value, InterpolationMethod defaultValue) {
        if ("rgb".equals(value)) {
            return InterpolationMethod.RGB;
        }
        if ("linearRGB".equals(value)) {
            return InterpolationMethod.LINEAR_RGB;
        }
        if (this.isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, this.getDocumentName(), this.startLine, this.startColumn);
            return defaultValue;
        }
        throw new FXGException(this.getStartLine(), this.getStartColumn(), "UnknownInterpolationMethod", value);
    }

    protected MaskType parseMaskType(String value, MaskType defaultValue) {
        if ("clip".equals(value)) {
            return MaskType.CLIP;
        }
        if ("alpha".equals(value)) {
            return MaskType.ALPHA;
        }
        if (this.getFileVersion().equalTo(FXGVersion.v1_0)) {
            throw new FXGException(this.getStartLine(), this.getStartColumn(), "UnknownMaskType", value);
        }
        if ("luminosity".equals(value)) {
            return MaskType.LUMINOSITY;
        }
        if (this.isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, this.getDocumentName(), this.startLine, this.startColumn);
            return defaultValue;
        }
        throw new FXGException(this.getStartLine(), this.getStartColumn(), "UnknownMaskType", value);
    }

    protected ResizeMode parseResizeMode(String value, ResizeMode defaultValue) {
        if ("noScale".equals(value)) {
            return ResizeMode.NOSCALE;
        }
        if ("repeat".equals(value)) {
            return ResizeMode.REPEAT;
        }
        if ("scale".equals(value)) {
            return ResizeMode.SCALE;
        }
        if (this.isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, this.getDocumentName(), this.startLine, this.startColumn);
            return defaultValue;
        }
        throw new FXGException(this.getStartLine(), this.getStartColumn(), "UnknownResizeMode", value);
    }

    protected SpreadMethod parseSpreadMethod(String value, SpreadMethod defaultValue) {
        if ("pad".equals(value)) {
            return SpreadMethod.PAD;
        }
        if ("reflect".equals(value)) {
            return SpreadMethod.REFLECT;
        }
        if ("repeat".equals(value)) {
            return SpreadMethod.REPEAT;
        }
        if (this.isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, this.getDocumentName(), this.startLine, this.startColumn);
            return defaultValue;
        }
        throw new FXGException(this.getStartLine(), this.getStartColumn(), "UnknownSpreadMethod", value);
    }

    protected String parseIdentifier(String value, String defaultValue) {
        Matcher m = idPattern.matcher(value);
        if (m.matches()) {
            return value;
        }
        if (this.isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, this.getDocumentName(), this.startLine, this.startColumn);
            return defaultValue;
        }
        throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidIdentifierFormat", value);
    }
}

