/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fxg;

import com.adobe.fxg.FXGException;

public final class FXGVersion {
    private static final double k_1_0 = 1.0;
    private static final double k_2_0 = 2.0;
    public static final FXGVersion v1_0 = new FXGVersion(1.0);
    public static final FXGVersion v2_0 = new FXGVersion(2.0);
    private final double version;

    private FXGVersion(double version) {
        if (version == Double.NaN || version < 1.0) {
            throw new FXGException("InvalidVersionNumber", new Object[0]);
        }
        this.version = version;
    }

    public static FXGVersion newInstance(double version) {
        return new FXGVersion(version);
    }

    public String asString() {
        return String.valueOf(this.version);
    }

    public boolean equalTo(FXGVersion version) {
        return this.compareTo(version) == 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FXGVersion)) {
            return false;
        }
        return this.equalTo((FXGVersion)object);
    }

    public boolean greaterThan(FXGVersion version) {
        return this.compareTo(version) > 0;
    }

    public boolean lessThan(FXGVersion version) {
        return this.lessThan(version);
    }

    private int compareTo(FXGVersion version) {
        double compareVersion;
        if (version == null) {
            throw new RuntimeException("Cannot compare FXGVersion to a null value.");
        }
        if (version == this) {
            return 0;
        }
        double thisVersion = this.asDouble();
        if (thisVersion < (compareVersion = version.asDouble())) {
            return -1;
        }
        if (thisVersion > compareVersion) {
            return 1;
        }
        return 0;
    }

    public double asDouble() {
        return this.version;
    }

    public long getMajorVersion() {
        return (long)this.version;
    }
}

