/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.log;

import flex.messaging.LocalizedException;
import flex.messaging.config.ConfigMap;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.log.Target;
import flex.messaging.util.UUIDUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTarget
implements Target {
    private static final int INVALID_FILTER_CHARS = 10016;
    private static final int INVALID_FILTER_STAR = 10017;
    protected final String id;
    protected List<String> filters;
    protected volatile short level;
    protected volatile int loggerCount;
    private final Object lock = new Object();
    private boolean usingDefaultFilter = false;

    public AbstractTarget() {
        this.id = UUIDUtils.createUUID();
        this.level = (short)8;
        this.filters = new ArrayList<String>();
        this.filters.add("*");
        this.usingDefaultFilter = true;
    }

    @Override
    public void initialize(String id, ConfigMap properties) {
    }

    @Override
    public List<String> getFilters() {
        return Collections.unmodifiableList(new ArrayList<String>(this.filters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFilter(String value) {
        if (value != null) {
            this.validateFilter(value);
        } else {
            value = "*";
        }
        boolean filterWasAdded = false;
        Object object = this.lock;
        synchronized (object) {
            if (!this.filters.contains(value)) {
                if (this.usingDefaultFilter) {
                    this.removeFilter("*");
                    this.usingDefaultFilter = false;
                }
                this.filters.add(value);
                filterWasAdded = true;
            }
        }
        if (filterWasAdded) {
            Log.processTargetFilterAdd(this, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFilter(String value) {
        boolean filterWasRemoved = false;
        Object object = this.lock;
        synchronized (object) {
            filterWasRemoved = this.filters.remove(value);
        }
        if (filterWasRemoved) {
            Log.processTargetFilterRemove(this, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFilters(List<String> value) {
        if (value != null && value.size() > 0) {
            for (int i = 0; i < value.size(); ++i) {
                this.validateFilter(value.get(i));
            }
        } else {
            value = new ArrayList<String>();
            value.add("*");
        }
        Log.removeTarget(this);
        Object object = this.lock;
        synchronized (object) {
            this.filters = value;
            this.usingDefaultFilter = false;
        }
        Log.addTarget(this);
    }

    @Override
    public short getLevel() {
        return this.level;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void setLevel(short value) {
        this.level = value;
        Log.resetTargetLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLogger(Logger logger) {
        if (logger != null) {
            Object object = this.lock;
            synchronized (object) {
                ++this.loggerCount;
            }
            logger.addTarget(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLogger(Logger logger) {
        if (logger != null) {
            Object object = this.lock;
            synchronized (object) {
                --this.loggerCount;
            }
            logger.removeTarget(this);
        }
    }

    public boolean containsFilter(String filter) {
        return this.filters.contains(filter);
    }

    private void validateFilter(String value) {
        if (Log.hasIllegalCharacters(value)) {
            LocalizedException ex = new LocalizedException();
            ex.setMessage(10016, new Object[]{value, "[]~$^&\\/(){}<>+=`!#%?,:;'\"@"});
            throw ex;
        }
        int index = value.indexOf("*");
        if (index >= 0 && index != value.length() - 1) {
            LocalizedException ex = new LocalizedException();
            ex.setMessage(10017, new Object[]{value});
            throw ex;
        }
    }
}

