/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts.flashtype;

import flash.fonts.flashtype.ADF;
import flash.fonts.flashtype.ADFMathUtils;
import flash.fonts.flashtype.ADFTypeSystem;
import java.lang.reflect.Method;

public class ADFAlgnZones {
    static final int AZ_ADF_MAXLEVEL = 5;
    static final float AZ_ADF_MAXERROR = 2.0E-4f;
    static final float AZ_EDGE_THRESHOLD = 0.04f;
    static final int AZ_MAX_NSAMPLES = 220;
    static final int AZ_MIN_NSAMPLES = 100;
    static final float AZ_RANGE_CUTOFF = 0.13f;
    static final float AZ_MIN_CHAR_DIST_PCT = 0.7f;
    static final int AZ_LEFT_EDGE_CROSSING = 0;
    static final int AZ_TOP_EDGE_CROSSING = 1;

    static void DetectEdges(ADF.ADFGlyph aDFGlyph, int n, int n2, int n3, float f, float[] fArray, int[] nArray, ADF.IntValue intValue, float[] fArray2) {
        int n4;
        int n5;
        float[] fArray3 = new float[3];
        int n6 = (int)ADFMathUtils.ADF_MAX(n2, n3);
        if (aDFGlyph == null) {
            intValue.value = 0;
            return;
        }
        float[] fArray4 = new float[n2 * n3];
        float f2 = 1.0f / (float)n2;
        float f3 = 1.0f / (float)n3;
        int n7 = (int)(aDFGlyph.glyphMinX * (float)n2);
        int n8 = (int)(aDFGlyph.glyphMaxX * (float)n2);
        int n9 = (int)(aDFGlyph.glyphMinY * (float)n3);
        int n10 = (int)(aDFGlyph.glyphMaxY * (float)n3);
        n7 = n7 < 2 ? 0 : n7 - 2;
        n9 = n9 < 2 ? 0 : n9 - 2;
        n8 = n8 > n2 - 3 ? n2 - 1 : n8 + 2;
        n10 = n10 > n3 - 3 ? n3 - 1 : n10 + 2;
        int n11 = 0;
        for (n5 = 0; n5 < n3; ++n5) {
            if (n5 < n9 || n5 > n10) {
                for (n4 = 0; n4 < n2; ++n4) {
                    fArray[n11++] = -1.0f;
                }
                continue;
            }
            fArray3[1] = (float)n5 * f3;
            for (n4 = 0; n4 < n2; ++n4) {
                if (n4 < n7 || n4 > n8) {
                    fArray[n11++] = -1.0f;
                    continue;
                }
                fArray3[0] = (float)n4 * f2;
                float f4 = ADF.ADFReconstructDistAbs(aDFGlyph, fArray3);
                fArray[n11++] = f4;
            }
        }
        switch (n) {
            case 0: {
                long l = n10 - n9 + 1;
                float f5 = (float)l * 2.0f * f2;
                if (f5 != 0.0f) {
                    f5 = 1.0f / f5;
                }
                n4 = n7 + 1;
                while (n4 < n8) {
                    for (n5 = n9 + 1; n5 < n10; ++n5) {
                        float f6;
                        float f7;
                        float f8 = fArray[n4 - 1 + n5 * n2];
                        float f9 = fArray[n4 + 1 + n5 * n2];
                        if (!(f8 * f9 < 0.0f) || !((f7 = -3.0f * Math.abs(f6 = fArray[n4 + n5 * n2]) + f9 - f8) > 0.0f)) continue;
                        int n12 = n4;
                        fArray4[n12] = fArray4[n12] + f7;
                    }
                    int n13 = n4++;
                    fArray4[n13] = fArray4[n13] * f5;
                }
                break;
            }
            case 1: {
                long l = n8 - n7 + 1;
                float f10 = (float)l * 2.0f * f3;
                if (f10 != 0.0f) {
                    f10 = 1.0f / f10;
                }
                for (n4 = n7 + 1; n4 < n8; ++n4) {
                    for (n5 = n9 + 1; n5 < n10; ++n5) {
                        float f11;
                        float f12;
                        float f13 = fArray[n4 + (n5 + 1) * n2];
                        float f14 = fArray[n4 + (n5 - 1) * n2];
                        if (!(f13 * f14 < 0.0f) || !((f12 = -3.0f * Math.abs(f11 = fArray[n4 + n5 * n2]) + f14 - f13) > 0.0f)) continue;
                        int n14 = n5;
                        fArray4[n14] = fArray4[n14] + f12;
                    }
                }
                n5 = n9 + 1;
                while (n5 < n10) {
                    int n15 = n5++;
                    fArray4[n15] = fArray4[n15] * f10;
                }
                break;
            }
            default: {
                intValue.value = 0;
                return;
            }
        }
        ADFAlgnZones.DetermineEdges(fArray4, n6, f, nArray, fArray2, intValue);
    }

    static void DetermineEdges(float[] fArray, int n, float f, int[] nArray, float[] fArray2, ADF.IntValue intValue) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        float f2 = 0.0f;
        float f3 = 1.0f / (float)n;
        for (n2 = 0; n2 < n; ++n2) {
            float f4 = fArray[n2];
            if (f2 == 0.0f && f4 > f) {
                n3 = n2;
                f2 = f4;
                continue;
            }
            if (f2 == 0.0f) continue;
            if (f4 >= f2) {
                n3 = n2;
                f2 = f4;
                continue;
            }
            if (!((float)(n2 - n3) * f3 > 0.13f)) continue;
            nArray[n4++] = n3;
            f2 = 0.0f;
        }
        if (n4 <= intValue.value) {
            intValue.value = n4;
        } else {
            int n5;
            for (n2 = 0; n2 < intValue.value; ++n2) {
                int n6 = -1;
                int n7 = 0;
                for (int i = 0; i < n4; ++i) {
                    n5 = nArray[i];
                    if (n5 >= n) continue;
                    if (n6 < 0) {
                        n6 = n5;
                        n7 = i;
                        continue;
                    }
                    if (!(fArray[n5] > fArray[n6])) continue;
                    n6 = n5;
                    n7 = i;
                }
                int n8 = n7;
                nArray[n8] = nArray[n8] + n;
            }
            n5 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                if (nArray[n2] < n) continue;
                nArray[n5++] = nArray[n2] - n;
            }
        }
        for (n2 = 0; n2 < intValue.value; ++n2) {
            fArray2[n2] = f3 * (float)nArray[n2];
        }
    }

    public static Object ADFInitAlgnZoneDetection(Object object, Object object2, String string, Method method, Object object3) throws Exception {
        float[] fArray = new float[2];
        float f = 0.04f;
        ADFTypeSystem.ADFGenAttrs aDFGenAttrs = new ADFTypeSystem.ADFGenAttrs();
        AlgnZoneState algnZoneState = new AlgnZoneState();
        aDFGenAttrs.maxLevel = 5L;
        aDFGenAttrs.maxError = 2.0E-4f;
        aDFGenAttrs.distEps = 0.0f;
        algnZoneState.pDist = new float[22000];
        algnZoneState.edgePtsIdx = new int[220];
        ADF.IntValue intValue = new ADF.IntValue(2);
        ADFTypeSystem.ADFPath aDFPath = (ADFTypeSystem.ADFPath)method.invoke(object3, object, object2, new Character('Z'));
        ADF.ADFGlyph aDFGlyph = (ADF.ADFGlyph)ADF.ADFGenerateADF(object, aDFPath, aDFGenAttrs);
        ADFAlgnZones.DetectEdges(aDFGlyph, 1, 100, 220, f, algnZoneState.pDist, algnZoneState.edgePtsIdx, intValue, fArray);
        if (intValue.value == 2) {
            algnZoneState.capHeight = (fArray[1] - aDFGlyph.glyphOriginY) / aDFGlyph.FUToADFScale;
            if (algnZoneState.capHeight < 0.7f * (aDFPath.glyphMaxY - aDFPath.glyphMinY)) {
                algnZoneState.capHeight = 0.0f;
            }
        } else {
            algnZoneState.capHeight = 0.0f;
        }
        intValue = new ADF.IntValue(2);
        aDFPath = (ADFTypeSystem.ADFPath)method.invoke(object3, object, object2, new Character('z'));
        aDFGlyph = (ADF.ADFGlyph)ADF.ADFGenerateADF(object, aDFPath, aDFGenAttrs);
        ADFAlgnZones.DetectEdges(aDFGlyph, 1, 100, 220, f, algnZoneState.pDist, algnZoneState.edgePtsIdx, intValue, fArray);
        if (intValue.value == 2) {
            algnZoneState.xHeight = (fArray[1] - aDFGlyph.glyphOriginY) / aDFGlyph.FUToADFScale;
            if (algnZoneState.xHeight < 0.7f * (aDFPath.glyphMaxY - aDFPath.glyphMinY)) {
                algnZoneState.xHeight = 0.0f;
            }
        } else {
            algnZoneState.xHeight = 0.0f;
        }
        intValue = new ADF.IntValue(1);
        aDFPath = (ADFTypeSystem.ADFPath)method.invoke(object3, object, object2, new Character('L'));
        aDFGlyph = (ADF.ADFGlyph)ADF.ADFGenerateADF(object, aDFPath, aDFGenAttrs);
        ADFAlgnZones.DetectEdges(aDFGlyph, 0, 220, 100, f, algnZoneState.pDist, algnZoneState.edgePtsIdx, intValue, fArray);
        algnZoneState.leftCapAlignPt = intValue.value == 1 ? (fArray[0] - aDFGlyph.glyphOriginX) / aDFGlyph.FUToADFScale : 0.0f;
        intValue = new ADF.IntValue(1);
        aDFPath = (ADFTypeSystem.ADFPath)method.invoke(object3, object, object2, new Character('l'));
        aDFGlyph = (ADF.ADFGlyph)ADF.ADFGenerateADF(object, aDFPath, aDFGenAttrs);
        ADFAlgnZones.DetectEdges(aDFGlyph, 0, 220, 100, f, algnZoneState.pDist, algnZoneState.edgePtsIdx, intValue, fArray);
        algnZoneState.leftXAlignPt = intValue.value == 1 ? (fArray[0] - aDFGlyph.glyphOriginX) / aDFGlyph.FUToADFScale : 0.0f;
        return algnZoneState;
    }

    public static void ADFDetectAlgnZones(Object object, Object object2, ADFTypeSystem.ADFPath aDFPath) {
        float f;
        float f2;
        float f3;
        float f4;
        float[] fArray = new float[10];
        float f5 = 0.04f;
        AlgnZoneState algnZoneState = (AlgnZoneState)object2;
        ADF.IntValue intValue = new ADF.IntValue(0);
        ADF.IntValue intValue2 = new ADF.IntValue(0);
        if (aDFPath == null) {
            return;
        }
        if (algnZoneState == null) {
            aDFPath.algnZonesMask = 0;
            return;
        }
        ADF.BooleanValue booleanValue = new ADF.BooleanValue(false);
        ADFAlgnZones.SetGlyphSpecificAlgnZoneData(aDFPath.charCode, booleanValue, intValue, intValue2);
        ADFTypeSystem.ADFGenAttrs aDFGenAttrs = new ADFTypeSystem.ADFGenAttrs();
        aDFGenAttrs.maxError = 2.0E-4f;
        aDFGenAttrs.distEps = 0.0f;
        aDFGenAttrs.maxLevel = intValue.value == 0 && intValue2.value == 0 ? 0L : 5L;
        ADF.ADFGlyph aDFGlyph = (ADF.ADFGlyph)ADF.ADFGenerateADF(object, aDFPath, aDFGenAttrs);
        if (aDFGlyph == null) {
            aDFPath.algnZonesMask = 0;
            return;
        }
        if (intValue.value != 0) {
            ADFAlgnZones.DetectEdges(aDFGlyph, 0, 220, 100, f5, algnZoneState.pDist, algnZoneState.edgePtsIdx, intValue, fArray);
        }
        if (intValue.value == 0) {
            f4 = booleanValue.value ? algnZoneState.leftCapAlignPt : algnZoneState.leftXAlignPt;
            f3 = 0.0f;
        } else if (intValue.value == 1) {
            f4 = (fArray[0] - aDFGlyph.glyphOriginX) / aDFGlyph.FUToADFScale;
            f3 = 0.0f;
        } else {
            f4 = (fArray[0] - aDFGlyph.glyphOriginX) / aDFGlyph.FUToADFScale;
            f3 = (fArray[1] - fArray[0]) / aDFGlyph.FUToADFScale;
            if (f3 * aDFGlyph.FUToADFScale < 0.13f) {
                f3 = 0.0f;
            }
        }
        if (intValue2.value != 0) {
            ADFAlgnZones.DetectEdges(aDFGlyph, 1, 100, 220, f5, algnZoneState.pDist, algnZoneState.edgePtsIdx, intValue2, fArray);
        }
        if (intValue2.value == 0) {
            f2 = 0.0f;
            f = booleanValue.value ? algnZoneState.capHeight : algnZoneState.xHeight;
        } else {
            f2 = 0.0f;
            f = (fArray[intValue2.value - 1] - aDFGlyph.glyphOriginY) / aDFGlyph.FUToADFScale;
            if (f < 0.0f) {
                f = -f;
            }
            if (f * aDFGlyph.FUToADFScale < 0.13f && aDFPath.charCode != '_') {
                f = 0.0f;
            }
        }
        float f6 = 1.0f / aDFPath.fontUnitsPerEM;
        aDFGlyph.xAlgnCoord = f4 *= f6;
        aDFGlyph.yAlgnCoord = f2 *= f6;
        aDFGlyph.xRange = f3 *= f6;
        aDFGlyph.yRange = f *= f6;
        aDFGlyph.algnZonesMask = 3;
        ADF.ADFPackAlgnZones(aDFGlyph, aDFPath);
    }

    static void SetGlyphSpecificAlgnZoneData(char c, ADF.BooleanValue booleanValue, ADF.IntValue intValue, ADF.IntValue intValue2) {
        booleanValue.value = true;
        intValue.value = 0;
        intValue2.value = 0;
        switch (c) {
            case 'l': 
            case 's': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': 
            case '\u00ff': 
            case '\u015b': 
            case '\u015d': 
            case '\u015f': 
            case '\u0161': 
            case '\u0175': 
            case '\u0177': 
            case '\u017a': 
            case '\u017c': 
            case '\u017e': {
                booleanValue.value = false;
            }
            case '&': 
            case '\'': 
            case '/': 
            case '2': 
            case '3': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case '<': 
            case '>': 
            case 'A': 
            case 'L': 
            case 'S': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Z': 
            case '\\': 
            case '\u00aa': 
            case '\u00ab': 
            case '\u00b0': 
            case '\u00b2': 
            case '\u00b3': 
            case '\u00b8': 
            case '\u00ba': 
            case '\u00bb': 
            case '\u00bc': 
            case '\u00bd': 
            case '\u00be': 
            case '\u00c0': 
            case '\u00c1': 
            case '\u00c2': 
            case '\u00c3': 
            case '\u00c4': 
            case '\u00c5': 
            case '\u00d7': 
            case '\u0100': 
            case '\u0102': 
            case '\u0104': 
            case '\u015a': 
            case '\u015c': 
            case '\u015e': 
            case '\u0160': 
            case '\u0174': 
            case '\u0179': 
            case '\u017b': 
            case '\u017d': 
            case '\u01cd': 
            case '\u01fa': {
                break;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 't': 
            case '\u00a2': 
            case '\u00de': 
            case '\u00e0': 
            case '\u00e1': 
            case '\u00e2': 
            case '\u00e3': 
            case '\u00e4': 
            case '\u00e5': 
            case '\u00e7': 
            case '\u00e8': 
            case '\u00e9': 
            case '\u00ea': 
            case '\u00eb': 
            case '\u00ec': 
            case '\u00ed': 
            case '\u00ee': 
            case '\u00ef': 
            case '\u00f0': 
            case '\u00fd': 
            case '\u00fe': 
            case '\u0101': 
            case '\u0103': 
            case '\u0105': 
            case '\u0107': 
            case '\u0109': 
            case '\u010b': 
            case '\u010d': 
            case '\u010f': 
            case '\u0111': 
            case '\u0113': 
            case '\u0115': 
            case '\u0117': 
            case '\u0119': 
            case '\u011b': 
            case '\u011d': 
            case '\u011f': 
            case '\u0121': 
            case '\u0123': 
            case '\u0129': 
            case '\u012b': 
            case '\u012d': 
            case '\u012f': 
            case '\u0131': 
            case '\u0135': 
            case '\u0137': 
            case '\u0138': 
            case '\u013a': 
            case '\u013c': 
            case '\u013e': 
            case '\u0140': 
            case '\u0142': 
            case '\u0155': 
            case '\u0157': 
            case '\u0159': 
            case '\u0163': 
            case '\u0165': 
            case '\u0167': 
            case '\u017f': 
            case '\u0192': 
            case '\u01ce': 
            case '\u01d0': 
            case '\u01fb': {
                booleanValue.value = false;
            }
            case '!': 
            case '$': 
            case '(': 
            case ')': 
            case '*': 
            case ',': 
            case '.': 
            case '1': 
            case '4': 
            case '5': 
            case '?': 
            case '@': 
            case 'C': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'P': 
            case 'R': 
            case 'T': 
            case 'Y': 
            case '[': 
            case ']': 
            case '{': 
            case '|': 
            case '}': 
            case '\u00a1': 
            case '\u00a3': 
            case '\u00a5': 
            case '\u00a6': 
            case '\u00a9': 
            case '\u00ae': 
            case '\u00b4': 
            case '\u00b6': 
            case '\u00b9': 
            case '\u00bf': 
            case '\u00c6': 
            case '\u00c7': 
            case '\u00c8': 
            case '\u00c9': 
            case '\u00ca': 
            case '\u00cb': 
            case '\u00cc': 
            case '\u00cd': 
            case '\u00ce': 
            case '\u00cf': 
            case '\u00dd': 
            case '\u0106': 
            case '\u0108': 
            case '\u010a': 
            case '\u010c': 
            case '\u0112': 
            case '\u0114': 
            case '\u0116': 
            case '\u0118': 
            case '\u011a': 
            case '\u011c': 
            case '\u011e': 
            case '\u0120': 
            case '\u0122': 
            case '\u0128': 
            case '\u012a': 
            case '\u012c': 
            case '\u012e': 
            case '\u0130': 
            case '\u0134': 
            case '\u0136': 
            case '\u0139': 
            case '\u013b': 
            case '\u013d': 
            case '\u013f': 
            case '\u0141': 
            case '\u0154': 
            case '\u0156': 
            case '\u0158': 
            case '\u0162': 
            case '\u0164': 
            case '\u0166': 
            case '\u0176': 
            case '\u0178': 
            case '\u018f': 
            case '\u01cf': 
            case '\u01fc': {
                intValue.value = 1;
                break;
            }
            case 'h': 
            case 'n': 
            case 'o': 
            case 'u': 
            case '\u00b5': 
            case '\u00e6': 
            case '\u00f1': 
            case '\u00f2': 
            case '\u00f3': 
            case '\u00f4': 
            case '\u00f5': 
            case '\u00f6': 
            case '\u00f8': 
            case '\u00f9': 
            case '\u00fa': 
            case '\u00fb': 
            case '\u00fc': 
            case '\u0125': 
            case '\u0127': 
            case '\u0133': 
            case '\u0144': 
            case '\u0146': 
            case '\u0148': 
            case '\u0149': 
            case '\u014b': 
            case '\u014d': 
            case '\u014f': 
            case '\u0151': 
            case '\u0153': 
            case '\u0169': 
            case '\u016b': 
            case '\u016d': 
            case '\u016f': 
            case '\u0171': 
            case '\u0173': 
            case '\u01a1': 
            case '\u01b0': 
            case '\u01d2': 
            case '\u01d4': 
            case '\u01d6': 
            case '\u01d8': 
            case '\u01da': 
            case '\u01dc': 
            case '\u01fd': 
            case '\u01ff': {
                booleanValue.value = false;
            }
            case '%': 
            case '0': 
            case 'B': 
            case 'D': 
            case 'H': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'Q': 
            case 'U': 
            case '\u00a4': 
            case '\u00a7': 
            case '\u00d0': 
            case '\u00d1': 
            case '\u00d2': 
            case '\u00d3': 
            case '\u00d4': 
            case '\u00d5': 
            case '\u00d6': 
            case '\u00d8': 
            case '\u00d9': 
            case '\u00da': 
            case '\u00db': 
            case '\u00dc': 
            case '\u00df': 
            case '\u010e': 
            case '\u0110': 
            case '\u0124': 
            case '\u0126': 
            case '\u0132': 
            case '\u0143': 
            case '\u0145': 
            case '\u0147': 
            case '\u014a': 
            case '\u014c': 
            case '\u014e': 
            case '\u0150': 
            case '\u0152': 
            case '\u0168': 
            case '\u016a': 
            case '\u016c': 
            case '\u016e': 
            case '\u0170': 
            case '\u0172': 
            case '\u01a0': 
            case '\u01af': 
            case '\u01d1': 
            case '\u01d3': 
            case '\u01d5': 
            case '\u01d7': 
            case '\u01d9': 
            case '\u01db': 
            case '\u01fe': {
                intValue.value = 2;
                break;
            }
            case 'm': {
                booleanValue.value = false;
                intValue.value = 3;
                break;
            }
            case '-': 
            case '^': 
            case '_': 
            case '~': 
            case '\u00ad': 
            case '\u00af': {
                intValue2.value = 1;
                break;
            }
            case '#': 
            case '=': {
                intValue2.value = 2;
                break;
            }
            case '+': 
            case '`': 
            case '\u00ac': 
            case '\u00b7': 
            case '\u00f7': {
                intValue.value = 1;
                intValue2.value = 1;
                break;
            }
            case ':': 
            case ';': 
            case '\u00b1': {
                intValue.value = 1;
                intValue2.value = 2;
                break;
            }
            case '\"': 
            case '\u00a8': {
                intValue.value = 2;
                intValue2.value = 1;
            }
        }
    }

    public static class AlgnZoneState {
        float leftXAlignPt;
        float leftCapAlignPt;
        float xHeight;
        float capHeight;
        float[] pDist;
        int[] edgePtsIdx;
    }
}

