/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontException;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.SWFFont4Description;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontLoader;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontResolver;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontSearchAttributes;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontResolver;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontSearchAttributes;
import flash.fonts.FontDescription;
import flash.fonts.FontFace;
import flash.fonts.FontManager;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineFont4;
import flash.util.LRUCache;
import flash.util.Trace;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFFFontManager
extends FontManager {
    private static final String FONT_EXT_OTF = ".otf";
    private static final String FONT_EXT_TTF = ".ttf";
    private static final String FONT_EXT_TTC = ".ttc";
    private static final String FONT_EXT_DFONT = ".dfont";
    private static final String MAX_CACHED_FONTS_KEY = "max-cached-fonts";
    private static final int DEFAULT_MAX_CACHE_SIZE = 10;
    private static final int DEFAULT_CACHE_PURGE_SIZE = 1;
    private FontLoader loader = new FontLoader();
    private PlatformFontResolver platformResolver = FontLoader.getPlatformFontResolverInstance();
    private FXGFontResolver legacyResolver = FontLoader.getFXGFontResolverInstance();
    private List localFontPaths;
    private boolean localPathsLoaded;
    private DefineFont4Cache defineFont4Cache;

    public void initialize(Map map) {
        int n = 10;
        if (map != null) {
            this.localFontPaths = (List)map.get("local-font-paths");
            String string = (String)map.get(MAX_CACHED_FONTS_KEY);
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.defineFont4Cache = new DefineFont4Cache(n / 2, n, 1);
    }

    public DefineFont createDefineFont(int n, FontDescription fontDescription) {
        DefineFont4 defineFont4;
        if (!fontDescription.compactFontFormat) {
            if (this.parent != null) {
                return this.parent.createDefineFont(n, fontDescription);
            }
            return null;
        }
        DefineFont4 defineFont42 = null;
        if (this.defineFont4Cache != null && (defineFont4 = (DefineFont4)this.defineFont4Cache.get(fontDescription)) != null) {
            defineFont42 = (DefineFont4)defineFont4.clone();
            if (fontDescription.alias != null) {
                defineFont42.fontName = fontDescription.alias;
            }
            return defineFont42;
        }
        defineFont4 = null;
        boolean bl = CFFFontManager.isBold((int)fontDescription.style);
        boolean bl2 = CFFFontManager.isItalic((int)fontDescription.style);
        try {
            if (fontDescription.source instanceof String) {
                PlatformFontSearchAttributes platformFontSearchAttributes;
                Font font;
                String string = (String)fontDescription.source;
                if (this.localFontPaths == null) {
                    throw new FontManagerException("Cannot embed font '" + string + "' because local fonts are not yet supported when embedAsCFF is true.");
                }
                if (!this.localPathsLoaded) {
                    this.loadLocalFonts();
                }
                if ((font = this.platformResolver.findFont(platformFontSearchAttributes = new PlatformFontSearchAttributes(string))) == null) {
                    FXGFontSearchAttributes fXGFontSearchAttributes = new FXGFontSearchAttributes(string, bl, bl2);
                    font = this.legacyResolver.findFont(fXGFontSearchAttributes);
                }
                if (font != null) {
                    defineFont4 = font.getSWFFont4Description();
                    defineFont42 = this.createDefineFont4(fontDescription, (SWFFont4Description)defineFont4);
                }
            } else {
                URL uRL = (URL)fontDescription.source;
                Font[] fontArray = this.loader.load(uRL);
                if (fontArray != null && fontArray.length > 0) {
                    if (fontArray.length == 1) {
                        Font font = fontArray[0];
                        defineFont4 = font.getSWFFont4Description();
                        defineFont42 = this.createDefineFont4(fontDescription, (SWFFont4Description)defineFont4);
                    } else {
                        Font font;
                        Font font2;
                        FXGFontResolver fXGFontResolver = FontLoader.getFXGFontResolverInstance();
                        for (int i = 0; i < fontArray.length; ++i) {
                            font2 = fontArray[i];
                            fXGFontResolver.addFont(font2);
                        }
                        String string = fontDescription.alias;
                        font2 = new FXGFontSearchAttributes(string, bl, bl2);
                        Font font3 = fXGFontResolver.findFont((FXGFontSearchAttributes)font2);
                        if (font3 == null && (font3 = fXGFontResolver.findFont((FXGFontSearchAttributes)(font2 = new FXGFontSearchAttributes(string = (defineFont4 = (font = fontArray[0]).getSWFFont4Description()).getFamily(), bl, bl2)))) == null) {
                            font3 = font;
                        }
                        if (font3 != null) {
                            defineFont4 = font3.getSWFFont4Description();
                            defineFont42 = this.createDefineFont4(fontDescription, (SWFFont4Description)defineFont4);
                        }
                    }
                }
            }
        }
        catch (FontLoadingException fontLoadingException) {
            throw new FontManagerException(fontDescription, (Exception)((Object)fontLoadingException));
        }
        catch (UnsupportedFontException unsupportedFontException) {
            throw new FontManagerException(fontDescription, (Exception)((Object)unsupportedFontException));
        }
        catch (InvalidFontException invalidFontException) {
            throw new FontManagerException(fontDescription, (Exception)((Object)invalidFontException));
        }
        catch (IOException iOException) {
            throw new FontManagerException(fontDescription, iOException);
        }
        if (defineFont42 != null && this.defineFont4Cache != null) {
            this.defineFont4Cache.put(fontDescription, defineFont42);
        }
        return defineFont42;
    }

    public FontFace getEntryFromLocation(URL uRL, int n, boolean bl) {
        if (this.parent != null) {
            return this.parent.getEntryFromLocation(uRL, n, bl);
        }
        return null;
    }

    public FontFace getEntryFromSystem(String string, int n, boolean bl) {
        if (this.parent != null) {
            return this.parent.getEntryFromSystem(string, n, bl);
        }
        return null;
    }

    private DefineFont4 createDefineFont4(FontDescription fontDescription, SWFFont4Description sWFFont4Description) throws IOException, InvalidFontException, UnsupportedFontException {
        if (fontDescription.alias == null) {
            fontDescription.alias = sWFFont4Description.getFamily();
        }
        DefineFont4 defineFont4 = new DefineFont4();
        defineFont4.fontName = fontDescription.alias;
        defineFont4.bold = CFFFontManager.isBold((int)fontDescription.style);
        defineFont4.italic = CFFFontManager.isItalic((int)fontDescription.style);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        if (fontDescription.unicodeRanges != null) {
            Iterator<Integer> iterator = this.getCodePointIterator(fontDescription.unicodeRanges);
            sWFFont4Description.streamFontData(iterator, (OutputStream)byteArrayOutputStream);
        } else {
            sWFFont4Description.streamFontData((OutputStream)byteArrayOutputStream);
        }
        defineFont4.data = byteArrayOutputStream.toByteArray();
        defineFont4.hasFontData = true;
        return defineFont4;
    }

    private Iterator<Integer> getCodePointIterator(String string) {
        int[][] nArray = this.getUnicodeRanges(string);
        CodePointIterator codePointIterator = new CodePointIterator(nArray);
        codePointIterator = new SWFFont4Description.TLFSubsetCompletionIterator((Iterator)codePointIterator);
        codePointIterator = new SWFFont4Description.FTESubsetCompletionIterator((Iterator)codePointIterator);
        return codePointIterator;
    }

    private void loadLocalFonts() {
        if (this.localFontPaths != null) {
            this.localPathsLoaded = true;
            long l = 0L;
            if (Trace.font) {
                l = System.currentTimeMillis();
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            ArrayList arrayList2 = new ArrayList();
            for (Object object : this.localFontPaths) {
                File file = new File((String)object);
                this.getLocalFontFiles(file, arrayList);
            }
            for (File file : arrayList) {
                Font[] fontArray = this.loader.load(file, false, arrayList2);
                for (int i = 0; i < fontArray.length; ++i) {
                    Font font = fontArray[i];
                    try {
                        this.platformResolver.addFont(font);
                        this.legacyResolver.addFont(font);
                        continue;
                    }
                    catch (FontException fontException) {
                        if (!Trace.font) continue;
                        Trace.trace((String)("Error loading local font " + file.getName()));
                    }
                }
            }
            if (Trace.font) {
                long l2 = System.currentTimeMillis() - l;
                Trace.trace((String)("Loaded local font paths in " + l2 + "ms."));
            }
        }
    }

    private void getLocalFontFiles(File file, List<File> list) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    this.getLocalFontFiles(file2, list);
                    continue;
                }
                if (!this.acceptFile(file2.getName())) continue;
                list.add(file2);
            }
        } else {
            list.add(file);
        }
    }

    private boolean acceptFile(String string) {
        return string != null && ((string = string.toLowerCase()).endsWith(FONT_EXT_TTF) || string.endsWith(FONT_EXT_OTF) || string.endsWith(FONT_EXT_DFONT) || string.endsWith(FONT_EXT_TTC));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CodePointIterator
    implements Iterator<Integer> {
        private int i = 0;
        private int c = 0;
        private int rowCount = 0;
        private int rowEnd = 0;
        private int rowStart = 0;
        private int[][] chars;

        public CodePointIterator(int[][] nArray) {
            this.chars = nArray;
            if (this.chars != null) {
                int[] nArray2;
                this.rowCount = this.chars.length;
                if (this.rowCount > 0 && (nArray2 = this.chars[this.i]) != null && nArray2.length == 2) {
                    this.rowStart = nArray2[0];
                    this.rowEnd = nArray2[1];
                    this.c = this.rowStart;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.i < this.rowCount && this.c <= this.rowEnd;
        }

        @Override
        public Integer next() {
            Integer n = null;
            if (this.i < this.rowCount && this.c <= this.rowEnd) {
                n = this.c++;
            }
            if (this.c > this.rowEnd) {
                int[] nArray;
                ++this.i;
                if (this.i < this.rowCount && (nArray = this.chars[this.i]) != null && nArray.length == 2) {
                    this.rowStart = nArray[0];
                    this.rowEnd = nArray[1];
                    this.c = this.rowStart;
                }
            }
            return n;
        }

        @Override
        public void remove() {
        }
    }

    private static class DefineFont4Cache
    extends LRUCache {
        private static final long serialVersionUID = -3243049168282817762L;

        private DefineFont4Cache(int n, int n2, int n3) {
            super(n, n2, n3);
        }
    }

    public static class FontManagerException
    extends RuntimeException {
        private static final long serialVersionUID = 2738969153721830047L;

        public FontManagerException(String string) {
            super(string);
        }

        public FontManagerException(FontDescription fontDescription, Exception exception) {
            super("The font " + fontDescription.source + " is not usable: " + exception.getMessage(), exception);
        }
    }
}

