/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fonts.transcoder;

import com.adobe.fonts.transcoder.AbstractFontTranscoder;
import com.adobe.fonts.transcoder.DefineFont3Transcoder;
import com.adobe.fonts.transcoder.DefineFont4Transcoder;
import com.adobe.fonts.transcoder.FontTranscoderException;
import flash.fonts.FontDescription;
import flash.util.Trace;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;

public class Font2SWF {
    public static void main(String[] stringArray) {
        try {
            Object object;
            Object object2;
            File file;
            String string;
            Font2SWF.print("Adobe Font2SWF Utility");
            Font2SWF.print("Copyright (c) 2009 Adobe Systems, Inc. All rights reserved.\n");
            long l = System.currentTimeMillis();
            DefineFontKind defineFontKind = DefineFontKind.DEFINEFONT4;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                string = Font2SWF.getArg(stringArray, i);
                if (string.equals("-?") || string.equals("-h") || string.equals("-help") || string.equals("--help")) {
                    Font2SWF.showUsage(null);
                    continue;
                }
                if (string.equals("-3")) {
                    defineFontKind = DefineFontKind.DEFINEFONT3;
                    continue;
                }
                if (string.equals("-4")) {
                    defineFontKind = DefineFontKind.DEFINEFONT4;
                    continue;
                }
                if (string.equals("-i") || string.equals("-italic")) {
                    bl2 = true;
                    continue;
                }
                if (string.equals("-b") || string.equals("-bold")) {
                    bl = true;
                    continue;
                }
                if (string.equals("-o") || string.equals("-output")) {
                    if ((string2 = Font2SWF.getArg(stringArray, ++i)).toLowerCase().endsWith(".swf")) continue;
                    string2 = string2 + ".swf";
                    continue;
                }
                if (string.equals("-a") || string.equals("-alias")) {
                    string5 = Font2SWF.getArg(stringArray, ++i);
                    continue;
                }
                if (string.equals("-u") || string.equals("-unicode-range")) {
                    if (!(string4 = Font2SWF.getArg(stringArray, ++i)).equals("*")) continue;
                    string4 = null;
                    continue;
                }
                if (string.startsWith("-")) {
                    Font2SWF.showUsage("Unsupported option: " + string);
                    continue;
                }
                if (string3 == null) {
                    string3 = string;
                    if (string3 == null || string3.startsWith("http:") || string3.startsWith("https:") || (file = new File(string3)).isAbsolute()) continue;
                    object2 = System.getProperty("user.dir");
                    string3 = (String)object2 + File.separator + string3;
                    continue;
                }
                Font2SWF.showUsage("Unexpected argument: " + string);
            }
            if (Font2SWF.isEmpty(string3)) {
                Font2SWF.showUsage("Missing font input path");
            }
            if (string2 == null) {
                object = string3;
                int n = string3.lastIndexOf(46);
                if (n > 0) {
                    object = ((String)object).substring(0, n);
                }
                if (((String)object).startsWith("file:///")) {
                    object = ((String)object).substring("file:///".length());
                }
                if (((String)object).startsWith("http:")) {
                    Font2SWF.showUsage("For remote fonts please use -o to specify the output path");
                }
                string2 = (String)object + ".swf";
            } else {
                object = new File(string2);
                if (!((File)object).isAbsolute()) {
                    string = System.getProperty("user.dir");
                    string2 = string + File.separator + string2;
                }
            }
            if (Font2SWF.isEmpty(string2)) {
                Font2SWF.showUsage("Output file path not specified");
            }
            if (!(string3.startsWith("http:") || string3.startsWith("https:") || string3.startsWith("file:"))) {
                string3 = "file:///" + string3;
            }
            object = null;
            object = defineFontKind == DefineFontKind.DEFINEFONT3 ? new DefineFont3Transcoder() : new DefineFont4Transcoder();
            FontDescription fontDescription = new FontDescription();
            fontDescription.advancedAntiAliasing = true;
            fontDescription.alias = string5;
            fontDescription.compactFontFormat = true;
            fontDescription.source = new URL(string3);
            fontDescription.style = (bl ? 1 : 0) + (bl2 ? 2 : 0);
            fontDescription.unicodeRanges = string4;
            Font2SWF.print("Reading font from " + fontDescription.source);
            file = new File(string2);
            if (!file.exists()) {
                file.getParentFile().mkdir();
                file.createNewFile();
            }
            object2 = new FileOutputStream(file);
            ((AbstractFontTranscoder)object).transcode(fontDescription, (OutputStream)object2);
            long l2 = System.currentTimeMillis() - l;
            Font2SWF.print("Generated SWF at " + string2 + " in " + l2 + "ms");
        }
        catch (Usage usage) {
            if (usage.error != null) {
                Font2SWF.print("Error: " + usage.error);
            }
            Font2SWF.printUsage();
        }
        catch (Exception exception) {
            if (Trace.error) {
                exception.printStackTrace();
            }
            System.err.println(exception.getLocalizedMessage());
        }
    }

    private static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private static String getArg(String[] stringArray, int n) throws Usage {
        if (n >= 0 && n < stringArray.length) {
            return stringArray[n];
        }
        Font2SWF.showUsage("Missing argument");
        return null;
    }

    private static void showUsage(String string) throws Usage {
        throw new Usage(string);
    }

    private static void printUsage() {
        Font2SWF.print("Usage: font2swf [options] <Font File>");
        Font2SWF.print("options:");
        Font2SWF.print("  -a, -alias <name>\t\t- set the font alias (defaults to font family name)");
        Font2SWF.print("  -b, -bold\t\t\t- treat the font as bold");
        Font2SWF.print("  -i, -italic\t\t\t- treat the font as italic");
        Font2SWF.print("  -o, -output <file path>\t- specify the SWF output file path");
        Font2SWF.print("  -u, -unicode-range <range>\t- set a unicode character range (default is '*' which includes all characters)");
        Font2SWF.print("  -3\t\t\t\t- generate DefineFont3 SWF tag");
        Font2SWF.print("  -4\t\t\t\t- generate DefineFont4 SWF tag (default)");
        Font2SWF.print("");
        Font2SWF.print("Example:");
        Font2SWF.print("  font2swf -4 -u U+0020-007F -bold -o C:/temp/myboldfont.swf C:/assets/fonts/myboldfont.ttf");
        Font2SWF.print("");
    }

    private static void print(String string) {
        System.out.println(string);
    }

    private static class Usage
    extends FontTranscoderException {
        private static final long serialVersionUID = 3682607093576649213L;
        public final String error;

        public Usage(String string) {
            super(string);
            this.error = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DefineFontKind {
        DEFINEFONT3,
        DEFINEFONT4;

    }
}

