/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem;

import flex2.compiler.CompilationUnit;
import flex2.compiler.Source;
import flex2.compiler.util.Name;
import flex2.compiler.util.QName;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import macromedia.asc.util.ContextStatics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationCache {
    private Map<String, Source> sources = new HashMap<String, Source>();
    private SoftReference<Object> trigger;
    private int lowestTotalDependentCount;
    private ContextStatics contextStatics;

    private static void addDependents(Source source, Set<QName> dependents, Map<QName, Source> qNameToSourceMap, Map<Name, Map<String, Source>> dependentMap) {
        CompilationUnit compilationUnit = source.getCompilationUnit();
        if (compilationUnit != null) {
            for (QName topLevelDefinition : compilationUnit.topLevelDefinitions) {
                Map<String, Source> topLevelDefinitionDependents = dependentMap.get(topLevelDefinition);
                if (topLevelDefinitionDependents == null) continue;
                for (Source dependentSource : topLevelDefinitionDependents.values()) {
                    boolean foundNewDependent = false;
                    CompilationUnit dependentCompilationUnit = dependentSource.getCompilationUnit();
                    if (dependentCompilationUnit != null) {
                        for (QName dependent : dependentCompilationUnit.topLevelDefinitions) {
                            if (dependents.contains(dependent)) continue;
                            dependents.add(dependent);
                            foundNewDependent = true;
                        }
                    }
                    if (!foundNewDependent) continue;
                    ApplicationCache.addDependents(dependentSource, dependents, qNameToSourceMap, dependentMap);
                }
            }
        }
    }

    void addSources(Map<String, Source> sources) {
        CompilationUnit compilationUnit;
        this.sources.putAll(sources);
        HashMap<QName, Source> qNames = new HashMap<QName, Source>(sources.size());
        HashMap<Name, Map<String, Source>> dependentMap = new HashMap<Name, Map<String, Source>>(sources.size());
        for (Source source : this.sources.values()) {
            compilationUnit = source.getCompilationUnit();
            if (compilationUnit == null) continue;
            for (QName qName : compilationUnit.topLevelDefinitions) {
                qNames.put(qName, source);
            }
        }
        for (Source source : this.sources.values()) {
            compilationUnit = source.getCompilationUnit();
            if (compilationUnit == null) continue;
            for (Name name : compilationUnit.inheritance) {
                if (!(name instanceof QName)) continue;
                HashMap<String, Source> inheritanceDependents = (HashMap<String, Source>)dependentMap.get(name);
                if (inheritanceDependents == null) {
                    inheritanceDependents = new HashMap<String, Source>();
                    dependentMap.put(name, inheritanceDependents);
                }
                inheritanceDependents.put(source.getName(), source);
            }
            for (Name name : compilationUnit.namespaces) {
                if (!(name instanceof QName)) continue;
                HashMap<String, Source> namespacesDependents = (HashMap<String, Source>)dependentMap.get(name);
                if (namespacesDependents == null) {
                    namespacesDependents = new HashMap<String, Source>();
                    dependentMap.put(name, namespacesDependents);
                }
                namespacesDependents.put(source.getName(), source);
            }
            for (Name name : compilationUnit.expressions) {
                if (!(name instanceof QName)) continue;
                HashMap<String, Source> expressionsDependents = (HashMap<String, Source>)dependentMap.get(name);
                if (expressionsDependents == null) {
                    expressionsDependents = new HashMap<String, Source>();
                    dependentMap.put(name, expressionsDependents);
                }
                expressionsDependents.put(source.getName(), source);
            }
            for (Name name : compilationUnit.types) {
                if (!(name instanceof QName)) continue;
                HashMap<String, Source> typesDependents = (HashMap<String, Source>)dependentMap.get(name);
                if (typesDependents == null) {
                    typesDependents = new HashMap<String, Source>();
                    dependentMap.put(name, typesDependents);
                }
                typesDependents.put(source.getName(), source);
            }
        }
        this.lowestTotalDependentCount = Integer.MAX_VALUE;
        for (Source source : this.sources.values()) {
            HashSet<QName> dependents = new HashSet<QName>();
            ApplicationCache.addDependents(source, dependents, qNames, dependentMap);
            int totalDependentCount = dependents.size();
            source.setTotalDependentCount(totalDependentCount);
            if (totalDependentCount >= this.lowestTotalDependentCount) continue;
            this.lowestTotalDependentCount = totalDependentCount;
        }
        this.reloadTrigger();
    }

    ContextStatics getContextStatics() {
        return this.contextStatics;
    }

    public Source getSource(String className) {
        return this.sources.get(className);
    }

    private void prune() {
        Iterator<Source> iterator = this.sources.values().iterator();
        int nextLowestTotalDependentCount = Integer.MAX_VALUE;
        while (iterator.hasNext()) {
            Source source = iterator.next();
            int totalDependentCount = source.getTotalDependentCount();
            if (totalDependentCount == this.lowestTotalDependentCount) {
                iterator.remove();
                continue;
            }
            if (totalDependentCount >= nextLowestTotalDependentCount) continue;
            nextLowestTotalDependentCount = totalDependentCount;
        }
        if (nextLowestTotalDependentCount < Integer.MAX_VALUE) {
            this.lowestTotalDependentCount = nextLowestTotalDependentCount;
            this.reloadTrigger();
        }
    }

    private void reloadTrigger() {
        if (this.trigger == null) {
            this.trigger = new SoftReference<1>(new Object(){

                protected void finalize() throws Throwable {
                    ApplicationCache.this.prune();
                }
            });
        }
    }

    public void clear() {
        this.sources.clear();
    }

    void setContextStatics(ContextStatics contextStatics) {
        this.contextStatics = contextStatics;
    }
}

