/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem;

import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerAPI;
import flex2.compiler.CompilerException;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.FileSpec;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.LicenseException;
import flex2.compiler.PreLink;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.Source;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.SubCompiler;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.SinglePathResolver;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcAPI;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.swc.SwcComponent;
import flex2.compiler.swc.SwcDirectoryArchive;
import flex2.compiler.swc.SwcDynamicArchive;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.SwcMovie;
import flex2.compiler.util.Benchmark;
import flex2.compiler.util.CompilerControl;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.PerformanceData;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.linker.LinkerConfiguration;
import flex2.linker.LinkerException;
import flex2.linker.SimpleMovie;
import flex2.tools.CompcPreLink;
import flex2.tools.Mxmlc;
import flex2.tools.ToolsConfiguration;
import flex2.tools.WebTierAPI;
import flex2.tools.oem.Builder;
import flex2.tools.oem.Configuration;
import flex2.tools.oem.LibraryCache;
import flex2.tools.oem.Logger;
import flex2.tools.oem.Message;
import flex2.tools.oem.PathResolver;
import flex2.tools.oem.ProgressMeter;
import flex2.tools.oem.Report;
import flex2.tools.oem.VirtualLocalFile;
import flex2.tools.oem.internal.LibraryData;
import flex2.tools.oem.internal.OEMConfiguration;
import flex2.tools.oem.internal.OEMReport;
import flex2.tools.oem.internal.OEMUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import macromedia.asc.util.ContextStatics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Library
implements Builder {
    private Set<VirtualFile> sources = new TreeSet<VirtualFile>(new Comparator<VirtualFile>(){

        @Override
        public int compare(VirtualFile f0, VirtualFile f1) {
            return f0.getName().compareTo(f1.getName());
        }
    });
    private Set<String> classes = new TreeSet<String>();
    private Set<String> resourceBundles;
    private Set<URI> namespaces = new TreeSet<URI>();
    private Map<String, VirtualFile> files;
    private Map<String, VirtualFile> stylesheets;
    private OEMConfiguration oemConfiguration = null;
    private Logger logger = null;
    private File output = null;
    private File directory = null;
    private MimeMappings mimeMappings;
    private ProgressMeter meter = null;
    protected PathResolver resolver = null;
    private CompilerControl cc;
    private LibraryCache librarySwcCache;
    LibraryData data = null;
    private String cacheName = null;
    private String configurationReport = null;
    private List<Message> messages;
    private HashMap<String, PerformanceData[]> compilerBenchmarks;
    private Benchmark benchmark;

    public Library() {
        this.resourceBundles = new TreeSet<String>();
        this.files = new TreeMap<String, VirtualFile>();
        this.stylesheets = new TreeMap<String, VirtualFile>();
        this.mimeMappings = new MimeMappings();
        this.cc = new CompilerControl();
        this.messages = new ArrayList<Message>();
    }

    public void addComponent(String includeClass) {
        this.classes.add(includeClass);
    }

    public void addComponent(File includeSource) {
        this.sources.add((VirtualFile)new LocalFile(includeSource));
    }

    public void addComponent(VirtualLocalFile includeSource) {
        this.sources.add(includeSource);
    }

    public void addComponent(URI includeNamespace) {
        this.namespaces.add(includeNamespace);
    }

    public void removeComponent(String includeClass) {
        this.classes.remove(includeClass);
    }

    public void removeComponent(File includeSource) {
        this.sources.remove(new LocalFile(includeSource));
    }

    public void removeComponent(VirtualLocalFile includeSource) {
        this.sources.remove(includeSource);
    }

    public void removeComponent(URI includeNamespace) {
        this.namespaces.remove(includeNamespace);
    }

    public void removeAllComponents() {
        this.sources.clear();
        this.classes.clear();
        this.namespaces.clear();
    }

    public void addResourceBundle(String resourceBundle) {
        this.resourceBundles.add(resourceBundle);
    }

    public void removeResourceBundle(String resourceBundle) {
        this.resourceBundles.remove(resourceBundle);
    }

    public void removeAllResourceBundles() {
        this.resourceBundles.clear();
    }

    public void addArchiveFile(String name, File file) {
        this.files.put(name, (VirtualFile)new LocalFile(file));
    }

    public void addArchiveFile(String name, VirtualLocalFile file) {
        this.files.put(name, file);
    }

    public void removeArchiveFile(String name) {
        this.files.remove(name);
    }

    public void removeAllArchiveFiles() {
        this.files.clear();
    }

    public void addStyleSheet(String name, File file) {
        this.stylesheets.put(name, (VirtualFile)new LocalFile(file));
    }

    public void addStyleSheet(String name, VirtualLocalFile file) {
        this.stylesheets.put(name, file);
    }

    public void removeStyleSheet(String name) {
        this.stylesheets.remove(name);
    }

    public void removeAllStyleSheets() {
        this.stylesheets.clear();
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.oemConfiguration = (OEMConfiguration)configuration;
    }

    @Override
    public Configuration getDefaultConfiguration() {
        return this.getDefaultConfiguration(false);
    }

    private Configuration getDefaultConfiguration(boolean processDefaults) {
        return OEMUtil.getLibraryConfiguration(this.constructCommandLine(null), false, OEMUtil.getLogger(this.logger, this.messages), this.resolver, this.mimeMappings, processDefaults);
    }

    public HashMap<String, PerformanceData[]> getCompilerBenchmarks() {
        return this.compilerBenchmarks;
    }

    @Override
    public Benchmark getBenchmark() {
        return this.benchmark;
    }

    @Override
    public Configuration getConfiguration() {
        return this.oemConfiguration;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setSupportedFileExtensions(String mimeType, String[] extensions) {
        this.mimeMappings.set(mimeType, extensions);
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public File getOutput() {
        return this.output;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public File getDirectory() {
        return this.directory;
    }

    @Override
    public void setProgressMeter(ProgressMeter meter) {
        this.meter = meter;
    }

    @Override
    public void setPathResolver(PathResolver resolver) {
        this.resolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long build(boolean incremental) throws IOException {
        if (this.output != null || this.directory != null) {
            long l;
            block7: {
                long size = 0L;
                try {
                    int result = this.compile(incremental);
                    if (result == 0 || result == Integer.MAX_VALUE || result == 1) {
                        size = this.link(null);
                    }
                    l = size;
                    Object var8_5 = null;
                    if (this.output == null || this.data == null || this.data.swcCache == null) break block7;
                    this.refreshLastModified();
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    if (this.output != null && this.data != null && this.data.swcCache != null) {
                        this.refreshLastModified();
                    }
                    if (this.benchmark != null && this.benchmark.hasStarted("postcompile")) {
                        this.benchmark.stopTime("postcompile", false);
                    }
                    throw throwable;
                }
            }
            if (this.benchmark != null && this.benchmark.hasStarted("postcompile")) {
                this.benchmark.stopTime("postcompile", false);
            }
            return l;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long build(OutputStream out, boolean incremental) throws IOException {
        block5: {
            long l;
            try {
                int result = this.compile(incremental);
                if (result != 0 && result != Integer.MAX_VALUE && result != 1) break block5;
                l = this.link(out);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var7_8 = null;
                    if (this.benchmark == null || !this.benchmark.hasStarted("postcompile")) break block6;
                    this.benchmark.stopTime("postcompile", false);
                }
                throw throwable;
            }
            if (this.benchmark != null && this.benchmark.hasStarted("postcompile")) {
                this.benchmark.stopTime("postcompile", false);
            }
            return l;
        }
        long l = 0L;
        Object var7_7 = null;
        if (this.benchmark != null && this.benchmark.hasStarted("postcompile")) {
            this.benchmark.stopTime("postcompile", false);
        }
        return l;
    }

    private int recompile(boolean fullRecompile, Map licenseMap, OEMConfiguration localOEMConfiguration) {
        SymbolTable symbolTable;
        this.data = new LibraryData();
        this.data.configuration = localOEMConfiguration.configuration;
        this.data.cacheName = this.cacheName;
        NameMappings mappings = CompilerAPI.getNameMappings((flex2.compiler.common.Configuration)localOEMConfiguration.configuration);
        NameMappings copy = mappings.copy();
        CompilerConfiguration compilerConfig = localOEMConfiguration.configuration.getCompilerConfiguration();
        compilerConfig.setMetadataExport(true);
        if (this.output != null || this.directory != null) {
            OEMUtil.setGeneratedDirectory(compilerConfig, this.output != null ? this.output : this.directory);
        }
        Transcoder[] transcoders = WebTierAPI.getTranscoders((flex2.compiler.common.Configuration)localOEMConfiguration.configuration);
        SubCompiler[] compilers = WebTierAPI.getCompilers((CompilerConfiguration)compilerConfig, (NameMappings)mappings, (Transcoder[])transcoders);
        this.data.fileSet = this.processSources();
        if (this.data.fileSet == null) {
            return -1;
        }
        this.data.fileSet.addAll(this.processStylesheets());
        if (!this.setupSourceContainers((flex2.compiler.common.Configuration)localOEMConfiguration.configuration, this.data.fileSet)) {
            return -1;
        }
        if (this.librarySwcCache != null) {
            this.data.swcCache = this.librarySwcCache.getSwcCache();
            this.data.perCompileData = this.librarySwcCache.getContextStatics();
            if (this.data.perCompileData != null) {
                this.data.perCompileData.clearUserDefined();
            }
        }
        if (this.data.swcCache == null) {
            this.data.swcCache = new SwcCache();
        }
        CompilerSwcContext swcContext = new CompilerSwcContext(true);
        try {
            swcContext.load(compilerConfig.getLibraryPath(), compilerConfig.getExternalLibraryPath(), null, compilerConfig.getIncludeLibraries(), mappings, I18nUtils.getTranslationFormat((CompilerConfiguration)compilerConfig), this.data.swcCache);
        }
        catch (SwcException ex) {
            return -1;
        }
        if (this.librarySwcCache != null && this.librarySwcCache.getSwcCache() != this.data.swcCache) {
            this.librarySwcCache.setSwcCache(this.data.swcCache);
        }
        this.data.includes = new HashSet(swcContext.getIncludes());
        this.data.excludes = new HashSet(swcContext.getExterns());
        localOEMConfiguration.configuration.addExterns((Collection)swcContext.getExterns());
        localOEMConfiguration.configuration.addIncludes((Collection)swcContext.getIncludes());
        this.data.swcArchiveFiles = new HashMap<String, VirtualFile>(swcContext.getIncludeFiles());
        this.data.cmdChecksum = localOEMConfiguration.cfgbuf.checksum_ts();
        this.data.linkChecksum = localOEMConfiguration.cfgbuf.link_checksum_ts();
        this.data.swcChecksum = swcContext.checksum();
        int[] checksums = new int[]{0, this.data.cmdChecksum, this.data.linkChecksum, this.data.swcChecksum};
        if (!fullRecompile) {
            if (!this.loadCompilationUnits(localOEMConfiguration.configuration, this.data.fileSet, swcContext, checksums)) {
                return -1;
            }
            this.data.checksum = checksums[0];
            if (this.data.units != null && this.data.units.size() > 0 && OEMUtil.isRecompilationNeeded(this.data, swcContext, localOEMConfiguration) && !this.setupSourceContainers((flex2.compiler.common.Configuration)localOEMConfiguration.configuration, this.data.fileSet)) {
                return -1;
            }
        }
        int count = CompilerAPI.validateCompilationUnits((FileSpec)this.data.fileSpec, (SourceList)this.data.sourceList, (SourcePath)this.data.sourcePath, (ResourceBundlePath)this.data.bundlePath, (ResourceContainer)this.data.resources, (CompilerSwcContext)swcContext, this.data.classes, (ContextStatics)this.data.perCompileData, (boolean)false, (flex2.compiler.common.Configuration)localOEMConfiguration.configuration);
        if (this.data.perCompileData != null) {
            symbolTable = new SymbolTable(this.data.perCompileData);
        } else {
            symbolTable = SymbolTable.newSymbolTable((flex2.compiler.common.Configuration)localOEMConfiguration.configuration);
            this.data.perCompileData = symbolTable.perCompileData;
            if (this.librarySwcCache != null) {
                this.librarySwcCache.setContextStatics(this.data.perCompileData);
            }
        }
        TreeMap<String, Source> classes = new TreeMap<String, Source>();
        this.data.nsComponents = this.processInputs(swcContext, copy, classes);
        if (this.data.nsComponents == null) {
            return -1;
        }
        this.data.classes = classes;
        this.data.sources = new ArrayList();
        this.data.units = this.compile(compilers, swcContext, symbolTable, mappings, licenseMap, this.data.classes, this.data.sources);
        this.data.checksum = OEMUtil.calculateChecksum(this.data, swcContext, localOEMConfiguration);
        boolean forcedToStop = CompilerAPI.forcedToStop();
        if (this.data.units == null || forcedToStop) {
            return -1;
        }
        return 1;
    }

    @Override
    public void stop() {
        this.cc.stop();
    }

    @Override
    public void clean() {
        this.clean(true, true, true, true, true, true);
    }

    @Override
    public void load(InputStream in) throws IOException {
        this.cacheName = OEMUtil.load(in, this.cacheName);
        this.clean(true, false, false);
    }

    @Override
    public long save(OutputStream out) throws IOException {
        return OEMUtil.save(out, this.cacheName, this.data);
    }

    @Override
    public Report getReport() {
        OEMUtil.setupLocalizationManager();
        return new OEMReport(this.data == null ? null : this.data.sources, this.data == null ? null : this.data.movie, this.data == null ? null : this.data.configuration, this.configurationReport, this.messages);
    }

    private String[] constructCommandLine(OEMConfiguration localOEMConfiguration) {
        return localOEMConfiguration != null ? localOEMConfiguration.getCompilerOptions() : new String[]{};
    }

    private Set<SwcComponent> processInputs(CompilerSwcContext swcContext, NameMappings mappings, Map<String, Source> classes) {
        try {
            Set<SwcComponent> nsComponents = this.processNamespaces(mappings, classes);
            if (nsComponents == null) {
                return null;
            }
            if (!this.processClasses(classes)) {
                return null;
            }
            return nsComponents;
        }
        catch (SwcException ex) {
            assert (ThreadLocalToolkit.errorCount() > 0);
            return null;
        }
    }

    private boolean processClasses(Map<String, Source> classes) {
        try {
            SwcAPI.setupClasses(new ArrayList<String>(this.classes), (SourcePath)this.data.sourcePath, classes);
            return true;
        }
        catch (CompilerException ex) {
            assert (ThreadLocalToolkit.errorCount() > 0);
            return false;
        }
    }

    private Set<SwcComponent> processNamespaces(NameMappings mappings, Map<String, Source> classes) {
        TreeSet<SwcComponent> nsComponents;
        block3: {
            nsComponents = null;
            try {
                List list = SwcAPI.setupNamespaceComponents(this.toStrings(this.namespaces), (NameMappings)mappings, (SourcePath)this.data.sourcePath, classes);
                nsComponents = new TreeSet<SwcComponent>(new Comparator<SwcComponent>(){

                    @Override
                    public int compare(SwcComponent c0, SwcComponent c1) {
                        return c0.getClassName().compareTo(c1.getClassName());
                    }
                });
                nsComponents.addAll(list);
            }
            catch (ConfigurationException ex) {
                Mxmlc.processConfigurationException((ConfigurationException)ex, (String)"oem");
            }
            catch (CompilerException ex) {
                if ($assertionsDisabled || ThreadLocalToolkit.errorCount() > 0) break block3;
                throw new AssertionError();
            }
        }
        return nsComponents;
    }

    private List<String> toStrings(Set<URI> set) {
        ArrayList<String> a = new ArrayList<String>(set.size());
        for (URI uri : set) {
            a.add(uri.toString());
        }
        return a;
    }

    private boolean setupSourceContainers(flex2.compiler.common.Configuration configuration, Set fileSet) {
        boolean result;
        block6: {
            CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
            VirtualFile[] asClasspath = compilerConfig.getSourcePath();
            result = false;
            try {
                this.data.sourcePath = new SourcePath(WebTierAPI.getSourcePathMimeTypes(), compilerConfig.allowSourcePathOverlap());
                this.data.sourcePath.addPathElements(asClasspath);
                ThreadLocalToolkit.getPathResolver().addSinglePathResolver((SinglePathResolver)this.data.sourcePath);
                List[] array = CompilerAPI.getVirtualFileList((Set)fileSet, (List)this.data.sourcePath.getPaths());
                this.data.fileSpec = new FileSpec(array[0], WebTierAPI.getFileSpecMimeTypes(), false);
                this.data.sourceList = new SourceList(array[1], asClasspath, null, WebTierAPI.getSourceListMimeTypes(), false);
                this.data.resources = new ResourceContainer();
                this.data.bundlePath = new ResourceBundlePath(compilerConfig, null);
                if (this.data.sources != null) {
                    this.data.sources.clear();
                }
                if (this.data.units != null) {
                    this.data.units.clear();
                }
                if (this.data.swcDefSignatureChecksums != null) {
                    this.data.swcDefSignatureChecksums.clear();
                }
                if (this.data.swcFileChecksums != null) {
                    this.data.swcFileChecksums.clear();
                }
                result = true;
            }
            catch (CompilerException ex) {
                if ($assertionsDisabled || ThreadLocalToolkit.errorCount() > 0) break block6;
                throw new AssertionError();
            }
        }
        return result;
    }

    private Set<VirtualFile> processSources() {
        TreeSet<VirtualFile> fileSet;
        block2: {
            fileSet = null;
            try {
                List fileList = CompilerAPI.getVirtualFileList(new ArrayList<VirtualFile>(this.sources), new HashSet<String>(Arrays.asList(WebTierAPI.getSourcePathMimeTypes())));
                fileSet = new TreeSet<VirtualFile>(new Comparator<VirtualFile>(){

                    @Override
                    public int compare(VirtualFile f0, VirtualFile f1) {
                        return f0.getName().compareTo(f1.getName());
                    }
                });
                fileSet.addAll(fileList);
            }
            catch (ConfigurationException ex) {
                if ($assertionsDisabled || ThreadLocalToolkit.errorCount() > 0) break block2;
                throw new AssertionError();
            }
        }
        return fileSet;
    }

    private Set<VirtualFile> processStylesheets() {
        TreeSet<VirtualFile> fileSet;
        block2: {
            fileSet = null;
            try {
                List fileList = CompilerAPI.getVirtualFileList(new ArrayList<VirtualFile>(this.stylesheets.values()), new HashSet<String>(Arrays.asList("text/css")));
                fileSet = new TreeSet<VirtualFile>(new Comparator<VirtualFile>(){

                    @Override
                    public int compare(VirtualFile f0, VirtualFile f1) {
                        return f0.getName().compareTo(f1.getName());
                    }
                });
                fileSet.addAll(fileList);
            }
            catch (ConfigurationException ex) {
                if ($assertionsDisabled || ThreadLocalToolkit.errorCount() > 0) break block2;
                throw new AssertionError();
            }
        }
        return fileSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean loadCompilationUnits(ToolsConfiguration configuration, Set fileSet, CompilerSwcContext swcContext, int[] checksums) {
        if (this.data.cacheName == null) {
            return true;
        }
        RandomAccessFile cacheFile = null;
        cacheFile = new RandomAccessFile(this.data.cacheName, "r");
        this.data.sources = new ArrayList();
        this.data.units = new ArrayList();
        this.data.swcDefSignatureChecksums = new HashMap();
        this.data.swcFileChecksums = new HashMap();
        CompilerAPI.loadCompilationUnits((flex2.compiler.common.Configuration)configuration, (FileSpec)this.data.fileSpec, (SourceList)this.data.sourceList, (SourcePath)this.data.sourcePath, (ResourceContainer)this.data.resources, (ResourceBundlePath)this.data.bundlePath, this.data.sources, this.data.units, (int[])checksums, this.data.swcDefSignatureChecksums, this.data.swcFileChecksums, (RandomAccessFile)cacheFile, (String)this.data.cacheName);
        Object var9_6 = null;
        if (cacheFile == null) return true;
        try {
            cacheFile.close();
            return true;
        }
        catch (IOException ex2) {}
        return true;
        {
            catch (FileNotFoundException ex) {
                ThreadLocalToolkit.logInfo((String)ex.getMessage());
                boolean bl = true;
                Object var9_7 = null;
                if (cacheFile == null) return bl;
                try {
                    cacheFile.close();
                    return bl;
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                return bl;
            }
            catch (IOException ex) {
                block14: {
                    boolean bl;
                    try {
                        ThreadLocalToolkit.logInfo((String)ex.getMessage());
                        if (this.setupSourceContainers((flex2.compiler.common.Configuration)configuration, fileSet)) break block14;
                        bl = false;
                        Object var9_8 = null;
                        if (cacheFile == null) return bl;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        if (cacheFile == null) throw throwable;
                        try {
                            cacheFile.close();
                            throw throwable;
                        }
                        catch (IOException ex2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        cacheFile.close();
                        return bl;
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                    return bl;
                }
                Object var9_9 = null;
                if (cacheFile == null) return true;
                try {
                    cacheFile.close();
                    return true;
                }
                catch (IOException ex2) {}
                return true;
            }
        }
    }

    protected int compile(boolean incremental) {
        VirtualFile[] includeLibs;
        this.messages.clear();
        OEMConfiguration tempOEMConfiguration = this.oemConfiguration == null ? (OEMConfiguration)this.getDefaultConfiguration(true) : OEMUtil.getLibraryConfiguration(this.constructCommandLine(this.oemConfiguration), this.oemConfiguration.keepLinkReport(), OEMUtil.getLogger(this.logger, this.messages), this.resolver, this.mimeMappings);
        if (tempOEMConfiguration == null) {
            this.clean(false, false, false);
            return -1;
        }
        if (this.oemConfiguration != null && this.oemConfiguration.keepConfigurationReport()) {
            this.configurationReport = OEMUtil.formatConfigurationBuffer(tempOEMConfiguration.cfgbuf);
        }
        if (this.oemConfiguration != null) {
            this.oemConfiguration.cfgbuf = tempOEMConfiguration.cfgbuf;
        }
        if (tempOEMConfiguration.configuration.benchmark()) {
            this.benchmark = CompilerAPI.runBenchmark();
            this.benchmark.setTimeFilter(tempOEMConfiguration.configuration.getBenchmarkTimeFilter());
            this.benchmark.startTime("precompile");
        } else {
            CompilerAPI.disableBenchmark();
        }
        this.cc.run();
        OEMUtil.init(OEMUtil.getLogger(this.logger, this.messages), this.mimeMappings, this.meter, this.resolver, this.cc);
        Map licenseMap = OEMUtil.getLicenseMap(tempOEMConfiguration.configuration);
        VirtualFile[] virtualFileArray = includeLibs = tempOEMConfiguration.configuration == null ? null : tempOEMConfiguration.configuration.getCompilerConfiguration().getIncludeLibraries();
        if (this.sources.size() == 0 && this.classes.size() == 0 && this.namespaces.size() == 0 && this.resourceBundles.size() == 0 && this.files.size() == 0 && this.stylesheets.size() == 0 && (includeLibs == null || includeLibs.length == 0)) {
            ThreadLocalToolkit.log((ILocalizableMessage)new ConfigurationException.NoSwcInputs(null, null, -1));
            this.clean(false, false, false);
            return -1;
        }
        if (this.data == null || !incremental) {
            String compilationType;
            String string = compilationType = this.cacheName != null ? "inactive" : "full";
            if (this.benchmark != null) {
                this.benchmark.benchmark2("Starting " + compilationType + " compile for " + this.getOutput(), true);
            }
            int returnValue = this.recompile(false, licenseMap, tempOEMConfiguration);
            if (this.benchmark != null) {
                this.benchmark.benchmark2("Ending " + compilationType + " compile for " + this.getOutput(), true);
            }
            this.clean(returnValue != 1, false, false);
            return returnValue;
        }
        CompilerAPI.setupHeadless((flex2.compiler.common.Configuration)tempOEMConfiguration.configuration);
        NameMappings mappings = CompilerAPI.getNameMappings((flex2.compiler.common.Configuration)tempOEMConfiguration.configuration);
        NameMappings copy = mappings.copy();
        this.data.sourcePath.clearCache();
        this.data.bundlePath.clearCache();
        this.data.resources.refresh();
        CompilerConfiguration compilerConfig = tempOEMConfiguration.configuration.getCompilerConfiguration();
        compilerConfig.setMetadataExport(true);
        if (this.output != null || this.directory != null) {
            OEMUtil.setGeneratedDirectory(compilerConfig, this.output != null ? this.output : this.directory);
        }
        Transcoder[] transcoders = WebTierAPI.getTranscoders((flex2.compiler.common.Configuration)tempOEMConfiguration.configuration);
        SubCompiler[] compilers = WebTierAPI.getCompilers((CompilerConfiguration)compilerConfig, (NameMappings)mappings, (Transcoder[])transcoders);
        CompilerSwcContext swcContext = new CompilerSwcContext(true);
        try {
            swcContext.load(compilerConfig.getLibraryPath(), compilerConfig.getExternalLibraryPath(), null, compilerConfig.getIncludeLibraries(), mappings, I18nUtils.getTranslationFormat((CompilerConfiguration)compilerConfig), this.data.swcCache);
        }
        catch (SwcException ex) {
            this.clean(false, false, false);
            return -1;
        }
        if (this.librarySwcCache != null && this.librarySwcCache.getSwcCache() != this.data.swcCache) {
            this.librarySwcCache.setSwcCache(this.data.swcCache);
        }
        if (OEMUtil.isRecompilationNeeded(this.data, swcContext, tempOEMConfiguration)) {
            if (this.benchmark != null) {
                this.benchmark.benchmark2("Starting full compile for " + this.getOutput(), true);
            }
            this.clean(true, false, false, true, false, false);
            int returnValue = this.recompile(true, licenseMap, tempOEMConfiguration);
            if (this.benchmark != null) {
                this.benchmark.benchmark2("Ending full compile for " + this.getOutput(), true);
            }
            this.clean(returnValue != 1, false, false);
            return returnValue;
        }
        Set<VirtualFile> fileSet = null;
        fileSet = this.processSources();
        if (fileSet == null) {
            this.clean(false, false, false);
            return -1;
        }
        fileSet.addAll(this.processStylesheets());
        boolean isFileSpecDifferent = this.isDifferent(this.data.fileSet, fileSet);
        if (isFileSpecDifferent) {
            if (this.benchmark != null) {
                this.benchmark.benchmark2("Starting full compile for " + this.getOutput(), true);
            }
            this.clean(true, false, false, true, false, false);
            int returnValue = this.recompile(true, licenseMap, tempOEMConfiguration);
            if (this.benchmark != null) {
                this.benchmark.benchmark2("Ending full compile for " + this.getOutput(), true);
            }
            this.clean(returnValue != 1, false, false);
            return returnValue;
        }
        if (this.benchmark != null) {
            this.benchmark.benchmark2("Starting active compile for " + this.getOutput(), true);
        }
        this.data.includes = new HashSet(swcContext.getIncludes());
        this.data.excludes = new HashSet(swcContext.getExterns());
        tempOEMConfiguration.configuration.addExterns((Collection)swcContext.getExterns());
        tempOEMConfiguration.configuration.addIncludes((Collection)swcContext.getIncludes());
        this.data.swcArchiveFiles = new HashMap<String, VirtualFile>(swcContext.getIncludeFiles());
        int count = CompilerAPI.validateCompilationUnits((FileSpec)this.data.fileSpec, (SourceList)this.data.sourceList, (SourcePath)this.data.sourcePath, (ResourceBundlePath)this.data.bundlePath, (ResourceContainer)this.data.resources, (CompilerSwcContext)swcContext, this.data.classes, (ContextStatics)this.data.perCompileData, (boolean)false, (flex2.compiler.common.Configuration)tempOEMConfiguration.configuration);
        TreeMap<String, Source> classes = new TreeMap<String, Source>();
        Set<SwcComponent> nsComponents = null;
        nsComponents = this.processInputs(swcContext, copy, classes);
        if (nsComponents == null) {
            this.clean(false, false, false);
            return -1;
        }
        boolean isDifferent = this.isDifferent(this.data.classes.keySet(), classes.keySet());
        if (count > 0 || isDifferent || this.isResourceBundleListDifferent() || this.data.swcChecksum != swcContext.checksum()) {
            SymbolTable symbolTable = new SymbolTable(this.data.perCompileData);
            this.data.configuration = tempOEMConfiguration.configuration;
            this.data.nsComponents = nsComponents;
            this.data.classes = classes;
            this.data.fileSet = fileSet;
            this.data.linkChecksum = tempOEMConfiguration.cfgbuf.link_checksum_ts();
            this.data.swcChecksum = swcContext.checksum();
            this.data.sources = new ArrayList();
            this.data.units = this.compile(compilers, swcContext, symbolTable, mappings, licenseMap, classes, this.data.sources);
            boolean forcedToStop = CompilerAPI.forcedToStop();
            if (this.data.units == null || forcedToStop) {
                this.clean(true, false, false);
                return -1;
            }
            if (this.benchmark != null) {
                this.benchmark.benchmark2("Ending active compile for " + this.getOutput(), true);
            }
            this.clean(false, false, false);
            return 1;
        }
        if (this.benchmark != null) {
            this.benchmark.stopTime("precompile", false);
            this.benchmark.startTime("postcompile");
        }
        int retVal = 0;
        if (this.data != null) {
            CompilerAPI.displayWarnings((List)this.data.units);
            if (this.data.linkChecksum != tempOEMConfiguration.cfgbuf.link_checksum_ts()) {
                retVal = Integer.MAX_VALUE;
            }
        } else {
            retVal = Integer.MAX_VALUE;
        }
        this.data.linkChecksum = tempOEMConfiguration.cfgbuf.link_checksum_ts();
        this.data.swcChecksum = swcContext.checksum();
        if (CompilerAPI.forcedToStop()) {
            retVal = -1;
        }
        if (this.benchmark != null) {
            this.benchmark.benchmark2("Ending active compile for " + this.getOutput(), true);
        }
        if (retVal == Integer.MAX_VALUE) {
            this.clean(false, false, false, false, false, true);
        } else {
            this.clean(false, false, false);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<CompilationUnit> compile(SubCompiler[] compilers, CompilerSwcContext swcContext, SymbolTable symbolTable, NameMappings nameMappings, Map licenseMap, Map<String, Source> classes, List<Source> sources) {
        List units = null;
        HashMap<String, VirtualFile> rbFiles = new HashMap<String, VirtualFile>();
        try {
            try {
                if (this.benchmark != null) {
                    for (int i = 0; i < compilers.length; ++i) {
                        compilers[i].initBenchmarks();
                    }
                    this.benchmark.stopTime("precompile", false);
                }
                units = CompilerAPI.compile((FileSpec)this.data.fileSpec, (SourceList)this.data.sourceList, classes.values(), (SourcePath)this.data.sourcePath, (ResourceContainer)this.data.resources, (ResourceBundlePath)this.data.bundlePath, (CompilerSwcContext)swcContext, (SymbolTable)symbolTable, (NameMappings)nameMappings, (flex2.compiler.common.Configuration)this.data.configuration, (SubCompiler[])compilers, (PreLink)new CompcPreLink(rbFiles, new ArrayList<String>(this.resourceBundles)), (Map)licenseMap, sources);
                if (this.benchmark != null) {
                    this.benchmark.startTime("postcompile");
                }
                if (this.benchmark != null && ThreadLocalToolkit.getLogger() != null) {
                    if (this.compilerBenchmarks == null) {
                        this.compilerBenchmarks = new HashMap();
                    }
                    this.compilerBenchmarks.clear();
                    flex2.compiler.Logger logger = ThreadLocalToolkit.getLogger();
                    for (int i = 0; i < compilers.length; ++i) {
                        SubCompiler compiler = compilers[i];
                        PerformanceData[] times = compiler.getBenchmarks();
                        if (times == null) continue;
                        compiler.logBenchmarks(logger);
                        String compilerName = compiler.getName();
                        this.compilerBenchmarks.put(compilerName, times);
                    }
                }
                Object var16_19 = null;
            }
            catch (LicenseException ex) {
                ThreadLocalToolkit.logError((String)ex.getMessage());
                Object var16_20 = null;
                this.data.sourcePath.clearCache();
                this.data.bundlePath.clearCache();
                this.data.resources.refresh();
                this.data.classes = classes;
                this.data.rbFiles = rbFiles;
                Map m = this.data.configuration.getCSSArchiveFiles();
                if (m != null) {
                    this.data.cssArchiveFiles = new HashMap<String, VirtualFile>(m);
                }
                if ((m = this.data.configuration.getL10NArchiveFiles()) != null) {
                    this.data.l10nArchiveFiles = new HashMap<String, VirtualFile>(m);
                }
                OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
                OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
                return units;
            }
            catch (CompilerException ex) {
                assert (ThreadLocalToolkit.errorCount() > 0);
                Object var16_21 = null;
                this.data.sourcePath.clearCache();
                this.data.bundlePath.clearCache();
                this.data.resources.refresh();
                this.data.classes = classes;
                this.data.rbFiles = rbFiles;
                Map m = this.data.configuration.getCSSArchiveFiles();
                if (m != null) {
                    this.data.cssArchiveFiles = new HashMap<String, VirtualFile>(m);
                }
                if ((m = this.data.configuration.getL10NArchiveFiles()) != null) {
                    this.data.l10nArchiveFiles = new HashMap<String, VirtualFile>(m);
                }
                OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
                OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
                return units;
            }
            catch (SwcException ex) {
                assert (ThreadLocalToolkit.errorCount() > 0);
                Object var16_22 = null;
                this.data.sourcePath.clearCache();
                this.data.bundlePath.clearCache();
                this.data.resources.refresh();
                this.data.classes = classes;
                this.data.rbFiles = rbFiles;
                Map m = this.data.configuration.getCSSArchiveFiles();
                if (m != null) {
                    this.data.cssArchiveFiles = new HashMap<String, VirtualFile>(m);
                }
                if ((m = this.data.configuration.getL10NArchiveFiles()) != null) {
                    this.data.l10nArchiveFiles = new HashMap<String, VirtualFile>(m);
                }
                OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
                OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
                return units;
            }
        }
        catch (Throwable throwable) {
            Object var16_23 = null;
            this.data.sourcePath.clearCache();
            this.data.bundlePath.clearCache();
            this.data.resources.refresh();
            this.data.classes = classes;
            this.data.rbFiles = rbFiles;
            Map m = this.data.configuration.getCSSArchiveFiles();
            if (m != null) {
                this.data.cssArchiveFiles = new HashMap<String, VirtualFile>(m);
            }
            if ((m = this.data.configuration.getL10NArchiveFiles()) != null) {
                this.data.l10nArchiveFiles = new HashMap<String, VirtualFile>(m);
            }
            OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
            OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
            throw throwable;
        }
        this.data.sourcePath.clearCache();
        this.data.bundlePath.clearCache();
        this.data.resources.refresh();
        this.data.classes = classes;
        this.data.rbFiles = rbFiles;
        Map m = this.data.configuration.getCSSArchiveFiles();
        if (m != null) {
            this.data.cssArchiveFiles = new HashMap<String, VirtualFile>(m);
        }
        if ((m = this.data.configuration.getL10NArchiveFiles()) != null) {
            this.data.l10nArchiveFiles = new HashMap<String, VirtualFile>(m);
        }
        OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
        OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
        return units;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long link(OutputStream out) throws IOException {
        if (this.data == null) return 0L;
        if (this.data.units == null) {
            return 0L;
        }
        boolean hasChanged = this.oemConfiguration == null ? false : this.oemConfiguration.hasChanged();
        flex2.compiler.common.Configuration config = null;
        if (hasChanged) {
            this.oemConfiguration = OEMUtil.getLinkerConfiguration(this.oemConfiguration.getLinkerOptions(), this.oemConfiguration.keepLinkReport(), OEMUtil.getLogger(this.logger, this.messages), this.mimeMappings, this.resolver, this.data.configuration, this.oemConfiguration.newLinkerOptionsAfterCompile, this.data.includes, this.data.excludes);
            if (this.oemConfiguration == null) {
                this.clean(false, false, false, false, false, true);
                return 0L;
            }
            config = this.oemConfiguration.configuration;
        } else {
            config = this.data.configuration;
        }
        if (config.benchmark()) {
            this.benchmark = CompilerAPI.runBenchmark();
            this.benchmark.setTimeFilter(config.getBenchmarkTimeFilter());
        } else {
            CompilerAPI.disableBenchmark();
        }
        try {
            try {
                OEMUtil.init(OEMUtil.getLogger(this.logger, this.messages), this.mimeMappings, this.meter, this.resolver, this.cc);
                SimpleMovie temp = this.data.movie;
                this.data.movie = SwcAPI.link((LinkerConfiguration)config, (List)this.data.units);
                SwcDirectoryArchive archive = null;
                TreeMap<String, VirtualFile> archiveFiles = new TreeMap<String, VirtualFile>();
                if (this.data.swcArchiveFiles != null) {
                    archiveFiles.putAll(this.data.swcArchiveFiles);
                }
                if (this.data.cssArchiveFiles != null) {
                    archiveFiles.putAll(this.data.cssArchiveFiles);
                }
                if (this.data.l10nArchiveFiles != null) {
                    archiveFiles.putAll(this.data.l10nArchiveFiles);
                }
                archiveFiles.putAll(this.files);
                if (this.directory != null) {
                    archive = new SwcDirectoryArchive(FileUtil.getCanonicalPath((File)this.directory));
                    SwcAPI.exportSwc((SwcArchive)archive, archiveFiles, this.stylesheets, (LinkerConfiguration)config, (SwcMovie)((SwcMovie)this.data.movie), new ArrayList<SwcComponent>(this.data.nsComponents), (SwcCache)this.data.swcCache, this.data.rbFiles);
                }
                long size = 0L;
                ByteArrayOutputStream baos = null;
                String path = null;
                if (this.output != null) {
                    path = FileUtil.getCanonicalPath((File)this.output);
                }
                if (out != null) {
                    baos = new ByteArrayOutputStream();
                    archive = new SwcDynamicArchive((OutputStream)baos, path);
                } else if (this.output != null) {
                    archive = new SwcDynamicArchive(path);
                }
                SwcAPI.exportSwc((SwcArchive)archive, archiveFiles, this.stylesheets, (LinkerConfiguration)config, (SwcMovie)((SwcMovie)this.data.movie), new ArrayList<SwcComponent>(this.data.nsComponents), (SwcCache)this.data.swcCache, this.data.rbFiles);
                if (out != null) {
                    ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
                    FileUtil.streamOutput((InputStream)in, (OutputStream)out);
                    size = baos.size();
                } else if (this.output != null) {
                    size = this.output.length();
                }
                if (hasChanged && temp != null) {
                    this.data.movie = temp;
                }
                long l = size;
                Object var14_18 = null;
                this.clean(false, false, false, true, false, true);
                return l;
            }
            catch (LinkerException ex) {
                assert (ThreadLocalToolkit.errorCount() > 0);
                long l = 0L;
                Object var14_19 = null;
                this.clean(false, false, false, true, false, true);
                return l;
            }
            catch (SwcException ex) {
                assert (ThreadLocalToolkit.errorCount() > 0);
                long l = 0L;
                Object var14_20 = null;
                this.clean(false, false, false, true, false, true);
                return l;
            }
            catch (Exception ex) {
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                ThreadLocalToolkit.logError((String)ex.getMessage());
                long l = 0L;
                Object var14_21 = null;
                this.clean(false, false, false, true, false, true);
                return l;
            }
        }
        catch (Throwable throwable) {
            Object var14_22 = null;
            this.clean(false, false, false, true, false, true);
            throw throwable;
        }
    }

    private void clean(boolean cleanData, boolean cleanCache, boolean cleanOutput) {
        this.clean(cleanData, cleanCache, cleanOutput, true, false, true);
    }

    private void clean(boolean cleanData, boolean cleanCache, boolean cleanOutput, boolean cleanConfig, boolean cleanMessages, boolean cleanThreadLocals) {
        if (cleanThreadLocals) {
            OEMUtil.clean();
        }
        if (this.oemConfiguration != null && cleanConfig) {
            this.oemConfiguration.reset();
        }
        if (cleanData) {
            this.data = null;
            this.configurationReport = null;
        }
        if (cleanCache && this.cacheName != null) {
            File dead = FileUtil.openFile((String)this.cacheName);
            if (dead != null && dead.exists()) {
                dead.delete();
            }
            this.cacheName = null;
        }
        if (cleanOutput && this.output != null && this.output.exists()) {
            this.output.delete();
        }
        if (cleanMessages) {
            this.messages.clear();
        }
    }

    private <T> boolean isDifferent(Collection<T> s1, Collection<T> s2) {
        Iterator<T> i = s2.iterator();
        while (i.hasNext()) {
            if (s1.contains(i.next())) continue;
            return true;
        }
        return s1.size() > s2.size();
    }

    private boolean isResourceBundleListDifferent() {
        int size1 = this.data == null || this.data.rbFiles == null ? 0 : this.data.rbFiles.size();
        int size2 = this.resourceBundles == null ? 0 : this.resourceBundles.size();
        return size1 != size2;
    }

    public LibraryCache getSwcCache() {
        return this.librarySwcCache;
    }

    @Override
    public void setSwcCache(LibraryCache swcCache) {
        this.librarySwcCache = swcCache;
    }

    public void refreshLastModified() {
        String fileName = FileUtil.getCanonicalPath((File)this.output);
        File file = new File(fileName);
        long lastModified = file.lastModified();
        this.data.swcCache.setLastModified(fileName, lastModified);
    }

    static {
        block2: {
            try {
                Class.forName("flex2.tools.oem.Application");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }
}

