/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem.internal;

import flash.util.FileUtils;
import flex2.compiler.API;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.ConfigurationException;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.VirtualFile;
import flex2.tools.ToolsConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ApplicationCompilerConfiguration
extends ToolsConfiguration {
    private List fileSpecs = new ArrayList();
    private String resourceModulePath;
    private boolean generateLinkReport;
    private List resourceBundles = new LinkedList();
    private VirtualFile configFile;
    private VirtualFile projector;

    public static Map getAliases() {
        HashMap map = new HashMap();
        map.putAll(Configuration.getAliases());
        map.remove("o");
        return map;
    }

    public void validate(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        super.validate(cfgbuf);
        String targetFile = this.getTargetFile();
        if (targetFile == null) {
            throw new ConfigurationException.MustSpecifyTarget(null, null, -1);
        }
        VirtualFile virt = this.getVirtualFile(targetFile);
        if (virt != null && this.getCompilerConfiguration().keepGeneratedActionScript()) {
            String dir = FileUtils.addPathComponents((String)virt.getParent(), (String)"generated", (char)File.separatorChar);
            this.getCompilerConfiguration().setGeneratedDirectory(FileUtils.canonicalPath((File)new File(dir)));
            File gd = new File(this.getCompilerConfiguration().getGeneratedDirectory());
            gd.mkdirs();
        }
    }

    private VirtualFile getVirtualFile(String file, ConfigurationValue cfgval) {
        try {
            return ConfigurationPathResolver.getVirtualFile((String)file, (ConfigurationPathResolver)this.configResolver, (ConfigurationValue)cfgval);
        }
        catch (ConfigurationException ex) {
            return null;
        }
    }

    private VirtualFile getVirtualFile(String targetFile) throws ConfigurationException {
        return API.getVirtualFile((String)targetFile, (boolean)false);
    }

    public List getFileSpecs() {
        return this.fileSpecs;
    }

    public void cfgFileSpecs(ConfigurationValue cv, List args) throws ConfigurationException {
        this.fileSpecs.addAll(args);
    }

    public static ConfigurationInfo getFileSpecsInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element"}){

            public boolean allowMultiple() {
                return true;
            }

            public boolean isHidden() {
                return true;
            }
        };
    }

    public String getTargetFile() {
        if (this.fileSpecs.size() == 0 && this.getIncludeResourceBundles().size() > 0) {
            if (this.resourceModulePath == null) {
                this.resourceModulePath = I18nUtils.getGeneratedResourceModule((ApplicationCompilerConfiguration)this).getPath();
            }
            return this.resourceModulePath;
        }
        return this.fileSpecs.size() > 0 ? (String)this.fileSpecs.get(this.fileSpecs.size() - 1) : null;
    }

    public boolean generateLinkReport() {
        return this.generateLinkReport;
    }

    public void keepLinkReport(boolean b) {
        this.generateLinkReport = b;
    }

    public List getIncludeResourceBundles() {
        return this.resourceBundles;
    }

    public void cfgIncludeResourceBundles(ConfigurationValue val, List includeResourceBundles) {
        this.resourceBundles.addAll(this.toQNameString(includeResourceBundles));
    }

    public static ConfigurationInfo getIncludeResourceBundlesInfo() {
        return new ConfigurationInfo(-1, new String[]{"bundle"}){

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public VirtualFile getLoadConfig() {
        return this.configFile;
    }

    public void cfgLoadConfig(ConfigurationValue cv, String filename) throws ConfigurationException {
        this.configFile = ConfigurationPathResolver.getVirtualFile((String)filename, (ConfigurationPathResolver)this.configResolver, (ConfigurationValue)cv);
    }

    public static ConfigurationInfo getLoadConfigInfo() {
        return new ConfigurationInfo(1, "filename"){

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public VirtualFile getProjector() {
        return this.projector;
    }

    public void cfgProjector(ConfigurationValue cfgval, String path) {
        this.projector = this.getVirtualFile(path, cfgval);
    }

    public static ConfigurationInfo getProjectorInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }
}

