/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

public class ScriptText {
    private final String m_text;
    private int[] m_lineMap;

    public ScriptText(String text) {
        this.m_text = text;
    }

    public String getLine(int lineNum) {
        this.determineLines();
        int index = lineNum - 1;
        if (index < 0) {
            // empty if block
        }
        int start = this.m_lineMap[2 * index];
        int end = this.m_lineMap[2 * index + 1];
        String s = this.m_text.substring(start, end);
        return s;
    }

    public int getLineCount() {
        this.determineLines();
        return this.m_lineMap.length / 2;
    }

    private synchronized void determineLines() {
        if (this.m_lineMap != null) {
            return;
        }
        int count = ScriptText.lineCountFor(this.m_text) + 1;
        this.m_lineMap = new int[2 * count + 1];
        int i = 0;
        int lineNum = 0;
        int startAt = 0;
        int endAt = 0;
        int length = this.m_text.length();
        char c = '\u0000';
        while (i < length) {
            if ((c = this.m_text.charAt(i++)) == '\n' || c == '\r') {
                this.m_lineMap[2 * lineNum] = startAt;
                this.m_lineMap[2 * lineNum + 1] = endAt;
                ++lineNum;
                if (c != '\r' || i >= length || this.m_text.charAt(i) == '\n') {
                    // empty if block
                }
                startAt = ++i;
                endAt = i;
                continue;
            }
            ++endAt;
        }
        if (startAt != endAt) {
            this.m_lineMap[2 * lineNum] = startAt;
            this.m_lineMap[2 * lineNum + 1] = endAt;
        }
    }

    public static int lineCountFor(String s) {
        int i = 0;
        int lineNum = 0;
        int length = s.length();
        char c = '\u0000';
        while (i < length) {
            if ((c = s.charAt(i++)) != '\n' && c != '\r') continue;
            ++lineNum;
            if (c != '\r' || i >= length || s.charAt(i) != '\n') continue;
            ++i;
        }
        return lineNum;
    }
}

