/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGImageElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.Viewport;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ImageNode;
import org.apache.batik.gvt.svg12.MultiResGraphicsNode;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SVGMultiImageElementBridge
extends SVGImageElementBridge {
    public String getNamespaceURI() {
        return "http://www.w3.org/2000/svg";
    }

    public String getLocalName() {
        return "multiImage";
    }

    public Bridge getInstance() {
        return new SVGImageElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        Object object;
        Dimension[] dimensionArray;
        Dimension[] dimensionArray2;
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return null;
        }
        ImageNode imageNode = (ImageNode)this.instantiateGraphicsNode();
        if (imageNode == null) {
            return null;
        }
        Rectangle2D rectangle2D = SVGMultiImageElementBridge.getImageBounds(bridgeContext, element);
        AffineTransform affineTransform = null;
        String string = element.getAttribute("transform");
        affineTransform = string.length() != 0 ? SVGUtilities.convertTransform(element, "transform", string) : new AffineTransform();
        affineTransform.translate(rectangle2D.getX(), rectangle2D.getY());
        imageNode.setTransform(affineTransform);
        imageNode.setVisible(CSSUtilities.convertVisibility(element));
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        Filter filter = imageNode.getGraphicsNodeRable(true);
        imageNode.setClip(new ClipRable8Bit(filter, double_));
        Rectangle2D rectangle2D2 = CSSUtilities.convertEnableBackground(element);
        if (rectangle2D2 != null) {
            imageNode.setBackgroundEnable(rectangle2D2);
        }
        bridgeContext.openViewport(element, new MultiImageElementViewport((float)rectangle2D.getWidth(), (float)rectangle2D.getHeight()));
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        LinkedList linkedList3 = new LinkedList();
        for (dimensionArray2 = element.getFirstChild(); dimensionArray2 != null; dimensionArray2 = dimensionArray2.getNextSibling()) {
            if (dimensionArray2.getNodeType() != 1) continue;
            dimensionArray = dimensionArray2;
            if (!this.getNamespaceURI().equals(dimensionArray.getNamespaceURI())) continue;
            if (dimensionArray.getLocalName().equals("subImage")) {
                this.addInfo((Element)dimensionArray, linkedList, linkedList2, linkedList3, rectangle2D);
            }
            if (!dimensionArray.getLocalName().equals("subImageRef")) continue;
            this.addRefInfo((Element)dimensionArray, linkedList, linkedList2, linkedList3, rectangle2D);
        }
        dimensionArray2 = new Dimension[linkedList.size()];
        dimensionArray = new Dimension[linkedList.size()];
        Element[] elementArray = new Element[linkedList.size()];
        Iterator iterator = linkedList2.iterator();
        Iterator iterator2 = linkedList3.iterator();
        Iterator iterator3 = linkedList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2;
            object = (Dimension)iterator.next();
            Dimension dimension = (Dimension)iterator2.next();
            if (object != null) {
                for (n2 = 0; n2 < n && (dimensionArray2[n2] == null || ((Dimension)object).width >= dimensionArray2[n2].width); ++n2) {
                }
            }
            for (int i = n; i > n2; --i) {
                elementArray[i] = elementArray[i - 1];
                dimensionArray2[i] = dimensionArray2[i - 1];
                dimensionArray[i] = dimensionArray[i - 1];
            }
            elementArray[n2] = (Element)iterator3.next();
            dimensionArray2[n2] = object;
            dimensionArray[n2] = dimension;
            ++n;
        }
        object = new MultiResGraphicsNode(element, double_, elementArray, dimensionArray2, dimensionArray, bridgeContext);
        imageNode.setImage((GraphicsNode)object);
        return imageNode;
    }

    public boolean isComposite() {
        return false;
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        this.initializeDynamicSupport(bridgeContext, element, graphicsNode);
        bridgeContext.closeViewport(element);
    }

    protected void initializeDynamicSupport(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        if (!bridgeContext.isInteractive()) {
            return;
        }
        ImageNode imageNode = (ImageNode)graphicsNode;
        bridgeContext.bind(element, imageNode.getImage());
        if (bridgeContext.isDynamic()) {
            this.e = element;
            this.node = graphicsNode;
            this.ctx = bridgeContext;
            ((SVGOMElement)element).setSVGContext(this);
        }
    }

    public void dispose() {
        this.ctx.removeViewport(this.e);
        super.dispose();
    }

    protected void addInfo(Element element, Collection collection, Collection collection2, Collection collection3, Rectangle2D rectangle2D) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            element2.setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getValue());
        }
        Node node = element.getFirstChild();
        while (node != null) {
            element2.appendChild(node);
            node = element.getFirstChild();
        }
        element.appendChild(element2);
        collection.add(element2);
        collection2.add(this.getElementMinPixel(element, rectangle2D));
        collection3.add(this.getElementMaxPixel(element, rectangle2D));
    }

    protected void addRefInfo(Element element, Collection collection, Collection collection2, Collection collection3, Rectangle2D rectangle2D) {
        String string = XLinkSupport.getXLinkHref(element);
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"xlink:href"});
        }
        String string2 = XMLBaseSupport.getCascadedXMLBase(element);
        ParsedURL parsedURL = string2 == null ? new ParsedURL(string) : new ParsedURL(string2, string);
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "image");
        element2.setAttributeNS("http://www.w3.org/1999/xlink", "href", parsedURL.toString());
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            element2.setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getValue());
        }
        String string3 = element.getAttribute("x");
        if (string3.length() == 0) {
            element2.setAttribute("x", "0");
        }
        if ((string3 = element.getAttribute("y")).length() == 0) {
            element2.setAttribute("y", "0");
        }
        if ((string3 = element.getAttribute("width")).length() == 0) {
            element2.setAttribute("width", "100%");
        }
        if ((string3 = element.getAttribute("height")).length() == 0) {
            element2.setAttribute("height", "100%");
        }
        element.appendChild(element2);
        collection.add(element2);
        collection2.add(this.getElementMinPixel(element, rectangle2D));
        collection3.add(this.getElementMaxPixel(element, rectangle2D));
    }

    protected Dimension getElementMinPixel(Element element, Rectangle2D rectangle2D) {
        return this.getElementPixelSize(element, "max-pixel-size", rectangle2D);
    }

    protected Dimension getElementMaxPixel(Element element, Rectangle2D rectangle2D) {
        return this.getElementPixelSize(element, "min-pixel-size", rectangle2D);
    }

    protected Dimension getElementPixelSize(Element element, String string, Rectangle2D rectangle2D) {
        float f;
        String string2 = element.getAttribute(string);
        if (string2.length() == 0) {
            return null;
        }
        Float[] floatArray = SVGUtilities.convertSVGNumberOptionalNumber(element, string, string2);
        if (floatArray[0] == null) {
            return null;
        }
        float f2 = f = floatArray[0].floatValue();
        if (floatArray[1] != null) {
            f2 = floatArray[1].floatValue();
        }
        return new Dimension((int)(rectangle2D.getWidth() / (double)f + 0.5), (int)(rectangle2D.getHeight() / (double)f2 + 0.5));
    }

    public static class MultiImageElementViewport
    implements Viewport {
        private float width;
        private float height;

        public MultiImageElementViewport(float f, float f2) {
            this.width = f;
            this.height = f2;
        }

        public float getWidth() {
            return this.width;
        }

        public float getHeight() {
            return this.height;
        }
    }
}

