/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.filechooser.FileSystemView;
import org.apache.batik.apps.svgbrowser.Resources;

class WindowsAltFileSystemView
extends FileSystemView {
    public static final String EXCEPTION_CONTAINING_DIR_NULL = "AltFileSystemView.exception.containing.dir.null";
    public static final String EXCEPTION_DIRECTORY_ALREADY_EXISTS = "AltFileSystemView.exception.directory.already.exists";
    public static final String NEW_FOLDER_NAME = " AltFileSystemView.new.folder.name";
    public static final String FLOPPY_DRIVE = "AltFileSystemView.floppy.drive";
    private static final Object[] noArgs = new Object[0];
    private static final Class[] noArgTypes = new Class[0];
    private static Method listRootsMethod = null;
    private static boolean listRootsMethodChecked = false;

    WindowsAltFileSystemView() {
    }

    public boolean isRoot(File f) {
        if (!f.isAbsolute()) {
            return false;
        }
        String parentPath = f.getParent();
        if (parentPath == null) {
            return true;
        }
        File parent = new File(parentPath);
        return parent.equals(f);
    }

    public File createNewFolder(File containingDir) throws IOException {
        if (containingDir == null) {
            throw new IOException(Resources.getString(EXCEPTION_CONTAINING_DIR_NULL));
        }
        File newFolder = null;
        newFolder = this.createFileObject(containingDir, Resources.getString(NEW_FOLDER_NAME));
        for (int i = 2; newFolder.exists() && i < 100; ++i) {
            newFolder = this.createFileObject(containingDir, Resources.getString(NEW_FOLDER_NAME) + " (" + i + ")");
        }
        if (newFolder.exists()) {
            throw new IOException(Resources.formatMessage(EXCEPTION_DIRECTORY_ALREADY_EXISTS, new Object[]{newFolder.getAbsolutePath()}));
        }
        newFolder.mkdirs();
        return newFolder;
    }

    public boolean isHiddenFile(File f) {
        return false;
    }

    public File[] getRoots() {
        Vector<FileSystemRoot> rootsVector = new Vector<FileSystemRoot>();
        FileSystemRoot floppy = new FileSystemRoot(Resources.getString(FLOPPY_DRIVE) + "\\");
        rootsVector.addElement(floppy);
        for (char c = 'C'; c <= 'Z'; c = (char)((char)(c + 1))) {
            char[] device = new char[]{c, ':', '\\'};
            String deviceName = new String(device);
            FileSystemRoot deviceFile = new FileSystemRoot(deviceName);
            if (deviceFile == null || !deviceFile.exists()) continue;
            rootsVector.addElement(deviceFile);
        }
        Object[] roots = new File[rootsVector.size()];
        rootsVector.copyInto(roots);
        return roots;
    }

    class FileSystemRoot
    extends File {
        public FileSystemRoot(File f) {
            super(f, "");
        }

        public FileSystemRoot(String s) {
            super(s);
        }

        public boolean isDirectory() {
            return true;
        }
    }
}

