/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.events;

import org.w3c.dom.events.EventListener;

public class EventListenerList {
    protected int n = 0;
    protected Entry first = null;
    protected EventListener[] listeners = null;

    public EventListener[] getEventListeners() {
        if (this.first == null) {
            return null;
        }
        if (this.listeners != null) {
            return this.listeners;
        }
        this.listeners = new EventListener[this.n];
        Entry current = this.first;
        for (int i = 0; i < this.n; ++i) {
            this.listeners[i] = current.listener;
            current = current.next;
        }
        return this.listeners;
    }

    public void add(EventListener listener) {
        this.first = new Entry(listener, this.first);
        this.listeners = null;
        ++this.n;
    }

    public void remove(EventListener listener) {
        if (this.first == null) {
            return;
        }
        if (this.first.listener == listener) {
            this.first = this.first.next;
            this.listeners = null;
            --this.n;
        } else {
            Entry prev = this.first;
            Entry e = this.first.next;
            while (e != null) {
                if (e.listener == listener) {
                    prev.next = e.next;
                    this.listeners = null;
                    --this.n;
                    break;
                }
                prev = e;
                e = e.next;
            }
        }
    }

    public boolean contains(EventListener listener) {
        Entry e = this.first;
        while (e != null) {
            if (listener == e.listener) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public int size() {
        return this.n;
    }

    protected static class Entry {
        EventListener listener;
        Entry next;

        public Entry(EventListener listener, Entry next) {
            this.listener = listener;
            this.next = next;
        }
    }
}

