/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.net.URL;
import org.apache.batik.css.engine.CSSImportedElementRoot;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.XMLConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLBaseSupport
implements XMLConstants {
    protected XMLBaseSupport() {
    }

    public static String getXMLBase(Element elt) {
        return elt.getAttributeNS("http://www.w3.org/XML/1998/namespace", "base");
    }

    public static String getCascadedXMLBase(Element elt) {
        Attr attr;
        SVGOMDocument svgDoc;
        URL url;
        String base = null;
        Node n = elt.getParentNode();
        while (n != null) {
            if (n.getNodeType() == 1) {
                base = XMLBaseSupport.getCascadedXMLBase((Element)n);
                break;
            }
            if (n instanceof CSSImportedElementRoot) {
                n = ((CSSImportedElementRoot)n).getCSSParentElement();
                continue;
            }
            n = n.getParentNode();
        }
        if (base == null && (url = (svgDoc = (SVGOMDocument)elt.getOwnerDocument()).getURLObject()) != null) {
            base = url.toString();
        }
        if ((attr = elt.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "base")) != null) {
            base = base == null ? attr.getNodeValue() : new ParsedURL(base, attr.getNodeValue()).toString();
        }
        return base;
    }
}

