/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFEncodeParam;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFField;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFImageEncoder;
import org.apache.batik.ext.awt.image.rendered.FormatRed;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;

public class TIFFTranscoder
extends ImageTranscoder {
    public static final TranscodingHints.Key KEY_FORCE_TRANSPARENT_WHITE = ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE;

    public TIFFTranscoder() {
        this.hints.put(KEY_FORCE_TRANSPARENT_WHITE, Boolean.FALSE);
    }

    public BufferedImage createImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    public void writeImage(BufferedImage img, TranscoderOutput output) throws TranscoderException {
        OutputStream ostream = output.getOutputStream();
        if (ostream == null) {
            throw new TranscoderException(Messages.formatMessage("tiff.badoutput", null));
        }
        TIFFEncodeParam params = new TIFFEncodeParam();
        float PixSzMM = this.userAgent.getPixelUnitToMillimeter();
        int numPix = (int)((double)(100000.0f / PixSzMM) + 0.5);
        int denom = 10000;
        long[] rational = new long[]{numPix, denom};
        TIFFField[] fields = new TIFFField[]{new TIFFField(296, 3, 1, new char[]{'\u0003'}), new TIFFField(282, 5, 1, new long[][]{rational}), new TIFFField(283, 5, 1, new long[][]{rational})};
        params.setExtraFields(fields);
        boolean forceTransparentWhite = false;
        if (this.hints.containsKey(KEY_FORCE_TRANSPARENT_WHITE)) {
            forceTransparentWhite = (Boolean)this.hints.get(KEY_FORCE_TRANSPARENT_WHITE);
        }
        int w = img.getWidth();
        int h = img.getHeight();
        SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)img.getSampleModel();
        if (forceTransparentWhite) {
            DataBufferInt biDB = (DataBufferInt)img.getRaster().getDataBuffer();
            int scanStride = sppsm.getScanlineStride();
            int dbOffset = biDB.getOffset();
            int[] pixels = biDB.getBankData()[0];
            int p = dbOffset;
            int adjust = scanStride - w;
            int a = 0;
            int r = 0;
            int g = 0;
            int b = 0;
            int pel = 0;
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    pel = pixels[p];
                    a = pel >> 24 & 0xFF;
                    r = pel >> 16 & 0xFF;
                    g = pel >> 8 & 0xFF;
                    b = pel & 0xFF;
                    r = (255 * (255 - a) + a * r) / 255;
                    g = (255 * (255 - a) + a * g) / 255;
                    b = (255 * (255 - a) + a * b) / 255;
                    pixels[p++] = a << 24 & 0xFF000000 | r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF;
                }
                p += adjust;
            }
        }
        try {
            TIFFImageEncoder tiffEncoder = new TIFFImageEncoder(ostream, params);
            int bands = sppsm.getNumBands();
            int[] off = new int[bands];
            for (int i = 0; i < bands; ++i) {
                off[i] = i;
            }
            PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(0, w, h, bands, w * bands, off);
            FormatRed rimg = new FormatRed(GraphicsUtil.wrap(img), sm);
            tiffEncoder.encode(rimg);
        }
        catch (IOException ex) {
            throw new TranscoderException(ex);
        }
    }
}

