/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.apache.batik.script.rhino.RhinoClassLoader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;

public class BatikSecurityController
extends SecurityController {
    public GeneratedClassLoader createClassLoader(ClassLoader parentLoader, Object securityDomain) {
        if (securityDomain instanceof RhinoClassLoader) {
            return (RhinoClassLoader)securityDomain;
        }
        throw new SecurityException("Script() objects are not supported");
    }

    public Object getDynamicSecurityDomain(Object securityDomain) {
        RhinoClassLoader loader = (RhinoClassLoader)securityDomain;
        if (loader != null) {
            return loader;
        }
        return AccessController.getContext();
    }

    public Object execWithDomain(final Context cx, final Scriptable scope, final Script script, Object securityDomain) throws JavaScriptException {
        AccessControlContext acc;
        if (securityDomain instanceof AccessControlContext) {
            acc = (AccessControlContext)securityDomain;
        } else {
            RhinoClassLoader loader = (RhinoClassLoader)securityDomain;
            acc = loader.rhinoAccessControlContext;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws JavaScriptException {
                    return script.exec(cx, scope);
                }
            }, acc);
        }
        catch (Exception e) {
            throw new JavaScriptException((Object)e);
        }
    }
}

