/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.GraphicsEnvironment;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.batik.gvt.font.AWTFontFamily;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.UnresolvedFontFamily;

public class FontFamilyResolver {
    public static final AWTFontFamily defaultFont = new AWTFontFamily("SansSerif");
    protected static final Map fonts = new HashMap();
    protected static final Vector awtFontFamilies = new Vector();
    protected static final Vector awtFonts = new Vector();
    protected static Map resolvedFontFamilies;

    public static String lookup(String familyName) {
        return (String)fonts.get(familyName.toLowerCase());
    }

    public static GVTFontFamily resolve(String familyName) {
        GVTFontFamily resolvedFF;
        if (resolvedFontFamilies == null) {
            resolvedFontFamilies = new HashMap();
        }
        if ((resolvedFF = (GVTFontFamily)resolvedFontFamilies.get(familyName.toLowerCase())) == null) {
            String awtFamilyName = (String)fonts.get(familyName.toLowerCase());
            if (awtFamilyName != null) {
                resolvedFF = new AWTFontFamily(awtFamilyName);
            }
            resolvedFontFamilies.put(familyName.toLowerCase(), resolvedFF);
        }
        return resolvedFF;
    }

    public static GVTFontFamily resolve(UnresolvedFontFamily fontFamily) {
        return FontFamilyResolver.resolve(fontFamily.getFamilyName());
    }

    public static GVTFontFamily getFamilyThatCanDisplay(char c) {
        for (int i = 0; i < awtFontFamilies.size(); ++i) {
            AWTFontFamily fontFamily = (AWTFontFamily)awtFontFamilies.get(i);
            AWTGVTFont font = (AWTGVTFont)awtFonts.get(i);
            if (!font.canDisplay(c) || fontFamily.getFamilyName().indexOf("Song") != -1) continue;
            return fontFamily;
        }
        return null;
    }

    static {
        fonts.put("sans-serif", "SansSerif");
        fonts.put("serif", "Serif");
        fonts.put("times", "Serif");
        fonts.put("times new roman", "Serif");
        fonts.put("cursive", "Dialog");
        fonts.put("fantasy", "Symbol");
        fonts.put("monospace", "Monospaced");
        fonts.put("monospaced", "Monospaced");
        fonts.put("courier", "Monospaced");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = env.getAvailableFontFamilyNames();
        int nFonts = fontNames != null ? fontNames.length : 0;
        for (int i = 0; i < nFonts; ++i) {
            fonts.put(fontNames[i].toLowerCase(), fontNames[i]);
            StringTokenizer st = new StringTokenizer(fontNames[i]);
            String fontNameWithoutSpaces = "";
            while (st.hasMoreTokens()) {
                fontNameWithoutSpaces = fontNameWithoutSpaces + st.nextToken();
            }
            fonts.put(fontNameWithoutSpaces.toLowerCase(), fontNames[i]);
            String fontNameWithDashes = fontNames[i].replace(' ', '-');
            if (fontNameWithDashes.equals(fontNames[i])) continue;
            fonts.put(fontNameWithDashes.toLowerCase(), fontNames[i]);
        }
        awtFontFamilies.add(defaultFont);
        awtFonts.add(new AWTGVTFont(defaultFont.getFamilyName(), 0, 12));
        Collection fontValues = fonts.values();
        Iterator iter = fontValues.iterator();
        while (iter.hasNext()) {
            String fontFamily = (String)iter.next();
            AWTFontFamily awtFontFamily = new AWTFontFamily(fontFamily);
            awtFontFamilies.add(awtFontFamily);
            AWTGVTFont font = new AWTGVTFont(fontFamily, 0, 12);
            awtFonts.add(font);
        }
    }
}

