/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.batik.script.rhino.RhinoInterpreter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

class EventTargetWrapper
extends NativeJavaObject {
    private static WeakHashMap mapOfListenerMap;
    private static final String ADD_NAME = "addEventListener";
    private static final String REMOVE_NAME = "removeEventListener";
    private static final Class[] ARGS_TYPE;
    private static final String NAME = "name";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$mozilla$javascript$Function;
    static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;
    static /* synthetic */ Class class$org$w3c$dom$events$EventListener;

    EventTargetWrapper(Scriptable scope, EventTarget object) {
        super(scope, (Object)object, null);
    }

    public Object get(String name, Scriptable start) {
        Object method = super.get(name, start);
        if (name.equals(ADD_NAME)) {
            method = new FunctionAddProxy((Function)method, this.initMap());
        }
        if (name.equals(REMOVE_NAME)) {
            method = new FunctionRemoveProxy((Function)method, this.initMap());
        }
        return method;
    }

    public Map initMap() {
        WeakHashMap map = null;
        if (mapOfListenerMap == null) {
            mapOfListenerMap = new WeakHashMap(10);
        }
        if ((map = (WeakHashMap)mapOfListenerMap.get(this.unwrap())) == null) {
            map = new WeakHashMap(2);
            mapOfListenerMap.put(this.unwrap(), map);
        }
        return map;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ARGS_TYPE = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$w3c$dom$events$EventListener == null ? (class$org$w3c$dom$events$EventListener = EventTargetWrapper.class$("org.w3c.dom.events.EventListener")) : class$org$w3c$dom$events$EventListener, Boolean.TYPE};
    }

    static class FunctionRemoveProxy
    extends FunctionProxy {
        private Map listenerMap;

        FunctionRemoveProxy(Function delegate, Map listenerMap) {
            super(delegate);
            this.listenerMap = listenerMap;
        }

        public Object call(Context ctx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
            NativeJavaObject njo = (NativeJavaObject)thisObj;
            if (args[1] instanceof Function) {
                SoftReference sr = (SoftReference)this.listenerMap.get(args[1]);
                if (sr == null) {
                    return Undefined.instance;
                }
                EventListener el = (EventListener)sr.get();
                if (el == null) {
                    return Undefined.instance;
                }
                Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = EventTargetWrapper.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function, Boolean.TYPE};
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Context.toType((Object)args[i], (Class)paramTypes[i]);
                }
                ((EventTarget)njo.unwrap()).removeEventListener((String)args[0], el, (Boolean)args[2]);
                return Undefined.instance;
            }
            if (args[1] instanceof NativeObject) {
                SoftReference sr = (SoftReference)this.listenerMap.get(args[1]);
                if (sr == null) {
                    return Undefined.instance;
                }
                EventListener el = (EventListener)sr.get();
                if (el == null) {
                    return Undefined.instance;
                }
                Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = EventTargetWrapper.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable, Boolean.TYPE};
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Context.toType((Object)args[i], (Class)paramTypes[i]);
                }
                ((EventTarget)njo.unwrap()).removeEventListener((String)args[0], el, (Boolean)args[2]);
                return Undefined.instance;
            }
            return this.delegate.call(ctx, scope, thisObj, args);
        }
    }

    static class FunctionAddProxy
    extends FunctionProxy {
        private Map listenerMap;

        FunctionAddProxy(Function delegate, Map listenerMap) {
            super(delegate);
            this.listenerMap = listenerMap;
        }

        public Object call(Context ctx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
            NativeJavaObject njo = (NativeJavaObject)thisObj;
            if (args[1] instanceof Function) {
                FunctionEventListener evtListener = new FunctionEventListener((Function)args[1], ((RhinoInterpreter.ExtendedContext)ctx).getInterpreter());
                this.listenerMap.put(args[1], new SoftReference<FunctionEventListener>(evtListener));
                Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = EventTargetWrapper.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function, Boolean.TYPE};
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Context.toType((Object)args[i], (Class)paramTypes[i]);
                }
                ((EventTarget)njo.unwrap()).addEventListener((String)args[0], evtListener, (Boolean)args[2]);
                return Undefined.instance;
            }
            if (args[1] instanceof NativeObject) {
                HandleEventListener evtListener = new HandleEventListener((Scriptable)args[1], ((RhinoInterpreter.ExtendedContext)ctx).getInterpreter());
                this.listenerMap.put(args[1], new SoftReference<HandleEventListener>(evtListener));
                Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventTargetWrapper.class$("java.lang.String")) : class$java$lang$String, class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = EventTargetWrapper.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable, Boolean.TYPE};
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Context.toType((Object)args[i], (Class)paramTypes[i]);
                }
                ((EventTarget)njo.unwrap()).addEventListener((String)args[0], evtListener, (Boolean)args[2]);
                return Undefined.instance;
            }
            return this.delegate.call(ctx, scope, thisObj, args);
        }
    }

    static abstract class FunctionProxy
    implements Function {
        protected Function delegate;

        public FunctionProxy(Function delegate) {
            this.delegate = delegate;
        }

        public Scriptable construct(Context cx, Scriptable scope, Object[] args) throws JavaScriptException {
            return this.delegate.construct(cx, scope, args);
        }

        public String getClassName() {
            return this.delegate.getClassName();
        }

        public Object get(String name, Scriptable start) {
            return this.delegate.get(name, start);
        }

        public Object get(int index, Scriptable start) {
            return this.delegate.get(index, start);
        }

        public boolean has(String name, Scriptable start) {
            return this.delegate.has(name, start);
        }

        public boolean has(int index, Scriptable start) {
            return this.delegate.has(index, start);
        }

        public void put(String name, Scriptable start, Object value) {
            this.delegate.put(name, start, value);
        }

        public void put(int index, Scriptable start, Object value) {
            this.delegate.put(index, start, value);
        }

        public void delete(String name) {
            this.delegate.delete(name);
        }

        public void delete(int index) {
            this.delegate.delete(index);
        }

        public Scriptable getPrototype() {
            return this.delegate.getPrototype();
        }

        public void setPrototype(Scriptable prototype) {
            this.delegate.setPrototype(prototype);
        }

        public Scriptable getParentScope() {
            return this.delegate.getParentScope();
        }

        public void setParentScope(Scriptable parent) {
            this.delegate.setParentScope(parent);
        }

        public Object[] getIds() {
            return this.delegate.getIds();
        }

        public Object getDefaultValue(Class hint) {
            return this.delegate.getDefaultValue(hint);
        }

        public boolean hasInstance(Scriptable instance) {
            return this.delegate.hasInstance(instance);
        }
    }

    static class HandleEventListener
    implements EventListener {
        private static final String HANDLE_EVENT = "handleEvent";
        private Scriptable scriptable;
        private Object[] array = new Object[1];
        private RhinoInterpreter interpreter;

        HandleEventListener(Scriptable s, RhinoInterpreter interpreter) {
            this.scriptable = s;
            this.interpreter = interpreter;
        }

        public void handleEvent(Event evt) {
            try {
                this.array[0] = evt;
                this.interpreter.enterContext();
                ScriptableObject.callMethod((Scriptable)this.scriptable, (String)HANDLE_EVENT, (Object[])this.array);
            }
            catch (JavaScriptException e) {
                throw new WrappedException((Throwable)e);
            }
            finally {
                Context.exit();
            }
        }
    }

    static class FunctionEventListener
    implements EventListener {
        private Function function;
        private RhinoInterpreter interpreter;

        FunctionEventListener(Function f, RhinoInterpreter i) {
            this.function = f;
            this.interpreter = i;
        }

        public void handleEvent(Event evt) {
            try {
                this.interpreter.callHandler(this.function, evt);
            }
            catch (JavaScriptException e) {
                throw new WrappedException((Throwable)e);
            }
        }
    }
}

