/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.batik.bridge.BaseScriptingEnvironment;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.Messages;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.ScriptingEnvironment;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.Window;
import org.apache.batik.util.EncodingUtilities;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.RunnableQueue;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGDocument;

public class ScriptingEnvironment
extends BaseScriptingEnvironment {
    protected static final String FRAGMENT_PREFIX = "<svg xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink'>";
    protected static final String FRAGMENT_SUFFIX = "</svg>";
    public static final String[] SVG_EVENT_ATTRS = new String[]{"onabort", "onerror", "onresize", "onscroll", "onunload", "onzoom", "onbegin", "onend", "onrepeat", "onfocusin", "onfocusout", "onactivate", "onclick", "onmousedown", "onmouseup", "onmouseover", "onmouseout", "onmousemove", "onkeypress", "onkeydown", "onkeyup"};
    public static final String[] SVG_DOM_EVENT = new String[]{"SVGAbort", "SVGError", "SVGResize", "SVGScroll", "SVGUnload", "SVGZoom", "beginEvent", "endEvent", "repeatEvent", "DOMFocusIn", "DOMFocusOut", "DOMActivate", "click", "mousedown", "mouseup", "mouseover", "mouseout", "mousemove", "keypress", "keydown", "keyup"};
    protected Timer timer = new Timer(true);
    protected UpdateManager updateManager;
    protected RunnableQueue updateRunnableQueue;
    protected EventListener domNodeInsertedListener = new DOMNodeInsertedListener();
    protected EventListener domNodeRemovedListener = new DOMNodeRemovedListener();
    protected EventListener domAttrModifiedListener = new DOMAttrModifiedListener();
    protected EventListener svgAbortListener = new ScriptingEventListener("onabort");
    protected EventListener svgErrorListener = new ScriptingEventListener("onerror");
    protected EventListener svgResizeListener = new ScriptingEventListener("onresize");
    protected EventListener svgScrollListener = new ScriptingEventListener("onscroll");
    protected EventListener svgUnloadListener = new ScriptingEventListener("onunload");
    protected EventListener svgZoomListener = new ScriptingEventListener("onzoom");
    protected EventListener beginListener = new ScriptingEventListener("onbegin");
    protected EventListener endListener = new ScriptingEventListener("onend");
    protected EventListener repeatListener = new ScriptingEventListener("onrepeat");
    protected EventListener focusinListener = new ScriptingEventListener("onfocusin");
    protected EventListener focusoutListener = new ScriptingEventListener("onfocusout");
    protected EventListener activateListener = new ScriptingEventListener("onactivate");
    protected EventListener clickListener = new ScriptingEventListener("onclick");
    protected EventListener mousedownListener = new ScriptingEventListener("onmousedown");
    protected EventListener mouseupListener = new ScriptingEventListener("onmouseup");
    protected EventListener mouseoverListener = new ScriptingEventListener("onmouseover");
    protected EventListener mouseoutListener = new ScriptingEventListener("onmouseout");
    protected EventListener mousemoveListener = new ScriptingEventListener("onmousemove");
    protected EventListener keypressListener = new ScriptingEventListener("onkeypress");
    protected EventListener keydownListener = new ScriptingEventListener("onkeydown");
    protected EventListener keyupListener = new ScriptingEventListener("onkeyup");
    protected EventListener[] listeners = new EventListener[]{this.svgAbortListener, this.svgErrorListener, this.svgResizeListener, this.svgScrollListener, this.svgUnloadListener, this.svgZoomListener, this.beginListener, this.endListener, this.repeatListener, this.focusinListener, this.focusoutListener, this.activateListener, this.clickListener, this.mousedownListener, this.mouseupListener, this.mouseoverListener, this.mouseoutListener, this.mousemoveListener, this.keypressListener, this.keydownListener, this.keyupListener};
    Map attrToDOMEvent = new HashMap(SVG_EVENT_ATTRS.length);
    Map attrToListener = new HashMap(SVG_EVENT_ATTRS.length);

    public ScriptingEnvironment(BridgeContext ctx) {
        super(ctx);
        for (int i = 0; i < SVG_EVENT_ATTRS.length; ++i) {
            this.attrToDOMEvent.put(SVG_EVENT_ATTRS[i], SVG_DOM_EVENT[i]);
            this.attrToListener.put(SVG_EVENT_ATTRS[i], this.listeners[i]);
        }
        this.updateManager = ctx.getUpdateManager();
        this.updateRunnableQueue = this.updateManager.getUpdateRunnableQueue();
        this.addScriptingListeners(this.document.getDocumentElement());
        EventTarget et = (EventTarget)((Object)this.document);
        et.addEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
        et.addEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
        et.addEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
    }

    public org.apache.batik.script.Window createWindow(Interpreter interp, String lang) {
        return new Window(interp, lang);
    }

    public void runEventHandler(String script, Event evt, String lang, String desc) {
        Interpreter interpreter = this.getInterpreter(lang);
        if (interpreter == null) {
            return;
        }
        try {
            this.checkCompatibleScriptURL(lang, this.docPURL);
            interpreter.bindObject("event", evt);
            interpreter.bindObject("evt", evt);
            interpreter.evaluate(new StringReader(script), desc);
        }
        catch (IOException ioe) {
        }
        catch (InterpreterException ie) {
            this.handleInterpreterException(ie);
        }
        catch (SecurityException se) {
            this.handleSecurityException(se);
        }
    }

    public void interrupt() {
        this.timer.cancel();
        this.removeScriptingListeners(this.document.getDocumentElement());
        EventTarget et = (EventTarget)((Object)this.document);
        et.removeEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
        et.removeEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
        et.removeEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
    }

    protected void addScriptingListeners(Node node) {
        if (node.getNodeType() == 1) {
            Element elt = (Element)node;
            EventTarget target = (EventTarget)((Object)elt);
            if ("http://www.w3.org/2000/svg".equals(elt.getNamespaceURI())) {
                if ("svg".equals(elt.getLocalName())) {
                    if (elt.hasAttributeNS(null, "onabort")) {
                        target.addEventListener("SVGAbort", this.svgAbortListener, false);
                    }
                    if (elt.hasAttributeNS(null, "onerror")) {
                        target.addEventListener("SVGError", this.svgErrorListener, false);
                    }
                    if (elt.hasAttributeNS(null, "onresize")) {
                        target.addEventListener("SVGResize", this.svgResizeListener, false);
                    }
                    if (elt.hasAttributeNS(null, "onscroll")) {
                        target.addEventListener("SVGScroll", this.svgScrollListener, false);
                    }
                    if (elt.hasAttributeNS(null, "onunload")) {
                        target.addEventListener("SVGUnload", this.svgUnloadListener, false);
                    }
                    if (elt.hasAttributeNS(null, "onzoom")) {
                        target.addEventListener("SVGZoom", this.svgZoomListener, false);
                    }
                } else {
                    String name = elt.getLocalName();
                    if (name.equals("set") || name.startsWith("animate")) {
                        if (elt.hasAttributeNS(null, "onbegin")) {
                            target.addEventListener("beginEvent", this.beginListener, false);
                        }
                        if (elt.hasAttributeNS(null, "onend")) {
                            target.addEventListener("endEvent", this.endListener, false);
                        }
                        if (elt.hasAttributeNS(null, "onrepeat")) {
                            target.addEventListener("repeatEvent", this.repeatListener, false);
                        }
                        return;
                    }
                }
            }
            if (elt.hasAttributeNS(null, "onfocusin")) {
                target.addEventListener("DOMFocusIn", this.focusinListener, false);
            }
            if (elt.hasAttributeNS(null, "onfocusout")) {
                target.addEventListener("DOMFocusOut", this.focusoutListener, false);
            }
            if (elt.hasAttributeNS(null, "onactivate")) {
                target.addEventListener("DOMActivate", this.activateListener, false);
            }
            if (elt.hasAttributeNS(null, "onclick")) {
                target.addEventListener("click", this.clickListener, false);
            }
            if (elt.hasAttributeNS(null, "onmousedown")) {
                target.addEventListener("mousedown", this.mousedownListener, false);
            }
            if (elt.hasAttributeNS(null, "onmouseup")) {
                target.addEventListener("mouseup", this.mouseupListener, false);
            }
            if (elt.hasAttributeNS(null, "onmouseover")) {
                target.addEventListener("mouseover", this.mouseoverListener, false);
            }
            if (elt.hasAttributeNS(null, "onmouseout")) {
                target.addEventListener("mouseout", this.mouseoutListener, false);
            }
            if (elt.hasAttributeNS(null, "onmousemove")) {
                target.addEventListener("mousemove", this.mousemoveListener, false);
            }
            if (elt.hasAttributeNS(null, "onkeypress")) {
                target.addEventListener("keypress", this.keypressListener, false);
            }
            if (elt.hasAttributeNS(null, "onkeydown")) {
                target.addEventListener("keydown", this.keydownListener, false);
            }
            if (elt.hasAttributeNS(null, "onkeyup")) {
                target.addEventListener("keyup", this.keyupListener, false);
            }
        }
        for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            this.addScriptingListeners(n);
        }
    }

    protected void removeScriptingListeners(Node node) {
        if (node.getNodeType() == 1) {
            Element elt = (Element)node;
            EventTarget target = (EventTarget)((Object)elt);
            if ("http://www.w3.org/2000/svg".equals(elt.getNamespaceURI())) {
                if ("svg".equals(elt.getLocalName())) {
                    target.removeEventListener("SVGAbort", this.svgAbortListener, false);
                    target.removeEventListener("SVGError", this.svgErrorListener, false);
                    target.removeEventListener("SVGResize", this.svgResizeListener, false);
                    target.removeEventListener("SVGScroll", this.svgScrollListener, false);
                    target.removeEventListener("SVGUnload", this.svgUnloadListener, false);
                    target.removeEventListener("SVGZoom", this.svgZoomListener, false);
                } else {
                    String name = elt.getLocalName();
                    if (name.equals("set") || name.startsWith("animate")) {
                        target.removeEventListener("beginEvent", this.beginListener, false);
                        target.removeEventListener("endEvent", this.endListener, false);
                        target.removeEventListener("repeatEvent", this.repeatListener, false);
                        return;
                    }
                }
            }
            target.removeEventListener("DOMFocusIn", this.focusinListener, false);
            target.removeEventListener("DOMFocusOut", this.focusoutListener, false);
            target.removeEventListener("DOMActivate", this.activateListener, false);
            target.removeEventListener("click", this.clickListener, false);
            target.removeEventListener("mousedown", this.mousedownListener, false);
            target.removeEventListener("mouseup", this.mouseupListener, false);
            target.removeEventListener("mouseover", this.mouseoverListener, false);
            target.removeEventListener("mouseout", this.mouseoutListener, false);
            target.removeEventListener("mousemove", this.mousemoveListener, false);
            target.removeEventListener("keypress", this.keypressListener, false);
            target.removeEventListener("keydown", this.keydownListener, false);
            target.removeEventListener("keyup", this.keyupListener, false);
        }
        for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            this.removeScriptingListeners(n);
        }
    }

    protected void updateScriptingListeners(Element elt, String attr) {
        String domEvt = (String)this.attrToDOMEvent.get(attr);
        if (domEvt == null) {
            return;
        }
        EventListener listener = (EventListener)this.attrToListener.get(attr);
        EventTarget target = (EventTarget)((Object)elt);
        if (elt.hasAttributeNS(null, attr)) {
            target.addEventListener(domEvt, listener, false);
        } else {
            target.removeEventListener(domEvt, listener, false);
        }
    }

    protected class ScriptingEventListener
    implements EventListener {
        protected String attribute;

        public ScriptingEventListener(String attr) {
            this.attribute = attr;
        }

        public void handleEvent(Event evt) {
            Element elt = (Element)((Object)evt.getCurrentTarget());
            String script = elt.getAttributeNS(null, this.attribute);
            if (script.length() == 0) {
                return;
            }
            DocumentLoader dl = ScriptingEnvironment.this.bridgeContext.getDocumentLoader();
            SVGDocument d = (SVGDocument)elt.getOwnerDocument();
            int line = dl.getLineNumber(elt);
            String desc = Messages.formatMessage("BaseScriptingEnvironment.constant.event.script.description", new Object[]{d.getURL(), this.attribute, new Integer(line)});
            Element e = elt;
            while (!(e == null || "http://www.w3.org/2000/svg".equals(e.getNamespaceURI()) && "svg".equals(e.getLocalName()))) {
                e = SVGUtilities.getParentElement(e);
            }
            if (e == null) {
                return;
            }
            String lang = e.getAttributeNS(null, "contentScriptType");
            ScriptingEnvironment.this.runEventHandler(script, evt, lang, desc);
        }
    }

    protected class DOMAttrModifiedListener
    implements EventListener {
        protected DOMAttrModifiedListener() {
        }

        public void handleEvent(Event evt) {
            MutationEvent me = (MutationEvent)evt;
            if (me.getAttrChange() != 1) {
                ScriptingEnvironment.this.updateScriptingListeners((Element)((Object)me.getTarget()), me.getAttrName());
            }
        }
    }

    protected class DOMNodeRemovedListener
    implements EventListener {
        protected DOMNodeRemovedListener() {
        }

        public void handleEvent(Event evt) {
            ScriptingEnvironment.this.removeScriptingListeners((Node)((Object)evt.getTarget()));
        }
    }

    protected class DOMNodeInsertedListener
    implements EventListener {
        protected DOMNodeInsertedListener() {
        }

        public void handleEvent(Event evt) {
            ScriptingEnvironment.this.addScriptingListeners((Node)((Object)evt.getTarget()));
        }
    }

    protected class Window
    implements org.apache.batik.script.Window {
        protected Interpreter interpreter;
        protected String language;
        static final String DEFLATE = "deflate";
        static final String GZIP = "gzip";
        static final String UTF_8 = "UTF-8";

        public Window(Interpreter interp, String lang) {
            this.interpreter = interp;
            this.language = lang;
        }

        public Object setInterval(String script, long interval) {
            TimerTask tt = new TimerTask(this, script){
                EvaluateIntervalRunnable eir;
                private final /* synthetic */ String val$script;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = this$1;
                    this.val$script = val$script;
                    this.eir = Window.access$000(this.this$1).new EvaluateIntervalRunnable(this.val$script, this.this$1.interpreter);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = this.eir;
                    synchronized (object) {
                        if (this.eir.count > 1) {
                            return;
                        }
                        ++this.eir.count;
                    }
                    object = Window.access$000((Window)this.this$1).updateRunnableQueue.getIteratorLock();
                    synchronized (object) {
                        if (Window.access$000((Window)this.this$1).updateRunnableQueue.getThread() == null) {
                            this.cancel();
                            return;
                        }
                        Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(this.eir);
                    }
                    object = this.eir;
                    synchronized (object) {
                        if (this.eir.error) {
                            this.cancel();
                        }
                    }
                }
            };
            ScriptingEnvironment.this.timer.schedule(tt, interval, interval);
            return tt;
        }

        public Object setInterval(Runnable r, long interval) {
            TimerTask tt = new TimerTask(this, r){
                EvaluateRunnableRunnable eihr;
                private final /* synthetic */ Runnable val$r;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = this$1;
                    this.val$r = val$r;
                    this.eihr = Window.access$000(this.this$1).new EvaluateRunnableRunnable(this.val$r);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    EvaluateRunnableRunnable evaluateRunnableRunnable = this.eihr;
                    synchronized (evaluateRunnableRunnable) {
                        if (this.eihr.count > 1) {
                            return;
                        }
                        ++this.eihr.count;
                    }
                    Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(this.eihr);
                    evaluateRunnableRunnable = this.eihr;
                    synchronized (evaluateRunnableRunnable) {
                        if (this.eihr.error) {
                            this.cancel();
                        }
                    }
                }
            };
            ScriptingEnvironment.this.timer.schedule(tt, interval, interval);
            return tt;
        }

        public void clearInterval(Object interval) {
            if (interval == null) {
                return;
            }
            ((TimerTask)interval).cancel();
        }

        public Object setTimeout(String script, long timeout) {
            TimerTask tt = new TimerTask(this, script){
                private final /* synthetic */ String val$script;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = this$1;
                    this.val$script = val$script;
                }

                public void run() {
                    Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(Window.access$000(this.this$1).new EvaluateRunnable(this.val$script, this.this$1.interpreter));
                }
            };
            ScriptingEnvironment.this.timer.schedule(tt, timeout);
            return tt;
        }

        public Object setTimeout(Runnable r, long timeout) {
            TimerTask tt = new TimerTask(this, r){
                private final /* synthetic */ Runnable val$r;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = this$1;
                    this.val$r = val$r;
                }

                public void run() {
                    Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this){
                        private final /* synthetic */ 4 this$2;
                        {
                            this.this$2 = this$2;
                        }

                        public void run() {
                            block2: {
                                try {
                                    4.access$100(this.this$2).run();
                                }
                                catch (Exception e) {
                                    if (Window.access$000((Window)4.access$200(this.this$2)).userAgent == null) break block2;
                                    Window.access$000((Window)4.access$200(this.this$2)).userAgent.displayError(e);
                                }
                            }
                        }
                    });
                }

                static /* synthetic */ Runnable access$100(4 x0) {
                    return x0.val$r;
                }

                static /* synthetic */ Window access$200(4 x0) {
                    return x0.this$1;
                }
            };
            ScriptingEnvironment.this.timer.schedule(tt, timeout);
            return tt;
        }

        public void clearTimeout(Object timeout) {
            if (timeout == null) {
                return;
            }
            ((TimerTask)timeout).cancel();
        }

        public Node parseXML(String text, Document doc) {
            SAXSVGDocumentFactory df = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
            URL urlObj = null;
            if (doc != null && doc instanceof SVGOMDocument) {
                urlObj = ((SVGOMDocument)doc).getURLObject();
            }
            if (urlObj == null) {
                urlObj = ((SVGOMDocument)ScriptingEnvironment.this.bridgeContext.getDocument()).getURLObject();
            }
            String uri = urlObj == null ? "" : urlObj.toString();
            try {
                Document d = df.createDocument(uri, new StringReader(text));
                if (doc == null) {
                    return d;
                }
                DocumentFragment result = doc.createDocumentFragment();
                result.appendChild(doc.importNode(d.getDocumentElement(), true));
                return result;
            }
            catch (Exception ex) {
                if (doc != null && doc instanceof SVGOMDocument) {
                    StringBuffer sb = new StringBuffer(ScriptingEnvironment.FRAGMENT_PREFIX.length() + text.length() + ScriptingEnvironment.FRAGMENT_SUFFIX.length());
                    sb.append(ScriptingEnvironment.FRAGMENT_PREFIX);
                    sb.append(text);
                    sb.append(ScriptingEnvironment.FRAGMENT_SUFFIX);
                    String newText = sb.toString();
                    try {
                        Document d = df.createDocument(uri, new StringReader(newText));
                        if (doc == null) {
                            doc = d;
                        }
                        for (Node n = d.getDocumentElement().getFirstChild(); n != null; n = n.getNextSibling()) {
                            if (n.getNodeType() != 1) continue;
                            n = doc.importNode(n, true);
                            DocumentFragment result = doc.createDocumentFragment();
                            result.appendChild(n);
                            return result;
                        }
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                }
                SAXDocumentFactory sdf = doc != null ? new SAXDocumentFactory(doc.getImplementation(), XMLResourceDescriptor.getXMLParserClassName()) : new SAXDocumentFactory(new GenericDOMImplementation(), XMLResourceDescriptor.getXMLParserClassName());
                try {
                    Document d = sdf.createDocument(uri, new StringReader(text));
                    if (doc == null) {
                        return d;
                    }
                    DocumentFragment result = doc.createDocumentFragment();
                    result.appendChild(doc.importNode(d.getDocumentElement(), true));
                    return result;
                }
                catch (Exception ext) {
                    if (ScriptingEnvironment.this.userAgent != null) {
                        ScriptingEnvironment.this.userAgent.displayError(ext);
                    }
                    return null;
                }
            }
        }

        public void getURL(String uri, Window.URLResponseHandler h) {
            this.getURL(uri, h, null);
        }

        public void getURL(String uri, Window.URLResponseHandler h, String enc) {
            Thread t = new Thread(this, uri, enc, h){
                private final /* synthetic */ String val$uri;
                private final /* synthetic */ String val$enc;
                private final /* synthetic */ Window.URLResponseHandler val$h;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = this$1;
                    this.val$uri = val$uri;
                    this.val$enc = val$enc;
                    this.val$h = val$h;
                }

                public void run() {
                    try {
                        int read;
                        Reader r;
                        URL burl = ((SVGOMDocument)Window.access$000((Window)this.this$1).document).getURLObject();
                        ParsedURL purl = new ParsedURL(burl, this.val$uri);
                        String e = null;
                        if (this.val$enc != null) {
                            e = EncodingUtilities.javaEncoding(this.val$enc);
                            e = e == null ? this.val$enc : e;
                        }
                        InputStream is = purl.openStream();
                        if (e == null) {
                            r = new InputStreamReader(is);
                        } else {
                            try {
                                r = new InputStreamReader(is, e);
                            }
                            catch (UnsupportedEncodingException uee) {
                                r = new InputStreamReader(is);
                            }
                        }
                        r = new BufferedReader(r);
                        StringBuffer sb = new StringBuffer();
                        char[] buf = new char[4096];
                        while ((read = r.read(buf, 0, buf.length)) != -1) {
                            sb.append(buf, 0, read);
                        }
                        r.close();
                        Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this, purl, sb){
                            private final /* synthetic */ ParsedURL val$purl;
                            private final /* synthetic */ StringBuffer val$sb;
                            private final /* synthetic */ 6 this$2;
                            {
                                this.this$2 = this$2;
                                this.val$purl = val$purl;
                                this.val$sb = val$sb;
                            }

                            public void run() {
                                block2: {
                                    try {
                                        6.access$300(this.this$2).getURLDone(true, this.val$purl.getContentType(), this.val$sb.toString());
                                    }
                                    catch (Exception e) {
                                        if (Window.access$000((Window)6.access$400(this.this$2)).userAgent == null) break block2;
                                        Window.access$000((Window)6.access$400(this.this$2)).userAgent.displayError(e);
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        if (e instanceof SecurityException) {
                            Window.access$000((Window)this.this$1).userAgent.displayError(e);
                        }
                        Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this){
                            private final /* synthetic */ 6 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void run() {
                                block2: {
                                    try {
                                        6.access$300(this.this$2).getURLDone(false, null, null);
                                    }
                                    catch (Exception e) {
                                        if (Window.access$000((Window)6.access$400(this.this$2)).userAgent == null) break block2;
                                        Window.access$000((Window)6.access$400(this.this$2)).userAgent.displayError(e);
                                    }
                                }
                            }
                        });
                    }
                }

                static /* synthetic */ Window.URLResponseHandler access$300(6 x0) {
                    return x0.val$h;
                }

                static /* synthetic */ Window access$400(6 x0) {
                    return x0.this$1;
                }
            };
            t.setPriority(1);
            t.start();
        }

        public void postURL(String uri, String content, Window.URLResponseHandler h) {
            this.postURL(uri, content, h, "text/plain", null);
        }

        public void postURL(String uri, String content, Window.URLResponseHandler h, String mimeType) {
            this.postURL(uri, content, h, mimeType, null);
        }

        public void postURL(String uri, String content, Window.URLResponseHandler h, String mimeType, String fEnc) {
            Thread t = new Thread(this, uri, mimeType, fEnc, content, h){
                private final /* synthetic */ String val$uri;
                private final /* synthetic */ String val$mimeType;
                private final /* synthetic */ String val$fEnc;
                private final /* synthetic */ String val$content;
                private final /* synthetic */ Window.URLResponseHandler val$h;
                private final /* synthetic */ Window this$1;
                {
                    this.this$1 = this$1;
                    this.val$uri = val$uri;
                    this.val$mimeType = val$mimeType;
                    this.val$fEnc = val$fEnc;
                    this.val$content = val$content;
                    this.val$h = val$h;
                }

                public void run() {
                    try {
                        int read;
                        URL burl = ((SVGOMDocument)Window.access$000((Window)this.this$1).document).getURLObject();
                        URL url = burl != null ? new URL(burl, this.val$uri) : new URL(this.val$uri);
                        URLConnection conn = url.openConnection();
                        conn.setDoOutput(true);
                        conn.setDoInput(true);
                        conn.setUseCaches(false);
                        conn.setRequestProperty("Content-Type", this.val$mimeType);
                        OutputStream os = conn.getOutputStream();
                        String e = null;
                        String enc = this.val$fEnc;
                        if (enc != null) {
                            if (enc.startsWith("deflate")) {
                                os = new DeflaterOutputStream(os);
                                enc = enc.length() > "deflate".length() ? enc.substring("deflate".length() + 1) : "";
                                conn.setRequestProperty("Content-Encoding", "deflate");
                            }
                            if (enc.startsWith("gzip")) {
                                os = new GZIPOutputStream(os);
                                enc = enc.length() > "gzip".length() ? enc.substring("gzip".length() + 1) : "";
                                conn.setRequestProperty("Content-Encoding", "deflate");
                            }
                            if (enc.length() != 0) {
                                e = EncodingUtilities.javaEncoding(enc);
                                if (e == null) {
                                    e = "UTF-8";
                                }
                            } else {
                                e = "UTF-8";
                            }
                        }
                        OutputStreamWriter w = e == null ? new OutputStreamWriter(os) : new OutputStreamWriter(os, e);
                        w.write(this.val$content);
                        ((Writer)w).flush();
                        ((Writer)w).close();
                        os.close();
                        InputStream is = conn.getInputStream();
                        e = "UTF-8";
                        Reader r = e == null ? new InputStreamReader(is) : new InputStreamReader(is, e);
                        r = new BufferedReader(r);
                        StringBuffer sb = new StringBuffer();
                        char[] buf = new char[4096];
                        while ((read = r.read(buf, 0, buf.length)) != -1) {
                            sb.append(buf, 0, read);
                        }
                        r.close();
                        Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this, conn, sb){
                            private final /* synthetic */ URLConnection val$conn;
                            private final /* synthetic */ StringBuffer val$sb;
                            private final /* synthetic */ 9 this$2;
                            {
                                this.this$2 = this$2;
                                this.val$conn = val$conn;
                                this.val$sb = val$sb;
                            }

                            public void run() {
                                block2: {
                                    try {
                                        9.access$500(this.this$2).getURLDone(true, this.val$conn.getContentType(), this.val$sb.toString());
                                    }
                                    catch (Exception e) {
                                        if (Window.access$000((Window)9.access$600(this.this$2)).userAgent == null) break block2;
                                        Window.access$000((Window)9.access$600(this.this$2)).userAgent.displayError(e);
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        if (e instanceof SecurityException) {
                            Window.access$000((Window)this.this$1).userAgent.displayError(e);
                        }
                        Window.access$000((Window)this.this$1).updateRunnableQueue.invokeLater(new Runnable(this){
                            private final /* synthetic */ 9 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void run() {
                                block2: {
                                    try {
                                        9.access$500(this.this$2).getURLDone(false, null, null);
                                    }
                                    catch (Exception e) {
                                        if (Window.access$000((Window)9.access$600(this.this$2)).userAgent == null) break block2;
                                        Window.access$000((Window)9.access$600(this.this$2)).userAgent.displayError(e);
                                    }
                                }
                            }
                        });
                    }
                }

                static /* synthetic */ Window.URLResponseHandler access$500(9 x0) {
                    return x0.val$h;
                }

                static /* synthetic */ Window access$600(9 x0) {
                    return x0.this$1;
                }
            };
            t.setPriority(1);
            t.start();
        }

        public void alert(String message) {
            if (ScriptingEnvironment.this.userAgent != null) {
                ScriptingEnvironment.this.userAgent.showAlert(message);
            }
        }

        public boolean confirm(String message) {
            if (ScriptingEnvironment.this.userAgent != null) {
                return ScriptingEnvironment.this.userAgent.showConfirm(message);
            }
            return false;
        }

        public String prompt(String message) {
            if (ScriptingEnvironment.this.userAgent != null) {
                return ScriptingEnvironment.this.userAgent.showPrompt(message);
            }
            return null;
        }

        public String prompt(String message, String defVal) {
            if (ScriptingEnvironment.this.userAgent != null) {
                return ScriptingEnvironment.this.userAgent.showPrompt(message, defVal);
            }
            return null;
        }

        public BridgeContext getBridgeContext() {
            return ScriptingEnvironment.this.bridgeContext;
        }

        public Interpreter getInterpreter() {
            return this.interpreter;
        }

        static /* synthetic */ ScriptingEnvironment access$000(Window x0) {
            return x0.ScriptingEnvironment.this;
        }
    }

    protected class EvaluateRunnableRunnable
    implements Runnable {
        public int count;
        public boolean error;
        protected Runnable runnable;

        public EvaluateRunnableRunnable(Runnable r) {
            this.runnable = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            EvaluateRunnableRunnable evaluateRunnableRunnable = this;
            synchronized (evaluateRunnableRunnable) {
                if (this.error) {
                    return;
                }
                --this.count;
            }
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                if (ScriptingEnvironment.this.userAgent != null) {
                    ScriptingEnvironment.this.userAgent.displayError(e);
                } else {
                    e.printStackTrace();
                }
                EvaluateRunnableRunnable evaluateRunnableRunnable2 = this;
                synchronized (evaluateRunnableRunnable2) {
                    this.error = true;
                }
            }
        }
    }

    protected class EvaluateIntervalRunnable
    implements Runnable {
        public int count;
        public boolean error;
        protected Interpreter interpreter;
        protected String script;

        public EvaluateIntervalRunnable(String s, Interpreter interp) {
            this.interpreter = interp;
            this.script = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            EvaluateIntervalRunnable evaluateIntervalRunnable = this;
            synchronized (evaluateIntervalRunnable) {
                if (this.error) {
                    return;
                }
                --this.count;
            }
            try {
                this.interpreter.evaluate(this.script);
            }
            catch (InterpreterException ie) {
                ScriptingEnvironment.this.handleInterpreterException(ie);
                EvaluateIntervalRunnable evaluateIntervalRunnable2 = this;
                synchronized (evaluateIntervalRunnable2) {
                    this.error = true;
                }
            }
            catch (Exception e) {
                if (ScriptingEnvironment.this.userAgent != null) {
                    ScriptingEnvironment.this.userAgent.displayError(e);
                } else {
                    e.printStackTrace();
                }
                EvaluateIntervalRunnable evaluateIntervalRunnable3 = this;
                synchronized (evaluateIntervalRunnable3) {
                    this.error = true;
                }
            }
        }
    }

    protected class EvaluateRunnable
    implements Runnable {
        protected Interpreter interpreter;
        protected String script;

        public EvaluateRunnable(String s, Interpreter interp) {
            this.interpreter = interp;
            this.script = s;
        }

        public void run() {
            try {
                this.interpreter.evaluate(this.script);
            }
            catch (InterpreterException ie) {
                ScriptingEnvironment.this.handleInterpreterException(ie);
            }
        }
    }
}

