/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg12;

import java.net.URL;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.SVG12CSSEngine;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractStylableDocument;
import org.apache.batik.dom.ExtensibleDOMImplementation;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.GenericElementNS;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg12.SVGOMFlowDivElement;
import org.apache.batik.dom.svg12.SVGOMFlowLineElement;
import org.apache.batik.dom.svg12.SVGOMFlowParaElement;
import org.apache.batik.dom.svg12.SVGOMFlowRegionBreakElement;
import org.apache.batik.dom.svg12.SVGOMFlowRegionElement;
import org.apache.batik.dom.svg12.SVGOMFlowRegionExcludeElement;
import org.apache.batik.dom.svg12.SVGOMFlowRootElement;
import org.apache.batik.dom.svg12.SVGOMFlowSpanElement;
import org.apache.batik.dom.svg12.SVGOMMultiImageElement;
import org.apache.batik.dom.svg12.SVGOMSolidColorElement;
import org.apache.batik.dom.svg12.SVGOMSubImageElement;
import org.apache.batik.dom.svg12.SVGOMSubImageRefElement;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.HashTable;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class SVG12DOMImplementation
extends SVGDOMImplementation {
    protected static HashTable svg12Factories = new HashTable(svg11Factories);
    protected static final DOMImplementation DOM_IMPLEMENTATION;

    public SVG12DOMImplementation() {
        this.factories = svg12Factories;
        this.registerFeature("CSS", "2.0");
        this.registerFeature("StyleSheets", "2.0");
        this.registerFeature("SVG", new String[]{"1.0", "1.1", "1.2"});
        this.registerFeature("SVGEvents", new String[]{"1.0", "1.1", "1.2"});
    }

    public CSSEngine createCSSEngine(AbstractStylableDocument doc, CSSContext ctx, ExtendedParser ep, ValueManager[] vms, ShorthandManager[] sms) {
        URL durl = ((SVGOMDocument)doc).getURLObject();
        SVG12CSSEngine result = new SVG12CSSEngine(doc, durl, ep, vms, sms, ctx);
        URL url = this.getClass().getResource("resources/UserAgentStyleSheet.css");
        if (url != null) {
            InputSource is = new InputSource(url.toString());
            result.setUserAgentStyleSheet(result.parseStyleSheet(is, url, "all"));
        }
        return result;
    }

    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        SVGOMDocument result = new SVGOMDocument(doctype, this);
        if (qualifiedName != null) {
            result.appendChild(result.createElementNS(namespaceURI, qualifiedName));
        }
        return result;
    }

    public Element createElementNS(AbstractDocument document, String namespaceURI, String qualifiedName) {
        String name;
        ExtensibleDOMImplementation.ElementFactory ef;
        if (namespaceURI == null) {
            return new GenericElement(qualifiedName.intern(), document);
        }
        if ("http://www.w3.org/2000/svg".equals(namespaceURI) && (ef = (ExtensibleDOMImplementation.ElementFactory)this.factories.get(name = DOMUtilities.getLocalName(qualifiedName))) != null) {
            return ef.create(DOMUtilities.getPrefix(qualifiedName), document);
        }
        return new GenericElementNS(namespaceURI.intern(), qualifiedName.intern(), document);
    }

    public static DOMImplementation getDOMImplementation() {
        return DOM_IMPLEMENTATION;
    }

    static {
        svg12Factories.put("flowDiv", new FlowDivElementFactory());
        svg12Factories.put("flowLine", new FlowLineElementFactory());
        svg12Factories.put("flowPara", new FlowParaElementFactory());
        svg12Factories.put("flowRegionBreak", new FlowRegionBreakElementFactory());
        svg12Factories.put("flowRegion", new FlowRegionElementFactory());
        svg12Factories.put("flowRegionExclude", new FlowRegionExcludeElementFactory());
        svg12Factories.put("flowRoot", new FlowRootElementFactory());
        svg12Factories.put("flowSpan", new FlowSpanElementFactory());
        svg12Factories.put("multiImage", new MultiImageElementFactory());
        svg12Factories.put("solidColor", new SolidColorElementFactory());
        svg12Factories.put("subImage", new SubImageElementFactory());
        svg12Factories.put("subImageRef", new SubImageRefElementFactory());
        DOM_IMPLEMENTATION = new SVG12DOMImplementation();
    }

    protected static class SubImageRefElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMSubImageRefElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class SubImageElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMSubImageElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class SolidColorElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMSolidColorElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class MultiImageElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMMultiImageElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowSpanElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFlowSpanElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowRootElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFlowRootElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowRegionExcludeElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFlowRegionExcludeElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowRegionElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFlowRegionElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowRegionBreakElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFlowRegionBreakElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowParaElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFlowParaElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowLineElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFlowLineElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowDivElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFlowDivElement(prefix, (AbstractDocument)doc);
        }
    }
}

