/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimatedBoolean;

public class SVGOMAnimatedBoolean
implements SVGAnimatedBoolean,
LiveAttributeValue {
    protected AbstractElement element;
    protected String namespaceURI;
    protected String localName;
    protected boolean baseVal;
    protected String defaultValue;
    protected boolean mutate;

    public SVGOMAnimatedBoolean(AbstractElement elt, String ns, String ln, Attr attr, String val) {
        this.element = elt;
        this.namespaceURI = ns;
        this.localName = ln;
        if (attr != null) {
            String s = attr.getValue();
            this.baseVal = "true".equals(s);
        }
        this.defaultValue = val;
    }

    public boolean getBaseVal() {
        return this.baseVal;
    }

    public void setBaseVal(boolean baseVal) throws DOMException {
        if (this.baseVal != baseVal) {
            this.mutate = true;
            this.baseVal = baseVal;
            this.element.setAttributeNS(this.namespaceURI, this.localName, baseVal ? "true" : "false");
            this.mutate = false;
        }
    }

    public boolean getAnimVal() {
        throw new RuntimeException("!!! TODO: getAnimVal()");
    }

    public void attrAdded(Attr node, String newv) {
        if (!this.mutate) {
            this.baseVal = "true".equals(newv);
        }
    }

    public void attrModified(Attr node, String oldv, String newv) {
        if (!this.mutate) {
            this.baseVal = "true".equals(newv);
        }
    }

    public void attrRemoved(Attr node, String oldv) {
        if (!this.mutate) {
            this.baseVal = "true".equals(this.defaultValue);
        }
    }
}

