/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.charset;

import com.adobe.agl.charset.CharsetDecoderICU;
import com.adobe.agl.charset.CharsetEncoderICU;
import com.adobe.agl.charset.CharsetICU;
import com.adobe.agl.text.UTF16;
import com.adobe.agl.text.UnicodeSet;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.text.Bidi;

class CharsetMacHebrew
extends CharsetICU {
    private static final byte[] fromUSubstitution = new byte[]{26};
    protected static final char LRE = '\u202a';
    protected static final char RLE = '\u202b';
    protected static final char PDF = '\u202c';
    protected static final char LRO = '\u202d';
    protected static final char RLO = '\u202e';
    protected static final char[] NLF = System.getProperty("line.separator").toCharArray();
    protected static final char LS = '\u2028';
    protected static final char PS = '\u2029';
    protected static final char VARIANT_TAG = '\uf87f';
    protected static final char GROUP_HINT = '\uf86a';
    protected static final int INVALID_CHAR = 65535;
    protected static final int ASCII_END = 127;
    protected static final int NO_CHAR_MARKER = 65534;
    protected static final int BYTE_MASK = 255;
    protected static final byte HEBREW_DIGIT_MIN = -80;
    protected static final byte HEBREW_DIGIT_MAX = -71;
    private UConverterDataMacHebrew extraInfo = null;
    protected static final char[] fromUnicodeTable = new char[]{'\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u00d0', '\u00d1', '\uffff', '\uffff', '\uffff', '\u00d4', '\u00d5', '\uffff', '\uffff', '\u00d2', '\u00d3', '\u00c1', '\uffff', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00c9', '\u00a7', '\u00a9', '\u00a8', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u00c7', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u00fe', '\uffff', '\u00fc', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u00fd', '\u00ff', '\u00fb', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u00a6', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u00d9', '\u00db', '\u00da', '\u00df', '\u00cf', '\u00cd', '\u00ce', '\u00cc', '\u00cb', '\u00dd', '\uffff', '\u00dc', '\u00c6', '\uffff', '\uffff', '\u00d8', '\uffff', '\uffff', '\uffff', '\uffff', '\u0080', '\uffff', '\uffff', '\u0082', '\uffff', '\u0083', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u0084', '\uffff', '\uffff', '\uffff', '\uffff', '\u0085', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u0086', '\uffff', '\uffff', '\uffff', '\u0088', '\u0087', '\u0089', '\u008b', '\u008a', '\u008c', '\uffff', '\u008d', '\u008f', '\u008e', '\u0090', '\u0091', '\u0093', '\u0092', '\u0094', '\u0095', '\uffff', '\u0096', '\u0098', '\u0097', '\u0099', '\u009b', '\u009a', '\uffff', '\uffff', '\u009d', '\u009c', '\u009e', '\u009f', '\uffff', '\uffff', '\uffff'};
    protected static final char[][] toUnicodeTable = new char[][]{{'\u0000', '\u0000'}, {'\u0001', '\u0000'}, {'\u0002', '\u0000'}, {'\u0003', '\u0000'}, {'\u0004', '\u0000'}, {'\u0005', '\u0000'}, {'\u0006', '\u0000'}, {'\u0007', '\u0000'}, {'\b', '\u0000'}, {'\t', '\u0000'}, {'\n', '\u0000'}, {'\u000b', '\u0000'}, {'\f', '\u0000'}, {'\r', '\u0000'}, {'\u000e', '\u0000'}, {'\u000f', '\u0000'}, {'\u0010', '\u0000'}, {'\u0011', '\u0000'}, {'\u0012', '\u0000'}, {'\u0013', '\u0000'}, {'\u0014', '\u0000'}, {'\u0015', '\u0000'}, {'\u0016', '\u0000'}, {'\u0017', '\u0000'}, {'\u0018', '\u0000'}, {'\u0019', '\u0000'}, {'\u001a', '\u0000'}, {'\u001b', '\u0000'}, {'\u001c', '\u0000'}, {'\u001d', '\u0000'}, {'\u001e', '\u0000'}, {'\u001f', '\u0000'}, {' ', '\u202d'}, {'!', '\u202d'}, {'\"', '\u202d'}, {'#', '\u202d'}, {'$', '\u202d'}, {'%', '\u202d'}, {'&', '\u0000'}, {'\'', '\u202d'}, {'(', '\u202d'}, {')', '\u202d'}, {'*', '\u202d'}, {'+', '\u202d'}, {',', '\u202d'}, {'-', '\u202d'}, {'.', '\u202d'}, {'/', '\u202d'}, {'0', '\u0000'}, {'1', '\u0000'}, {'2', '\u0000'}, {'3', '\u0000'}, {'4', '\u0000'}, {'5', '\u0000'}, {'6', '\u0000'}, {'7', '\u0000'}, {'8', '\u0000'}, {'9', '\u0000'}, {':', '\u202d'}, {';', '\u202d'}, {'<', '\u202d'}, {'=', '\u202d'}, {'>', '\u202d'}, {'?', '\u202d'}, {'@', '\u0000'}, {'A', '\u0000'}, {'B', '\u0000'}, {'C', '\u0000'}, {'D', '\u0000'}, {'E', '\u0000'}, {'F', '\u0000'}, {'G', '\u0000'}, {'H', '\u0000'}, {'I', '\u0000'}, {'J', '\u0000'}, {'K', '\u0000'}, {'L', '\u0000'}, {'M', '\u0000'}, {'N', '\u0000'}, {'O', '\u0000'}, {'P', '\u0000'}, {'Q', '\u0000'}, {'R', '\u0000'}, {'S', '\u0000'}, {'T', '\u0000'}, {'U', '\u0000'}, {'V', '\u0000'}, {'W', '\u0000'}, {'X', '\u0000'}, {'Y', '\u0000'}, {'Z', '\u0000'}, {'[', '\u202d'}, {'\\', '\u0000'}, {']', '\u202d'}, {'^', '\u0000'}, {'_', '\u0000'}, {'`', '\u0000'}, {'a', '\u0000'}, {'b', '\u0000'}, {'c', '\u0000'}, {'d', '\u0000'}, {'e', '\u0000'}, {'f', '\u0000'}, {'g', '\u0000'}, {'h', '\u0000'}, {'i', '\u0000'}, {'j', '\u0000'}, {'k', '\u0000'}, {'l', '\u0000'}, {'m', '\u0000'}, {'n', '\u0000'}, {'o', '\u0000'}, {'p', '\u0000'}, {'q', '\u0000'}, {'r', '\u0000'}, {'s', '\u0000'}, {'t', '\u0000'}, {'u', '\u0000'}, {'v', '\u0000'}, {'w', '\u0000'}, {'x', '\u0000'}, {'y', '\u0000'}, {'z', '\u0000'}, {'{', '\u202d'}, {'|', '\u202d'}, {'}', '\u202d'}, {'~', '\u0000'}, {'\u007f', '\u0000'}, {'\u00c4', '\u0000'}, {'\uffff', '\u0000'}, {'\u00c7', '\u0000'}, {'\u00c9', '\u0000'}, {'\u00d1', '\u0000'}, {'\u00d6', '\u0000'}, {'\u00dc', '\u0000'}, {'\u00e1', '\u0000'}, {'\u00e0', '\u0000'}, {'\u00e2', '\u0000'}, {'\u00e4', '\u0000'}, {'\u00e3', '\u0000'}, {'\u00e5', '\u0000'}, {'\u00e7', '\u0000'}, {'\u00e9', '\u0000'}, {'\u00e8', '\u0000'}, {'\u00ea', '\u0000'}, {'\u00eb', '\u0000'}, {'\u00ed', '\u0000'}, {'\u00ec', '\u0000'}, {'\u00ee', '\u0000'}, {'\u00ef', '\u0000'}, {'\u00f1', '\u0000'}, {'\u00f3', '\u0000'}, {'\u00f2', '\u0000'}, {'\u00f4', '\u0000'}, {'\u00f6', '\u0000'}, {'\u00f5', '\u0000'}, {'\u00fa', '\u0000'}, {'\u00f9', '\u0000'}, {'\u00fb', '\u0000'}, {'\u00fc', '\u0000'}, {' ', '\u202e'}, {'!', '\u202e'}, {'\"', '\u202e'}, {'#', '\u202e'}, {'$', '\u202e'}, {'%', '\u202e'}, {'\u20aa', '\u0000'}, {'\'', '\u202e'}, {')', '\u202e'}, {'(', '\u202e'}, {'*', '\u202e'}, {'+', '\u202e'}, {',', '\u202e'}, {'-', '\u202e'}, {'.', '\u202e'}, {'/', '\u202e'}, {'0', '\u202e'}, {'1', '\u202e'}, {'2', '\u202e'}, {'3', '\u202e'}, {'4', '\u202e'}, {'5', '\u202e'}, {'6', '\u202e'}, {'7', '\u202e'}, {'8', '\u202e'}, {'9', '\u202e'}, {':', '\u202e'}, {';', '\u202e'}, {'<', '\u202e'}, {'=', '\u202e'}, {'>', '\u202e'}, {'?', '\u202e'}, {'\uffff', '\u0000'}, {'\u201e', '\u202e'}, {'\uf89b', '\u0000'}, {'\uf89c', '\u0000'}, {'\uf89d', '\u0000'}, {'\uf89e', '\u0000'}, {'\u05bc', '\u0000'}, {'\ufb4b', '\u0000'}, {'\ufb35', '\u0000'}, {'\u2026', '\u202e'}, {'\u00a0', '\u202e'}, {'\u05b8', '\u0000'}, {'\u05b7', '\u0000'}, {'\u05b5', '\u0000'}, {'\u05b6', '\u0000'}, {'\u05b4', '\u0000'}, {'\u2013', '\u202e'}, {'\u2014', '\u202e'}, {'\u201c', '\u202e'}, {'\u201d', '\u202e'}, {'\u2018', '\u202e'}, {'\u2019', '\u202e'}, {'\ufb2a', '\u0000'}, {'\ufb2b', '\u0000'}, {'\u05bf', '\u0000'}, {'\u05b0', '\u0000'}, {'\u05b2', '\u0000'}, {'\u05b1', '\u0000'}, {'\u05bb', '\u0000'}, {'\u05b9', '\u0000'}, {'\uffff', '\u0000'}, {'\u05b3', '\u0000'}, {'\u05d0', '\u0000'}, {'\u05d1', '\u0000'}, {'\u05d2', '\u0000'}, {'\u05d3', '\u0000'}, {'\u05d4', '\u0000'}, {'\u05d5', '\u0000'}, {'\u05d6', '\u0000'}, {'\u05d7', '\u0000'}, {'\u05d8', '\u0000'}, {'\u05d9', '\u0000'}, {'\u05da', '\u0000'}, {'\u05db', '\u0000'}, {'\u05dc', '\u0000'}, {'\u05dd', '\u0000'}, {'\u05de', '\u0000'}, {'\u05df', '\u0000'}, {'\u05e0', '\u0000'}, {'\u05e1', '\u0000'}, {'\u05e2', '\u0000'}, {'\u05e3', '\u0000'}, {'\u05e4', '\u0000'}, {'\u05e5', '\u0000'}, {'\u05e6', '\u0000'}, {'\u05e7', '\u0000'}, {'\u05e8', '\u0000'}, {'\u05e9', '\u0000'}, {'\u05ea', '\u0000'}, {'}', '\u202e'}, {']', '\u202e'}, {'{', '\u202e'}, {'[', '\u202e'}, {'|', '\u202e'}};

    protected boolean isNLF(StringBuffer fromUPara, int paraIndex) {
        for (int i = 1; i < NLF.length; ++i) {
            if (fromUPara.charAt(paraIndex++) == NLF[i]) continue;
            return false;
        }
        return true;
    }

    public CharsetMacHebrew(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        super(icuCanonicalName, javaCanonicalName, aliases);
        this.maxBytesPerChar = 4;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
        this.extraInfo = new UConverterDataMacHebrew();
        if (this.extraInfo != null) {
            UConverterDataMacHebrew converterData = this.extraInfo;
            converterData.contextDirectionToUnicode = (char)65534;
            converterData.name = "MacHebrew";
        }
    }

    public CharsetDecoder newDecoder() {
        return new CharsetDecoderMacHebrew(this);
    }

    public CharsetEncoder newEncoder() {
        return new CharsetEncoderMacHebrew(this);
    }

    void getUnicodeSetImpl(UnicodeSet setFillIn, int which) {
    }

    class CharsetEncoderMacHebrew
    extends CharsetEncoderICU {
        private CharsetICU mycs;

        public CharsetEncoderMacHebrew(CharsetICU cs) {
            super(cs, fromUSubstitution);
            this.mycs = cs;
            this.implReset();
        }

        protected void implReset() {
            super.implReset();
        }

        public boolean canEncode(int[] input) {
            char[] arr = new char[input.length];
            for (int i = 0; i < input.length; ++i) {
                UTF16.append(arr, i, input[i]);
            }
            CharsetEncoderICU mycse = (CharsetEncoderICU)this.mycs.newEncoder();
            CharBuffer in = CharBuffer.wrap(arr);
            ByteBuffer out = ByteBuffer.allocate(in.length() * (int)mycse.maxBytesPerChar() + 1);
            mycse.setFallbackUsed(this.isFallbackUsed());
            CoderResult res = mycse.encodeLoop(in, out, null, false);
            return !res.isUnmappable();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult cr = CoderResult.UNDERFLOW;
            int realSourceArrayIndex = source.position();
            int targetByteUnit = 0;
            char sourceChar = '\u0000';
            int curParaIndex = 0;
            if (!source.hasRemaining()) {
                return CoderResult.UNDERFLOW;
            }
            if (!target.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            UConverterDataMacHebrew converterData = CharsetMacHebrew.this.extraInfo;
            if (!flush) {
                Bidi bidiPara;
                while (source.hasRemaining()) {
                    if (!converterData.isInParagraph) {
                        if (realSourceArrayIndex < source.limit()) {
                            sourceChar = source.get(realSourceArrayIndex++);
                            converterData.fromUPara.append(sourceChar);
                            if (sourceChar != '\u2029') continue;
                            converterData.isInParagraph = true;
                            converterData.realSourceArrayIndex = realSourceArrayIndex;
                            continue;
                        }
                        source.position(source.limit());
                        continue;
                    }
                    bidiPara = new Bidi(converterData.fromUPara.toString(), -1);
                    while (converterData.paraIndex < converterData.fromUPara.length()) {
                        curParaIndex = converterData.paraIndex;
                        int pos = source.position();
                        source.position(pos + 1);
                        sourceChar = converterData.fromUPara.charAt(converterData.paraIndex++);
                        targetByteUnit = 65535;
                        if (sourceChar <= '\u202e' && sourceChar >= '\u202a') continue;
                        if (sourceChar == '\u2029' || sourceChar == '\u2028') {
                            targetByteUnit = (byte)NLF[0];
                        } else if (sourceChar <= '\u007f') {
                            targetByteUnit = bidiPara.getLevelAt(curParaIndex) % 2 == 1 ? (sourceChar >= ' ' && sourceChar <= '%' || sourceChar >= '\'' && sourceChar <= '?' || sourceChar == '[' || sourceChar == ']' || sourceChar >= '{' && sourceChar <= '}' ? fromUnicodeTable[sourceChar & 0xFF] : (int)sourceChar) : (int)sourceChar;
                        } else if (sourceChar >= '\u05d0' && sourceChar <= '\u05ea') {
                            targetByteUnit = 224 + (sourceChar - 1488);
                        } else if (sourceChar == '\u05b8') {
                            if (converterData.paraIndex < converterData.fromUPara.length() && converterData.fromUPara.charAt(converterData.paraIndex) == '\uf87f') {
                                targetByteUnit = 222;
                                ++converterData.paraIndex;
                            } else {
                                targetByteUnit = fromUnicodeTable[sourceChar & 0xFF];
                            }
                        } else if (sourceChar == '\u05f2') {
                            if (converterData.paraIndex >= converterData.fromUPara.length() || converterData.fromUPara.charAt(converterData.paraIndex) != '\u05b7') return CoderResult.unmappableForLength(1);
                            targetByteUnit = 129;
                            ++converterData.paraIndex;
                        } else if (sourceChar == '\uf86a') {
                            int paraIndex = converterData.paraIndex + 1;
                            if (converterData.paraIndex >= converterData.fromUPara.length() || paraIndex >= converterData.fromUPara.length() || converterData.fromUPara.charAt(converterData.paraIndex) != '\u05dc' || converterData.fromUPara.charAt(paraIndex) != '\u05b9') return CoderResult.unmappableForLength(1);
                            targetByteUnit = 192;
                            converterData.paraIndex = paraIndex + 1;
                        } else if (sourceChar >= '\u00c4' && sourceChar <= '\u00dc' || sourceChar >= '\u00e0' && sourceChar <= '\u00fc' || sourceChar >= '\u2013' && sourceChar <= '\u201e' || sourceChar == '\u2026' || sourceChar == '\u20aa' || sourceChar == '\ufb4b' || sourceChar >= '\u05b0' && sourceChar <= '\u05bf' || sourceChar >= '\uf89b' && sourceChar <= '\uf89e') {
                            targetByteUnit = fromUnicodeTable[sourceChar & 0xFF];
                        } else {
                            switch (sourceChar) {
                                case '\u00a0': {
                                    targetByteUnit = 202;
                                    break;
                                }
                                case '\ufb2a': {
                                    targetByteUnit = 214;
                                    break;
                                }
                                case '\ufb2b': {
                                    targetByteUnit = 215;
                                    break;
                                }
                                case '\ufb35': {
                                    targetByteUnit = 200;
                                    break;
                                }
                            }
                        }
                        if (targetByteUnit == 65535) return CoderResult.unmappableForLength(1);
                        if (sourceChar == '\u2028' || sourceChar == '\u2029') {
                            for (int i = 0; i < NLF.length && !(cr = this.WriteToTargetFromU(offsets, source, target, targetByteUnit = (int)((byte)NLF[i]))).isOverflow(); ++i) {
                            }
                            continue;
                        }
                        cr = this.WriteToTargetFromU(offsets, source, target, targetByteUnit);
                        if (!cr.isOverflow()) continue;
                        break;
                    }
                    if (cr.isOverflow()) break;
                    converterData.fromUPara = new StringBuffer();
                    converterData.paraIndex = 0;
                    converterData.isInParagraph = false;
                    realSourceArrayIndex = converterData.realSourceArrayIndex;
                }
                if (converterData.fromUPara.length() <= 0) return cr;
                bidiPara = new Bidi(converterData.fromUPara.toString(), -1);
                while (converterData.paraIndex < converterData.fromUPara.length()) {
                    curParaIndex = converterData.paraIndex;
                    sourceChar = converterData.fromUPara.charAt(converterData.paraIndex++);
                    targetByteUnit = 65535;
                    if (sourceChar <= '\u202e' && sourceChar >= '\u202a') continue;
                    if (sourceChar == '\u2029' || sourceChar == '\u2028') {
                        targetByteUnit = (byte)NLF[0];
                    } else if (sourceChar <= '\u007f') {
                        targetByteUnit = bidiPara.getLevelAt(curParaIndex) % 2 == 1 ? (sourceChar >= ' ' && sourceChar <= '%' || sourceChar >= '\'' && sourceChar <= '?' || sourceChar == '[' || sourceChar == ']' || sourceChar >= '{' && sourceChar <= '}' ? fromUnicodeTable[sourceChar & 0xFF] : (int)sourceChar) : (int)sourceChar;
                    } else if (sourceChar >= '\u05d0' && sourceChar <= '\u05ea') {
                        targetByteUnit = 224 + (sourceChar - 1488);
                    } else if (sourceChar == '\u05b8') {
                        if (converterData.paraIndex < converterData.fromUPara.length() && converterData.fromUPara.charAt(converterData.paraIndex) == '\uf87f') {
                            targetByteUnit = 222;
                            ++converterData.paraIndex;
                        } else {
                            targetByteUnit = fromUnicodeTable[sourceChar & 0xFF];
                        }
                    } else if (sourceChar == '\u05f2') {
                        if (converterData.paraIndex >= converterData.fromUPara.length() || converterData.fromUPara.charAt(converterData.paraIndex) != '\u05b7') return CoderResult.unmappableForLength(1);
                        targetByteUnit = 129;
                        ++converterData.paraIndex;
                    } else if (sourceChar == '\uf86a') {
                        int paraIndex = converterData.paraIndex + 1;
                        if (converterData.paraIndex >= converterData.fromUPara.length() || paraIndex >= converterData.fromUPara.length() || converterData.fromUPara.charAt(converterData.paraIndex) != '\u05dc' || converterData.fromUPara.charAt(paraIndex) != '\u05b9') return CoderResult.unmappableForLength(1);
                        targetByteUnit = 192;
                        converterData.paraIndex = paraIndex + 1;
                    } else if (sourceChar >= '\u00c4' && sourceChar <= '\u00dc' || sourceChar >= '\u00e0' && sourceChar <= '\u00fc' || sourceChar >= '\u2013' && sourceChar <= '\u201e' || sourceChar == '\u2026' || sourceChar == '\u20aa' || sourceChar == '\ufb4b' || sourceChar >= '\u05b0' && sourceChar <= '\u05bf' || sourceChar >= '\uf89b' && sourceChar <= '\uf89e') {
                        targetByteUnit = fromUnicodeTable[sourceChar & 0xFF];
                    } else {
                        switch (sourceChar) {
                            case '\u00a0': {
                                targetByteUnit = 202;
                                break;
                            }
                            case '\ufb2a': {
                                targetByteUnit = 214;
                                break;
                            }
                            case '\ufb2b': {
                                targetByteUnit = 215;
                                break;
                            }
                            case '\ufb35': {
                                targetByteUnit = 200;
                                break;
                            }
                        }
                    }
                    if (targetByteUnit == 65535) return CoderResult.unmappableForLength(1);
                    if (sourceChar == '\u2028' || sourceChar == '\u2029') {
                        for (int i = 0; i < NLF.length && !(cr = this.WriteToTargetFromU(offsets, source, target, targetByteUnit = (int)((byte)NLF[i]))).isOverflow(); ++i) {
                        }
                        continue;
                    }
                    cr = this.WriteToTargetFromU(offsets, source, target, targetByteUnit);
                    if (!cr.isOverflow()) continue;
                    break;
                }
                if (cr.isOverflow()) return cr;
                converterData.fromUPara = new StringBuffer();
                converterData.paraIndex = 0;
                return cr;
            }
            if (converterData.fromUPara.length() <= 0) return cr;
            Bidi bidiPara = new Bidi(converterData.fromUPara.toString(), -1);
            while (converterData.paraIndex < converterData.fromUPara.length()) {
                curParaIndex = converterData.paraIndex;
                sourceChar = converterData.fromUPara.charAt(converterData.paraIndex++);
                targetByteUnit = 65535;
                if (sourceChar <= '\u202e' && sourceChar >= '\u202a') continue;
                if (sourceChar == '\u2029' || sourceChar == '\u2028') {
                    targetByteUnit = (byte)NLF[0];
                } else if (sourceChar <= '\u007f') {
                    targetByteUnit = bidiPara.getLevelAt(curParaIndex) % 2 == 1 ? (sourceChar >= ' ' && sourceChar <= '%' || sourceChar >= '\'' && sourceChar <= '?' || sourceChar == '[' || sourceChar == ']' || sourceChar >= '{' && sourceChar <= '}' ? fromUnicodeTable[sourceChar & 0xFF] : (int)sourceChar) : (int)sourceChar;
                } else if (sourceChar >= '\u05d0' && sourceChar <= '\u05ea') {
                    targetByteUnit = 224 + (sourceChar - 1488);
                } else if (sourceChar == '\u05b8') {
                    if (converterData.paraIndex < converterData.fromUPara.length() && converterData.fromUPara.charAt(converterData.paraIndex) == '\uf87f') {
                        targetByteUnit = 222;
                        ++converterData.paraIndex;
                    } else {
                        targetByteUnit = fromUnicodeTable[sourceChar & 0xFF];
                    }
                } else if (sourceChar == '\u05f2') {
                    if (converterData.paraIndex >= converterData.fromUPara.length() || converterData.fromUPara.charAt(converterData.paraIndex) != '\u05b7') return CoderResult.unmappableForLength(1);
                    targetByteUnit = 129;
                    ++converterData.paraIndex;
                } else if (sourceChar == '\uf86a') {
                    int paraIndex = converterData.paraIndex + 1;
                    if (converterData.paraIndex >= converterData.fromUPara.length() || paraIndex >= converterData.fromUPara.length() || converterData.fromUPara.charAt(converterData.paraIndex) != '\u05dc' || converterData.fromUPara.charAt(paraIndex) != '\u05b9') return CoderResult.unmappableForLength(1);
                    targetByteUnit = 192;
                    converterData.paraIndex = paraIndex + 1;
                } else if (sourceChar >= '\u00c4' && sourceChar <= '\u00dc' || sourceChar >= '\u00e0' && sourceChar <= '\u00fc' || sourceChar >= '\u2013' && sourceChar <= '\u201e' || sourceChar == '\u2026' || sourceChar == '\u20aa' || sourceChar == '\ufb4b' || sourceChar >= '\u05b0' && sourceChar <= '\u05bf' || sourceChar >= '\uf89b' && sourceChar <= '\uf89e') {
                    targetByteUnit = fromUnicodeTable[sourceChar & 0xFF];
                } else {
                    switch (sourceChar) {
                        case '\u00a0': {
                            targetByteUnit = 202;
                            break;
                        }
                        case '\ufb2a': {
                            targetByteUnit = 214;
                            break;
                        }
                        case '\ufb2b': {
                            targetByteUnit = 215;
                            break;
                        }
                        case '\ufb35': {
                            targetByteUnit = 200;
                            break;
                        }
                    }
                }
                if (targetByteUnit == 65535) return CoderResult.unmappableForLength(1);
                if (sourceChar == '\u2028' || sourceChar == '\u2029') {
                    for (int i = 0; i < NLF.length && !(cr = this.WriteToTargetFromU(offsets, source, target, targetByteUnit = (int)((byte)NLF[i]))).isOverflow(); ++i) {
                    }
                    continue;
                }
                cr = this.WriteToTargetFromU(offsets, source, target, targetByteUnit);
                if (!cr.isOverflow()) continue;
                break;
            }
            if (cr.isOverflow()) return cr;
            converterData.fromUPara = new StringBuffer();
            converterData.paraIndex = 0;
            source.position(0);
            return cr;
        }

        private final CoderResult encodeChar(CharBuffer source, ByteBuffer target, IntBuffer offsets, char ch) {
            CoderResult cr = null;
            return cr;
        }

        private CoderResult WriteToTargetFromU(IntBuffer offsets, CharBuffer source, ByteBuffer target, int targetByteUnit) {
            CoderResult cr = CoderResult.UNDERFLOW;
            if (target.hasRemaining()) {
                if ((targetByteUnit & 0xFFFF) <= 255) {
                    target.put((byte)targetByteUnit);
                    if (offsets != null) {
                        offsets.put(source.position() - 1);
                    }
                } else {
                    target.put((byte)(targetByteUnit >> 8));
                    if (offsets != null) {
                        offsets.put(source.position() - 1);
                    }
                    if (target.hasRemaining()) {
                        target.put((byte)targetByteUnit);
                        if (offsets != null) {
                            offsets.put(source.position() - 1);
                        }
                    } else {
                        this.errorBuffer[this.errorBufferLength++] = (byte)targetByteUnit;
                        cr = CoderResult.OVERFLOW;
                    }
                }
            } else {
                if ((targetByteUnit & 0xFF00) > 0) {
                    this.errorBuffer[this.errorBufferLength++] = (byte)(targetByteUnit >> 8);
                }
                this.errorBuffer[this.errorBufferLength++] = (byte)targetByteUnit;
                cr = CoderResult.OVERFLOW;
            }
            return cr;
        }
    }

    class CharsetDecoderMacHebrew
    extends CharsetDecoderICU {
        public CharsetDecoderMacHebrew(CharsetICU cs) {
            super(cs);
            this.implReset();
        }

        protected void implReset() {
            super.implReset();
            this.toUnicodeStatus = 65535;
            this.mode = 0;
        }

        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult cr = CoderResult.UNDERFLOW;
            int targetUniChar = 0;
            short sourceChar = 0;
            int[] targetBegin = new int[1];
            int[] offsetsBegin = new int[1];
            UConverterDataMacHebrew data = CharsetMacHebrew.this.extraInfo;
            while (source.hasRemaining()) {
                if (target.hasRemaining()) {
                    sourceChar = (short)((short)source.get() & 0xFF);
                    targetUniChar = toUnicodeTable[sourceChar][0];
                    switch (toUnicodeTable[sourceChar][1]) {
                        case '\u0000': {
                            byte targetDirection = Character.getDirectionality((char)targetUniChar);
                            if (this.toUnicodeStatus != 65535) {
                                if (data.contextDirectionToUnicode == targetDirection) {
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus);
                                    this.toUnicodeStatus = 65535;
                                } else {
                                    int directionTmp = data.contextDirectionToUnicode == '\u0000' ? 8237 : 8238;
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, directionTmp);
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus);
                                    this.toUnicodeStatus = 65535;
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8236);
                                }
                            } else if (data.contextDirectionToUnicode == '\u202d' || data.contextDirectionToUnicode == '\u202e') {
                                cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8236);
                            }
                            switch (sourceChar) {
                                case 129: {
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 1522);
                                    targetUniChar = 1463;
                                    break;
                                }
                                case 192: {
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 63594);
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 1500);
                                    targetUniChar = 1465;
                                    break;
                                }
                                case 222: {
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 1464);
                                    targetUniChar = 63615;
                                }
                            }
                            cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar);
                            if (targetDirection == 0 || targetDirection == 1) {
                                data.contextDirectionToUnicode = (char)targetDirection;
                                break;
                            }
                            data.contextDirectionToUnicode = (char)65534;
                            break;
                        }
                        case '\u202d': {
                            if (this.toUnicodeStatus != 65535) {
                                if (data.contextDirectionToUnicode == '\u0000') {
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8237);
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus);
                                    this.toUnicodeStatus = 65535;
                                } else {
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8238);
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus);
                                    this.toUnicodeStatus = 65535;
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8236);
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8237);
                                }
                                cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar);
                                data.contextDirectionToUnicode = (char)8237;
                                break;
                            }
                            if (data.contextDirectionToUnicode == '\u0000') {
                                this.toUnicodeStatus = targetUniChar;
                                break;
                            }
                            if (data.contextDirectionToUnicode == '\u202d') {
                                cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar);
                                break;
                            }
                            if (data.contextDirectionToUnicode == '\u202e') {
                                cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8236);
                            }
                            cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8237);
                            cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar);
                            data.contextDirectionToUnicode = (char)8237;
                            break;
                        }
                        case '\u202e': {
                            if (this.toUnicodeStatus != 65535) {
                                if (data.contextDirectionToUnicode == '\u0001') {
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8238);
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus);
                                    this.toUnicodeStatus = 65535;
                                } else {
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8237);
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus);
                                    this.toUnicodeStatus = 65535;
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8236);
                                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8238);
                                }
                                cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar);
                                data.contextDirectionToUnicode = (char)8238;
                                break;
                            }
                            if (data.contextDirectionToUnicode == '\u0001') {
                                if (sourceChar < -80 || sourceChar > -71) {
                                    this.toUnicodeStatus = targetUniChar;
                                    break;
                                }
                                cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8238);
                                cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar);
                                data.contextDirectionToUnicode = (char)8238;
                                break;
                            }
                            if (data.contextDirectionToUnicode == '\u202e') {
                                cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar);
                                break;
                            }
                            if (data.contextDirectionToUnicode == '\u202d') {
                                cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8236);
                            }
                            cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8238);
                            cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar);
                            data.contextDirectionToUnicode = (char)8238;
                        }
                    }
                    continue;
                }
                cr = CoderResult.OVERFLOW;
                break;
            }
            if (!cr.isOverflow() && flush && !source.hasRemaining()) {
                if (this.toUnicodeStatus != 65535) {
                    int directionTmp = data.contextDirectionToUnicode == '\u0000' ? 8237 : 8238;
                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, directionTmp);
                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus);
                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8236);
                } else if (data.contextDirectionToUnicode == '\u202d' || data.contextDirectionToUnicode == '\u202e') {
                    cr = this.WriteToTargetToU(offsets, source.position() - 2, source, target, 8236);
                }
            }
            return cr;
        }

        private CoderResult WriteToTargetToU(IntBuffer offsets, int offset, ByteBuffer source, CharBuffer target, int targetUniChar) {
            CoderResult cr = CoderResult.UNDERFLOW;
            if (target.hasRemaining()) {
                target.put((char)targetUniChar);
                if (offsets != null) {
                    offsets.put(offset);
                }
            } else {
                this.charErrorBufferArray[this.charErrorBufferLength++] = (char)targetUniChar;
                cr = CoderResult.OVERFLOW;
            }
            return cr;
        }
    }

    private static final class UConverterDataMacHebrew {
        int option;
        char contextDirectionToUnicode;
        boolean isFirstBuffer = true;
        String name;
        int realSourceArrayIndex = -1;
        StringBuffer fromUPara = new StringBuffer();
        int paraIndex = 0;
        boolean isInParagraph = false;

        void initialize() {
            this.contextDirectionToUnicode = (char)65534;
            this.name = "MacHebrew";
        }

        UConverterDataMacHebrew() {
            this.initialize();
        }
    }
}

