/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.charset;

import com.adobe.agl.charset.CharsetDecoderICU;
import com.adobe.agl.charset.CharsetEncoderICU;
import com.adobe.agl.charset.CharsetICU;
import com.adobe.agl.text.UTF16;
import com.adobe.agl.text.UnicodeSet;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class CharsetISCII
extends CharsetICU {
    private final short UCNV_OPTIONS_VERSION_MASK = (short)15;
    private final short UCNV_OPTIONS_MAC_MASK = (short)32;
    private final short ZWNJ = (short)8204;
    private final short ZWJ = (short)8205;
    private final short ATR = (short)239;
    private final short EXT = (short)240;
    private final short DANDA = (short)2404;
    private final short DOUBLE_DANDA = (short)2405;
    private final short ISCII_NUKTA = (short)233;
    private final short ISCII_HALANT = (short)232;
    private final short ISCII_DANDA = (short)234;
    private final short ISCII_VOWEL_SIGN_E = (short)224;
    private final short ISCII_INV = (short)217;
    private final short INDIC_BLOCK_BEGIN = (short)2304;
    private final short INDIC_BLOCK_END = (short)3455;
    private final short INDIC_RANGE = (short)1151;
    private final short VOCALLIC_RR = (short)2353;
    private final short LF = (short)10;
    private final short ASCII_END = (short)160;
    private final int NO_CHAR_MARKER = 65534;
    private final short TELUGU_DELTA = (short)768;
    private final short DEV_ABBR_SIGN = (short)2416;
    private final short DEV_ANUDATTA = (short)2386;
    private final short EXT_RANGE_BEGIN = (short)161;
    private final short EXT_RANGE_END = (short)238;
    private final String ISCII_CNV_PREFIX = "ISCII,version=";
    private static final LookupDataStruct[] lookupInitialData = new LookupDataStruct[]{new LookupDataStruct(0, 128, 66), new LookupDataStruct(1, 8, 67), new LookupDataStruct(2, 64, 75), new LookupDataStruct(3, 32, 74), new LookupDataStruct(4, 16, 71), new LookupDataStruct(5, 1, 68), new LookupDataStruct(6, 4, 69), new LookupDataStruct(7, 4, 72), new LookupDataStruct(8, 2, 73)};
    private static final short[] validityTable = new short[]{0, 248, 255, 255, 128, 255, 255, 255, 255, 255, 255, 190, 158, 160, 135, 255, 255, 160, 135, 255, 255, 255, 254, 254, 254, 255, 255, 254, 255, 254, 255, 255, 254, 254, 254, 255, 255, 254, 254, 254, 255, 129, 255, 254, 254, 254, 255, 255, 255, 131, 255, 247, 131, 247, 254, 191, 255, 255, 0, 0, 216, 128, 255, 255, 255, 255, 255, 190, 172, 160, 135, 255, 255, 160, 135, 255, 255, 255, 0, 0, 160, 128, 128, 128, 128, 4, 20, 26, 128, 192, 192, 192, 200, 152, 192, 152, 190, 158, 136, 136, 128, 128, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final char[] fromUnicodeTableWin = new char[]{'\u00a0', '\u00a1', '\u00a2', '\u00a3', '\ua4e0', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\ua6e9', '\u00ae', '\u00ab', '\u00ac', '\u00ad', '\u00b2', '\u00af', '\u00b0', '\u00b1', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\uffff', '\uffff', '\u00e9', '\ueae9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\udfe9', '\u00e3', '\u00e0', '\u00e1', '\u00e2', '\u00e7', '\u00e4', '\u00e5', '\u00e6', '\u00e8', '\u00ec', '\u00ed', '\ua1e9', '\uffff', '\uf0b8', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\ub3e9', '\ub4e9', '\ub5e9', '\ubae9', '\ubfe9', '\uc0e9', '\uc9e9', '\u00ce', '\uaae9', '\ua7e9', '\udbe9', '\udce9', '\u00ea', '\ueaea', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\uf0bf', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff'};
    private static final char[] toUnicodeTableWin = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '\u00a0', '\u0901', '\u0902', '\u0903', '\u0905', '\u0906', '\u0907', '\u0908', '\u0909', '\u090a', '\u090b', '\u090e', '\u090f', '\u0910', '\u090d', '\u0912', '\u0913', '\u0914', '\u0911', '\u0915', '\u0916', '\u0917', '\u0918', '\u0919', '\u091a', '\u091b', '\u091c', '\u091d', '\u091e', '\u091f', '\u0920', '\u0921', '\u0922', '\u0923', '\u0924', '\u0925', '\u0926', '\u0927', '\u0928', '\u0929', '\u092a', '\u092b', '\u092c', '\u092d', '\u092e', '\u092f', '\u095f', '\u0930', '\u0931', '\u0932', '\u0933', '\u0934', '\u0935', '\u0936', '\u0937', '\u0938', '\u0939', '\u200d', '\u093e', '\u093f', '\u0940', '\u0941', '\u0942', '\u0943', '\u0946', '\u0947', '\u0948', '\u0945', '\u094a', '\u094b', '\u094c', '\u0949', '\u094d', '\u093c', '\u0964', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u0966', '\u0967', '\u0968', '\u0969', '\u096a', '\u096b', '\u096c', '\u096d', '\u096e', '\u096f', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff'};
    private static final char[] fromUnicodeTableMac = new char[]{'\u00a0', '\u00a1', '\u00a2', '\u00a3', '\uffff', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\ua6e9', '\u00ae', '\u00ab', '\u00ac', '\u00ad', '\u00b2', '\u00af', '\u00b0', '\u00b1', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\uffff', '\uffff', '\u00e9', '\ueae9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\udfe9', '\u00e3', '\u00e0', '\u00e1', '\u00e2', '\u00e7', '\u00e4', '\u00e5', '\u00e6', '\u00e8', '\u00ec', '\u00ed', '\ua1e9', '\uffff', '\uf0b8', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\ub3e9', '\ub4e9', '\ub5e9', '\ubae9', '\ubfe9', '\uc0e9', '\uc9e9', '\u00ce', '\uaae9', '\ua7e9', '\udbe9', '\udce9', '\u00ea', '\u0090', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u0091', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff'};
    private static final char[] toUnicodeTableMac = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u00d7', '\u2212', '\u2013', '\u2014', '\u2018', '\u2019', '\u2026', '\u2022', '\u00a9', '\u00ae', '\u2122', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0965', '\u0970', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u0901', '\u0902', '\u0903', '\u0905', '\u0906', '\u0907', '\u0908', '\u0909', '\u090a', '\u090b', '\u090e', '\u090f', '\u0910', '\u090d', '\u0912', '\u0913', '\u0914', '\u0911', '\u0915', '\u0916', '\u0917', '\u0918', '\u0919', '\u091a', '\u091b', '\u091c', '\u091d', '\u091e', '\u091f', '\u0920', '\u0921', '\u0922', '\u0923', '\u0924', '\u0925', '\u0926', '\u0927', '\u0928', '\u0929', '\u092a', '\u092b', '\u092c', '\u092d', '\u092e', '\u092f', '\u095f', '\u0930', '\u0931', '\u0932', '\u0933', '\u0934', '\u0935', '\u0936', '\u0937', '\u0938', '\u0939', '\u200d', '\u093e', '\u093f', '\u0940', '\u0941', '\u0942', '\u0943', '\u0946', '\u0947', '\u0948', '\u0945', '\u094a', '\u094b', '\u094c', '\u0949', '\u094d', '\u093c', '\u0964', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff', '\u0966', '\u0967', '\u0968', '\u0969', '\u096a', '\u096b', '\u096c', '\u096d', '\u096e', '\u096f', '\uffff', '\uffff', '\uffff', '\uffff', '\uffff'};
    private static char[] toUnicodeTable = toUnicodeTableWin;
    private static char[] fromUnicodeTable = fromUnicodeTableWin;
    private static final char[][] nuktaSpecialCases = new char[][]{{'\u0010', '\u0000'}, {'\u00a6', '\u090c'}, {'\u00ea', '\u093d'}, {'\u00df', '\u0944'}, {'\u00a1', '\u0950'}, {'\u00b3', '\u0958'}, {'\u00b4', '\u0959'}, {'\u00b5', '\u095a'}, {'\u00ba', '\u095b'}, {'\u00bf', '\u095c'}, {'\u00c0', '\u095d'}, {'\u00c9', '\u095e'}, {'\u00aa', '\u0960'}, {'\u00a7', '\u0961'}, {'\u00db', '\u0962'}, {'\u00dc', '\u0963'}};
    private static final char[][] vowelSignESpecialCases = new char[][]{{'\u0002', '\u0000'}, {'\u00a4', '\u0904'}};
    private static final short[][] lookupTable = new short[][]{{0, 0}, {0, 0}, {0, 128}, {1, 8}, {5, 1}, {6, 4}, {1, 8}, {4, 16}, {7, 4}, {8, 2}, {3, 32}, {2, 64}};
    private UConverterDataISCII extraInfo = null;
    protected byte[] fromUSubstitution = new byte[]{26};

    public CharsetISCII(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        super(icuCanonicalName, javaCanonicalName, aliases);
        this.maxBytesPerChar = 4;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
        boolean isMacIndic = icuCanonicalName.endsWith(",mac");
        if (isMacIndic) {
            int index = icuCanonicalName.indexOf(",mac");
            int option = Integer.parseInt(icuCanonicalName.substring(14, index));
            this.extraInfo = new UConverterDataISCII(option, new String("ISCII,version=" + (option & 0xF) + ",mac"));
        } else {
            int option = Integer.parseInt(icuCanonicalName.substring(14));
            this.extraInfo = new UConverterDataISCII(option, new String("ISCII,version=" + (option & 0xF)));
        }
        if (isMacIndic) {
            toUnicodeTable = toUnicodeTableMac;
            fromUnicodeTable = fromUnicodeTableMac;
        } else {
            toUnicodeTable = toUnicodeTableWin;
            fromUnicodeTable = fromUnicodeTableWin;
        }
    }

    public CharsetDecoder newDecoder() {
        return new CharsetDecoderISCII(this);
    }

    public CharsetEncoder newEncoder() {
        return new CharsetEncoderISCII(this);
    }

    void getUnicodeSetImpl(UnicodeSet setFillIn, int which) {
        setFillIn.add(0, 160);
        for (int script = 0; script <= 8; ++script) {
            char mask = (char)CharsetISCII.lookupInitialData[script].maskEnum;
            for (int idx = 0; idx < 128; ++idx) {
                if ((validityTable[idx] & mask) == 0 && (script != 6 || idx != 49)) continue;
                setFillIn.add(idx + script * 128 + 2304);
            }
        }
        setFillIn.add(2404);
        setFillIn.add(2405);
        setFillIn.add(8204);
        setFillIn.add(8205);
    }

    class CharsetEncoderISCII
    extends CharsetEncoderICU {
        private CharsetICU mycs;

        public CharsetEncoderISCII(CharsetICU cs) {
            super(cs, CharsetISCII.this.fromUSubstitution);
            this.mycs = cs;
            this.implReset();
        }

        protected void implReset() {
            super.implReset();
            CharsetISCII.this.extraInfo.initialize();
        }

        public boolean canEncode(int[] input) {
            char[] arr = new char[input.length];
            for (int i = 0; i < input.length; ++i) {
                UTF16.append(arr, i, input[i]);
            }
            CharsetEncoderICU mycse = (CharsetEncoderICU)this.mycs.newEncoder();
            CharBuffer in = CharBuffer.wrap(arr);
            ByteBuffer out = ByteBuffer.allocate(in.length() * (int)mycse.maxBytesPerChar() + 1);
            mycse.setFallbackUsed(this.isFallbackUsed());
            CoderResult res = mycse.encodeLoop(in, out, null, true);
            return !res.isUnmappable();
        }

        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult cr;
            block33: {
                int sourceChar;
                block34: {
                    int targetByteUnit = 0;
                    sourceChar = 0;
                    short newDelta = 0;
                    short range = 0;
                    boolean deltaChanged = false;
                    UConverterDataISCII converterData = CharsetISCII.this.extraInfo;
                    newDelta = converterData.currentDeltaFromUnicode;
                    range = (short)(newDelta / 128);
                    sourceChar = this.fromUChar32;
                    if (sourceChar != 0) {
                        CoderResult cr2 = this.handleSurrogates(source, (char)sourceChar);
                        return cr2 != null ? cr2 : CoderResult.unmappableForLength(2);
                    }
                    block17: while (true) {
                        if (!source.hasRemaining()) {
                            return CoderResult.UNDERFLOW;
                        }
                        if (!target.hasRemaining()) {
                            return CoderResult.OVERFLOW;
                        }
                        targetByteUnit = 65535;
                        sourceChar = source.get();
                        if (converterData.isMacIndic) {
                            switch (sourceChar) {
                                case 215: {
                                    targetByteUnit = 128;
                                    break;
                                }
                                case 8722: {
                                    targetByteUnit = 129;
                                    break;
                                }
                                case 8211: {
                                    targetByteUnit = 130;
                                    break;
                                }
                                case 8212: {
                                    targetByteUnit = 131;
                                    break;
                                }
                                case 8216: {
                                    targetByteUnit = 132;
                                    break;
                                }
                                case 8217: {
                                    targetByteUnit = 133;
                                    break;
                                }
                                case 8230: {
                                    targetByteUnit = 134;
                                    break;
                                }
                                case 8226: {
                                    targetByteUnit = 135;
                                    break;
                                }
                                case 169: {
                                    targetByteUnit = 136;
                                    break;
                                }
                                case 174: {
                                    targetByteUnit = 137;
                                    break;
                                }
                                case 8482: {
                                    targetByteUnit = 138;
                                    break;
                                }
                            }
                            if (targetByteUnit != 65535) {
                                cr = this.WriteToTargetFromU(offsets, source, target, targetByteUnit);
                                if (!cr.isOverflow()) continue;
                                break block33;
                            }
                        }
                        if (sourceChar <= 160) {
                            cr = this.WriteToTargetFromU(offsets, source, target, sourceChar);
                            if (!cr.isOverflow()) {
                                if (converterData.isMacIndic || sourceChar != 10) continue;
                                targetByteUnit = 61184;
                                this.fromUnicodeStatus = sourceChar;
                                cr = this.WriteToTargetFromU(offsets, source, target, targetByteUnit += (byte)lookupInitialData[range].isciiLang);
                                if (!cr.isOverflow()) continue;
                            }
                            break block33;
                        }
                        switch (sourceChar) {
                            case 8204: {
                                if (converterData.contextCharFromUnicode != 0) {
                                    converterData.contextCharFromUnicode = 0;
                                    targetByteUnit = 232;
                                    break;
                                }
                                converterData.contextCharFromUnicode = 0;
                                continue block17;
                            }
                            case 8205: {
                                targetByteUnit = converterData.contextCharFromUnicode != 0 ? 233 : 217;
                                converterData.contextCharFromUnicode = 0;
                                break;
                            }
                            default: {
                                if ((char)(3455 - sourceChar) <= '\u047f') {
                                    if (sourceChar != 2404 && sourceChar != 2405) {
                                        range = (short)((sourceChar - 2304) / 128);
                                        newDelta = (short)(range * 128);
                                        if (newDelta != converterData.currentDeltaFromUnicode || converterData.isFirstBuffer) {
                                            converterData.currentDeltaFromUnicode = newDelta;
                                            converterData.currentMaskFromUnicode = lookupInitialData[range].maskEnum;
                                            deltaChanged = true;
                                            converterData.isFirstBuffer = false;
                                        }
                                        sourceChar -= converterData.currentDeltaFromUnicode;
                                    }
                                    targetByteUnit = fromUnicodeTable[(short)sourceChar & 0xFF];
                                    if ((validityTable[(short)sourceChar & 0xFF] & converterData.currentMaskFromUnicode) == 0 && (converterData.currentDeltaFromUnicode != 768 || sourceChar != 2353)) {
                                        targetByteUnit = 65535;
                                    }
                                    if (!converterData.isMacIndic && deltaChanged) {
                                        int temp = 0;
                                        temp = 61184;
                                        temp = (char)(temp + (char)(lookupInitialData[range].isciiLang & 0xFF));
                                        deltaChanged = false;
                                        cr = this.WriteToTargetFromU(offsets, source, target, temp);
                                        if (cr.isOverflow()) break;
                                    }
                                }
                                converterData.contextCharFromUnicode = 0;
                            }
                        }
                        if (targetByteUnit == 65535) break block34;
                        if (targetByteUnit == 232) {
                            converterData.contextCharFromUnicode = (char)targetByteUnit;
                        }
                        if ((cr = this.WriteToTargetFromU(offsets, source, target, targetByteUnit)).isOverflow()) break;
                    }
                    break block33;
                }
                if (UTF16.isSurrogate((char)sourceChar)) {
                    cr = this.handleSurrogates(source, (char)sourceChar);
                    return cr != null ? cr : CoderResult.unmappableForLength(2);
                }
                return CoderResult.unmappableForLength(1);
            }
            return cr;
        }

        private CoderResult WriteToTargetFromU(IntBuffer offsets, CharBuffer source, ByteBuffer target, int targetByteUnit) {
            CoderResult cr = CoderResult.UNDERFLOW;
            if (target.hasRemaining()) {
                if (targetByteUnit <= 255) {
                    target.put((byte)targetByteUnit);
                    if (offsets != null) {
                        offsets.put(source.position() - 1);
                    }
                } else {
                    target.put((byte)(targetByteUnit >> 8));
                    if (offsets != null) {
                        offsets.put(source.position() - 1);
                    }
                    if (target.hasRemaining()) {
                        target.put((byte)targetByteUnit);
                        if (offsets != null) {
                            offsets.put(source.position() - 1);
                        }
                    } else {
                        this.errorBuffer[this.errorBufferLength++] = (byte)targetByteUnit;
                        cr = CoderResult.OVERFLOW;
                    }
                }
            } else {
                if ((targetByteUnit & 0xFF00) > 0) {
                    this.errorBuffer[this.errorBufferLength++] = (byte)(targetByteUnit >> 8);
                }
                this.errorBuffer[this.errorBufferLength++] = (byte)targetByteUnit;
                cr = CoderResult.OVERFLOW;
            }
            return cr;
        }
    }

    class CharsetDecoderISCII
    extends CharsetDecoderICU {
        public CharsetDecoderISCII(CharsetICU cs) {
            super(cs);
            this.implReset();
        }

        protected void implReset() {
            super.implReset();
            this.toUnicodeStatus = 65535;
            CharsetISCII.this.extraInfo.initialize();
        }

        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult cr = CoderResult.UNDERFLOW;
            int targetUniChar = 0;
            short sourceChar = 0;
            boolean gotoCallBack = false;
            UConverterDataISCII data = CharsetISCII.this.extraInfo;
            block8: while (source.hasRemaining()) {
                targetUniChar = 65535;
                if (target.hasRemaining()) {
                    sourceChar = (short)((short)source.get() & 0xFF);
                    if (data.contextCharToUnicode == 239) {
                        if (((short)(75 - sourceChar) & 0xFF) <= 9) {
                            data.currentDeltaToUnicode = (short)(lookupTable[sourceChar & 0xF][0] * 128);
                            data.currentMaskToUnicode = lookupTable[sourceChar & 0xF][1];
                        } else if (sourceChar == 64) {
                            data.currentDeltaToUnicode = data.defDeltaToUnicode;
                            data.currentMaskToUnicode = data.defMaskToUnicode;
                        } else if (sourceChar < 33 || sourceChar > 63) {
                            cr = CoderResult.malformedForLength(1);
                            data.contextCharToUnicode = 65534;
                            gotoCallBack = true;
                        }
                        if (!gotoCallBack) {
                            data.contextCharToUnicode = 65534;
                            continue;
                        }
                    } else if (data.contextCharToUnicode == 240) {
                        if (((short)(238 - sourceChar) & 0xFF) <= 77) {
                            if (sourceChar == 191 || sourceChar == 184) {
                                int n = targetUniChar = sourceChar == 191 ? 2416 : 2386;
                                if ((validityTable[(short)targetUniChar & 0xFF] & data.currentMaskToUnicode) > 0) {
                                    data.contextCharToUnicode = 65534;
                                    this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar, data.currentDeltaToUnicode);
                                    continue;
                                }
                            }
                            targetUniChar = 65535;
                            cr = CoderResult.unmappableForLength(1);
                        } else {
                            data.contextCharToUnicode = 65534;
                            cr = CoderResult.malformedForLength(1);
                        }
                        gotoCallBack = true;
                    } else if (data.contextCharToUnicode == 217) {
                        targetUniChar = sourceChar == 232 ? 32 : 8205;
                        this.WriteToTargetToU(offsets, source.position() - 2, source, target, targetUniChar, data.currentDeltaToUnicode);
                        data.contextCharToUnicode = 65534;
                    }
                    if (!gotoCallBack) {
                        switch (sourceChar) {
                            case 217: 
                            case 239: 
                            case 240: {
                                data.contextCharToUnicode = (char)sourceChar;
                                if (this.toUnicodeStatus == 65535) continue block8;
                                this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus, data.currentDeltaToUnicode);
                                this.toUnicodeStatus = 65535;
                                continue block8;
                            }
                            case 234: {
                                if (data.contextCharToUnicode == 234) {
                                    targetUniChar = 2405;
                                    data.contextCharToUnicode = 65534;
                                    this.toUnicodeStatus = 65535;
                                    break;
                                }
                                targetUniChar = this.GetMapping(sourceChar, targetUniChar, data);
                                data.contextCharToUnicode = (char)sourceChar;
                                break;
                            }
                            case 232: {
                                if (data.contextCharToUnicode == 232) {
                                    targetUniChar = 8204;
                                    data.contextCharToUnicode = 65534;
                                    break;
                                }
                                targetUniChar = this.GetMapping(sourceChar, targetUniChar, data);
                                data.contextCharToUnicode = (char)sourceChar;
                                break;
                            }
                            case 10: 
                            case 13: {
                                data.resetToDefaultToUnicode = true;
                                targetUniChar = this.GetMapping(sourceChar, targetUniChar, data);
                                data.contextCharToUnicode = (char)sourceChar;
                                break;
                            }
                            case 224: {
                                boolean find = false;
                                for (int n = 1; n < vowelSignESpecialCases[0][0]; ++n) {
                                    if (vowelSignESpecialCases[n][0] != ((short)data.contextCharToUnicode & 0xFF)) continue;
                                    targetUniChar = vowelSignESpecialCases[n][1];
                                    find = true;
                                    break;
                                }
                                if (find && (validityTable[(byte)targetUniChar] & data.currentMaskFromUnicode) > 0) {
                                    data.contextCharToUnicode = 65534;
                                    this.toUnicodeStatus = 65535;
                                    break;
                                }
                                targetUniChar = this.GetMapping(sourceChar, targetUniChar, data);
                                data.contextCharToUnicode = (char)sourceChar;
                                break;
                            }
                            case 233: {
                                if (data.contextCharToUnicode == 232) {
                                    targetUniChar = 8205;
                                    data.contextCharToUnicode = 65534;
                                    break;
                                }
                                boolean found = false;
                                for (int i = 1; i < nuktaSpecialCases[0][0]; ++i) {
                                    if (nuktaSpecialCases[i][0] != ((short)data.contextCharToUnicode & 0xFF)) continue;
                                    targetUniChar = nuktaSpecialCases[i][1];
                                    found = true;
                                    break;
                                }
                                if (found && (validityTable[(byte)targetUniChar] & data.currentMaskToUnicode) > 0) {
                                    data.contextCharToUnicode = 65534;
                                    this.toUnicodeStatus = 65535;
                                    break;
                                }
                            }
                            default: {
                                targetUniChar = this.GetMapping(sourceChar, targetUniChar, data);
                                data.contextCharToUnicode = (char)sourceChar;
                            }
                        }
                    }
                    if (this.toUnicodeStatus != 65535 && !gotoCallBack) {
                        this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus, data.currentDeltaToUnicode);
                        this.toUnicodeStatus = 65535;
                    }
                    if (targetUniChar != 65535 && !gotoCallBack) {
                        this.toUnicodeStatus = (char)targetUniChar;
                        if (!data.resetToDefaultToUnicode) continue;
                        data.currentDeltaToUnicode = data.defDeltaToUnicode;
                        data.currentMaskToUnicode = data.defMaskToUnicode;
                        data.resetToDefaultToUnicode = false;
                        continue;
                    }
                    if (!gotoCallBack) {
                        cr = CoderResult.unmappableForLength(1);
                    }
                    this.toUBytesArray[0] = (byte)sourceChar;
                    this.toULength = 1;
                    gotoCallBack = false;
                    break;
                }
                cr = CoderResult.OVERFLOW;
                break;
            }
            if (!cr.isError() && !cr.isOverflow() && flush && !source.hasRemaining()) {
                if (data.contextCharToUnicode == 239 || data.contextCharToUnicode == 240 || data.contextCharToUnicode == 217) {
                    this.toUBytesArray[0] = (byte)data.contextCharToUnicode;
                    this.toULength = 1;
                    data.contextCharToUnicode = 65534;
                } else {
                    this.toULength = 0;
                }
                if (this.toUnicodeStatus != 65535) {
                    this.WriteToTargetToU(offsets, source.position() - 2, source, target, this.toUnicodeStatus, data.currentDeltaToUnicode);
                    this.toUnicodeStatus = 65535;
                }
            }
            return cr;
        }

        private CoderResult WriteToTargetToU(IntBuffer offsets, int offset, ByteBuffer source, CharBuffer target, int targetUniChar, short delta) {
            CoderResult cr = CoderResult.UNDERFLOW;
            if (targetUniChar > 160 && targetUniChar != 8205 && targetUniChar != 8204 && targetUniChar != 2404 && targetUniChar != 2405) {
                targetUniChar += delta;
            }
            if (target.hasRemaining()) {
                target.put((char)targetUniChar);
                if (offsets != null) {
                    offsets.put(offset);
                }
            } else {
                this.charErrorBufferArray[this.charErrorBufferLength++] = (char)targetUniChar;
                cr = CoderResult.OVERFLOW;
            }
            return cr;
        }

        private int GetMapping(short sourceChar, int targetUniChar, UConverterDataISCII data) {
            targetUniChar = toUnicodeTable[sourceChar];
            if (sourceChar > 160 && (validityTable[(short)targetUniChar & 0xFF] & data.currentMaskToUnicode) == 0 && (data.currentDeltaToUnicode != 768 || targetUniChar != 2353)) {
                targetUniChar = 65535;
            }
            return targetUniChar;
        }
    }

    private static final class LookupDataStruct {
        short uniLang;
        short maskEnum;
        short isciiLang;

        LookupDataStruct(short uniLang, short maskEnum, short isciiLang) {
            this.uniLang = uniLang;
            this.maskEnum = maskEnum;
            this.isciiLang = isciiLang;
        }
    }

    private final class UConverterDataISCII {
        int option;
        int contextCharToUnicode;
        int contextCharFromUnicode;
        short defDeltaToUnicode;
        short currentDeltaFromUnicode;
        short currentDeltaToUnicode;
        short currentMaskFromUnicode;
        short currentMaskToUnicode;
        short defMaskToUnicode;
        boolean isFirstBuffer;
        boolean resetToDefaultToUnicode;
        String name;
        boolean isMacIndic;

        UConverterDataISCII(int option, String name) {
            this.option = option;
            this.name = name;
            this.initialize();
        }

        void initialize() {
            this.contextCharToUnicode = 65534;
            this.currentDeltaFromUnicode = 0;
            this.isMacIndic = this.name.endsWith(",mac");
            this.defDeltaToUnicode = (short)(lookupInitialData[this.option & 0xF].uniLang * 128);
            this.currentDeltaFromUnicode = (short)(lookupInitialData[this.option & 0xF].uniLang * 128);
            this.currentDeltaToUnicode = (short)(lookupInitialData[this.option & 0xF].uniLang * 128);
            this.currentMaskToUnicode = lookupInitialData[this.option & 0xF].maskEnum;
            this.currentMaskFromUnicode = lookupInitialData[this.option & 0xF].maskEnum;
            this.defMaskToUnicode = lookupInitialData[this.option & 0xF].maskEnum;
            this.isFirstBuffer = true;
            this.resetToDefaultToUnicode = false;
        }
    }

    private static final class MaskEnum {
        static final short DEV_MASK = 128;
        static final short PNJ_MASK = 64;
        static final short GJR_MASK = 32;
        static final short ORI_MASK = 16;
        static final short BNG_MASK = 8;
        static final short KND_MASK = 4;
        static final short MLM_MASK = 2;
        static final short TML_MASK = 1;
        static final short ZERO = 0;

        private MaskEnum() {
        }
    }

    private static final class ISCIILang {
        static final short DEF = 64;
        static final short RMN = 65;
        static final short DEV = 66;
        static final short BNG = 67;
        static final short TML = 68;
        static final short TLG = 69;
        static final short ASM = 70;
        static final short ORI = 71;
        static final short KND = 72;
        static final short MLM = 73;
        static final short GJR = 74;
        static final short PNJ = 75;
        static final short ARB = 113;
        static final short PES = 114;
        static final short URD = 115;
        static final short SND = 116;
        static final short KSM = 117;
        static final short PST = 118;

        private ISCIILang() {
        }
    }

    private static final class UniLang {
        static final short DEVALANGARI = 0;
        static final short BENGALI = 1;
        static final short GURMUKHI = 2;
        static final short GUJARATI = 3;
        static final short ORIYA = 4;
        static final short TAMIL = 5;
        static final short TELUGU = 6;
        static final short KANNADA = 7;
        static final short MALAYALAM = 8;
        static final short DELTA = 128;

        private UniLang() {
        }
    }
}

