/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTSelectors;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.Tag;
import com.adobe.fontengine.font.type1.Type1Font;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.infontformatting.BaseFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.InFontFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.LookupsCache;

public final class GlyphFormatter
extends BaseFormatter {
    private static final int[] gposFeatures = new int[]{Tag.feature_mark, Tag.feature_mkmk};

    protected boolean canFormatOT() {
        return true;
    }

    protected int formatOT(OpenTypeFont openTypeFont, AttributedRun attributedRun, int n, int n2, boolean bl) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        this.posFromAdvanceWidth(attributedRun, openTypeFont, n, n2);
        if (openTypeFont.gpos != null) {
            int n3 = GlyphFormatter.getOTScriptTag((Integer)attributedRun.getElementStyle(n, InFontFormatter.scriptAttribute));
            int n4 = GlyphFormatter.getOTLanguageTag((ULocale)attributedRun.getElementStyle(n, ElementAttribute.locale));
            int[][] nArray = LookupsCache.resolveFeatureTag(openTypeFont.gpos, n3, n4, gposFeatures);
            n2 = openTypeFont.gpos.applyLookups(nArray[0], attributedRun, n, n2, OTSelectors.everywhere, openTypeFont.gdef);
            n2 = openTypeFont.gpos.applyLookups(nArray[1], attributedRun, n, n2, OTSelectors.everywhere, openTypeFont.gdef);
        } else if (bl && openTypeFont.kern != null) {
            this.applyKernTable(openTypeFont, attributedRun, n, n2);
        }
        return n2;
    }

    protected boolean canFormatTT() {
        return true;
    }

    protected int formatTT(OpenTypeFont openTypeFont, AttributedRun attributedRun, int n, int n2, boolean bl) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        this.posFromAdvanceWidth(attributedRun, openTypeFont, n, n2);
        if (bl && openTypeFont.kern != null) {
            this.applyKernTable(openTypeFont, attributedRun, n, n2);
        }
        return n2;
    }

    protected boolean canFormatT1() {
        return true;
    }

    protected int formatT1(Type1Font type1Font, AttributedRun attributedRun, int n, int n2, boolean bl) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        this.posFromAdvanceWidth(attributedRun, type1Font, n, n2);
        if (bl) {
            for (int i = n; i < n2 - 1; ++i) {
                double d = type1Font.getKernValue(attributedRun.elementAt(i), attributedRun.elementAt(i + 1));
                attributedRun.adjustPlacementAndAdvance(i, 0.0, 0.0, d, 0.0);
            }
        }
        return n2;
    }

    protected boolean canFormatGeneric() {
        return true;
    }

    protected int formatGeneric(FontData fontData, AttributedRun attributedRun, int n, int n2, boolean bl) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        this.posFromAdvanceWidth(attributedRun, fontData, n, n2);
        return n2;
    }
}

