/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.mac;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.WrapperFontData;
import com.adobe.fontengine.fontmanagement.Platform;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontDescription;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontDescription;

public class ResourceFontData
extends WrapperFontData {
    private String rsrcFontName;
    private String sfntName;
    private ULocale locale;
    private boolean isBold;
    private boolean isItalic;

    public ResourceFontData(FontData fontData, ULocale uLocale, String string, String string2, boolean bl, boolean bl2) {
        super(fontData);
        this.locale = uLocale;
        this.rsrcFontName = string;
        this.sfntName = string2;
        this.isBold = bl;
        this.isItalic = bl2;
    }

    public FXGFontDescription[] getFXGFontDescription(Platform platform, ULocale uLocale) throws InvalidFontException, UnsupportedFontException {
        if ((platform == Platform.MAC_OSX || platform == null) && this.locale != null && this.rsrcFontName != null && ResourceFontData.isContainedWithin(this.locale, uLocale)) {
            FXGFontDescription[] fXGFontDescriptionArray = new FXGFontDescription[]{new FXGFontDescription(Platform.MAC_OSX, this.locale, this.rsrcFontName, this.isBold, this.isItalic)};
            return fXGFontDescriptionArray;
        }
        return new FXGFontDescription[0];
    }

    public PlatformFontDescription[] getPlatformFontDescription(Platform platform, ULocale uLocale) throws InvalidFontException, UnsupportedFontException {
        PlatformFontDescription[] platformFontDescriptionArray = this.getFontData().getPlatformFontDescription(platform, uLocale);
        if (platformFontDescriptionArray != null) {
            return platformFontDescriptionArray;
        }
        if ((platform == Platform.MAC_OSX || platform == null) && this.locale != null && this.sfntName != null && ResourceFontData.isContainedWithin(this.locale, uLocale)) {
            platformFontDescriptionArray = new PlatformFontDescription[]{new PlatformFontDescription(Platform.MAC_OSX, this.locale, this.sfntName)};
            return platformFontDescriptionArray;
        }
        return new PlatformFontDescription[0];
    }

    private static boolean isContainedWithin(ULocale uLocale, ULocale uLocale2) {
        if (uLocale2 == null) {
            return true;
        }
        String string = uLocale.getLanguage();
        if (string != null && !string.equals("") && !string.equals(uLocale2.getLanguage())) {
            return false;
        }
        String string2 = uLocale.getCountry();
        if (string2 != null && !string2.equals("") && !string2.equals(uLocale2.getCountry())) {
            return false;
        }
        String string3 = uLocale.getScript();
        return string3 == null || !string3.equals("") || string3.equals(uLocale2.getScript());
    }
}

