/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import java.io.IOException;

final class CFFByteArray
extends FontByteArray {
    private CFFByteArray(int n) {
        super(n);
    }

    public CFFByteArray(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        super(fontByteArray, false);
    }

    protected static final CFFByteArrayBuilder getCFFByteArrayBuilderInstance() {
        return new CFFByteArrayBuilder();
    }

    protected static final CFFByteArrayBuilder getCFFByteArrayBuilderInstance(int n) {
        return new CFFByteArrayBuilder(n);
    }

    protected final int getcard8(int n) throws InvalidFontException {
        if (n < 0 || n >= this.getSize()) {
            throw new InvalidFontException("Invalid index");
        }
        return this.getRawByte(n);
    }

    protected final int getint8(int n) throws InvalidFontException {
        if (n < 0 || n >= this.getSize()) {
            throw new InvalidFontException("Invalid index");
        }
        return this.getSignedRawByte(n);
    }

    protected final int getcard16(int n) throws InvalidFontException {
        return this.getcard8(n) << 8 | this.getcard8(n + 1);
    }

    protected final int getint16(int n) throws InvalidFontException {
        return this.getint8(n) << 8 | this.getcard8(n + 1);
    }

    protected final int getcard24(int n) throws InvalidFontException {
        return this.getcard8(n) << 16 | this.getcard8(n + 1) << 8 | this.getcard8(n + 2);
    }

    protected final long getcard32(int n) throws InvalidFontException {
        return this.getcard8(n) << 24 | this.getcard8(n + 1) << 16 | this.getcard8(n + 2) << 8 | this.getcard8(n + 3);
    }

    protected final int getint32(int n) throws InvalidFontException {
        return this.getint8(n) << 24 | this.getcard8(n + 1) << 16 | this.getcard8(n + 2) << 8 | this.getcard8(n + 3);
    }

    protected int getOffSize(int n) throws InvalidFontException {
        return this.getcard8(n);
    }

    protected int getOffset(int n, int n2, String string) throws UnsupportedFontException, InvalidFontException {
        switch (n2) {
            case 1: {
                return this.getcard8(n);
            }
            case 2: {
                return this.getcard16(n);
            }
            case 3: {
                return this.getcard24(n);
            }
        }
        if (this.getcard8(n) > 127) {
            throw new UnsupportedFontException(string);
        }
        return (int)this.getcard32(n);
    }

    static final class CFFByteArrayBuilder
    extends FontByteArray.FontByteArrayBuilder {
        protected CFFByteArrayBuilder() {
            super(new CFFByteArray(1024));
        }

        protected CFFByteArrayBuilder(int n) {
            super(new CFFByteArray(n));
        }

        protected void addCard32(int n) {
            this.appendRawByte((byte)(n >> 24 & 0xFF));
            this.appendRawByte((byte)(n >> 16 & 0xFF));
            this.appendRawByte((byte)(n >> 8 & 0xFF));
            this.appendRawByte((byte)(n & 0xFF));
        }

        protected void addCard24(int n) {
            this.appendRawByte((byte)(n >> 16 & 0xFF));
            this.appendRawByte((byte)(n >> 8 & 0xFF));
            this.appendRawByte((byte)(n & 0xFF));
        }

        protected void addCard16(int n) {
            this.appendRawByte((byte)(n >> 8 & 0xFF));
            this.appendRawByte((byte)(n & 0xFF));
        }

        protected void addCard8(int n) {
            this.appendRawByte((byte)(n & 0xFF));
        }

        protected void addOffset(int n, int n2) {
            if (n == 1) {
                this.addCard8(n2);
            } else if (n == 2) {
                this.addCard16(n2);
            } else if (n == 3) {
                this.addCard24(n2);
            } else {
                this.addCard32(n2);
            }
        }

        protected void setCard32(int n, int n2) {
            this.setRawByte(n++, (byte)(n2 >> 24 & 0xFF));
            this.setRawByte(n++, (byte)(n2 >> 16 & 0xFF));
            this.setRawByte(n++, (byte)(n2 >> 8 & 0xFF));
            this.setRawByte(n++, (byte)(n2 & 0xFF));
        }

        protected void addBytes(byte[] byArray, int n, int n2) {
            this.append(byArray, n, n2);
        }

        protected void addBytes(CFFByteArray cFFByteArray, int n, int n2) throws InvalidFontException {
            this.append(cFFByteArray, n, n2);
        }

        protected CFFByteArray toCFFByteArray() {
            CFFByteArray cFFByteArray = (CFFByteArray)this.byteArray;
            this.byteArray = null;
            return cFFByteArray;
        }
    }
}

