/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public final class StemFinder
implements OutlineConsumer {
    private final boolean findVerticalStem;
    private final boolean hintsForFauxing;
    private List leftEdges = new LinkedList();
    private List rightEdges = new LinkedList();
    private List removedEdges = new ArrayList();
    private double currentX;
    private double currentY;
    private Matrix currentMatrix;
    private Matrix lastMatrixSet;
    private static final Matrix thousand = new Matrix(1000.0, 0.0, 0.0, 1000.0, 0.0, 0.0);

    public StemFinder(boolean bl, boolean bl2) {
        this.findVerticalStem = bl;
        this.hintsForFauxing = bl2;
    }

    private void addEdge(double d, double d2, double d3, double d4, boolean bl, List list) {
        list.add(new Edge(d, d2, d3, d4, bl));
    }

    public void reset() {
        this.leftEdges.clear();
        this.rightEdges.clear();
        this.removedEdges.clear();
    }

    public void setMatrix(Matrix matrix) {
        this.lastMatrixSet = matrix.multiply(thousand);
    }

    public void moveto(double d, double d2) {
        this.currentX = d;
        this.currentY = d2;
        this.currentMatrix = this.lastMatrixSet;
    }

    public void lineto(double d, double d2) {
        this.addLine(this.currentX, this.currentY, d, d2);
        this.currentX = d;
        this.currentY = d2;
        this.currentMatrix = this.lastMatrixSet;
    }

    private void addLine(double d, double d2, double d3, double d4) {
        d = this.currentMatrix.applyToXYGetX(d, d2);
        d2 = this.currentMatrix.applyToXYGetY(d, d2);
        d3 = this.lastMatrixSet.applyToXYGetX(d3, d4);
        d4 = this.lastMatrixSet.applyToXYGetY(d3, d4);
        if (this.findVerticalStem && d2 == d4 || !this.findVerticalStem && d == d3) {
            return;
        }
        if (this.findVerticalStem) {
            if (d2 < d4) {
                if (d < d3) {
                    this.addEdge(d, d2, d3, d4, false, this.rightEdges);
                } else {
                    this.addEdge(d3, d2, d, d4, true, this.rightEdges);
                }
            } else if (d < d3) {
                this.addEdge(d, d4, d3, d2, true, this.leftEdges);
            } else {
                this.addEdge(d3, d4, d, d2, false, this.leftEdges);
            }
        } else if (d < d3) {
            if (d2 < d4) {
                this.addEdge(d2, d, d4, d3, false, this.rightEdges);
            } else {
                this.addEdge(d4, d, d2, d3, true, this.leftEdges);
            }
        } else if (d2 < d4) {
            this.addEdge(d2, d3, d4, d, true, this.rightEdges);
        } else {
            this.addEdge(d4, d3, d2, d, false, this.leftEdges);
        }
    }

    public void curveto(double d, double d2, double d3, double d4) {
        this.curveto(Math.round((this.currentX + 2.0 * d) / 3.0), Math.round((this.currentY + 2.0 * d2) / 3.0), Math.round((2.0 * d + d3) / 3.0), Math.round((2.0 * d2 + d4) / 3.0), d3, d4);
    }

    public void curveto(double d, double d2, double d3, double d4, double d5, double d6) {
        this.addLine(this.currentX, this.currentY, d, d2);
        this.addLine(d, d2, d3, d4);
        this.addLine(d3, d4, d5, d6);
        this.currentX = d5;
        this.currentY = d6;
        this.currentMatrix = this.lastMatrixSet;
    }

    private void mergeLines(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Edge edge = (Edge)list.get(i);
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                int n = listIterator.nextIndex();
                Edge edge2 = (Edge)listIterator.next();
                if (edge == edge2 || !edge.continuation(edge2)) continue;
                if (n < i) {
                    --i;
                }
                listIterator.remove();
            }
        }
    }

    private void mergeLines() {
        this.mergeLines(this.leftEdges);
        this.mergeLines(this.rightEdges);
    }

    private void removeInnerCounters() {
    }

    private void removeAngledLines(List list, double d, boolean bl) {
        ListIterator listIterator = list.listIterator();
        double d2 = this.findVerticalStem ? Math.tan(Math.toRadians(d)) : 0.15;
        while (listIterator.hasNext()) {
            boolean bl2;
            double d3;
            Edge edge = (Edge)listIterator.next();
            if (this.findVerticalStem) {
                d3 = -(edge.endStemDir - edge.startStemDir) / (edge.endOppositeDir - edge.startOppositeDir);
                bl2 = d == 0.0 ? true : (d > 0.0 ? edge.positiveAngle : !edge.positiveAngle);
            } else {
                d3 = (edge.endOppositeDir - edge.startOppositeDir) / (edge.endStemDir - edge.startStemDir);
                bl2 = true;
            }
            if (bl2 && !(d3 < d2 - 0.22) && !(d3 > d2 + 0.22)) continue;
            if (bl) {
                this.removedEdges.add(edge);
            }
            listIterator.remove();
        }
    }

    private void removeIrrelevantLines(double d) {
        this.removeAngledLines(this.leftEdges, d, false);
        this.removeAngledLines(this.rightEdges, d, true);
        if (this.hintsForFauxing) {
            this.removeInnerCounters();
        }
    }

    private boolean partiallyContained(Edge edge, Edge edge2, Edge edge3, double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        boolean bl = false;
        if (this.findVerticalStem) {
            d6 = edge.startStemDir;
            d5 = edge.positiveAngle ? edge.endOppositeDir : edge.startOppositeDir;
            d4 = edge.endStemDir;
            d3 = edge.positiveAngle ? edge.startOppositeDir : edge.endOppositeDir;
        } else {
            d3 = 0.0;
            d4 = 0.0;
            d5 = 0.0;
            d6 = 0.0;
        }
        double d7 = d6;
        double d8 = d5;
        for (int i = 0; i < 2; ++i) {
            if (!(d8 > d) && !(d8 < d2)) {
                double d9 = edge2.getStemPosGivenOppPos(d8);
                double d10 = edge3.getStemPosGivenOppPos(d8);
                if (!(d9 > d7) && !(d10 < d7)) {
                    if (!(d9 != d7 && d10 != d7 && d != d8 && d2 != d8 || bl)) {
                        bl = true;
                    } else {
                        return true;
                    }
                }
            }
            d7 = d4;
            d8 = d3;
        }
        return false;
    }

    private boolean crossesHorizontalLine(Edge edge, Edge edge2, Edge edge3, double d) {
        if (edge.endOppositeDir < d || edge.startOppositeDir > d) {
            return false;
        }
        double d2 = edge.getStemPosGivenOppPos(d);
        return !(edge2.getStemPosGivenOppPos(d) >= d2) && !(edge3.getStemPosGivenOppPos(d) <= d2);
    }

    private boolean crossesEdge(Edge edge, Edge edge2, double d, double d2, boolean bl) {
        if (edge.m == edge2.m) {
            return false;
        }
        double d3 = (edge.c - edge2.c) / (edge.m - edge2.m);
        if (d3 < d2 || d3 > d || d3 < d2 || d3 > d) {
            return false;
        }
        if (d3 == d2 || d3 == d) {
            return bl ? edge.m > edge2.m : edge.m < edge2.m;
        }
        return true;
    }

    private boolean intermediateRemovedEdge(Edge edge, Edge edge2, double d, double d2) {
        for (Edge edge3 : this.removedEdges) {
            if (!(edge3.endOppositeDir > d2) || !(edge3.startOppositeDir < d) || !(edge3.startStemDir < edge2.endStemDir) || !(edge3.endStemDir > edge.startStemDir) || !this.partiallyContained(edge3, edge, edge2, d, d2) && !this.crossesHorizontalLine(edge3, edge, edge2, d) && !this.crossesHorizontalLine(edge3, edge, edge2, d2) && !this.crossesEdge(edge3, edge, d, d2, true) && !this.crossesEdge(edge3, edge2, d, d2, false)) continue;
            return true;
        }
        return false;
    }

    private double averageWidth(double d, double d2, boolean bl) {
        double d3 = 0.0;
        int n = 0;
        Iterator iterator = this.leftEdges.iterator();
        double d4 = 0.8 * d;
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            ArrayList<Point> arrayList = new ArrayList<Point>();
            arrayList.add(new Point(edge.startOppositeDir, edge.endOppositeDir));
            ListIterator<Point> listIterator = arrayList.listIterator();
            block1: while (listIterator.hasNext()) {
                Iterator iterator2 = this.rightEdges.iterator();
                Point point = (Point)listIterator.next();
                while (iterator2.hasNext()) {
                    double d5;
                    double d6;
                    Edge edge2 = (Edge)iterator2.next();
                    if (edge2.endStemDir < edge.endStemDir || !(edge2.endOppositeDir > point.x) || !(edge2.startOppositeDir < point.y)) continue;
                    double d7 = Math.min(point.y, edge2.endOppositeDir);
                    if (!(this.intermediateRemovedEdge(edge, edge2, d7, d6 = Math.max(point.x, edge2.startOppositeDir)) || bl && Edge.isShortOverlap(d7, d6))) {
                        double d8;
                        d5 = edge2.getStemPosGivenOppPos(d7) - edge.getStemPosGivenOppPos(d7);
                        boolean bl2 = false;
                        boolean bl3 = false;
                        if (d7 - d6 < 130.0) {
                            bl2 = true;
                        } else if (n > 0) {
                            d8 = d3 / (double)n;
                            if (d8 - d5 > 60.0) {
                                bl2 = true;
                            } else if (d5 - d8 > 60.0 && d7 - d6 > 100.0) {
                                bl3 = true;
                            }
                        }
                        if (d5 > 0.0 && (!bl || !bl2 && d5 < d4 && d5 < 450.0)) {
                            if (bl3 && bl) {
                                d3 = 0.0;
                                n = 0;
                            }
                            d3 += d5;
                            ++n;
                        }
                        d5 = edge2.getStemPosGivenOppPos(d6) - edge.getStemPosGivenOppPos(d6);
                        bl2 = d7 - d6 < 130.0;
                        bl3 = false;
                        if (n > 0) {
                            d8 = d3 / (double)n;
                            if (d8 - d5 > 60.0) {
                                bl2 = true;
                            } else if (d5 - d8 > 60.0 && d7 - d6 > 100.0) {
                                bl3 = true;
                            }
                        }
                        if (d5 > 0.0 && (!bl || !bl2 && d5 < d4 && d5 < 450.0)) {
                            if (bl3 && bl) {
                                d3 = 0.0;
                                n = 0;
                            }
                            d3 += d5;
                            ++n;
                        }
                    }
                    if (d7 == point.y) {
                        if (d6 == point.x) continue block1;
                        point.y = d6;
                        continue;
                    }
                    if (d6 == point.x) {
                        point.x = d7;
                        continue;
                    }
                    d5 = point.x;
                    point.x = edge2.endOppositeDir;
                    point = new Point(d5, edge2.startOppositeDir);
                    listIterator.add(point);
                    listIterator.previous();
                }
            }
        }
        if (n == 0) {
            return 0.0;
        }
        return d3 / (double)n;
    }

    public double getComputedStem(double d, double d2) {
        this.mergeLines();
        this.removeIrrelevantLines(d2);
        Collections.sort(this.leftEdges, EdgeComparator.comparator);
        Collections.sort(this.rightEdges, EdgeComparator.comparator);
        double d3 = this.averageWidth(d, d2, true);
        if (d3 == 0.0) {
            d3 = this.averageWidth(d, d2, false);
        }
        return d3;
    }

    public void endchar() {
    }

    private static class Edge {
        private static final int SHORT_STEM = 130;
        private static final int SHORT_OVERLAP = 50;
        static final double ANGLE_VARIANCE_ALLOWED = 0.22;
        static final double MAX_WIDTH_PERCENTAGE = 0.8;
        static final double MAX_STEM = 450.0;
        static final int MAX_STEM_VARIANCE = 60;
        static final int MIN_LENGTH_FOR_STEM_OVERRIDE = 100;
        double startStemDir;
        double startOppositeDir;
        double endStemDir;
        double endOppositeDir;
        final double m;
        final double c;
        final boolean positiveAngle;

        Edge(double d, double d2, double d3, double d4, boolean bl) {
            this.startStemDir = d;
            this.startOppositeDir = d2;
            this.endStemDir = d3;
            this.endOppositeDir = d4;
            this.m = (d - d3) / (d2 - d4);
            this.c = d - d2 * ((d - d3) / (d2 - d4));
            this.positiveAngle = bl;
        }

        private static boolean almostEqual(double d, double d2) {
            return Math.abs(d - d2) < 1.0E-4;
        }

        private boolean endpointsMeet(Edge edge) {
            return Edge.almostEqual(this.startOppositeDir, edge.endOppositeDir) || Edge.almostEqual(this.endOppositeDir, edge.startOppositeDir);
        }

        private boolean sameFormula(Edge edge) {
            return Edge.almostEqual(this.m, edge.m) && Edge.almostEqual(this.c, edge.c);
        }

        double getStemPosGivenOppPos(double d) {
            return this.m * d + this.c;
        }

        boolean continuation(Edge edge) {
            if (this.sameFormula(edge) && this.endpointsMeet(edge)) {
                if (edge.endOppositeDir > this.endOppositeDir) {
                    this.endOppositeDir = edge.endOppositeDir;
                }
                if (edge.startOppositeDir < this.startOppositeDir) {
                    this.startOppositeDir = edge.startOppositeDir;
                }
                if (edge.endStemDir > this.endStemDir) {
                    this.endStemDir = edge.endStemDir;
                }
                if (edge.startStemDir < this.startStemDir) {
                    this.startStemDir = edge.startStemDir;
                }
                return true;
            }
            return false;
        }

        static boolean isShortOverlap(double d, double d2) {
            return d - d2 < 50.0;
        }

        static boolean isShort(double d, double d2) {
            return d - d2 < 130.0;
        }
    }

    private static class EdgeComparator
    implements Comparator {
        static final EdgeComparator comparator = new EdgeComparator();

        private EdgeComparator() {
        }

        public int compare(Object object, Object object2) {
            Edge edge = (Edge)object;
            Edge edge2 = (Edge)object2;
            if (edge.endStemDir < edge2.endStemDir || edge.endStemDir == edge2.endStemDir && edge.endOppositeDir < edge2.endOppositeDir) {
                return -1;
            }
            if (edge.endOppositeDir > edge2.endOppositeDir || edge.endStemDir > edge2.endStemDir) {
                return 1;
            }
            return 0;
        }
    }
}

