/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.type1.Type1Font;
import com.adobe.fontengine.fontmanagement.URLFont;

public final class IntelligentResolver {
    public static Font choosePreferredFont(Font font, Font font2) throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        FontData fontData = ((FontImpl)font).getFontData();
        FontData fontData2 = ((FontImpl)font2).getFontData();
        if (fontData.getClass() != fontData2.getClass()) {
            if (fontData instanceof OpenTypeFont) {
                return font;
            }
            if (fontData2 instanceof OpenTypeFont) {
                return font2;
            }
            if (fontData instanceof Type1Font) {
                return font;
            }
            return font2;
        }
        if (fontData instanceof OpenTypeFont) {
            if (((OpenTypeFont)fontData).cff != null && ((OpenTypeFont)fontData2).cff == null) {
                return font;
            }
            if (((OpenTypeFont)fontData).cff == null && ((OpenTypeFont)fontData2).cff != null) {
                return font2;
            }
        }
        if (fontData.getNumGlyphs() > fontData2.getNumGlyphs()) {
            return font;
        }
        if (fontData.getNumGlyphs() < fontData2.getNumGlyphs()) {
            return font2;
        }
        if (font.getClass() != font2.getClass()) {
            if (font instanceof URLFont) {
                return font;
            }
            return font2;
        }
        return font;
    }
}

