/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.postscript;

import com.adobe.fontengine.CharUtil;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.GlyphNames;
import com.adobe.fontengine.font.postscript.CIDtoUnicode;
import com.adobe.fontengine.font.postscript.GlyphNamesAccessor;

public final class UnicodeCmap {
    int[][][] cmap = null;

    public int getGlyphForChar(int n) throws InvalidFontException, UnsupportedFontException {
        if (n >> 16 >= this.cmap.length) {
            return -1;
        }
        int[][] nArray = this.cmap[n >> 16];
        if (nArray == null) {
            return 0;
        }
        int[] nArray2 = nArray[n >> 8 & 0xFF];
        if (nArray2 == null) {
            return 0;
        }
        return nArray2[n & 0xFF];
    }

    public int getFirstSupportedChar() {
        for (int i = 0; i < this.cmap.length; ++i) {
            if (this.cmap[i] == null) continue;
            for (int j = 0; j < this.cmap[i].length; ++j) {
                if (this.cmap[i][j] == null) continue;
                for (int k = 0; k < this.cmap[i][j].length; ++k) {
                    if (this.cmap[i][j][k] == 0) continue;
                    return i << 16 | j << 8 | k;
                }
            }
        }
        return Integer.MAX_VALUE;
    }

    public int getLastSupportedChar() {
        for (int i = this.cmap.length - 1; i >= 0; --i) {
            if (this.cmap[i] == null) continue;
            for (int j = this.cmap[i].length - 1; j >= 0; --j) {
                if (this.cmap[i][j] == null) continue;
                for (int k = this.cmap[i][j].length - 1; k >= 0; --k) {
                    if (this.cmap[i][j][k] == 0) continue;
                    return i << 16 | j << 8 | k;
                }
            }
        }
        return 0;
    }

    public static UnicodeCmap computeCmapFromGlyphNames(int n, boolean bl, GlyphNamesAccessor glyphNamesAccessor) throws InvalidFontException, UnsupportedFontException {
        int[][][] nArrayArray = new int[n][][];
        for (int i = 1; i < n; ++i) {
            String string = glyphNamesAccessor.getAGlyphName(i);
            nArrayArray[i] = UnicodeCmap.characterizeGlyphName(string, bl);
        }
        return UnicodeCmap.buildCmap(nArrayArray);
    }

    private static int[][] characterizeGlyphName(String string, boolean bl) {
        int[][] nArrayArray;
        int[] nArray = GlyphNames.resolveAGNCNameIntoArray(string, bl);
        int n = nArray.length;
        boolean bl2 = GlyphNames.getAGNCNameSuffix(string) != null;
        int[] nArray2 = CharUtil.mapStringFrom(nArray, 0, n);
        if (nArray2.length == 0) {
            nArrayArray = n == 1 ? new int[][]{{nArray[0], bl2 ? 1 : 0}} : new int[][]{};
        } else {
            nArrayArray = new int[nArray2.length][];
            for (int i = 0; i < nArray2.length; ++i) {
                nArrayArray[i] = new int[]{nArray2[i], bl2 ? 1 : 0};
            }
        }
        return nArrayArray;
    }

    public static UnicodeCmap computeCmapFromCids(int n, GlyphCidAccessor glyphCidAccessor, String string, String string2) throws InvalidFontException, UnsupportedFontException {
        int[][][] nArrayArray = new int[n][][];
        CIDtoUnicode cIDtoUnicode = CIDtoUnicode.get(string, string2);
        for (int i = 0; i < n; ++i) {
            int n2 = glyphCidAccessor.getAGlyphCid(i);
            nArrayArray[i] = UnicodeCmap.characterizeCid(cIDtoUnicode, n2);
        }
        return UnicodeCmap.buildCmap(nArrayArray);
    }

    static int[][] characterizeCid(CIDtoUnicode cIDtoUnicode, int n) {
        int n2 = cIDtoUnicode.cid2usv(n);
        if (n2 == -1) {
            return new int[0][];
        }
        return new int[][]{{n2, 0}};
    }

    private static UnicodeCmap buildCmap(int[][][] nArray) {
        UnicodeCmap unicodeCmap = new UnicodeCmap();
        unicodeCmap.cmap = new int[17][][];
        int[][][] nArrayArray = new int[17][][];
        for (int i = 1; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                int n = nArray[i][j][0];
                int n2 = nArray[i][j][1];
                int n3 = n >> 16;
                int n4 = n >> 8 & 0xFF;
                int n5 = n & 0xFF;
                if (unicodeCmap.cmap[n3] == null) {
                    unicodeCmap.cmap[n3] = new int[256][];
                    nArrayArray[n3] = new int[256][];
                }
                if (unicodeCmap.cmap[n3][n4] == null) {
                    unicodeCmap.cmap[n3][n4] = new int[256];
                    nArrayArray[n3][n4] = new int[256];
                    for (int k = 0; k < 256; ++k) {
                        unicodeCmap.cmap[n3][n4][k] = 0;
                        nArrayArray[n3][n4][k] = Integer.MAX_VALUE;
                    }
                }
                if (n2 >= nArrayArray[n3][n4][n5]) continue;
                unicodeCmap.cmap[n3][n4][n5] = i;
                nArrayArray[n3][n4][n5] = n2;
            }
        }
        return unicodeCmap;
    }

    public static abstract class GlyphCidAccessor {
        public abstract int getAGlyphCid(int var1) throws InvalidFontException, UnsupportedFontException;
    }
}

